/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.util.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class QRCodeUtils {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private static final String DEFAULT_CODE = "example";
    private static final String DEFAULT_SUFFIX = "jpg";
    private static final int DEFAULT_HEIGHT = 20;
    private static final int DEFAULT_WIDTH = 20;
    private static final Logger logger = CommonLogger.getLogger((String)QRCodeUtils.class.getName());

    public static void generateBarcodePicture(OutputStream os, BarcodeFormat format, Map config) throws BOSException {
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf8");
        QRCodeUtils.checkConfigData(config);
        String barcode = StringUtils.cnulls(config.get("barcode"));
        String suffix = StringUtils.cnulls(config.get("suffix"));
        int height = Integer.parseInt(StringUtils.cnulls(config.get("height")));
        int width = Integer.parseInt(StringUtils.cnulls(config.get("width")));
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = new MultiFormatWriter().encode(barcode, format, width, height, hints);
        }
        catch (WriterException e) {
            logger.error((Object)"bitMatrix encode fail!");
            throw new BOSException((Throwable)e);
        }
        int[] rec = bitMatrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!bitMatrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        int width1 = resMatrix.getWidth();
        int height1 = resMatrix.getHeight();
        BufferedImage img = new BufferedImage(width1, height1, 12);
        for (int x = 0; x < width1; ++x) {
            for (int y = 0; y < height1; ++y) {
                img.setRGB(x, y, resMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        try {
            ImageIO.write((RenderedImage)img, suffix, os);
        }
        catch (IOException e) {
            logger.error((Object)"ImageIO write fail!");
            throw new BOSException((Throwable)e);
        }
    }

    private static void checkConfigData(Map config) {
        int height;
        String suffix;
        String barcode = StringUtils.cnulls(config.get("barcode"));
        if (StringUtils.isEmpty((String)barcode)) {
            config.put("barcode", DEFAULT_CODE);
        }
        if (StringUtils.isEmpty((String)(suffix = StringUtils.cnulls(config.get("suffix"))))) {
            config.put("suffix", DEFAULT_SUFFIX);
        }
        config.put("height", (height = Integer.parseInt(StringUtils.cnulls(config.get("height")))) == 0 ? 20 : height);
        int width = Integer.parseInt(StringUtils.cnulls(config.get("width")));
        config.put("width", height == 0 ? 20 : width);
    }
}

