/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.browser;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.form2.ui.AbstractNotePrint;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePageProvider;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.bos.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.bos.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.bos.ctrl.print.printjob.IPageProvider;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.printjob.MultiBufferPrintJobs;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.GraphicsForMeasurement;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintPageProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.LongPageModeHeadFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterResolution;

public class R1PrintBrowser
extends AbstractNotePrint {
    private IPrintVariantListener _varListener;
    private INotePrintHelper.ICustomizePrintJobConfig _customizePrintJobConfig;
    private boolean isCrossPrint = false;

    public void setVariantListener(IPrintVariantListener l) {
        this._varListener = l;
    }

    public void initPrintCtrl(Object templateModel) {
        if (!(templateModel instanceof RuntimeModel)) {
            throw new IllegalArgumentException("Argument templateModel must be RuntimeModel.");
        }
        RuntimeModel runtimeModel = (RuntimeModel)templateModel;
        runtimeModel.setVariantListener(this._varListener);
        ReportModel mo = runtimeModel.getReportModel();
        R1PrintInfo pi = R1PrintModelHelper.getPrintInfo(mo);
        if (pi.getHaveBackground()) {
            this.fireStateListener(1, Boolean.TRUE);
            this.fireStateListener(2, Boolean.TRUE);
        } else {
            this.fireStateListener(1, Boolean.FALSE);
        }
    }

    public int print(Object templateModel, boolean isPreview, boolean isShowPrinterDialog, Component owner, String title) {
        if (templateModel instanceof RuntimeModel) {
            return this.print((RuntimeModel)templateModel, R1PrintBrowser.getMaxPagesLimit(), isPreview, isShowPrinterDialog, false, owner, title);
        }
        throw new IllegalArgumentException("Argument templateModel must be RuntimeModel.");
    }

    private int print(RuntimeModel runtimeModel, int forceStopPages, boolean isPreview, boolean isShowPrinterDialog, boolean isSync, Component owner, String title) {
        this.getPrinterCtrl().clear();
        this.initPrintCtrl(runtimeModel);
        R1PrintPageProvider pageProvider = this.createPageProvider(forceStopPages);
        AbstractNotePrint.WaitingDialog dlg = null;
        if (!isSync && isPreview) {
            dlg = AbstractNotePrint.WaitingDialog.create((Component)owner);
            pageProvider.setListener((INotePageProvider.INotePageProviderListener)new AbstractNotePrint.PageProviderListener(dlg));
        }
        this.generate(runtimeModel, isSync, pageProvider);
        if (!isSync && isPreview) {
            dlg.show();
            if (dlg.isUserCancel()) {
                pageProvider.forceStop();
                return 2;
            }
        }
        ReportModel mo = runtimeModel.getReportModel();
        R1PrintInfo pi = R1PrintBrowser.getPrintInfo(mo);
        this.createPrintJob(mo, pi, pageProvider);
        return R1PrintBrowser.runPrintCtrl((KDPrinter)this.getPrinterCtrl(), (boolean)isPreview, (boolean)isShowPrinterDialog, (Component)owner, (String)title);
    }

    public int designTimePreview(RuntimeModel rm, Component owner, String title) {
        return this.print(rm, 10, true, true, true, owner, title);
    }

    public Paper getPrintPaper(RuntimeModel runtimeModel) {
        ReportModel mo = runtimeModel.getReportModel();
        runtimeModel.setVariantListener(this._varListener);
        this.getPrinterCtrl().clear();
        R1PrintInfo pi = R1PrintBrowser.getPrintInfo(mo);
        R1PrintPageProvider pageProvider = this.createPageProvider(1);
        this.generate(runtimeModel, true, pageProvider);
        IPrintJob printJob = this.createPrintJob(mo, pi, pageProvider);
        this.getPrinterCtrl().preParePrint();
        Paper paper = printJob.getPaper(0);
        return paper;
    }

    private R1PrintPageProvider createPageProvider(int forceStopPages) {
        R1PrintPageProvider pageProvider = new R1PrintPageProvider();
        pageProvider.setPagesOfForceStop(forceStopPages);
        pageProvider.setCrossPrint(this.isCrossPrint);
        return pageProvider;
    }

    private void generate(RuntimeModel runtimeModel, boolean sync, R1PrintPageProvider pageProvider) {
        final Generater generater = new Generater(pageProvider, runtimeModel);
        if (sync) {
            generater.generate();
        } else {
            Thread thread = new Thread((Runnable)generater, "R1-Print Engine");
            this.getPrinterCtrl().addPreviewActionListener(new IPrintActionListener(){

                public void beforePrintOrPreview() {
                }

                public void beforePreview() {
                }

                public void beforePrint() {
                }

                public void closePreview() {
                    generater.stopPageProvider();
                }
            });
            thread.start();
        }
    }

    public IPrintJob createPrintJob(Object templateModel) {
        RuntimeModel runtimeModel = (RuntimeModel)templateModel;
        runtimeModel.reInitialize();
        R1PrintPageProvider pageProvider = this.createPageProvider(0);
        this.generate(runtimeModel, true, pageProvider);
        ReportModel mo = runtimeModel.getReportModel();
        R1PrintInfo pi = R1PrintBrowser.getPrintInfo(mo);
        return this.createPrintJob(mo, pi, pageProvider);
    }

    private IPrintJob createPrintJob(ReportModel model, R1PrintInfo pi, R1PrintPageProvider pageProvider) {
        BufferPrintJob prtJob = new BufferPrintJob();
        prtJob.setPageProvider((IPageProvider)pageProvider);
        this.getPrinterCtrl().addPrintJob((IPrintJob)prtJob);
        prtJob.getConfig().setConfigPanesVisible(Resources.getMsg((String)"tree.headerfooter"), false);
        this.makePrintJobConfig(pi, prtJob.getConfig());
        prtJob.getConfig().setPageMarginPanelVisible(this.isShowMarginPanel());
        this.configToolbar();
        prtJob.setVariantParser((IVariantParser)pageProvider.getDelayVarProvider());
        return prtJob;
    }

    private void makePrintJobConfig(R1PrintInfo pi, PrintJobConfig pjc) {
        PrinterResolution printerResolution;
        if (this._customizePrintJobConfig != null) {
            this._customizePrintJobConfig.setConfigChangeHandlerEnabled(false);
        }
        if ((printerResolution = pi.getPrinterResolution()) != null) {
            pjc.addAttribute((Attribute)printerResolution);
        }
        int leftMagin = pi.getMarginLeft();
        int rightMagin = pi.getMarginRight();
        int topMagin = pi.getMarginTop();
        int bottomMagin = pi.getMarginBottom();
        pjc.setLeftMargin((float)(leftMagin < 0 ? 0 : leftMagin / 10), 1000);
        pjc.setRightMargin((float)(rightMagin < 0 ? 0 : rightMagin / 10), 1000);
        pjc.setBodyTopMargin((float)(topMagin < 0 ? 0 : topMagin / 10), 1000);
        pjc.setBodyBottomMargin((float)(bottomMagin < 0 ? 0 : bottomMagin / 10), 1000);
        MediaSizeName msn = null;
        if (pi.isCustomPaper()) {
            int oriWidth = pi.getCustomWidth();
            int oriHeight = pi.getCustomHeight();
            this.getPrinterCtrl().setDynamicPaper(pi.isDynamicPaper());
            float width = oriWidth / 10;
            float height = pi.isDynamicPaper() ? 65535.0f : (float)(oriHeight / 10);
            MediaSizeNameExtend media = MediaSizeNameExtend.CUSTOM;
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
            if (ms instanceof FreeMediaSize) {
                ((FreeMediaSize)ms).setXY(width, height, 1000);
            } else if (ms == null) {
                new FreeMediaSize(width, height, 1000, (MediaSizeName)media);
            }
            pjc.addAttribute((Attribute)media);
        } else {
            msn = KDPrinterUtils.getMediaSizeName((String)pi.getPaperName());
            pjc.addAttribute((Attribute)msn);
        }
        if ("LANDSCAPE".equalsIgnoreCase(pi.getOrientation())) {
            pjc.addAttribute((Attribute)OrientationRequested.LANDSCAPE);
        } else {
            pjc.addAttribute((Attribute)OrientationRequested.PORTRAIT);
        }
        if (this._customizePrintJobConfig != null) {
            this._customizePrintJobConfig.customize(pjc);
            this._customizePrintJobConfig.setConfigChangeHandlerEnabled(true);
        }
    }

    public void setCustomizePrintJobConfig(INotePrintHelper.ICustomizePrintJobConfig customizePrintJobConfig) {
        this._customizePrintJobConfig = customizePrintJobConfig;
    }

    public List<BufferedImage> exportJPG(Object templateModel) {
        this.initPdfGraphicsForMeasurement();
        try {
            this.innerExportPDF(templateModel);
            List list = this.getPrinterCtrl().getIOManager().exportToJpg();
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.clearPdfGraphicsForMeasurement();
        }
    }

    public void exportPDF(Object templateModel, String file) {
        this.initPdfGraphicsForMeasurement();
        try {
            this.innerExportPDF(templateModel);
            this.getPrinterCtrl().getIOManager().exportToPdf(file);
        }
        finally {
            this.clearPdfGraphicsForMeasurement();
        }
    }

    public void exportPDF(Object templateModel, OutputStream outputStream) {
        try {
            this.initPdfGraphicsForMeasurement();
            this.innerExportPDF(templateModel);
            this.getPrinterCtrl().getIOManager().exportToPdf(outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.clearPdfGraphicsForMeasurement();
        }
    }

    public ArrayList<OutputStream> exportPDF(Object templateModel, ArrayList<OutputStream> list) {
        try {
            this.initPdfGraphicsForMeasurement();
            this.innerExportPDF(templateModel);
            ArrayList arrayList = this.getPrinterCtrl().getIOManager().exportToPdf(list);
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.clearPdfGraphicsForMeasurement();
        }
    }

    private void initPdfGraphicsForMeasurement() {
        try {
            int width = 96;
            int height = 96;
            Rectangle rc = new Rectangle((float)width, (float)height);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Document document = new Document(rc, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)os);
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfTemplate pdftemplate = pdfContentByte.createTemplate((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height));
            Graphics2D graphics2d = pdftemplate.createGraphics((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height), (FontMapper)Style.DEFAULT_FONTMAPPERPLUS);
            graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
            GraphicsForMeasurement.set(graphics2d);
        }
        catch (Exception e) {
            Logger.warn((String)"Cannot create the graphics for measurement");
        }
    }

    private void clearPdfGraphicsForMeasurement() {
        GraphicsForMeasurement.set(null);
        this.deleteTempFile();
    }

    private void innerExportPDF(Object templateModel) {
        if (!(templateModel instanceof RuntimeModel)) {
            throw new IllegalArgumentException("Argument templateModel must be RuntimeModel.");
        }
        RuntimeModel runtimeModel = (RuntimeModel)templateModel;
        this.getPrinterCtrl().clear();
        runtimeModel.setVariantListener(this._varListener);
        R1PrintPageProvider pageProvider = this.createPageProvider(R1PrintBrowser.getMaxPagesLimit());
        this.generate(runtimeModel, true, pageProvider);
        ReportModel mo = runtimeModel.getReportModel();
        R1PrintInfo pi = R1PrintBrowser.getPrintInfo(mo);
        this.createPrintJob(mo, pi, pageProvider);
    }

    public void setCrossPrint(boolean isCrossPrint) {
        this.isCrossPrint = isCrossPrint;
    }

    private static R1PrintInfo getPrintInfo(ReportModel mo) {
        LongPageModeHeadFooterModel hfm;
        R1PrintInfo pi = R1PrintModelHelper.getPrintInfo(mo);
        R1PrintPage page = (R1PrintPage)mo.getPage();
        if (!page.isHeightSyncFromPaper() && (hfm = R1PrintModelHelper.getHeadFooterOfLongPageMode(page)) != null) {
            int newMarginTop = (pi = new R1PrintInfo(pi)).getMarginTop() - hfm.getHeader().getHeightLom();
            if (newMarginTop < 0) {
                newMarginTop = 0;
                hfm.getHeader().setHeightLom(pi.getMarginTop());
            }
            pi.setMarginTop(newMarginTop);
            int newMarginBottom = pi.getMarginBottom() - hfm.getFooter().getHeightLom();
            if (newMarginBottom < 0) {
                newMarginBottom = 0;
                hfm.getFooter().setHeightLom(pi.getMarginBottom());
            }
            pi.setMarginBottom(newMarginBottom);
        }
        return pi;
    }

    private void deleteTempFile() {
        boolean client = ConfigMDUtil.isClient();
        if (!client) {
            MultiBufferPrintJobs jobs = (MultiBufferPrintJobs)this.getPrinterCtrl().getPrintJob();
            int taskCount = jobs.getTaskCount();
            for (int i = 0; i < taskCount; ++i) {
                BufferPrintJob bjob = (BufferPrintJob)jobs.getPrintJobByPaperIndex(i);
                IPageProvider pageProvider = bjob.getPageProvider();
                if (!(pageProvider instanceof R1PrintPageProvider)) continue;
                ((R1PrintPageProvider)pageProvider).getLogicList().destroy();
            }
        }
    }

    public void exportExecl(Object templateModel, OutputStream outputStream) {
        try {
            this.initPdfGraphicsForMeasurement();
            this.innerExportPDF(templateModel);
            this.getPrinterCtrl().getIOManager().exportToXls2(outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.clearPdfGraphicsForMeasurement();
        }
    }

    private static class Generater
    implements Runnable {
        private R1PrintPageProvider pageProvider;
        private RuntimeModel runtimeModel;

        public Generater(R1PrintPageProvider pp, RuntimeModel mo) {
            this.pageProvider = pp;
            this.runtimeModel = mo;
        }

        @Override
        public void run() {
            try {
                this.generate();
            }
            catch (Throwable t) {
                log.error((Object)"R1-Print\u5f15\u64ce\u6267\u884c\u7ebf\u7a0b\u672a\u6355\u83b7\u7684\u5f02\u5e38", t);
                this.pageProvider.errorForceStopped();
            }
        }

        public void generate() {
            R1PrintInfo pi = R1PrintModelHelper.getPrintInfo(this.runtimeModel.getReportModel());
            Dimension dim = pi.getPrintableAreaSize();
            if (pi.isDynamicPaper()) {
                dim.height = Integer.MAX_VALUE;
            }
            this.pageProvider.generate(this.runtimeModel, dim.width, dim.height);
        }

        public void stopPageProvider() {
            this.pageProvider.forceStop();
        }
    }
}

