/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.operate;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.form2.ui.NotePrinter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.AbstractOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeBindSource;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeObject;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintBrowser;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PreviewOperate
extends AbstractOperate {
    private static final String TESTER_FOLDER = "/tester_r1print";

    @Override
    public boolean isNeedShowUI() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean operate() {
        R1PrintBrowser browser = new R1PrintBrowser();
        NotePrinter notePrinter = new NotePrinter();
        browser.setPrinterCtrl(notePrinter.getPrinter());
        browser.setStateListener(notePrinter.getNoteStateListener());
        browser.setVariantListener(new VarientProvider());
        ReportModel model = this.getCore().getModel();
        RuntimeModel runtimeModel = new RuntimeModel(model);
        List<BarcodeObject> barcodes = this.findInContainer(model.getPage(), BarcodeObject.class);
        HashSet<String> barcodeFields = new HashSet<String>();
        for (BarcodeObject barcode : barcodes) {
            List<BarcodeBindSource> fields = barcode.getFields();
            for (BarcodeBindSource field : fields) {
                if (field.getBindField() == null) continue;
                barcodeFields.add(field.getBindField().getField().getName());
            }
        }
        runtimeModel.hookDataProvider(new DataProvider(model.getDataManager(), barcodeFields));
        browser.designTimePreview(runtimeModel, this.getParentCtrl(), MultiLanguageUtil.getMLS("operate.PreviewOperate.preview", "\u9884\u89c8"));
        return true;
    }

    private <T> List<T> findInContainer(IContainer page, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (clazz.isInstance(page)) {
            result.add(clazz.cast(page));
            return result;
        }
        List children = page.getChildren();
        for (IReportObject child : children) {
            if (child instanceof LayoutGrid) {
                IElement[] elements;
                for (IElement element : elements = ((LayoutGrid)child).getAllSubElements()) {
                    if (!(element instanceof LayoutGridCell)) continue;
                    result.addAll(this.findInContainer((LayoutGridCell)element, clazz));
                }
            }
            if (!clazz.isInstance(child)) continue;
            result.add(clazz.cast(child));
        }
        return result;
    }

    private static class TestersDataProvider
    extends AbstractPrintDataProvider {
        private String folderPath;
        private File file;

        public TestersDataProvider(File file, String folderPath) {
            this.file = file;
            this.folderPath = folderPath;
        }

        private int getType(String t) {
            if ("S".equalsIgnoreCase(t)) {
                return 12;
            }
            if ("N".equalsIgnoreCase(t)) {
                return 3;
            }
            if ("B".equalsIgnoreCase(t)) {
                return -7;
            }
            if ("D".equalsIgnoreCase(t)) {
                return 91;
            }
            if ("F".equalsIgnoreCase(t)) {
                return -2;
            }
            throw new RuntimeException("Unknown type defined: " + t);
        }

        private int getColIdx(String[] heads, String colName) {
            for (int i = 0; i < heads.length; ++i) {
                if (!colName.equalsIgnoreCase(heads[i])) continue;
                return i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
            try (FileInputStream inputStream = null;){
                String line;
                inputStream = new FileInputStream(this.file);
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                String titleLine = br.readLine();
                String[] types = titleLine.split(",");
                br.readLine();
                titleLine = br.readLine();
                String[] heads = titleLine.split(",");
                DynamicRowSet rowSet = new DynamicRowSet(heads.length);
                for (int i = 0; i < heads.length; ++i) {
                    rowSet.setColInfo(i + 1, heads[i], heads[i], this.getType(types[i]), null);
                }
                R1PrintDataParameter parameter = dataSource.getAssociateParameter();
                while ((line = br.readLine()) != null) {
                    if (StringUtil.isEmptyString((String)line)) continue;
                    String[] values = line.split(",", types.length);
                    if (parameter != null) {
                        String colName = parameter.getId();
                        int idx = this.getColIdx(heads, colName);
                        if (idx < 0) {
                            throw new RuntimeException("\u9519\u8bef\u7684\u53c2\u6570\u540d\u79f0\uff1a" + colName);
                        }
                        if (!StringUtil.equals((String)values[idx], (String)parameter.getValue().toString())) continue;
                    }
                    rowSet.moveToInsertRow();
                    block12: for (int i = 0; i < heads.length; ++i) {
                        int type = this.getType(types[i]);
                        switch (type) {
                            case 12: {
                                byte[] bytes;
                                if (values[i].startsWith("file://")) {
                                    bytes = this.getFileBytes(values[i].substring(7));
                                    rowSet.updateString(i + 1, new String(bytes));
                                    continue block12;
                                }
                                rowSet.updateString(i + 1, values[i]);
                                continue block12;
                            }
                            case 3: {
                                if (StringUtil.isEmptyString((String)values[i])) {
                                    rowSet.updateBigDecimal(i + 1, new BigDecimal(0));
                                    continue block12;
                                }
                                rowSet.updateBigDecimal(i + 1, new BigDecimal(values[i].trim()));
                                continue block12;
                            }
                            case -7: {
                                rowSet.updateBoolean(i + 1, Boolean.valueOf(values[i]).booleanValue());
                                continue block12;
                            }
                            case 91: {
                                if (StringUtil.isEmptyString((String)values[i])) {
                                    rowSet.updateDate(i + 1, null);
                                    continue block12;
                                }
                                rowSet.updateDate(i + 1, Date.valueOf(values[i]));
                                continue block12;
                            }
                            case -2: {
                                byte[] bytes = this.getFileBytes(values[i]);
                                rowSet.updateBytes(i + 1, bytes);
                                continue block12;
                            }
                            default: {
                                throw new RuntimeException("unknown type");
                            }
                        }
                    }
                    rowSet.insertRow();
                }
                rowSet.beforeFirst();
                DynamicRowSet dynamicRowSet = rowSet;
                return dynamicRowSet;
            }
        }

        private byte[] getFileBytes(String fileName) throws Exception {
            byte[] baos2;
            File file = new File(this.folderPath + "/" + fileName);
            InputStream is = null;
            try {
                if (file.exists()) {
                    is = new FileInputStream(file);
                }
                if (is != null) {
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    int len = 0;
                    while ((len = is.read(bytes)) > 0) {
                        baos2.write(bytes, 0, len);
                    }
                    byte[] byArray = baos2.toByteArray();
                    return byArray;
                }
                baos2 = new byte[]{};
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return baos2;
        }
    }

    protected static class DataProvider
    extends AbstractPrintDataProvider {
        private HashMap rowSets = new HashMap();
        private static HashSet<String> barcodeFields = new HashSet();

        public DataProvider(IR1DataManager dm) {
            DataExtend[] dataExtends = dm.getDataExtends();
            int c = dataExtends.length;
            for (int i = 0; i < c; ++i) {
                IRowSet rowSet;
                String dsName = dataExtends[i].getName();
                MetaClass mc = (MetaClass)dm.getObject(dsName);
                if (mc == null || (rowSet = DataProvider.makeRowSet(mc.getFields())) == null) continue;
                this.rowSets.put(dsName, rowSet);
            }
        }

        public DataProvider(IR1DataManager dm, HashSet<String> barcodeFields) {
            DataProvider.barcodeFields.clear();
            DataProvider.barcodeFields = barcodeFields;
            DataExtend[] dataExtends = dm.getDataExtends();
            int c = dataExtends.length;
            for (int i = 0; i < c; ++i) {
                IRowSet rowSet;
                String dsName = dataExtends[i].getName();
                MetaClass mc = (MetaClass)dm.getObject(dsName);
                if (mc == null || (rowSet = DataProvider.makeRowSet(mc.getFields())) == null) continue;
                this.rowSets.put(dsName, rowSet);
            }
        }

        private static IRowSet makeRowSet(List fields) {
            int size = fields.size();
            try {
                DynamicRowSet drs = new DynamicRowSet(size);
                for (int i = 0; i < size; ++i) {
                    MetaField mf = (MetaField)fields.get(i);
                    int type = DataType.isNumberType((DataType)mf.getType()) ? 6 : 12;
                    drs.setColInfo(i + 1, mf.getName(), mf.getName(), type, null);
                }
                for (int r = 1; r <= 5; ++r) {
                    drs.moveToInsertRow();
                    for (int i = 0; i < size; ++i) {
                        MetaField mf = (MetaField)fields.get(i);
                        if (DataType.isNumberType((DataType)mf.getType())) {
                            drs.updateFloat(i + 1, (float)r + (float)r / 10.0f);
                            continue;
                        }
                        if (barcodeFields.contains(mf.getName())) {
                            drs.updateString(i + 1, mf.getName() + r);
                            continue;
                        }
                        drs.updateString(i + 1, mf.getAliasName() + r);
                    }
                    drs.insertRow();
                }
                drs.beforeFirst();
                return drs;
            }
            catch (SQLException e) {
                return null;
            }
        }

        @Override
        public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
            String strCtrlHomeDir = GlobalLocator.getInstance().getHomeDir();
            String strDir = strCtrlHomeDir + PreviewOperate.TESTER_FOLDER;
            if (new File(strDir).exists()) {
                String dsName = dataSource.getId();
                String strFile = new StringBuffer(strDir + "/" + dsName + ".csv").toString();
                File dsFile = new File(strFile);
                if (dsFile.exists()) {
                    TestersDataProvider testers = new TestersDataProvider(dsFile, strDir);
                    return testers.getData(dataSource);
                }
            }
            return (IRowSet)this.rowSets.get(dataSource.getId());
        }
    }

    private static class VarientProvider
    implements IPrintVariantListener {
        private VarientProvider() {
        }

        @Override
        public String requestVar(String type, String varName) {
            return varName;
        }
    }
}

