/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.operate;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.AbstractOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.LongPageModeHeadFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.headfooter.LongPageModeHeadFooterUI;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrintSetOperate
extends AbstractOperate {
    @Override
    public boolean operate() {
        PageSetDialog dialog = PageSetDialog.create(this.getParentCtrl());
        dialog.setTitle(MultiLanguageUtil.getMLS("operate.PrintSetOperate.paperSet", ""));
        dialog.setModel(this.getCore().getModel());
        if (dialog.showDialog()) {
            this.getCore().storeUndoState(dialog.getTitle());
            R1PrintInfo info = dialog.getPrintInfo();
            R1PrintModelHelper.setPrintInfo(this.getCore().getModel(), info);
            R1PrintPage page = (R1PrintPage)this.getCore().getModel().getPage();
            dialog.pageUi2Model(page);
            this.getCore().getModel().setDirty(true);
            this.getCore().getPageContainer().repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isNeedShowUI() {
        return true;
    }

    private static class DpiItem {
        public static DpiItem DPI_DEFAULT = new DpiItem(-1, -1);
        public static DpiItem DPI_72 = new DpiItem(72, 72);
        public static DpiItem DPI_96 = new DpiItem(96, 96);
        public static DpiItem DPI_100 = new DpiItem(100, 100);
        public static DpiItem DPI_150 = new DpiItem(150, 150);
        public static DpiItem DPI_200 = new DpiItem(200, 200);
        public static DpiItem DPI_300 = new DpiItem(300, 300);
        public static DpiItem DPI_600 = new DpiItem(600, 600);
        public static DpiItem DPI_1200 = new DpiItem(1200, 1200);
        public static DpiItem[] allDpiItems = new DpiItem[]{DPI_DEFAULT, DPI_72, DPI_96, DPI_100, DPI_150, DPI_200, DPI_300, DPI_600, DPI_1200};
        private int xDpis;
        private int yDpis;

        public DpiItem(int xDpis, int yDpis) {
            this.xDpis = xDpis;
            this.yDpis = yDpis;
        }

        public int getXDpis() {
            return this.xDpis;
        }

        public int getYDpis() {
            return this.yDpis;
        }

        public String toString() {
            if (this.equals(DPI_DEFAULT)) {
                return "default";
            }
            return String.format("%dx%d", this.xDpis, this.yDpis);
        }

        public static DpiItem[] getAllDpiItems() {
            return allDpiItems;
        }
    }

    private static class PageSetDialog
    extends TypicalDialog {
        private KDComboBox cmbPaper;
        private KDComboBox cmbOrientation;
        private KDSpinner spnWidth;
        private KDSpinner spnHeight;
        private KDSpinner spnTopMargin;
        private KDSpinner spnRightMargin;
        private KDSpinner spnLeftMargin;
        private KDSpinner spnBottomMargin;
        private KDSpinner spnPageWidth;
        private KDSpinner spnPageHeight;
        private KDCheckBox chkPageWidthSyncFromPaper;
        private KDCheckBox chkPageHeightSyncFromPaper;
        private KDCheckBox chkDynamicPaper;
        private KDCheckBox chkVerEconomizePaper;
        private KDCheckBox chkHorEconomizePaper;
        private KDSpinner spnVerPageSpace;
        private KDSpinner spnHorPageSpace;
        private KDComboBox cbPrinterResolution;
        private KDWorkButton btnHeadFooter;
        private ReportModel reportModel;
        private R1PrintPage page;
        private R1PrintInfo oldInfo;

        public static PageSetDialog create(JComponent parentCtrl) {
            Window owner = SwingUtilities.getWindowAncestor(parentCtrl);
            if (owner instanceof Dialog) {
                return new PageSetDialog((Dialog)owner);
            }
            if (owner instanceof Frame) {
                return new PageSetDialog((Frame)owner);
            }
            return new PageSetDialog();
        }

        public PageSetDialog(Frame parent) {
            super(parent);
        }

        public PageSetDialog(Dialog parent) {
            super(parent);
        }

        public PageSetDialog() {
        }

        public void setModel(ReportModel reportModel) {
            this.reportModel = reportModel;
            this.pageModel2Ui((R1PrintPage)reportModel.getPage());
            this.setPrintInfo(R1PrintModelHelper.getPrintInfo(reportModel));
        }

        private void setPrintInfo(R1PrintInfo info) {
            this.oldInfo = info;
            this.model2Ui(info);
        }

        private void pageModel2Ui(R1PrintPage page) {
            this.setPageWidth(page.getWidthLom());
            this.setPageHeight(page.getHeightLom());
            this.setPageWidthSyncFromPaper(page.isWidthSyncFromPaper());
            this.setPageHeightSyncFromPaper(page.isHeightSyncFromPaper());
            this.syncPageSizeCtrlEnabled();
            this.page = page;
        }

        private void model2Ui(R1PrintInfo pi) {
            this.setPaperName(pi.getPaperName());
            if (this.isCustomPaper()) {
                this.setPaperWidth(pi.getCustomWidth());
                this.setPaperHeight(pi.getCustomHeight());
            } else {
                this.syncPaperSizeByName(this.getPaperName());
            }
            this.setOrientation(pi.getOrientation());
            this.setTopMargin(pi.getMarginTop());
            this.setBottomMargin(pi.getMarginBottom());
            this.setLeftMargin(pi.getMarginLeft());
            this.setRightMargin(pi.getMarginRight());
            this.setDynamicPaper(pi.isDynamicPaper());
            this.setVerEconomizePaper(pi.isVerEconomizePaper());
            this.setVerPageSpace(pi.getVerPageSpace());
            this.setHorEconomizePaper(pi.isHorEconomizePaper());
            this.setHorPageSpace(pi.getHorPageSpace());
            this.setPrinterResolution(pi.getPrinterResolution());
        }

        public R1PrintInfo getPrintInfo() {
            R1PrintInfo info = new R1PrintInfo(this.oldInfo);
            this.ui2Model(info);
            return info;
        }

        public void pageUi2Model(R1PrintPage page) {
            page.setWidthLom(this.getPageWidth());
            page.setHeightLom(this.getPageHeight());
            page.setWidthSyncFromPaper(this.isPageWidthSyncFromPaper());
            page.setHeightSyncFromPaper(this.isPageHeightSyncFromPaper());
        }

        private void ui2Model(R1PrintInfo pi) {
            if (this.isCustomPaper()) {
                pi.setCustomPaper(this.getPaperWidth(), this.getPaperHeight());
            } else {
                pi.setPaperName(this.getPaperName());
            }
            pi.setOrientation(this.getOrientation());
            pi.setMarginTop(this.getTopMargin());
            pi.setMarginBottom(this.getBottomMargin());
            pi.setMarginLeft(this.getLeftMargin());
            pi.setMarginRight(this.getRightMargin());
            pi.setVerPageSpace(this.getVerPageSpace());
            pi.setHorPageSpace(this.getHorPageSpace());
            pi.setDynamicPaper(this.isDynamicPaper());
            pi.setVerEconomizePaper(this.isVerEconomizePaper());
            pi.setHorEconomizePaper(this.isHorEconomizePaper());
            pi.setPrinterResolution(this.getPrinterResolution());
        }

        protected void todoInit() {
            this.initComponents();
            this.installListener();
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            KDLabelContainer lbcPaper = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbPaper, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.paper", ""), (int)60);
            KDLabelContainer lbcWidth = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnWidth, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.width", ""), (int)60);
            KDLabelContainer lbcHeight = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnHeight, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.height", ""), (int)60);
            KDLabelContainer lbcOrientation = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbOrientation, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.orientation", ""), (int)60);
            KDLabel labWidthUnit = new KDLabel(MultiLanguageUtil.getMLS("operate.PrintSetOperate.unit", ""));
            KDLabel labHeightUnit = new KDLabel(MultiLanguageUtil.getMLS("operate.PrintSetOperate.unit", ""));
            KDLabel labHorSpaceUnit = new KDLabel(MultiLanguageUtil.getMLS("operate.PrintSetOperate.unit", ""));
            KDLabel labVerSpaceUnit = new KDLabel(MultiLanguageUtil.getMLS("operate.PrintSetOperate.unit", ""));
            KDLabel labEconomizeTitle = new KDLabel(MultiLanguageUtil.getMLS("operate.PrintSetOperate.explain", ""));
            KDLabelContainer lbcTopMargin = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnTopMargin, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.topMargin", ""), (int)40);
            KDLabelContainer lbcBottomMargin = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnBottomMargin, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.bottomMargin", ""), (int)40);
            KDLabelContainer lbcLeftMargin = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnLeftMargin, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.leftMargin", ""), (int)40);
            KDLabelContainer lbcRightMargin = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnRightMargin, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.rightMargin", ""), (int)40);
            KDLabelContainer lbcPageWidth = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnPageWidth, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.width", ""), (int)60);
            KDLabelContainer lbcPageHeight = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnPageHeight, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.height", ""), (int)60);
            KDLabelContainer lbcHorPageSpace = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnHorPageSpace, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.horPageSpace", ""), (int)50);
            KDLabelContainer lbcVerPageSpace = CtrlSwingUtilities.createLabelContainer((JComponent)this.spnVerPageSpace, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.verPageSpace", ""), (int)50);
            KDLabelContainer lbcPrinterResolution = CtrlSwingUtilities.createLabelContainer((JComponent)this.cbPrinterResolution, (String)MultiLanguageUtil.getMLS("operate.PrintSetOperate.dpi", ""), (int)50);
            KDPanel panPaper = new KDPanel();
            panPaper.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("operate.PrintSetOperate.paper", "")));
            panPaper.setLayout(null);
            panPaper.add((Component)lbcPaper);
            panPaper.add((Component)lbcWidth);
            panPaper.add((Component)lbcHeight);
            panPaper.add((Component)labWidthUnit);
            panPaper.add((Component)labHeightUnit);
            panPaper.add((Component)lbcOrientation);
            KDPanel panMargin = new KDPanel();
            panMargin.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("operate.PrintSetOperate.marginUnit", "")));
            panMargin.setLayout(null);
            panMargin.add((Component)lbcTopMargin);
            panMargin.add((Component)lbcBottomMargin);
            panMargin.add((Component)lbcLeftMargin);
            panMargin.add((Component)lbcRightMargin);
            KDPanel panPrinter = new KDPanel();
            panPrinter.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("operate.PrintSetOperate.printer", "")));
            panPrinter.setLayout(null);
            panPrinter.add((Component)this.chkDynamicPaper);
            panPrinter.add((Component)labEconomizeTitle);
            panPrinter.add((Component)this.chkHorEconomizePaper);
            panPrinter.add((Component)this.chkVerEconomizePaper);
            panPrinter.add((Component)lbcHorPageSpace);
            panPrinter.add((Component)lbcVerPageSpace);
            panPrinter.add((Component)labHorSpaceUnit);
            panPrinter.add((Component)labVerSpaceUnit);
            panPrinter.add((Component)lbcPrinterResolution);
            panPrinter.add((Component)this.cbPrinterResolution);
            KDPanel panPage = new KDPanel();
            panPage.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("operate.PrintSetOperate.page", "")));
            panPage.setLayout(null);
            panPage.add((Component)lbcPageWidth);
            panPage.add((Component)lbcPageHeight);
            panPage.add((Component)this.chkPageWidthSyncFromPaper);
            panPage.add((Component)this.chkPageHeightSyncFromPaper);
            panPage.add((Component)this.btnHeadFooter);
            lbcPaper.setBounds(10, 24, 230, 19);
            lbcWidth.setBounds(10, 46, 150, 19);
            labWidthUnit.setBounds(170, 46, 70, 19);
            lbcHeight.setBounds(10, 69, 150, 19);
            labHeightUnit.setBounds(170, 69, 70, 19);
            lbcOrientation.setBounds(10, 92, 230, 19);
            lbcTopMargin.setBounds(70, 24, 90, 19);
            lbcLeftMargin.setBounds(10, 58, 90, 19);
            lbcRightMargin.setBounds(120, 58, 90, 19);
            lbcBottomMargin.setBounds(70, 92, 90, 19);
            this.chkDynamicPaper.setBounds(10, 24, 280, 19);
            this.chkHorEconomizePaper.setBounds(10, 49, 100, 19);
            this.chkVerEconomizePaper.setBounds(10, 71, 100, 19);
            lbcHorPageSpace.setBounds(120, 49, 100, 19);
            lbcVerPageSpace.setBounds(120, 71, 100, 19);
            labHorSpaceUnit.setBounds(220, 49, 70, 19);
            labVerSpaceUnit.setBounds(220, 71, 70, 19);
            lbcPrinterResolution.setBounds(10, 96, 100, 19);
            this.cbPrinterResolution.setBounds(120, 96, 100, 19);
            lbcPageWidth.setBounds(10, 24, 150, 19);
            lbcPageHeight.setBounds(10, 47, 150, 19);
            this.chkPageWidthSyncFromPaper.setBounds(170, 24, 150, 19);
            this.chkPageHeightSyncFromPaper.setBounds(170, 47, 150, 19);
            this.btnHeadFooter.setBounds(360, 45, 100, 22);
            Table tb = thisCell.split(4, 1);
            tb.rowStyle(0).setHeight(125);
            tb.rowStyle(1).setHeight(125);
            tb.rowStyle(2).setHeight(80);
            tb.rowStyle(3).setPriY(1);
            Table tb1 = tb.cell(0).split(1, 2);
            tb1.colStyle(0).setWidth(250);
            tb1.colStyle(1).setPriX(1);
            parent.add((Component)panPaper, tb1.cell(0));
            parent.add((Component)panMargin, tb1.cell(1));
            parent.add((Component)panPrinter, tb.cell(1));
            parent.add((Component)panPage, tb.cell(2));
            this.setSize(500, 410);
            this.setResizable(false);
            this.setLocationRelativeTo(null);
        }

        private void initComponents() {
            this.cmbPaper = new KDComboBox();
            this.cmbOrientation = new KDComboBox();
            this.spnWidth = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 0, 100000, 1));
            this.spnHeight = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 0, 100000, 1));
            this.spnTopMargin = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 0, 10000, 1));
            this.spnBottomMargin = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 0, 10000, 1));
            this.spnLeftMargin = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 0, 10000, 1));
            this.spnRightMargin = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 0, 10000, 1));
            this.spnPageWidth = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 0, 100000, 1));
            this.spnPageHeight = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 0, 100000, 1));
            this.chkPageWidthSyncFromPaper = new KDCheckBox(MultiLanguageUtil.getMLS("operate.PrintSetOperate.widthSyncFromPaper", ""));
            this.chkPageHeightSyncFromPaper = new KDCheckBox(MultiLanguageUtil.getMLS("operate.PrintSetOperate.heightSyncFromPaper", ""));
            this.btnHeadFooter = new KDWorkButton(MultiLanguageUtil.getMLS("operate.PrintSetOperate.headFooter", ""));
            this.chkDynamicPaper = new KDCheckBox(MultiLanguageUtil.getMLS("operate.PrintSetOperate.dynamicPaper", ""));
            this.chkHorEconomizePaper = new KDCheckBox(MultiLanguageUtil.getMLS("operate.PrintSetOperate.horEconomizePaper", ""));
            this.spnHorPageSpace = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, 10000, 1));
            this.spnHorPageSpace.setEnabled(this.chkHorEconomizePaper.isSelected());
            this.chkHorEconomizePaper.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    spnHorPageSpace.setEnabled(((KDCheckBox)e.getSource()).isSelected());
                }
            });
            this.btnHeadFooter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LongPageModeHeadFooterModel model = R1PrintModelHelper.getHeadFooterOfLongPageMode(page);
                    if (model == null) {
                        model = new LongPageModeHeadFooterModel();
                    }
                    LongPageModeHeadFooterUI ui = new LongPageModeHeadFooterUI();
                    ui.setDataManager(reportModel.getDataManager());
                    ui.setModel(model);
                    SimpleDialog dlg = SimpleDialog.create((Component)btnHeadFooter);
                    dlg.setTitle(MultiLanguageUtil.getMLS("operate.PrintSetOperate.headFooterDlgTitle", ""));
                    dlg.setComponent((Component)((Object)ui));
                    dlg.setSize(640, 480);
                    if (dlg.showDialog()) {
                        ui.acceptModified(model);
                        R1PrintModelHelper.setHeadFooterOfLongPageMode(page, model);
                    }
                }
            });
            this.chkVerEconomizePaper = new KDCheckBox(MultiLanguageUtil.getMLS("operate.PrintSetOperate.verEconomizePaper", ""));
            this.spnVerPageSpace = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, 10000, 1));
            this.spnVerPageSpace.setEnabled(this.chkVerEconomizePaper.isSelected());
            this.chkVerEconomizePaper.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    spnVerPageSpace.setEnabled(((KDCheckBox)e.getSource()).isSelected());
                }
            });
            this.cbPrinterResolution = new KDComboBox();
            this.cbPrinterResolution.addItems((Object[])DpiItem.getAllDpiItems());
            this.cbPrinterResolution.setEnabled(true);
            this.cbPrinterResolution.setVisible(true);
            this.chkPageWidthSyncFromPaper.setToolTipText(MultiLanguageUtil.getMLS("operate.PrintSetOperate.toolTips1", ""));
            this.chkPageHeightSyncFromPaper.setToolTipText(MultiLanguageUtil.getMLS("operate.PrintSetOperate.toolTips2", ""));
            this.chkDynamicPaper.setToolTipText(MultiLanguageUtil.getMLS("operate.PrintSetOperate.toolTips3", ""));
            this.cmbPaper.addItem((Object)"Custom");
            this.cmbPaper.addItems((Object[])R1PrintInfo.getAllPaperNames());
            this.cmbOrientation.addItem((Object)MultiLanguageUtil.getMLS("operate.PrintSetOperate.vertical", ""));
            this.cmbOrientation.addItem((Object)MultiLanguageUtil.getMLS("operate.PrintSetOperate.horizontal", ""));
            this.chkPageWidthSyncFromPaper.setEnabled(false);
        }

        private void installListener() {
            PaperNameHandler handler = new PaperNameHandler();
            this.cmbPaper.addActionListener((ActionListener)handler);
            SyncPageSizeHandler handler1 = new SyncPageSizeHandler();
            this.spnWidth.addChangeListener((ChangeListener)handler1);
            this.spnHeight.addChangeListener((ChangeListener)handler1);
            this.spnTopMargin.addChangeListener((ChangeListener)handler1);
            this.spnBottomMargin.addChangeListener((ChangeListener)handler1);
            this.spnLeftMargin.addChangeListener((ChangeListener)handler1);
            this.spnRightMargin.addChangeListener((ChangeListener)handler1);
            this.cmbOrientation.addActionListener((ActionListener)handler1);
            SyncPageSizeCtrlHandler handler2 = new SyncPageSizeCtrlHandler();
            this.chkPageWidthSyncFromPaper.addActionListener((ActionListener)handler2);
            this.chkPageHeightSyncFromPaper.addActionListener((ActionListener)handler2);
            SyncDynamicPaperCtrlHandler handler3 = new SyncDynamicPaperCtrlHandler();
            this.cmbPaper.addActionListener((ActionListener)handler3);
            this.cmbOrientation.addActionListener((ActionListener)handler3);
        }

        private void syncPaperSizeByName(String paperName) {
            Dimension dim = R1PrintInfo.getPaperSize(paperName);
            this.setPaperWidth(dim.width);
            this.setPaperHeight(dim.height);
        }

        private void syncPageSizeByPaper() {
            R1PrintInfo tempInfo = this.getPrintInfo();
            Dimension dim = tempInfo.getPrintableAreaSize();
            if (this.isPageWidthSyncFromPaper()) {
                this.setPageWidth(dim.width);
            }
            if (this.isPageHeightSyncFromPaper()) {
                this.setPageHeight(dim.height);
            }
        }

        private void syncPageSizeCtrlEnabled() {
            this.spnPageWidth.setEnabled(!this.isPageWidthSyncFromPaper());
            this.spnPageHeight.setEnabled(!this.isPageHeightSyncFromPaper());
            this.btnHeadFooter.setEnabled(!this.isPageHeightSyncFromPaper());
        }

        private void syncDynamicPaperEnabled() {
            if (this.isCustomPaper() && this.getOrientation() == "PORTRAIT") {
                this.chkDynamicPaper.setEnabled(true);
            } else {
                this.chkDynamicPaper.setEnabled(false);
                this.chkDynamicPaper.setSelected(false);
            }
        }

        private String getPaperName() {
            return (String)this.cmbPaper.getSelectedItem();
        }

        private void setPaperName(String name) {
            this.cmbPaper.setSelectedItem((Object)name);
        }

        private boolean isCustomPaper() {
            return "Custom".equalsIgnoreCase(this.getPaperName());
        }

        private int getPaperHeight() {
            return this.spnHeight.getIntegerVlaue();
        }

        private void setPaperHeight(int reportHeight) {
            this.spnHeight.setValue((Object)new Integer(reportHeight));
        }

        private int getPaperWidth() {
            return this.spnWidth.getIntegerVlaue();
        }

        private void setPaperWidth(int reportWidth) {
            this.spnWidth.setValue((Object)new Integer(reportWidth));
        }

        private String getOrientation() {
            if (this.cmbOrientation.getSelectedIndex() == 0) {
                return "PORTRAIT";
            }
            return "LANDSCAPE";
        }

        private void setOrientation(String orientation) {
            if (orientation.equals("PORTRAIT")) {
                this.cmbOrientation.setSelectedIndex(0);
            } else {
                this.cmbOrientation.setSelectedIndex(1);
            }
        }

        private int getTopMargin() {
            return this.spnTopMargin.getIntegerVlaue();
        }

        private void setTopMargin(int topMargin) {
            this.spnTopMargin.setValue((Object)new Integer(topMargin));
        }

        private int getBottomMargin() {
            return this.spnBottomMargin.getIntegerVlaue();
        }

        private void setBottomMargin(int bottomMargin) {
            this.spnBottomMargin.setValue((Object)new Integer(bottomMargin));
        }

        private int getLeftMargin() {
            return this.spnLeftMargin.getIntegerVlaue();
        }

        private void setLeftMargin(int leftMargin) {
            this.spnLeftMargin.setValue((Object)new Integer(leftMargin));
        }

        private int getRightMargin() {
            return this.spnRightMargin.getIntegerVlaue();
        }

        private void setRightMargin(int rightMargin) {
            this.spnRightMargin.setValue((Object)new Integer(rightMargin));
        }

        private boolean isDynamicPaper() {
            return this.chkDynamicPaper.isSelected();
        }

        private void setDynamicPaper(boolean is) {
            this.chkDynamicPaper.setSelected(is);
        }

        private boolean isVerEconomizePaper() {
            return this.chkVerEconomizePaper.isSelected();
        }

        private void setVerEconomizePaper(boolean is) {
            this.chkVerEconomizePaper.setSelected(is);
        }

        private int getVerPageSpace() {
            return this.spnVerPageSpace.getIntegerVlaue();
        }

        private void setVerPageSpace(int pageSpace) {
            this.spnVerPageSpace.setValue((Object)new Integer(pageSpace));
        }

        private boolean isHorEconomizePaper() {
            return this.chkHorEconomizePaper.isSelected();
        }

        private void setHorEconomizePaper(boolean horEconomizePaper) {
            this.chkHorEconomizePaper.setSelected(horEconomizePaper);
        }

        private int getHorPageSpace() {
            return this.spnHorPageSpace.getIntegerVlaue();
        }

        private void setHorPageSpace(int horPageSpace) {
            this.spnHorPageSpace.setValue((Object)new Integer(horPageSpace));
        }

        private int getPageWidth() {
            return this.spnPageWidth.getIntegerVlaue();
        }

        private void setPageWidth(int w) {
            this.spnPageWidth.setValue((Object)new Integer(w));
        }

        private int getPageHeight() {
            return this.spnPageHeight.getIntegerVlaue();
        }

        private void setPageHeight(int h) {
            this.spnPageHeight.setValue((Object)new Integer(h));
        }

        private boolean isPageWidthSyncFromPaper() {
            return this.chkPageWidthSyncFromPaper.isSelected();
        }

        private void setPageWidthSyncFromPaper(boolean is) {
            this.chkPageWidthSyncFromPaper.setSelected(is);
        }

        private boolean isPageHeightSyncFromPaper() {
            return this.chkPageHeightSyncFromPaper.isSelected();
        }

        private void setPageHeightSyncFromPaper(boolean is) {
            this.chkPageHeightSyncFromPaper.setSelected(is);
        }

        private PrinterResolution getPrinterResolution() {
            DpiItem dpiItem = (DpiItem)this.cbPrinterResolution.getSelectedItem();
            if (dpiItem != null && !dpiItem.equals(DpiItem.DPI_DEFAULT)) {
                PrinterResolution printerResolution = new PrinterResolution(dpiItem.getXDpis(), dpiItem.getYDpis(), 100);
                return printerResolution;
            }
            return null;
        }

        private void setPrinterResolution(PrinterResolution printerResolution) {
            if (printerResolution == null) {
                this.cbPrinterResolution.setSelectedItem((Object)DpiItem.DPI_DEFAULT);
                return;
            }
            int xDpis = printerResolution.getCrossFeedResolution(100);
            int yDpis = printerResolution.getFeedResolution(100);
            DpiItem targetDpiItem = DpiItem.DPI_DEFAULT;
            for (DpiItem dpiItem : DpiItem.getAllDpiItems()) {
                if (dpiItem.getXDpis() != xDpis || dpiItem.getYDpis() != yDpis) continue;
                targetDpiItem = dpiItem;
            }
            this.cbPrinterResolution.setSelectedItem((Object)targetDpiItem);
        }

        protected boolean verify() {
            int pageH;
            if (!this.isMarginCorrect()) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("operate.PrintSetOperate.warning1", "\u3002"), (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
            if (this.isPrinterSettingError()) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("operate.PrintSetOperate.warning2", ""), (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
            int pageW = this.getPageWidth();
            boolean[] isOutside = this.page.checkChildrenOutside(pageW, pageH = this.getPageHeight());
            if (isOutside[0] || isOutside[1]) {
                StringBuffer sb = new StringBuffer();
                sb.append(MultiLanguageUtil.getMLS("operate.PrintSetOperate.warning3", ""));
                if (isOutside[0]) {
                    sb.append(MultiLanguageUtil.getMLS("operate.PrintSetOperate.warning4", "\uff1a"));
                    sb.append(pageW);
                    if (isOutside[1]) {
                        sb.append(MultiLanguageUtil.getMLS("operate.PrintSetOperate.warning5", ""));
                    }
                }
                if (isOutside[1]) {
                    sb.append(MultiLanguageUtil.getMLS("operate.PrintSetOperate.warning6", ""));
                    sb.append(pageH);
                }
                sb.append(MultiLanguageUtil.getMLS("operate.PrintSetOperate.warning7", ""));
                return WindowUtil.msgboxYesNo((Component)((Object)this), (Object)sb.toString(), (String)this.getTitle());
            }
            return true;
        }

        private boolean isPrinterSettingError() {
            return this.isDynamicPaper() && (this.isVerEconomizePaper() || this.isHorEconomizePaper());
        }

        private boolean isMarginCorrect() {
            String orientation = this.getOrientation();
            return !(orientation.equals("PORTRAIT") ? this.getLeftMargin() + this.getRightMargin() > this.getPaperWidth() || this.getTopMargin() + this.getBottomMargin() > this.getPaperHeight() : this.getLeftMargin() + this.getRightMargin() > this.getPaperHeight() || this.getTopMargin() + this.getBottomMargin() > this.getPaperWidth());
        }

        private class SyncDynamicPaperCtrlHandler
        implements ActionListener {
            private SyncDynamicPaperCtrlHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PageSetDialog.this.syncDynamicPaperEnabled();
            }
        }

        private class SyncPageSizeCtrlHandler
        implements ActionListener {
            private SyncPageSizeCtrlHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object oriValue;
                PageSetDialog.this.syncPageSizeCtrlEnabled();
                if (e.getSource() == PageSetDialog.this.chkPageWidthSyncFromPaper) {
                    if (PageSetDialog.this.isPageWidthSyncFromPaper()) {
                        PageSetDialog.this.chkPageWidthSyncFromPaper.setUserObject((Object)PageSetDialog.this.spnPageWidth.getIntegerVlaue());
                        PageSetDialog.this.syncPageSizeByPaper();
                    } else {
                        oriValue = PageSetDialog.this.chkPageWidthSyncFromPaper.getUserObject();
                        if (oriValue != null) {
                            PageSetDialog.this.spnPageWidth.setValue(oriValue);
                        }
                    }
                }
                if (e.getSource() == PageSetDialog.this.chkPageHeightSyncFromPaper) {
                    if (PageSetDialog.this.isPageHeightSyncFromPaper()) {
                        PageSetDialog.this.chkPageHeightSyncFromPaper.setUserObject((Object)PageSetDialog.this.spnPageHeight.getIntegerVlaue());
                        PageSetDialog.this.syncPageSizeByPaper();
                    } else {
                        oriValue = PageSetDialog.this.chkPageHeightSyncFromPaper.getUserObject();
                        if (oriValue != null) {
                            PageSetDialog.this.spnPageHeight.setValue(oriValue);
                        }
                    }
                }
            }
        }

        private class SyncPageSizeHandler
        implements ChangeListener,
        ActionListener {
            private SyncPageSizeHandler() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                PageSetDialog.this.syncPageSizeByPaper();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PageSetDialog.this.syncPageSizeByPaper();
            }
        }

        private class PaperNameHandler
        implements ActionListener {
            private PaperNameHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isCustomPaper = PageSetDialog.this.isCustomPaper();
                PageSetDialog.this.spnHeight.setEnabled(isCustomPaper);
                PageSetDialog.this.spnWidth.setEnabled(isCustomPaper);
                if (!isCustomPaper) {
                    PageSetDialog.this.syncPaperSizeByName(PageSetDialog.this.getPaperName());
                }
                PageSetDialog.this.syncPageSizeByPaper();
            }
        }
    }
}

