/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.operate.grid;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.AbstractOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractNormalRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.R1PrintGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGrid;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public class InsertRowOperate
extends AbstractOperate {
    @Override
    public boolean operate() {
        this.getCore().storeUndoState("\u63d2\u5165\u884c");
        ElementPath ep = this.getSelected();
        Object objRootEle = ep.getRootPathComponent();
        if (objRootEle instanceof DataGrid) {
            return this.operateDataGrid((DataGrid)objRootEle);
        }
        if (objRootEle instanceof LayoutGrid) {
            return this.operateLayoutGrid((LayoutGrid)objRootEle);
        }
        return false;
    }

    private boolean operateLayoutGrid(LayoutGrid layoutGrid) {
        ElementPath ep = this.getSelected();
        Object objLastEle = ep.getLastPathComponent();
        InsertSimpleRowDialog dlg = (InsertSimpleRowDialog)((Object)WindowUtil.createWindow(InsertSimpleRowDialog.class, (Component)this.getParentCtrl()));
        if (dlg.showDialog()) {
            int number = dlg.getNumber();
            boolean isBefore = dlg.isBeforeCurrent();
            int currentIdx = 0;
            if (objLastEle instanceof AbstractCell) {
                currentIdx = layoutGrid.getIndexOfCell((AbstractCell)((AbstractCell)objLastEle)).x;
            } else if (objLastEle instanceof AbstractRow) {
                currentIdx = layoutGrid.getIndexOfRow((AbstractRow)objLastEle);
            }
            this.insertNormalRows(layoutGrid, currentIdx, isBefore, number);
            if (layoutGrid.isHorizontalFill() || layoutGrid.isVerticalFill()) {
                IReportObject parentRo = (IReportObject)layoutGrid.getParent().getRootPathComponent();
                ContainerUtil.layoutChildren(parentRo);
            }
            this.getCore().getPageContainer().repaint();
            return true;
        }
        return false;
    }

    private boolean operateDataGrid(DataGrid dataGrid) {
        ElementPath ep = this.getSelected();
        Object objLastEle = ep.getLastPathComponent();
        InsertRowDialog dlg = (InsertRowDialog)((Object)WindowUtil.createWindow(InsertRowDialog.class, (Component)this.getParentCtrl()));
        String dsName = dataGrid.getDataSource().getDs();
        Object ds = this.getCore().getModel().getDataManager().getObject(dsName);
        dlg.setDatasource((MetaClass)ds);
        boolean isToShowDialog = true;
        while (isToShowDialog) {
            if (!dlg.showDialog()) {
                return false;
            }
            isToShowDialog = false;
            int type = dlg.getRowType();
            int number = dlg.getNumber();
            boolean isBefore = dlg.isBeforeCurrent();
            int currentIdx = 0;
            if (objLastEle instanceof AbstractCell) {
                currentIdx = dataGrid.getIndexOfCell((AbstractCell)((AbstractCell)objLastEle)).x;
            } else if (objLastEle instanceof AbstractRow) {
                currentIdx = dataGrid.getIndexOfRow((AbstractRow)objLastEle);
            }
            switch (type) {
                case 1: {
                    if (this.insertNormalRows(dataGrid, currentIdx, isBefore, number)) break;
                    WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("grid.InsertColumnOperate.error1", ""), (String)dlg.getTitle(), (Component)this.getParentCtrl());
                    isToShowDialog = true;
                    break;
                }
                case 3: {
                    if (this.insertGroupRows(dataGrid, currentIdx, isBefore, number)) break;
                    WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("grid.InsertColumnOperate.error2", ""), (String)dlg.getTitle(), (Component)this.getParentCtrl());
                    isToShowDialog = true;
                    break;
                }
                case 4: {
                    R1PrintGroup group = new R1PrintGroup(dlg.getGroupField().getName());
                    if (this.insertGroup(dataGrid, group)) break;
                    WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("grid.InsertColumnOperate.error3", ""), (String)dlg.getTitle(), (Component)this.getParentCtrl());
                    isToShowDialog = true;
                    break;
                }
            }
        }
        if (dataGrid.isHorizontalFill() || dataGrid.isVerticalFill()) {
            IReportObject parentRo = (IReportObject)dataGrid.getParent().getRootPathComponent();
            ContainerUtil.layoutChildren(parentRo);
        }
        this.getCore().getPageContainer().repaint();
        return true;
    }

    @Override
    public boolean isValid() {
        IElement ele;
        ElementPath ep = this.getSelected();
        return ep != null && ((ele = (IElement)ep.getLastPathComponent()) instanceof AbstractCell || ele instanceof AbstractRow);
    }

    @Override
    public boolean isNeedShowUI() {
        return true;
    }

    private void insertSeveralRows(AbstractGrid grid, int type, int insertIdx, int several) {
        ArrayList<ElementPath> newSelection = new ArrayList<ElementPath>();
        for (int i = 0; i < several; ++i) {
            AbstractRow row = grid.insertRow(type, insertIdx);
            if (row == null) continue;
            this.getCore().getModel().allotSubElementIdWidthFire(grid, row);
            newSelection.add(grid.makeElementPath(row));
        }
        if (newSelection.size() > 0) {
            this.getCore().setSelection(newSelection.toArray(new ElementPath[0]));
        }
    }

    private void insertSeveralGroupRows(AbstractGrid grid, R1PrintGroup group, int insertIdx, int several) {
        ArrayList<ElementPath> newSelection = new ArrayList<ElementPath>();
        for (int i = 0; i < several; ++i) {
            AbstractGroupRow row = (AbstractGroupRow)grid.insertRow(3, insertIdx);
            row.setGroup(group);
            if (row == null) continue;
            this.getCore().getModel().allotSubElementIdWidthFire(grid, row);
            newSelection.add(grid.makeElementPath(row));
        }
        if (newSelection.size() > 0) {
            this.getCore().setSelection(newSelection.toArray(new ElementPath[0]));
        }
    }

    private boolean insertNormalRows(AbstractGrid grid, int currentIdx, boolean isBefore, int several) {
        AbstractRow currentRow = grid.getRow(currentIdx);
        if (currentRow instanceof AbstractNormalRow) {
            this.insertSeveralRows(grid, 1, currentIdx + (isBefore ? 0 : 1), several);
            return true;
        }
        if (isBefore) {
            if (currentIdx == 0 || grid.getRow(currentIdx - 1) instanceof AbstractNormalRow) {
                this.insertSeveralRows(grid, 1, currentIdx, several);
                return true;
            }
        } else {
            int bottomIdx = grid.getRowsCount() - 1;
            if (currentIdx == bottomIdx || grid.getRow(currentIdx + 1) instanceof AbstractNormalRow) {
                this.insertSeveralRows(grid, 1, currentIdx + 1, several);
                return true;
            }
        }
        return false;
    }

    private boolean insertGroupRows(AbstractDataGrid grid, int currentIdx, boolean isBefore, int several) {
        AbstractRow currentRow = grid.getRow(currentIdx);
        if (currentRow instanceof AbstractGroupRow) {
            R1PrintGroup g = (R1PrintGroup)((AbstractGroupRow)currentRow).getGroup();
            this.insertSeveralGroupRows(grid, g, currentIdx + (isBefore ? 0 : 1), several);
            return true;
        }
        return false;
    }

    private boolean insertGroup(AbstractDataGrid grid, R1PrintGroup group) {
        if (this.isGroupExist(grid, group)) {
            return false;
        }
        boolean beforeDetail = false;
        boolean topAdded = false;
        for (int i = grid.getRowsCount() - 1; i >= 0; --i) {
            AbstractRow row = grid.getRow(i);
            if (!beforeDetail && row instanceof AbstractDetailRow) {
                this.insertSeveralGroupRows(grid, group, i + 1, 1);
                beforeDetail = true;
            }
            if (!beforeDetail || row instanceof AbstractDetailRow) continue;
            this.insertSeveralGroupRows(grid, group, i + 1, 1);
            topAdded = true;
            break;
        }
        if (beforeDetail && !topAdded) {
            this.insertSeveralGroupRows(grid, group, 0, 1);
        }
        return true;
    }

    private boolean isGroupExist(AbstractDataGrid grid, R1PrintGroup group) {
        int c = grid.getRowsCount();
        for (int i = 0; i < c; ++i) {
            AbstractRow row = grid.getRow(i);
            if (!(row instanceof AbstractGroupRow) || !R1PrintGroup.equals(group, ((AbstractGroupRow)row).getGroup())) continue;
            return true;
        }
        return false;
    }

    public static class InsertSimpleRowDialog
    extends TypicalDialog {
        private KDSpinner spiNumber;
        private KDRadioButton radBeforeCurrent;
        private KDRadioButton radAfterCurrent;

        public InsertSimpleRowDialog() {
        }

        public InsertSimpleRowDialog(Frame owner) {
            super(owner);
        }

        public InsertSimpleRowDialog(Dialog owner) {
            super(owner);
        }

        protected void todoInit() {
            this.setTitle(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.insertRow", ""));
            this.setSize(200, 200);
            this.setResizable(false);
            this.spiNumber = new KDSpinner();
            SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 99, 1);
            this.spiNumber.setModel((SpinnerModel)model);
            this.radBeforeCurrent = new KDRadioButton(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.beforeRow", ""));
            this.radAfterCurrent = new KDRadioButton(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.afterRow", ""));
            KDButtonGroup groupPosition = new KDButtonGroup();
            groupPosition.add((AbstractButton)this.radBeforeCurrent);
            groupPosition.add((AbstractButton)this.radAfterCurrent);
            this.radAfterCurrent.setSelected(true);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            KDLabelContainer lbcNumber = new KDLabelContainer((JComponent)this.spiNumber);
            lbcNumber.setBoundLabelLength(60);
            lbcNumber.setBoundLabelText(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.rowNumber", ""));
            lbcNumber.setBoundLabelUnderline(true);
            KDPanel panPosition = new KDPanel(null);
            panPosition.setOpaque(false);
            panPosition.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.location", "")));
            panPosition.add((Component)this.radBeforeCurrent);
            panPosition.add((Component)this.radAfterCurrent);
            this.radBeforeCurrent.setBounds(20, 20, 100, 20);
            this.radAfterCurrent.setBounds(20, 40, 100, 20);
            Table tl = thisCell.split(3, 1);
            tl.rowStyle(0).setHeight(80);
            tl.rowStyle(1).setHeight(19);
            tl.rowStyle(1).setMargin(4, 8, 4, 0);
            tl.rowStyle(2).setPriY(1);
            parent.add((Component)panPosition, tl.cell(0));
            parent.add((Component)lbcNumber, tl.cell(1));
        }

        public int getNumber() {
            return (Integer)this.spiNumber.getValue();
        }

        public boolean isBeforeCurrent() {
            return this.radBeforeCurrent.isSelected();
        }
    }

    public static class InsertRowDialog
    extends TypicalDialog {
        public static final int Type_NormalRow = 1;
        public static final int Type_GroupRow = 3;
        public static final int Type_Grouop = 4;
        private KDRadioButton radNormalRow;
        private KDRadioButton radGroupRow;
        private KDRadioButton radGroup;
        private KDSpinner spiNumber;
        private KDComboBox cmbGroupField;
        private KDRadioButton radBeforeCurrent;
        private KDRadioButton radAfterCurrent;

        public InsertRowDialog() {
        }

        public InsertRowDialog(Dialog owner) {
            super(owner);
        }

        public InsertRowDialog(Frame owner) {
            super(owner);
        }

        protected void todoInit() {
            this.setTitle(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.insertRow", ""));
            this.setSize(305, 255);
            this.setResizable(false);
            this.radNormalRow = new KDRadioButton(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.normalRow", ""));
            this.radGroupRow = new KDRadioButton(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.groupRow", ""));
            this.radGroup = new KDRadioButton(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.radGroup", ""));
            this.spiNumber = new KDSpinner();
            SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 99, 1);
            this.spiNumber.setModel((SpinnerModel)model);
            this.cmbGroupField = new KDComboBox();
            this.radBeforeCurrent = new KDRadioButton(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.beforeRow", ""));
            this.radAfterCurrent = new KDRadioButton(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.afterRow", ""));
            KDButtonGroup groupType = new KDButtonGroup();
            groupType.add((AbstractButton)this.radNormalRow);
            groupType.add((AbstractButton)this.radGroupRow);
            groupType.add((AbstractButton)this.radGroup);
            KDButtonGroup groupPosition = new KDButtonGroup();
            groupPosition.add((AbstractButton)this.radBeforeCurrent);
            groupPosition.add((AbstractButton)this.radAfterCurrent);
            this.radNormalRow.setSelected(true);
            this.radAfterCurrent.setSelected(true);
            this.syncCtrlEnabled();
            this.installListener();
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            KDLabelContainer lbcNumber = new KDLabelContainer((JComponent)this.spiNumber);
            lbcNumber.setBoundLabelLength(60);
            lbcNumber.setBoundLabelText(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.rowNumber", ""));
            lbcNumber.setBoundLabelUnderline(true);
            KDLabelContainer lbcGroupField = new KDLabelContainer((JComponent)this.cmbGroupField);
            lbcGroupField.setBoundLabelLength(80);
            lbcGroupField.setBoundLabelText(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.groupField", ""));
            lbcGroupField.setBoundLabelUnderline(true);
            KDPanel panType = new KDPanel(null);
            panType.setOpaque(false);
            panType.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.type", "")));
            KDPanel panPosition = new KDPanel(null);
            panPosition.setOpaque(false);
            panPosition.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.location", "")));
            KDPanel panGroup = new KDPanel(null);
            panGroup.setOpaque(false);
            panGroup.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("grid.InsertColumnOperate.radGroup", "")));
            panType.add((Component)this.radNormalRow);
            panType.add((Component)this.radGroupRow);
            panType.add((Component)this.radGroup);
            this.radNormalRow.setBounds(20, 20, 120, 20);
            this.radGroupRow.setBounds(20, 50, 120, 20);
            this.radGroup.setBounds(20, 80, 120, 20);
            panPosition.add((Component)this.radBeforeCurrent);
            panPosition.add((Component)this.radAfterCurrent);
            this.radBeforeCurrent.setBounds(20, 20, 100, 20);
            this.radAfterCurrent.setBounds(20, 40, 100, 20);
            panGroup.add((Component)lbcGroupField);
            lbcGroupField.setBounds(20, 20, 240, 19);
            Table tl = thisCell.split(3, 1);
            tl.rowStyle(0).setHeight(115);
            tl.rowStyle(1).setHeight(60);
            tl.rowStyle(1).setMarginTop(8);
            tl.rowStyle(2).setPriY(1);
            Table tlRow1 = tl.cell(0).splitCol(2);
            tlRow1.colStyle(0).setWidth(150);
            tlRow1.colStyle(1).setMarginLeft(8);
            tlRow1.colStyle(1).setPriX(1);
            Table tlRow1Col2 = tlRow1.cell(1).splitRow(2);
            tlRow1Col2.rowStyle(0).setPriY(1);
            tlRow1Col2.rowStyle(1).setHeight(19);
            tlRow1Col2.rowStyle(1).setMargin(4, 8, 4, 0);
            parent.add((Component)panType, tlRow1.cell(0));
            parent.add((Component)panPosition, tlRow1Col2.cell(0));
            parent.add((Component)lbcNumber, tlRow1Col2.cell(1));
            parent.add((Component)panGroup, tl.cell(1));
        }

        private void installListener() {
            ActionHandler actionHandler = new ActionHandler();
            this.radNormalRow.addActionListener((ActionListener)actionHandler);
            this.radGroupRow.addActionListener((ActionListener)actionHandler);
            this.radGroup.addActionListener((ActionListener)actionHandler);
        }

        private void syncCtrlEnabled() {
            this.radAfterCurrent.setEnabled(!this.radGroup.isSelected());
            this.radBeforeCurrent.setEnabled(!this.radGroup.isSelected());
            this.spiNumber.setEnabled(!this.radGroup.isSelected());
            this.cmbGroupField.setEnabled(this.radGroup.isSelected());
        }

        public void setDataGrid(boolean isDataGrid) {
            this.radGroupRow.setEnabled(isDataGrid);
            this.radGroup.setEnabled(isDataGrid);
            this.syncCtrlEnabled();
        }

        public void setDatasource(MetaClass mc) {
            if (mc == null) {
                this.radGroup.setEnabled(false);
                this.syncCtrlEnabled();
                return;
            }
            Iterator it = mc.getFields().iterator();
            if (!it.hasNext()) {
                this.radGroup.setEnabled(false);
                this.syncCtrlEnabled();
                return;
            }
            while (it.hasNext()) {
                MetaField mf = (MetaField)it.next();
                this.cmbGroupField.addItem((Object)mf);
            }
        }

        public int getRowType() {
            return this.radNormalRow.isSelected() ? 1 : (this.radGroupRow.isSelected() ? 3 : 4);
        }

        public int getNumber() {
            return (Integer)this.spiNumber.getValue();
        }

        public boolean isBeforeCurrent() {
            return this.radBeforeCurrent.isSelected();
        }

        public MetaField getGroupField() {
            return (MetaField)this.cmbGroupField.getSelectedItem();
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertRowDialog.this.syncCtrlEnabled();
            }
        }
    }
}

