/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.ImageRender;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.IActionManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.data.DeleteDataOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.data.OrderDataOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.data.RenameDataOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.AbstractR1Designer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.DataTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.icon.R1DesignerIcons;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.owner.IR1DesignerOwner;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.wizard.IReportWizard;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.DataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReaderWriterFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlWriter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.IConfigFileCreator;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.config.R1PrintConfigReader;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.R1PrintActionManager;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.operate.data.AddDataOperate;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.operate.data.EditParamOperate;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.data.R1PrintDataManager;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.ScriptViewer;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.clipboard.R1PrintClipboard;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.formulatree.FormulaTree;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.provider.R1PrintPropertyPanelProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io.R1PrintXmlReader;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io.R1PrintXmlWriter;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.event.PopupMenuAdapter;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreePath;
import org.jdom2.Element;

public class R1PrintDesigner
extends AbstractR1Designer {
    private IConfigFileCreator _menuConfigCreator;
    private IConfigFileCreator _toolboxConfigCreator;
    private IConfigFileCreator _popupMenuConfigCreator;
    private IReportWizard _reportWizard;
    private String _title;

    public R1PrintDesigner(IR1DesignerOwner owner) {
        super(owner);
    }

    @Override
    protected String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    protected IConfigFileCreator getMenuConfigCreator() {
        if (this._menuConfigCreator == null) {
            this._menuConfigCreator = new IConfigFileCreator(){

                @Override
                public InputStream create() {
                    return R1PrintConfigReader.getDesignerMenu();
                }
            };
        }
        return this._menuConfigCreator;
    }

    public void setMenuConfigCreator(IConfigFileCreator creater) {
        this._menuConfigCreator = creater;
    }

    @Override
    protected IConfigFileCreator getToolboxConfigCreator() {
        if (this._toolboxConfigCreator == null) {
            this._toolboxConfigCreator = new IConfigFileCreator(){

                @Override
                public InputStream create() {
                    return R1PrintConfigReader.getToolbox();
                }
            };
        }
        return this._toolboxConfigCreator;
    }

    public void setToolboxConfigCreator(IConfigFileCreator creater) {
        this._toolboxConfigCreator = creater;
    }

    @Override
    protected IConfigFileCreator getPopupMenuConfigCreator() {
        if (this._popupMenuConfigCreator == null) {
            this._popupMenuConfigCreator = new IConfigFileCreator(){

                @Override
                public InputStream create() {
                    return R1PrintConfigReader.getPopupMenu();
                }
            };
        }
        return this._popupMenuConfigCreator;
    }

    public void setPopupMenuConfigCreator(IConfigFileCreator creater) {
        this._popupMenuConfigCreator = creater;
    }

    @Override
    public IReportWizard getReportWizard() {
        return this._reportWizard;
    }

    public void setReportWizard(IReportWizard wizard) {
        this._reportWizard = wizard;
    }

    @Override
    protected void initCore(ComboPanel core) {
        core.setPropertyPanelProvier(new R1PrintPropertyPanelProvider());
        core.addChangeListener(new TitleChangeHandler());
        IR1Ruler hRuler = core.getRuler(0);
        hRuler.setPixelPerUnit((float)KDToolkit.getCurrentDpi() / 25.43f);
        hRuler.setDrawingTenUnit(1);
        IR1Ruler vRuler = core.getRuler(1);
        vRuler.setPixelPerUnit((float)KDToolkit.getCurrentDpi() / 25.43f);
        vRuler.setDrawingTenUnit(1);
        core.setClipboard(new R1PrintClipboard());
        core.getPageContainer().setExtendedRenderer(new PageExtendedRenderer(core));
        core.getPageContainer().getPageBlank().x = 100;
        core.getPageContainer().getPageBlank().y = 50;
        this.initFormulaNavigation(core);
        ScriptViewer sv = new ScriptViewer(core);
        this.getCore().getStructureTree().addAction(sv.getAction());
    }

    @Override
    protected void initDataTree(DataTree dataTree) {
        dataTree.addButton(new AddDataOperate(), R1DesignerIcons.ICN_DataWizard, MultiLanguageUtil.getMLS("gui.R1PrintDesigner.addData", ""));
        dataTree.addButton(new DeleteDataOperate(), R1DesignerIcons.ICN_DELETE, MultiLanguageUtil.getMLS("gui.R1PrintDesigner.delData", ""));
        dataTree.addButton(new RenameDataOperate(), R1DesignerIcons.ICN_RENAME, MultiLanguageUtil.getMLS("gui.R1PrintDesigner.rename", ""));
        dataTree.addButton(new EditParamOperate(), R1DesignerIcons.ICN_SET, MultiLanguageUtil.getMLS("gui.R1PrintDesigner.setParameter", ""));
        dataTree.addButton(new OrderDataOperate(), R1DesignerIcons.ICN_ORDER, MultiLanguageUtil.getMLS("gui.R1PrintDesigner.fieldOrder", ""));
        dataTree.addTreePopupMenuListener(new TreePopupMenuHandler(this.getCore()));
    }

    private void initFormulaNavigation(ComboPanel core) {
        FormulaTree ft = new FormulaTree(core);
        core.addNavigation(MultiLanguageUtil.getMLS("gui.R1PrintDesigner.formula", ""), ft.getCtrl());
    }

    @Override
    protected IR1XmlReaderWriterFactory createXmlReaderWriterFactory() {
        return new XmlReaderWriterFactory();
    }

    @Override
    protected IActionManager createActionManager(AbstractR1Designer designer, Element xml) {
        return new R1PrintActionManager(designer, xml);
    }

    @Override
    protected IDataXmlTrans createDataXmlTrans() {
        return new DataXmlTrans();
    }

    @Override
    protected IR1DataManager createDataManager() {
        return new R1PrintDataManager();
    }

    protected class TreePopupMenuHandler
    implements TreePopupMenuListener {
        private ComboPanel core;

        public TreePopupMenuHandler(ComboPanel core) {
            this.core = core;
        }

        public boolean popMenu(TreePopupMenuEvent event) {
            TreePath treePath = event.getClosestPath();
            if (treePath != null) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
                Object selectedObject = node.getUserObject();
                if (!(selectedObject instanceof DataExtend)) {
                    return false;
                }
                DataExtend ext = (DataExtend)((Object)selectedObject);
                IR1DataManager dm = this.core.getModel().getDataManager();
                if (dm.isNameKeyWord(ext.getName())) {
                    return false;
                }
                DataExtend[] dataExts = dm.getDataExtends();
                boolean toShow = false;
                if (dataExts.length > 1 && !ext.equals((Object)dataExts[0])) {
                    List pss = ext.getParamSources();
                    if (pss.size() > 0) {
                        DataParamSource dps = (DataParamSource)((Object)pss.get(0));
                        if (StringUtil.isEmptyString((String)dps.getReferenceDataName())) {
                            toShow = true;
                        }
                    } else {
                        toShow = true;
                    }
                }
                if (toShow) {
                    final JPopupMenu menu = event.getMenu();
                    final KDMenuItem menuItem = new KDMenuItem((Action)new ToMainDsAction(ext));
                    menu.add((JMenuItem)menuItem);
                    event.getMenu().addPopupMenuListener((PopupMenuListener)new PopupMenuAdapter(){

                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            menu.remove((Component)menuItem);
                            menu.removePopupMenuListener((PopupMenuListener)((Object)this));
                        }
                    });
                    return true;
                }
            }
            return false;
        }

        class ToMainDsAction
        extends AbstractAction {
            private DataExtend target;

            public ToMainDsAction(DataExtend ext) {
                this.putValue("Name", MultiLanguageUtil.getMLS("gui.R1PrintDesigner.mainDataSource", ""));
                this.target = ext;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                IR1DataManager dm = TreePopupMenuHandler.this.core.getModel().getDataManager();
                Object data = dm.getObject(this.target.getName());
                dm.remveData(this.target);
                dm.insertData(0, this.target, data);
                StringBuffer sb = new StringBuffer();
                sb.append(MultiLanguageUtil.getMLS("gui.R1PrintDesigner.info1", ""));
                sb.append(MultiLanguageUtil.getMLS("gui.R1PrintDesigner.info2", ""));
                sb.append(MultiLanguageUtil.getMLS("gui.R1PrintDesigner.info3", ""));
                WindowUtil.msgboxInfo((Object)sb.toString(), (String)TreePopupMenuHandler.this.core.getPromptTitle(), (Component)TreePopupMenuHandler.this.core.getPanel());
            }
        }
    }

    private static class PageExtendedRenderer
    implements PageContainer.IExtendedRenderer {
        private ComboPanel core;

        public PageExtendedRenderer(ComboPanel core) {
            this.core = core;
        }

        @Override
        public void drawUnderPage(Graphics g) {
            R1PrintInfo printInfo = R1PrintModelHelper.getPrintInfo(this.core.getModel());
            R1PrintPage page = (R1PrintPage)this.core.getModel().getPage();
            Image image = page.getImg();
            if (image != null) {
                Graphics g4Paper1 = g.create();
                int offSetX = Util.lom2Pixel(page.getPictureOffSetX());
                int offSetY = Util.lom2Pixel(page.getPictureOffSetY());
                Point pt = new Point(offSetX, offSetY);
                ImageRender render = new ImageRender();
                if (page.isConsultPage()) {
                    g4Paper1.translate(this.core.getPageContainer().getPagePos().x, this.core.getPageContainer().getPagePos().y);
                    render.setGraphics2D((Graphics2D)g4Paper1.create(0, 0, page.getWidth(), page.getHeight()));
                } else {
                    g4Paper1.translate(this.core.getPageContainer().getPaperPos().x, this.core.getPageContainer().getPaperPos().y);
                    render.setGraphics2D((Graphics2D)g4Paper1.create(0, 0, Util.lom2Pixel(printInfo.getPrintablePaperSize().width), Util.lom2Pixel(printInfo.getPrintablePaperSize().height)));
                }
                render.draw(pt, image);
            }
            Graphics g4Paper = g.create();
            g4Paper.translate(this.core.getPageContainer().getPaperPos().x, this.core.getPageContainer().getPaperPos().y);
            g4Paper.setColor(new Color(200, 200, 200, 100));
            g4Paper.fillRect(0, 0, Util.lom2Pixel(printInfo.getMarginLeft()), Util.lom2Pixel(printInfo.getPrintablePaperSize().height));
            g4Paper.fillRect(Util.lom2Pixel(printInfo.getMarginLeft()) + page.getWidth(), 0, Util.lom2Pixel(printInfo.getMarginRight()), Util.lom2Pixel(printInfo.getPrintablePaperSize().height));
            g4Paper.fillRect(Util.lom2Pixel(printInfo.getMarginLeft()), 0, page.getWidth(), Util.lom2Pixel(printInfo.getMarginTop()));
            if (page.getHeight() <= Util.lom2Pixel(printInfo.getPrintableAreaSize().height)) {
                g4Paper.fillRect(Util.lom2Pixel(printInfo.getMarginLeft()), Util.lom2Pixel(printInfo.getPrintablePaperSize().height - printInfo.getMarginBottom()), page.getWidth(), Util.lom2Pixel(printInfo.getMarginBottom()));
            }
            PageContainer pageContainer = this.core.getPageContainer();
            this.core.getRuler(0).setZeroOfmark(pageContainer.getPagePos().x - pageContainer.getPaperPos().x);
            this.core.getRuler(1).setZeroOfmark(pageContainer.getPagePos().y - pageContainer.getPaperPos().y);
        }

        @Override
        public void drawUponPage(Graphics g) {
            Point offset = this.core.getPageContainer().getPagePos();
            R1PrintPage page = (R1PrintPage)this.core.getModel().getPage();
            int pageW = page.getWidth();
            int pageH = page.getHeight();
            R1PrintInfo info = R1PrintModelHelper.getPrintInfo(this.core.getModel());
            Dimension dim = info.getPrintableAreaSize();
            int printableAreaW = Util.lom2Pixel(dim.width);
            int printableAreaH = Util.lom2Pixel(dim.height);
            if (pageH != printableAreaH || pageW != printableAreaW) {
                Color oriColor = g.getColor();
                g.setColor(Color.BLUE);
                ((Graphics2D)g).setStroke(PenStyle.PS_DASHDOTDOT.getStroke(1));
                int hx1 = offset.x;
                int hy1 = offset.y + printableAreaH;
                int hx2 = offset.x + Math.max(pageW, printableAreaW);
                int hy2 = hy1;
                g.drawLine(hx1, hy1, hx2, hy2);
                int vx1 = offset.x + printableAreaW;
                int vy1 = offset.y;
                int vx2 = vx1;
                int vy2 = offset.y + Math.max(pageH, printableAreaH);
                g.drawLine(vx1, vy1, vx2, vy2);
                g.setColor(Color.BLACK);
                g.drawString(MultiLanguageUtil.getMLS("gui.R1PrintDesigner.pagination", ""), hx2 + 6, hy2 + 5);
                g.setColor(oriColor);
            }
        }
    }

    private static class XmlReaderWriterFactory
    implements IR1XmlReaderWriterFactory {
        private XmlReaderWriterFactory() {
        }

        @Override
        public IR1XmlReader createXmlReader() {
            return new R1PrintXmlReader();
        }

        @Override
        public IR1XmlWriter createXmlWriter() {
            return new R1PrintXmlWriter();
        }
    }

    class TitleChangeHandler
    implements PropertyChangeListener {
        TitleChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "title") {
                StringBuffer sb = new StringBuffer();
                sb.append(R1PrintDesigner.this.getTitle());
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    sb.append(" *");
                }
                R1PrintDesigner.this.getOwner().setTitle(sb.toString());
            }
        }
    }
}

