/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property;

import com.kingdee.bos.ctrl.kdf.util.style.Border;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.BorderPane;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.IPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Point;
import java.util.ArrayList;

public class PanelBorder
extends BorderPane
implements IPropertyPanel {
    private StyleAttributes _saBorder;
    private StyleAttributes _saBorderOri;
    private StyleAttributes _saInnerBorder;
    private BorderSorter[] _borderSorters;
    private final int S_Single = 0;
    private final int S_NorthWest = 1;
    private final int S_North = 2;
    private final int S_NorthEast = 3;
    private final int S_West = 4;
    private final int S_Navel = 5;
    private final int S_East = 6;
    private final int S_SouthWest = 7;
    private final int S_South = 8;
    private final int S_SouthEast = 9;
    private final int S_Top = 10;
    private final int S_Middle = 11;
    private final int S_Bottom = 12;
    private final int S_Left = 13;
    private final int S_Center = 14;
    private final int S_Right = 15;
    private final int[] B_Left = new int[]{1, 4, 7, 10, 11, 12, 13, 0};
    private final int[] B_Right = new int[]{3, 6, 9, 10, 11, 12, 15, 0};
    private final int[] B_Top = new int[]{1, 2, 3, 10, 13, 14, 15, 0};
    private final int[] B_Bottom = new int[]{7, 8, 9, 12, 13, 14, 15, 0};
    private final int[] B_Vertical_Left = new int[]{2, 5, 8, 3, 6, 9, 14, 15};
    private final int[] B_Vertical_Right = new int[]{1, 4, 7, 2, 5, 8, 13, 14};
    private final int[] B_Horizontal_Top = new int[]{4, 5, 6, 7, 8, 9, 11, 12};
    private final int[] B_Horizontal_Bottom = new int[]{1, 2, 3, 4, 5, 6, 10, 11};

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("property.PanelBorder.border", "");
    }

    @Override
    public KDPanel getPanel() {
        return this;
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eps) {
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        this._borderSorters = new BorderSorter[16];
        for (int i = 0; i < this._borderSorters.length; ++i) {
            this._borderSorters[i] = new BorderSorter();
        }
        this.sortBorder(eps);
        this._saBorder = this.mixBorder();
        this._saBorder.clearDirtyFlag();
        this.setSA(this._saBorder);
        this._saInnerBorder = this.mixInnerBorder();
        this._saInnerBorder.clearDirtyFlag();
        if (this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE) || this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE) || this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR)) {
            this.setInnerVEnabled(true);
        } else {
            this.setInnerVEnabled(this._saInnerBorder.getBorderLineStyle(Styles.Position.LEFT) != null);
        }
        if (this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_TOP_LINESTYLE) || this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_TOP_PENSTYLE) || this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_TOP_COLOR)) {
            this.setInnerHEnabled(true);
        } else {
            this.setInnerHEnabled(this._saInnerBorder.getBorderLineStyle(Styles.Position.TOP) != null);
        }
        this.setInnerSA(this._saInnerBorder);
        this._saBorderOri = Styles.getSA((StyleAttributes)this._saBorder);
    }

    @Override
    public void updateElementValue(ElementPath[] eps) {
        StyleAttributes saInnerBorderNew;
        if (!this._saBorder.equals((Object)this._saBorderOri)) {
            this.updateBorder();
        }
        if (!this._saInnerBorder.equals((Object)(saInnerBorderNew = this.getInnerBorder().getSA()))) {
            this._saInnerBorder = saInnerBorderNew;
            this.updateInnerBorder();
        }
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public void setContext(Object context) {
    }

    @Override
    public void outTab() {
    }

    @Override
    public void intoTab() {
    }

    private void sortBorder(ElementPath[] eps) {
        IElement ele = (IElement)eps[0].getLastPathComponent();
        IReportObject ro = (IReportObject)eps[0].getRootPathComponent();
        if (!(ele instanceof IReportObject)) {
            if (ro instanceof AbstractGrid) {
                this.sortGridBorder((AbstractGrid)ro, eps);
            } else {
                this._borderSorters[0].addElement(ele);
            }
        } else {
            for (int i = 0; i < eps.length; ++i) {
                ele = (IElement)eps[i].getLastPathComponent();
                ro = (IReportObject)eps[i].getRootPathComponent();
                if (ele instanceof AbstractGrid) {
                    this.sortGridBorder((AbstractGrid)ro, new ElementPath[]{eps[i]});
                    continue;
                }
                this._borderSorters[0].addElement(ele);
            }
        }
    }

    private void sortGridBorder(AbstractGrid grid, ElementPath[] eps) {
        int i;
        int rowsCount = grid.getRowsCount();
        int colsCount = grid.getColumnsCount();
        boolean[][] mark = new boolean[rowsCount][colsCount];
        int c = eps.length;
        for (int i2 = 0; i2 < c; ++i2) {
            int j;
            IElement ele = (IElement)eps[i2].getLastPathComponent();
            if (ele instanceof AbstractCell) {
                Point idx = grid.getIndexOfCell((AbstractCell)ele);
                mark[idx.x][idx.y] = true;
                continue;
            }
            if (ele instanceof AbstractRow) {
                int idx = grid.getIndexOfRow((AbstractRow)ele);
                for (j = 0; j < colsCount; ++j) {
                    mark[idx][j] = true;
                }
                continue;
            }
            if (ele instanceof AbstractColumn) {
                int idx = grid.getIndexOfColumn((AbstractColumn)ele);
                for (j = 0; j < rowsCount; ++j) {
                    mark[j][idx] = true;
                }
                continue;
            }
            if (ele != grid) continue;
            for (int j2 = 0; j2 < rowsCount; ++j2) {
                for (int k = 0; k < colsCount; ++k) {
                    mark[j2][k] = true;
                }
            }
            break;
        }
        int rMin = -1;
        int rMax = -1;
        boolean isMinFound = false;
        boolean isMaxFound = false;
        for (int i3 = 0; i3 < rowsCount; ++i3) {
            for (int j = 0; j < colsCount; ++j) {
                if (mark[i3][j] && !isMinFound) {
                    isMinFound = true;
                    rMin = i3;
                }
                if (!mark[rowsCount - i3 - 1][colsCount - j - 1] || isMaxFound) continue;
                isMaxFound = true;
                rMax = rowsCount - i3 - 1;
            }
            if (isMinFound && isMaxFound) break;
        }
        int cMin = -1;
        int cMax = -1;
        isMinFound = false;
        isMaxFound = false;
        for (int j = 0; j < colsCount; ++j) {
            for (i = 0; i < rowsCount; ++i) {
                if (mark[i][j] && !isMinFound) {
                    isMinFound = true;
                    cMin = j;
                }
                if (!mark[rowsCount - i - 1][colsCount - j - 1] || isMaxFound) continue;
                isMaxFound = true;
                cMax = colsCount - j - 1;
            }
            if (isMinFound && isMaxFound) break;
        }
        boolean isRect = true;
        if (!mark[rMin][cMin] || !mark[rMax][cMax]) {
            isRect = false;
        } else {
            for (i = rMin; i <= rMax; ++i) {
                for (int j = cMin; j <= cMax; ++j) {
                    if (mark[i][j]) continue;
                    isRect = false;
                    break;
                }
                if (!isRect) break;
            }
        }
        if (!isRect) {
            for (i = rMin; i <= rMax; ++i) {
                AbstractRow row = grid.getRow(i);
                for (int j = cMin; j <= cMax; ++j) {
                    if (!mark[i][j]) continue;
                    this._borderSorters[0].addElement(row.getCell(j));
                }
            }
        } else {
            boolean isSingleCol;
            boolean isSingleRow = rMin == rMax;
            boolean bl = isSingleCol = cMin == cMax;
            if (isSingleRow) {
                AbstractRow row = grid.getRow(rMin);
                if (isSingleCol) {
                    this._borderSorters[0].addElement(row.getCell(cMin));
                } else {
                    this._borderSorters[13].addElement(row.getCell(cMin));
                    this._borderSorters[15].addElement(row.getCell(cMax));
                    for (int i4 = cMin + 1; i4 <= cMax - 1; ++i4) {
                        this._borderSorters[14].addElement(row.getCell(i4));
                    }
                }
            } else if (isSingleCol) {
                this._borderSorters[10].addElement(grid.getCell(rMin, cMin));
                this._borderSorters[12].addElement(grid.getCell(rMax, cMin));
                for (int i5 = rMin + 1; i5 <= rMax - 1; ++i5) {
                    this._borderSorters[11].addElement(grid.getCell(i5, cMin));
                }
            } else {
                for (int i6 = rMin; i6 <= rMax; ++i6) {
                    AbstractRow row = grid.getRow(i6);
                    for (int j = cMin; j <= cMax; ++j) {
                        int m = i6 == rMin ? (j == cMin ? 1 : (j == cMax ? 3 : 2)) : (i6 == rMax ? (j == cMin ? 7 : (j == cMax ? 9 : 8)) : (j == cMin ? 4 : (j == cMax ? 6 : 5)));
                        this._borderSorters[m].addElement(row.getCell(j));
                    }
                }
            }
        }
    }

    private StyleAttributes mixBorder() {
        StyleAttributes sa = Styles.getEmptySA();
        this.mixBorder(sa, this.B_Left, Styles.Position.LEFT, Styles.Position.LEFT);
        this.mixBorder(sa, this.B_Right, Styles.Position.RIGHT, Styles.Position.RIGHT);
        this.mixBorder(sa, this.B_Top, Styles.Position.TOP, Styles.Position.TOP);
        this.mixBorder(sa, this.B_Bottom, Styles.Position.BOTTOM, Styles.Position.BOTTOM);
        return sa;
    }

    private StyleAttributes mixInnerBorder() {
        StyleAttributes sa = Styles.getEmptySA();
        this.mixBorder(sa, this.B_Vertical_Left, Styles.Position.LEFT, Styles.Position.LEFT);
        this.mixBorder(sa, this.B_Vertical_Right, Styles.Position.RIGHT, Styles.Position.LEFT);
        this.mixBorder(sa, this.B_Horizontal_Top, Styles.Position.TOP, Styles.Position.TOP);
        this.mixBorder(sa, this.B_Horizontal_Bottom, Styles.Position.BOTTOM, Styles.Position.TOP);
        return sa;
    }

    private void mixBorder(StyleAttributes sa, int[] suffix, Styles.Position posSource, Styles.Position posTarget) {
        for (int i = 0; i < suffix.length; ++i) {
            BorderSorter bs = this._borderSorters[suffix[i]];
            IElement[] eles = bs.getElements();
            for (int j = 0; j < eles.length; ++j) {
                Border border = Styles.getStyle((ShareStyleAttributes)eles[j].getNotNullSA()).getBorder(posSource);
                sa.mixBorder(border, posTarget);
            }
        }
    }

    private void updateBorder() {
        if (!(this._saBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE) || this._saBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE) || this._saBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR))) {
            this.updateBorder(this._saBorder, this.B_Left, Styles.Position.LEFT, Styles.Position.LEFT);
        }
        if (!(this._saBorder.isUnsureValue(StyleAttributes.BORDER_RIGHT_LINESTYLE) || this._saBorder.isUnsureValue(StyleAttributes.BORDER_RIGHT_PENSTYLE) || this._saBorder.isUnsureValue(StyleAttributes.BORDER_RIGHT_COLOR))) {
            this.updateBorder(this._saBorder, this.B_Right, Styles.Position.RIGHT, Styles.Position.RIGHT);
        }
        if (!(this._saBorder.isUnsureValue(StyleAttributes.BORDER_TOP_LINESTYLE) || this._saBorder.isUnsureValue(StyleAttributes.BORDER_TOP_PENSTYLE) || this._saBorder.isUnsureValue(StyleAttributes.BORDER_TOP_COLOR))) {
            this.updateBorder(this._saBorder, this.B_Top, Styles.Position.TOP, Styles.Position.TOP);
        }
        if (!(this._saBorder.isUnsureValue(StyleAttributes.BORDER_BOTTOM_LINESTYLE) || this._saBorder.isUnsureValue(StyleAttributes.BORDER_BOTTOM_PENSTYLE) || this._saBorder.isUnsureValue(StyleAttributes.BORDER_BOTTOM_COLOR))) {
            this.updateBorder(this._saBorder, this.B_Bottom, Styles.Position.BOTTOM, Styles.Position.BOTTOM);
        }
    }

    private void updateInnerBorder() {
        if (!(this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE) || this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE) || this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR))) {
            this.updateBorder(this._saInnerBorder, this.B_Vertical_Left, Styles.Position.LEFT, Styles.Position.LEFT);
            this.updateBorder(this._saInnerBorder, this.B_Vertical_Right, Styles.Position.LEFT, Styles.Position.RIGHT);
        }
        if (!(this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_TOP_LINESTYLE) || this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_TOP_PENSTYLE) || this._saInnerBorder.isUnsureValue(StyleAttributes.BORDER_TOP_COLOR))) {
            this.updateBorder(this._saInnerBorder, this.B_Horizontal_Top, Styles.Position.TOP, Styles.Position.TOP);
            this.updateBorder(this._saInnerBorder, this.B_Horizontal_Bottom, Styles.Position.TOP, Styles.Position.BOTTOM);
        }
    }

    private void updateBorder(StyleAttributes sa, int[] suffix, Styles.Position posSource, Styles.Position posTarget) {
        Border border = Styles.getStyle((ShareStyleAttributes)sa).getBorder(posSource);
        for (int i = 0; i < suffix.length; ++i) {
            BorderSorter bs = this._borderSorters[suffix[i]];
            IElement[] eles = bs.getElements();
            for (int j = 0; j < eles.length; ++j) {
                eles[j].getNotNullSA().setBorder(border, posTarget);
            }
        }
    }

    private static class BorderSorter {
        private ArrayList elements = new ArrayList();

        private BorderSorter() {
        }

        public void addElement(IElement ele) {
            this.elements.add(ele);
        }

        public IElement[] getElements() {
            return this.elements.toArray(new IElement[0]);
        }
    }
}

