/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.R1PrintGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.AbstractGridCreatorStep;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.GroupObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.Model;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.StatObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.StepSelectData;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.StepSelectField;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.StepSelectGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.StepSelectStat;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;

public class GridCreatorWizard {
    private StepSelectData _stepSelectData;
    private StepSelectField _stepSelectField;
    private StepSelectGroup _stepSelectGroup;
    private StepSelectStat _stepSelectStat;
    private Model _model = new Model();

    public boolean reCreateDataGrid(DataGrid grid, IR1DataManager dm, JComponent parentCtrl) {
        WizardDialog dlg = this.getDialog(parentCtrl);
        this.setSteps(dlg, dm);
        dlg.show();
        if (dlg.isFinished()) {
            int w = grid.getWidthLom();
            int h = grid.getHeightLom();
            String dsName = dm.getNameByObj(this._model.getSelectedDataSource());
            grid.removeAllCell();
            this.initDataGrid(grid, dsName, w, h);
            return true;
        }
        return false;
    }

    private WizardDialog getDialog(JComponent parentCtrl) {
        WizardDialog dlg = (WizardDialog)WindowUtil.createWindow(WizardDialog.class, (Component)parentCtrl);
        dlg.setModal(true);
        dlg.setBigSize(true);
        dlg.setLocationRelativeTo(null);
        dlg.hidePicture();
        dlg.setTitle(MultiLanguageUtil.getMLS("datagrid.GridCreatorWizard.gridWizard", ""), true);
        return dlg;
    }

    private void setSteps(WizardDialog dlg, IR1DataManager dm) {
        this._stepSelectData = new StepSelectData(dm);
        this._stepSelectField = new StepSelectField();
        this._stepSelectGroup = new StepSelectGroup();
        this._stepSelectStat = new StepSelectStat();
        this._stepSelectData.setModel(this._model);
        this._stepSelectField.setModel(this._model);
        this._stepSelectGroup.setModel(this._model);
        this._stepSelectStat.setModel(this._model);
        ArrayList<AbstractGridCreatorStep> list = new ArrayList<AbstractGridCreatorStep>();
        list.add(this._stepSelectData);
        list.add(this._stepSelectField);
        list.add(this._stepSelectGroup);
        list.add(this._stepSelectStat);
        dlg.setStepsList(list);
    }

    private void initDataGrid(AbstractDataGrid grid, String dsName, int w, int h) {
        grid.getDataSource().setDs(dsName);
        grid.addRow(1);
        AbstractDetailRow dataRow = (AbstractDetailRow)grid.addRow(2);
        Field[] fields = this._model.getSelectedFields();
        int c = fields.length;
        for (int i = 0; i < c; ++i) {
            Field mf = fields[i];
            AbstractColumn col = grid.addColumn();
            col.setWidthLom(Util.pixel2Lom(100));
            if (w <= 0) {
                col.setWidthLom(c < 8 ? 200 : (c < 16 ? 100 : 1600 / c));
            } else {
                col.setWidthLom((int)((float)w / (float)c));
            }
            DataGridCell cellHead = (DataGridCell)grid.getCell(0, i);
            DataGridCell cellDetail = (DataGridCell)grid.getCell(1, i);
            cellHead.setValue(new Text(mf.getAliasName()));
            cellDetail.setValue(CellField.create(mf));
        }
        GroupObject[] groupObjects = this._model.getGroups();
        if (groupObjects != null) {
            for (int i = 0; i < groupObjects.length; ++i) {
                GroupObject groupObject = groupObjects[i];
                ArrayList[] counts = GridCreatorWizard.getStatCount(groupObject);
                if (groupObject.getGroup().getAccording() == null) {
                    GridCreatorWizard.addTotalStatRows(grid, dataRow, counts[0], counts[1]);
                    continue;
                }
                GridCreatorWizard.addGroupStatRows(grid, dataRow, groupObject.getGroup(), counts[0], counts[1]);
            }
        }
        if (h > 0) {
            c = grid.getRowsCount();
            int rowH = (int)((float)h / (float)c);
            for (int i = 0; i < c; ++i) {
                grid.getRow(i).setHeightLom(rowH);
            }
        }
    }

    private static void addTotalStatRows(AbstractDataGrid grid, AbstractDetailRow detailRow, ArrayList heads, ArrayList tails) {
        int detailRowIdx;
        int tailIdx = detailRowIdx = grid.getIndexOfRow(detailRow);
        ArrayList<AbstractRow> tailRows = new ArrayList<AbstractRow>();
        for (StatObject stat : tails) {
            int colIdx = GridCreatorWizard.searchBoundFieldColumnIndex(detailRow, stat.getStatField());
            AbstractRow row = GridCreatorWizard.getRowToAddStat(tailRows, colIdx);
            if (row == null) {
                row = grid.insertRow(1, ++tailIdx);
                tailRows.add(row);
            }
            DataGridCell cell = (DataGridCell)row.getCell(colIdx);
            cell.setValue(stat.getStatField());
        }
        int headIdx = detailRowIdx - 1;
        ArrayList<AbstractRow> headRows = new ArrayList<AbstractRow>();
        for (StatObject stat : heads) {
            int colIdx = GridCreatorWizard.searchBoundFieldColumnIndex(detailRow, stat.getStatField());
            AbstractRow row = GridCreatorWizard.getRowToAddStat(headRows, colIdx);
            if (row == null) {
                row = grid.insertRow(1, ++headIdx);
                headRows.add(row);
            }
            DataGridCell cell = (DataGridCell)row.getCell(colIdx);
            cell.setValue(stat.getStatField());
        }
    }

    private static void addGroupStatRows(AbstractDataGrid grid, AbstractDetailRow detailRow, R1PrintGroup group, ArrayList heads, ArrayList tails) {
        int detailRowIdx;
        int tailIdx = detailRowIdx = grid.getIndexOfRow(detailRow);
        ArrayList<AbstractRow> tailRows = new ArrayList<AbstractRow>();
        AbstractGroupRow groupRow = (AbstractGroupRow)grid.insertRow(3, ++tailIdx);
        groupRow.setGroup(group);
        tailRows.add(groupRow);
        for (StatObject stat : tails) {
            int colIdx = GridCreatorWizard.searchBoundFieldColumnIndex(detailRow, stat.getStatField());
            AbstractRow row = GridCreatorWizard.getRowToAddStat(tailRows, colIdx);
            if (row == null) {
                row = grid.insertRow(3, ++tailIdx);
                ((AbstractGroupRow)row).setGroup(group);
                tailRows.add(row);
            }
            DataGridCell cell = (DataGridCell)row.getCell(colIdx);
            cell.setValue(stat.getStatField());
        }
        int headIdx = detailRowIdx - 1;
        ArrayList<AbstractRow> headRows = new ArrayList<AbstractRow>();
        groupRow = (AbstractGroupRow)grid.insertRow(3, ++headIdx);
        groupRow.setGroup(group);
        headRows.add(groupRow);
        for (StatObject stat : heads) {
            int colIdx = GridCreatorWizard.searchBoundFieldColumnIndex(detailRow, stat.getStatField());
            AbstractRow row = GridCreatorWizard.getRowToAddStat(headRows, colIdx);
            if (row == null) {
                row = grid.insertRow(3, ++headIdx);
                ((AbstractGroupRow)row).setGroup(group);
                headRows.add(row);
            }
            DataGridCell cell = (DataGridCell)row.getCell(colIdx);
            cell.setValue(stat.getStatField());
        }
    }

    private static ArrayList[] getStatCount(GroupObject groupObject) {
        ArrayList<StatObject> heads = new ArrayList<StatObject>();
        ArrayList<StatObject> tails = new ArrayList<StatObject>();
        StatObject[] stats = groupObject.getStatObjects();
        for (int i = 0; i < stats.length; ++i) {
            if (stats[i].isAtHeader()) {
                heads.add(stats[i]);
                continue;
            }
            tails.add(stats[i]);
        }
        return new ArrayList[]{heads, tails};
    }

    private static int searchBoundFieldColumnIndex(AbstractDetailRow detailRow, StatField statField) {
        Field mf = statField.getField();
        int idx = 0;
        int c = detailRow.getCellCount();
        for (int i = 0; i < c; ++i) {
            DataGridCell cell = (DataGridCell)detailRow.getCell(i);
            Field field = (Field)((Object)cell.getValue());
            if (!mf.equals(field)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    private static AbstractRow getRowToAddStat(ArrayList rows, int ColIdx) {
        for (AbstractRow row : rows) {
            DataGridCell cell = (DataGridCell)row.getCell(ColIdx);
            if (cell.getValue() != null) continue;
            return row;
        }
        return null;
    }
}

