/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.common.currency.CurrencyFormatManager;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ScriptSystemMethod;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.BlankRowDataHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.CurrencyFormat;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;

public class PWCurrency
extends AbstractPrintWidgetText {
    private CurrencyFormat _currencyFormat;

    public CurrencyFormat getFormatDescription() {
        if (this._currencyFormat == null) {
            this._currencyFormat = new CurrencyFormat();
        }
        return this._currencyFormat;
    }

    public void setFormatDescription(CurrencyFormat desc) {
        this._currencyFormat = desc;
    }

    @Override
    public IPrintWidget copy() {
        IPrintWidget widget = super.copy();
        PWCurrency wc = (PWCurrency)widget;
        wc.setFormatDescription(this.getFormatDescription());
        return widget;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        String ds;
        PWCurrency output = (PWCurrency)outputWidget;
        if (StringUtil.isEmptyString((String)this.getDatasource())) {
            output.setOutputValue(new Variant((Object)output.getOriValue()));
        } else {
            ds = output.getDatasource();
            output.setOutputValue(this.getDataHelper(helper, ds).getFieldValue(ds, output.getOriValue()));
        }
        if (StringUtil.isEmptyString((String)this.getFormatDescription().getCurrencyCodeDatasource())) {
            output.getFormatDescription().setCurrencyCode(this.getFormatDescription().getCurrencyCodeField());
        } else {
            ds = output.getFormatDescription().getCurrencyCodeDatasource();
            output.getFormatDescription().setCurrencyCode(this.getDataHelper(helper, ds).getFieldValue(ds, output.getFormatDescription().getCurrencyCodeField()).toString());
        }
        output.formatOutput();
    }

    private static CurrencyFormatManager getFormater() {
        return CurrencyFormatManager.shareInstance();
    }

    @Override
    public void formatOutput() {
        if (this.getOutputValue().getValue() == null) {
            this.setOutputText("");
            return;
        }
        if (this.getOutputValue() == BlankRowDataHelper.EMPTY) {
            this.setOutputText(this.getOutputValue().toString());
            return;
        }
        StringBuffer outputText = new StringBuffer();
        if (this.getFormatDescription().isLowerNumber()) {
            outputText.append(this.getOutputValue().toString());
        } else if (this.getFormatDescription().isTypeNote()) {
            if (this.getFormatDescription().getCurrencyCode() != null) {
                ScriptSystemMethod ssm = new ScriptSystemMethod();
                String symbol = PWCurrency.getFormater().getSymbol(this.getFormatDescription().getCurrencyCode());
                outputText.append(ssm.formatChequeCurrency(this.getOutputValue(), symbol.charAt(symbol.length() - 1), 1));
            } else {
                outputText.append(this.getOutputValue());
            }
        } else {
            outputText.append(PWCurrency.getFormater().upperFomat(this.getFormatDescription().getCurrencyCode(), this.getFormatDescription().getLanguage().getLocale(), this.getOutputValue(), this.getFormatDescription().isAddPrefix()));
        }
        if (this.getFormatDescription().isAddPrefix() && !this.getFormatDescription().isTypeNote() && this.getFormatDescription().isLowerNumber()) {
            outputText.insert(0, PWCurrency.getFormater().getSymbol(this.getFormatDescription().getCurrencyCode()));
        }
        this.setOutputText(outputText.toString());
    }
}

