/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.loop;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.R1PDataVisitor;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.log4j.Logger;

class TransposedDataHelper
implements IWidgetExecuteHelper.IDataHelper {
    private static final Logger log = LogUtil.getPackageLogger(TransposedDataHelper.class);
    private R1PDataVisitor _dataVisitor;

    public TransposedDataHelper(IRowSet rowSet) {
        try {
            this._dataVisitor = R1PDataVisitor.create(rowSet);
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            throw new R1PrintRuntimeException("Create transpose data error.");
        }
    }

    @Override
    public int getCurrentPositon(String ds) {
        return this._dataVisitor.getCurrentPositon();
    }

    @Override
    public Variant getFieldValue(String ds, String field) {
        try {
            if (this._dataVisitor.isBOF() && this._dataVisitor.isDataChanged()) {
                this._dataVisitor.next();
            }
            return this._dataVisitor.getFieldData(field);
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    @Override
    public Variant getPreviousRowFieldValue(String ds, String field) {
        try {
            return this._dataVisitor.getPreviousRowFieldData(field);
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    @Override
    public Variant getPropheticRowFieldData(String ds, String field) {
        try {
            return this._dataVisitor.getPropheticRowFieldData(field);
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasNext(String ds) {
        try {
            return this._dataVisitor.hasNext();
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isBOF(String ds) {
        try {
            return this._dataVisitor.isBOF();
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isEOF(String ds) {
        try {
            return this._dataVisitor.isEOF();
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isNumberField(String ds, String field) {
        int type;
        try {
            type = this._dataVisitor.getFieldType(field);
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
        return type == 4 || type == 6 || type == 8 || type == 2 || type == 3 || type == -5 || type == 5 || type == -6;
    }

    @Override
    public boolean next(String ds) {
        try {
            return this._dataVisitor.next();
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isContextRelative() {
        return true;
    }

    @Override
    public void beforeFirst(String ds) {
        try {
            this._dataVisitor.secondSpring();
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public int getRowsCount(String ds) {
        try {
            return this._dataVisitor.getRowsCount();
        }
        catch (R1PrintDataException e) {
            log.error((Object)"", (Throwable)e);
            return -1;
        }
    }
}

