/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportframework;

import com.kingdee.bos.ctrl.bizshare.EnumType;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.data.invoke.AbstractLocalDataExecutor;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ReportType;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.KdrsConfigure;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.AReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportframework.design.IReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.AbstractLocalReportExecutor;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportFactory {
    public static final Logger log = LogUtil.getPackageLogger(ReportFactory.class);
    public static final String ATTR_BROWSER = "browser";
    public static final String ATTR_REPORT_EXECUTOR = "report-executor";
    public static final String ATTR_DESIGNER = "designer";
    public static final String ATTR_DATA_EXECUTOR = "data-executor";
    public static final String ATTR_STATIC_METACLASS = "static-mc";
    public static final String ATTR_IS_REPORT = "is-report";
    public static final String ATTR_REPORT_EXECUTOR_INTERFACE = "report-executor-interface";
    public static final ReportType REPORT_FORM = ReportType.FORM;
    public static final ReportType REPORT_OLAP = ReportType.OLAP;
    public static final EnumType KDRS_XDATA = new EnumType("kdrs-xdata", "kdrs-xdata");

    private static Class loadClass(Object category, String category_attr) throws ReportException {
        if (category == null) {
            return null;
        }
        String name = category.toString();
        Map map = ReportFactory.getCategoryAttributes(name);
        if (map == null) {
            return null;
        }
        Object object = map.get(category_attr);
        if (object instanceof String) {
            try {
                object = Class.forName((String)object);
                map.put(category_attr, object);
            }
            catch (Exception ex) {
                throw ReportException.makeException(ex.toString(), ex);
            }
        }
        return (Class)object;
    }

    public static AReportBrowser createBrowser(Object category, Component owner) throws ReportException {
        Class browserCls = ReportFactory.loadClass(category, ATTR_BROWSER);
        if (browserCls != null) {
            try {
                Constructor c = browserCls.getConstructor(Component.class);
                return (AReportBrowser)c.newInstance(owner);
            }
            catch (Exception ex) {
                throw ReportException.makeException(ex.toString(), ex);
            }
        }
        throw new ReportException(MultiLanguageUtil.getMLS("reportframework.ReportFactory.unrecognizedReportType", "") + category);
    }

    public static IReportDesigner createDesigner(Object category, Component owner) throws ReportException {
        Class browserCls = ReportFactory.loadClass(category, ATTR_DESIGNER);
        if (browserCls != null) {
            try {
                Constructor c = browserCls.getConstructor(Component.class);
                return (IReportDesigner)c.newInstance(owner);
            }
            catch (Exception ex) {
                throw ReportException.makeException(ex.toString(), ex);
            }
        }
        throw new ReportException(MultiLanguageUtil.getMLS("reportframework.ReportFactory.unrecognizedReportType", "") + category);
    }

    public static AbstractLocalDataExecutor createDataExecutor(Object category) throws ReportException {
        Class dataExecutorCls = ReportFactory.loadClass(category, ATTR_DATA_EXECUTOR);
        if (dataExecutorCls != null) {
            try {
                Constructor c = dataExecutorCls.getConstructor(new Class[0]);
                return (AbstractLocalDataExecutor)c.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw ReportException.makeException(ex.toString(), ex);
            }
        }
        throw new ReportException(MultiLanguageUtil.getMLS("reportframework.ReportFactory.unrecognizedReportType", "") + category);
    }

    public static AbstractLocalReportExecutor createExecutor(Object category) throws ReportException {
        Class browserCls = ReportFactory.loadClass(category, ATTR_REPORT_EXECUTOR);
        if (browserCls != null) {
            try {
                Constructor c = browserCls.getConstructor(new Class[0]);
                return (AbstractLocalReportExecutor)c.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw ReportException.makeException(ex.toString(), ex);
            }
        }
        throw new ReportException(MultiLanguageUtil.getMLS("reportframework.ReportFactory.unrecognizedReportType", "") + category);
    }

    public static final Class getReportExecutorType(String category) throws ReportException {
        return ReportFactory.loadClass(category, ATTR_REPORT_EXECUTOR_INTERFACE);
    }

    public static final boolean isStaticMetaClass(String category) throws ReportException {
        String name;
        Map map;
        if (category != null && (map = ReportFactory.getCategoryAttributes(name = category.toString())) != null) {
            String str = (String)map.get(ATTR_STATIC_METACLASS);
            return Boolean.valueOf(str);
        }
        throw new ReportException(MultiLanguageUtil.getMLS("reportframework.ReportFactory.unrecognizedReportType", "") + category);
    }

    public static final boolean isReportType(String category) throws ReportException {
        String name;
        Map map;
        if (category != null && (map = ReportFactory.getCategoryAttributes(name = category.toString())) != null) {
            String str = (String)map.get(ATTR_IS_REPORT);
            return Boolean.valueOf(str);
        }
        throw new ReportException(MultiLanguageUtil.getMLS("reportframework.ReportFactory.unrecognizedReportType", "") + category);
    }

    public static Map getCategoryAttributes(String category) {
        return KdrsConfigure.getCategoryAttributes(category);
    }

    public static String getCategoryAttribute(String category, String attName) {
        Map atts = ReportFactory.getCategoryAttributes(category);
        return atts != null ? (String)atts.get(attName) : null;
    }

    public static String[] getAcceptableCatgories(String category) {
        String metas = ReportFactory.getCategoryAttribute(category, "metas");
        if (metas != null) {
            return metas.split(",");
        }
        return null;
    }
}

