/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.CubeModelEditor;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.IStorage;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.reportone.data.modal.Import;
import com.kingdee.bos.ctrl.reportone.data.modal.Imports;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.AcceptParametersPanel;
import com.kingdee.bos.ctrl.reportone.reportframework.IObjectStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.CubeParametersProvider;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.KdrsCubeModel;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.KdrsCubeModelUtil;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.ui.KdrsCubeModelConfigurePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ReportStorage_CubeModelStorage
implements IStorage {
    IReportStorage rptSto;
    IObjectSelector mdSelector;
    CubeModelEditor cmEditor;
    private KdrsCubeModel oldCubeModel;

    public ReportStorage_CubeModelStorage(IReportStorage rptSto, IObjectSelector mdSelector) {
        this.rptSto = rptSto;
        this.mdSelector = mdSelector;
    }

    public void setCmEditor(CubeModelEditor cmEditor) {
        this.cmEditor = cmEditor;
    }

    public static KdrsCubeModel load(InputStream in) throws ReportException {
        try {
            KdrsCubeModel model = new KdrsCubeModel();
            model.loadXML(XmlUtil.loadXmlStream((InputStream)in));
            return model;
        }
        catch (Exception ex) {
            throw ReportException.makeException("", ex);
        }
    }

    public CubeModel open() throws AnalysisException {
        CubeModel cubeModel;
        InputStream in = null;
        try {
            if (this.rptSto instanceof IStreamStorage) {
                in = ((IStreamStorage)this.rptSto).getInputStream();
                KdrsCubeModel kdrsCubeModel = this.oldCubeModel = ReportStorage_CubeModelStorage.load(in);
                return kdrsCubeModel;
            }
            cubeModel = (CubeModel)((IObjectStorage)this.rptSto).getInputObject();
        }
        catch (ReportException ex) {
            throw new AnalysisException((Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return cubeModel;
    }

    public boolean save(CubeModel cubeModel) throws AnalysisException {
        boolean bl;
        OutputStream out = null;
        try {
            KdrsCubeModel newModel = this.createWrappedCubeModel(cubeModel, this.oldCubeModel == null, true);
            if (newModel == null) {
                boolean bl2 = false;
                return bl2;
            }
            this.oldCubeModel = newModel;
            cubeModel = newModel;
            if (this.rptSto instanceof IStreamStorage) {
                out = ((IStreamStorage)this.rptSto).getOutputStream();
                CubeModelUtil.saveSchema((CubeModel)cubeModel, (OutputStream)out, (String)"UTF-8");
            } else {
                ((IObjectStorage)this.rptSto).setOutputObject(cubeModel);
            }
            bl = true;
        }
        catch (ReportException ex) {
            throw new AnalysisException((Throwable)ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public void temporarilySave(CubeModel cubeModel) {
        this.oldCubeModel = this.createWrappedCubeModel(cubeModel, true, false);
    }

    private void copyModel(KdrsCubeModel m1, KdrsCubeModel m2) {
        if (m2 == null || m2.getCubes() == null) {
            return;
        }
        if (m2.getImports() != null) {
            m1.setImports(m2.getImports());
        }
        if (m2.getParameters() != null) {
            for (int i = 0; i < m2.getParameters().size(); ++i) {
                m1.getParameters().add(m2.getParameters().get(i));
            }
        }
    }

    private KdrsCubeModel createWrappedCubeModel(CubeModel cubeModel, boolean forceConfig, boolean callBySave) {
        boolean needReConfig = forceConfig;
        if (cubeModel == null) {
            return null;
        }
        Imports imports_cur = KdrsCubeModelUtil.getImports(cubeModel.saveXML());
        Imports imports_old = this.oldCubeModel == null ? null : KdrsCubeModelUtil.getImports(this.oldCubeModel.saveXML());
        KdrsCubeModel newModel = new KdrsCubeModel(cubeModel);
        KdrsCubeModel tempModel = new KdrsCubeModel(cubeModel);
        this.copyModel(tempModel, this.oldCubeModel);
        if (KdrsCubeModelUtil.compareImports(imports_cur, imports_old)) {
            if (needReConfig) {
                newModel.setParameters(this.oldCubeModel.getParameters());
                newModel.setImports(this.oldCubeModel.getImports());
            }
        } else {
            newModel.setImports(imports_cur);
            this.autoMakeParameters(newModel);
            tempModel.setImports(imports_cur);
            this.autoMakeParameters(tempModel);
            if (callBySave) {
                return newModel;
            }
            needReConfig = true;
        }
        if (needReConfig) {
            KdrsCubeModelConfigurePanel panel = new KdrsCubeModelConfigurePanel(this.mdSelector);
            panel.setCubeModel(newModel);
            try {
                if (WindowUtil.showSimpleDialog((Component)((Object)panel), (Component)this.cmEditor, (String)ImplResource.getString("res_11"), (Dimension)new Dimension(800, 600))) {
                    return panel.getTargetCubeModel();
                }
                return tempModel;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            newModel.setParameters(this.oldCubeModel.getParameters());
            newModel.setImports(this.oldCubeModel.getImports());
        }
        return newModel;
    }

    private void autoMakeParameters(KdrsCubeModel cube) {
        ArrayList ps;
        Imports imports = cube.getImports();
        HashSet<Parameter> modelParameters = new HashSet<Parameter>();
        if (imports != null) {
            for (int i = 0; i < imports.size(); ++i) {
                Import importObj = (Import)((Object)imports.get(i));
                MetaClass mc = (MetaClass)this.mdSelector.getObject(importObj.getExpr());
                List parameters = mc.getParameters();
                if (parameters == null) continue;
                HashMap<Parameter, Parameter> importArgs = importObj.getArgs();
                if (importArgs == null) {
                    importArgs = new HashMap<Parameter, Parameter>();
                    importObj.setArgs(importArgs);
                }
                for (int j = 0; j < parameters.size(); ++j) {
                    Parameter p = (Parameter)parameters.get(j);
                    if (ParamUtil.isDataViewParam(p) && !KdrsCubeModelUtil.importIsFactTable(importObj)) continue;
                    Parameter modelParameter = new Parameter();
                    modelParameter.copy(p);
                    modelParameter.setName(AcceptParametersPanel.getSplitedString(mc.getName()) + "_" + p.getName());
                    modelParameters.add(modelParameter);
                    ParamUtil.tryResetDataViewURI(modelParameter, importObj.getExpr());
                    Parameter pVal = new Parameter();
                    pVal.copy(modelParameter);
                    pVal.setProperty("external_ref_type", (Object)CubeParametersProvider.TYPE);
                    if ("false".equals(modelParameter.getProperty(Parameter.P_isVisible.getName()))) continue;
                    importArgs.put(p, pVal);
                }
            }
        }
        if ((ps = cube.getParameters()) == null) {
            ps = new ArrayList();
            cube.setParameters(ps);
        } else {
            ps.clear();
        }
        ps.addAll(modelParameters);
    }
}

