/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.xquery;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSource;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSourceFactory;
import com.kingdee.bos.ctrl.reportone.data.modal.CommonQuery;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.data.modal.io.CommonQuery2Xml;
import com.kingdee.bos.ctrl.reportone.data.modal.query.AQuery2SQL;
import com.kingdee.bos.ctrl.reportone.data.modal.query.framework.ksql.KsqlQuery;
import com.kingdee.bos.ctrl.reportone.data.wizard.commonquery.KsqlCommonQueryWizard;
import com.kingdee.bos.ctrl.reportone.data.wizard.framework.datadef.DefaultCommonQueryWizardModel;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_ReportExecutor_Proxy;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.reportframework.EditingObjectException;
import com.kingdee.bos.ctrl.reportone.reportframework.IObjectStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.IReportExecutor;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import com.kingdee.bos.ctrl.reportone.reportimpl.xquery.IXQueryRptExecutor;
import com.kingdee.bos.ctrl.reportone.reportimpl.xquery.XQueryObjectStorage;
import java.awt.Component;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class XQueryRptDesigner
extends AReportDesigner
implements BizContent_ReportExecutor_Proxy.IReportContentProvider {
    public static final Logger log = LogUtil.getLogger(XQueryRptDesigner.class);
    public static final String ARG_QUERY2SQL = ParamUtil.makeArgName("ARG_Query2SQL", XQueryRptDesigner.class);
    private KsqlCommonQueryWizard _dataWizardDialog;
    private DefaultCommonQueryWizardModel _wizardModel;

    public XQueryRptDesigner(Component owner) {
        super(owner);
    }

    @Override
    public void design(boolean isNew, HashMap args) throws ReportException {
        HashMap objAttrs;
        CommonQuery xquery;
        IDataSource defaultDS;
        if (this._dataWizardDialog != null) {
            throw new AlreadyOpenedException();
        }
        IReportEnv rptEnv = this.getReportEnv();
        IObjectStorage objSto = this.getObjectStorage();
        IDataSourceFactory dsFactory = rptEnv.getDSFactory();
        if (isNew) {
            defaultDS = dsFactory.getDefaultDataSource();
            if (defaultDS == null) {
                throw new ReportException(ImplResource.getString("res_40"));
            }
            xquery = new CommonQuery();
            xquery.setQuery(new KsqlQuery(true));
        } else {
            xquery = (CommonQuery)objSto.getInputObject();
            if (xquery == null) {
                throw new EditingObjectException();
            }
            defaultDS = dsFactory.getDataSource(xquery.getDSPath());
            if (defaultDS == null) {
                defaultDS = dsFactory.getDefaultDataSource();
            }
            if (defaultDS == null) {
                throw new ReportException(ImplResource.getString("res_41") + xquery.getDSPath());
            }
        }
        this._wizardModel = new DefaultCommonQueryWizardModel();
        this._wizardModel.setCommonQuery(xquery);
        this._wizardModel.setObjectSelector(this.getObjectSelector(args));
        this._wizardModel.setSQLMaker((AQuery2SQL)args.get(ARG_QUERY2SQL));
        this._wizardModel.setXQueryExecutor((IXQueryRptExecutor)args.get(IReportExecutor.class));
        this._dataWizardDialog = (KsqlCommonQueryWizard)((Object)WindowUtil.createWindow(KsqlCommonQueryWizard.class, (Component)this.owner));
        this._dataWizardDialog.setDataWizardModel(this._wizardModel);
        Object uiTitle = args.get(ReportUtil.ARG_UI_TITLE);
        this._dataWizardDialog.setTitle(uiTitle != null ? (String)uiTitle : ImplResource.getString("res_42"));
        this._dataWizardDialog.setSize(this.DEFAULT_WINDOW_SIZE);
        if (!this._dataWizardDialog.showDialog()) {
            this.fireWindowClosed();
            throw new UserCancelException();
        }
        xquery.setDSPath(defaultDS.getName());
        if (args != null && (objAttrs = (HashMap)args.get("objAttrs")) != null) {
            HashMap alias_attrs = (HashMap)objAttrs.clone();
            xquery.getProperties().putAll(alias_attrs);
            String name = (String)objAttrs.get("name");
            if (name != null) {
                xquery.setName(name);
            }
        }
        objSto.setOutputObject(xquery);
        this.fireSaveCompleted();
        this.fireWindowClosed();
    }

    private IObjectStorage getObjectStorage() {
        IReportStorage rptSto = this.getReportEnv().getReportStorage();
        if (rptSto instanceof IStreamStorage) {
            return new XQueryObjectStorage((IStreamStorage)rptSto, true);
        }
        return (IObjectStorage)rptSto;
    }

    @Override
    public String getRptCategory() {
        return "kdrs-query";
    }

    @Override
    public byte[] getRptTemplate() {
        try {
            CommonQuery cq = this._wizardModel.getCommonQuery();
            Element e = CommonQuery2Xml.toXml(cq);
            return XmlUtil.saveXmlBytes((Element)e);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            return null;
        }
    }
}

