/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.DecimalFormatEx;
import com.kingdee.bos.ctrl.swing.DefaultHandleKDComponentException;
import com.kingdee.bos.ctrl.swing.IBoundLabelControl;
import com.kingdee.bos.ctrl.swing.ICtrTextDocumentFilter;
import com.kingdee.bos.ctrl.swing.IHandleKDComponentException;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.INumberTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.NumberFeatureMode;
import com.kingdee.bos.ctrl.swing.NumberFormatterEx;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.swing.util.SwingLogUtil;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;
import javax.swing.undo.UndoManager;

public class BasicNumberTextField
extends BasicFormattedTextField
implements INumberTextField,
IKDComponent,
IBoundLabelControl {
    private static final long serialVersionUID = -6637514383597876981L;
    private Object userObject = null;
    protected KDLabelContainer kdLabelContainer;
    private Number maximumNumber = null;
    private Number minimumNumber = null;
    private int precision = 0;
    private int roundingMode = 4;
    private int dataVerifyMode = 9;
    protected int dataType = 2;
    private boolean isImmediatelyValidate = true;
    private boolean isSupportedEmpty = false;
    private boolean isCommitsOnValidEdit = false;
    private boolean negatived = true;
    private NumberFeatureMode numberFeatureMode = null;
    private InnerPropertyChangeListener innerPropertyListener = null;
    private PropertyChangeListener dataChangePropertyHandler = null;
    private JComponent[] allowedProcessMouseComps = null;
    IHandleKDComponentException defaultHandleKDComponentException = null;
    private static final IHandleKDComponentException HandleKDComponentnException = new DefaultHandleKDComponentException();
    private boolean isSelectAllOnFocus = false;
    private Insets customInsets;
    public static final String undoAction = "undo-BasicNumberTextField";
    public static final String redoAction = "redo-BasicNumberTextField";
    public UndoManager manager = null;

    public BasicNumberTextField() {
        this(2);
        this.initUndo();
    }

    public BasicNumberTextField(int pDataType) {
        this.init(pDataType);
        this.initUndo();
    }

    public BasicNumberTextField(Object value) {
        int tempDataType = this.objectToIntType(value);
        this.init(tempDataType);
        this.setValue(value);
        this.initUndo();
    }

    public BasicNumberTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.init(-1);
        this.initUndo();
    }

    private void initUndo() {
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, undoAction);
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, redoAction);
        actionMap.put(undoAction, new UndoAction());
        actionMap.put(redoAction, new RedoAction());
    }

    protected void init(int newDataType) {
        this.setColumns(10);
        CtrlPlainDocument numberDocument = new CtrlPlainDocument();
        DefaultCtrlTextDocumentFilter ctrlTextDocuFilter = new DefaultCtrlTextDocumentFilter();
        numberDocument.setCtrTextDocumentFilter(ctrlTextDocuFilter);
        this.setDocument(numberDocument);
        if (this.dataChangePropertyHandler != null) {
            this.removePropertyChangeListener("value", this.dataChangePropertyHandler);
            this.dataChangePropertyHandler = null;
        } else {
            this.dataChangePropertyHandler = new DataPropertyChangeListener();
        }
        this.addPropertyChangeListener("value", this.dataChangePropertyHandler);
        this.setInputVerifier(new FormattedTextFieldVerifier());
        this.defaultHandleKDComponentException = HandleKDComponentnException;
        this.initByDataType(newDataType);
        this.createFormatterFactoryByDataType(newDataType);
        this.setMaximumNumber(CtrlSwingUtilities.BUS_MAX_BIGDECIMAL);
        this.setMinimumNumber(CtrlSwingUtilities.BUS_MIN_BIGDECIMAL);
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.listenerList.add(DataChangeListener.class, l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.listenerList.remove(DataChangeListener.class, l);
    }

    protected void fireDataChangeListener(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    public void setCtrlTextDocumentFilter(ICtrTextDocumentFilter newValue) {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            ((CtrlPlainDocument)document).setCtrTextDocumentFilter(newValue);
        }
    }

    public ICtrTextDocumentFilter getCtrlTextDocumentFilter() {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            return ((CtrlPlainDocument)document).getCtrTextDocumentFilter();
        }
        return null;
    }

    private void initByDataType(int newDataType) {
        switch (newDataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.precision = 0;
                break;
            }
            case 4: {
                this.precision = 6;
                break;
            }
            case 5: 
            case 6: {
                this.precision = 10;
                break;
            }
        }
    }

    protected NumberFeatureMode createNumberFeatureMode() {
        return new NumberFeatureMode();
    }

    public JFormattedTextField.AbstractFormatter getEditFormatter() {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory != null && formatterFactory instanceof DefaultFormatterFactory) {
            return ((DefaultFormatterFactory)formatterFactory).getEditFormatter();
        }
        return null;
    }

    public void setEditFormatter(JFormattedTextField.AbstractFormatter newValue) {
        if (newValue != null) {
            this.setFormatterFactory(null, newValue);
        }
    }

    public JFormattedTextField.AbstractFormatter getDispalyFormatter() {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory != null && formatterFactory instanceof DefaultFormatterFactory) {
            return ((DefaultFormatterFactory)formatterFactory).getDisplayFormatter();
        }
        return null;
    }

    public void setDisplayFormatter(JFormattedTextField.AbstractFormatter newValue) {
        if (newValue != null) {
            this.setFormatterFactory(newValue, null);
        }
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new BigDecimal(number.toString());
        }
        return null;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new BigInteger(String.valueOf(number.intValue()));
        }
        return null;
    }

    @Override
    public Byte getByteValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Byte(number.byteValue());
        }
        return null;
    }

    @Override
    public Float getFloatValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Float(number.floatValue());
        }
        return null;
    }

    @Override
    public Integer getIntegerValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Integer(number.intValue());
        }
        return null;
    }

    @Override
    public Long getLongValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Long(number.longValue());
        }
        return null;
    }

    @Override
    public Double getDoubleValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Double(number.doubleValue());
        }
        return null;
    }

    @Override
    public Number getMaximumNumber() {
        return this.maximumNumber;
    }

    @Override
    public Number getMinimumNumber() {
        return this.minimumNumber;
    }

    @Override
    public int getMultiplier() {
        return this.getNumberFeatureMode().getMultiplier();
    }

    @Override
    public NumberFeatureMode getNumberFeatureMode() {
        if (this.numberFeatureMode == null) {
            this.numberFeatureMode = this.createNumberFeatureMode();
            if (this.innerPropertyListener == null) {
                this.innerPropertyListener = new InnerPropertyChangeListener();
            } else {
                this.numberFeatureMode.removeProtyListener(this.innerPropertyListener);
            }
            this.numberFeatureMode.addPropertyListener(this.innerPropertyListener);
        }
        return this.numberFeatureMode;
    }

    @Override
    public Number getNumberValue() {
        Number obj = this.GETNumberValue();
        if (obj == null) {
            return obj;
        }
        switch (this.dataType) {
            case 0: {
                return new Byte(obj.byteValue());
            }
            case 1: {
                return new Short(obj.shortValue());
            }
            case 2: {
                return new Integer(obj.intValue());
            }
            case 3: {
                return new Long(obj.longValue());
            }
            case 4: {
                return new Float(obj.floatValue());
            }
            case 5: {
                return new Double(obj.doubleValue());
            }
            case 6: {
                return new BigDecimal(obj.toString());
            }
            case 7: {
                return new BigInteger(obj.toString());
            }
        }
        return obj;
    }

    private Number GETNumberValue() {
        block2: {
            try {
                this.commitEdit();
            }
            catch (ParseException ex) {
                if (this.getDataVerifyMode() != 9) break block2;
                this.setValue(this.getValue());
            }
        }
        Object obj = this.getValue();
        return (Number)obj;
    }

    @Override
    public Number getNumberValue(Class valueClass) {
        if (valueClass == null) {
            throw new NullPointerException("valueClass is null in getNumberValue(Class)");
        }
        int newDataType = this.classToIntType(valueClass);
        switch (newDataType) {
            case 0: {
                return this.getByteValue();
            }
            case 1: {
                return this.getShortValue();
            }
            case 2: {
                return this.getIntegerValue();
            }
            case 3: {
                return this.getLongValue();
            }
            case 4: {
                return this.getFloatValue();
            }
            case 5: {
                return this.getDoubleValue();
            }
            case 7: {
                return this.getBigIntegerValue();
            }
            case 6: {
                return this.getBigDecimalValue();
            }
        }
        return this.getIntegerValue();
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    public Short getShortValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Short(number.shortValue());
        }
        return null;
    }

    @Override
    public boolean isGroupingUsed() {
        return this.getNumberFeatureMode().isDisGroupingUsed();
    }

    @Override
    public boolean isPercentingUsed() {
        return this.getNumberFeatureMode().isDisPercentingUsed();
    }

    @Override
    public void setGroupingUsed(boolean newValue) {
        this.getNumberFeatureMode().setDisGroupingUsed(newValue);
    }

    @Override
    public void setMaximumNumber(Number newValue) {
        Number old = this.maximumNumber;
        int eq = CtrlSwingUtilities.judgeNumber(old, newValue);
        if (eq != 0) {
            this.maximumNumber = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(15);
            }
        }
    }

    @Override
    public void setMinimumNumber(Number newValue) {
        Number old = this.minimumNumber;
        int eq = CtrlSwingUtilities.judgeNumber(old, newValue);
        if (eq != 0) {
            this.minimumNumber = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(16);
            }
        }
    }

    @Override
    public void setMultiplier(int newValue) {
        this.getNumberFeatureMode().setMultiplier(newValue);
    }

    @Override
    public void setNumberFeatureMode(NumberFeatureMode newValue) {
        if (newValue == null) {
            return;
        }
        if (this.numberFeatureMode != null && this.innerPropertyListener != null) {
            this.numberFeatureMode.removeProtyListener(this.innerPropertyListener);
        }
        this.numberFeatureMode = newValue;
        if (this.innerPropertyListener == null) {
            this.innerPropertyListener = new InnerPropertyChangeListener();
        }
        this.numberFeatureMode.addPropertyListener(this.innerPropertyListener);
    }

    @Override
    public void setNumberValue(Number newValue) {
        this.setValue(newValue);
    }

    public void setNumberValue(Number newValue, boolean fireListener) {
        this.setValue(newValue, fireListener);
    }

    @Override
    public void setValue(Object value) {
        if (value != null && !(value instanceof Number)) {
            throw new IllegalArgumentException("the value'type must be java.lang.Number or null,in method setValue(value)");
        }
        if (value != null && this.getFormatterFactory() == null) {
            int tempDataType = this.objectToIntType(value);
            this.initByDataType(tempDataType);
            this.createFormatterFactoryByDataType(tempDataType);
        }
        if (value != null && this.maximumNumber != null && this.minimumNumber != null) {
            if (((Number)value).doubleValue() > this.maximumNumber.doubleValue()) {
                value = this.maximumNumber;
            }
            if (((Number)value).doubleValue() < this.minimumNumber.doubleValue()) {
                value = this.minimumNumber;
            }
        }
        super.setValue(value);
    }

    @Override
    public void setValue(Object value, boolean fireListener) {
        if (value != null && !(value instanceof Number)) {
            throw new IllegalArgumentException("the value'type must be java.lang.Number or null,in method setValue(value)");
        }
        if (value != null && this.getFormatterFactory() == null) {
            int tempDataType = this.objectToIntType(value);
            this.initByDataType(tempDataType);
            this.createFormatterFactoryByDataType(tempDataType);
        }
        if (value != null && this.maximumNumber != null && this.minimumNumber != null) {
            if (((Number)value).doubleValue() > this.maximumNumber.doubleValue()) {
                value = this.maximumNumber;
            }
            if (((Number)value).doubleValue() < this.minimumNumber.doubleValue()) {
                value = this.minimumNumber;
            }
        }
        super.setValue(value, fireListener);
    }

    private int objectToIntType(Object value) {
        if (value != null) {
            if (value instanceof Byte) {
                return 0;
            }
            if (value instanceof Short) {
                return 1;
            }
            if (value instanceof Integer) {
                return 2;
            }
            if (value instanceof Float) {
                return 4;
            }
            if (value instanceof Double) {
                return 5;
            }
            if (value instanceof Long) {
                return 3;
            }
            if (value instanceof BigInteger) {
                return 7;
            }
            if (value instanceof BigDecimal) {
                return 6;
            }
        }
        return 2;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            if (e.getID() == 1005) {
                ((CtrlPlainDocument)document).setFocusing(false);
            } else {
                ((CtrlPlainDocument)document).setFocusing(true);
            }
        }
        super.processFocusEvent(e);
        if (e.getID() == 1004 && this.isSelectAllOnFocus()) {
            this.selectAll();
        }
    }

    private int classToIntType(Class classValue) {
        String cName = classValue.getName();
        if (cName.equals("java.lang.Byte")) {
            return 0;
        }
        if (cName.equals("java.lang.Short")) {
            return 1;
        }
        if (cName.equals("java.lang.Integer")) {
            return 2;
        }
        if (cName.equals("java.lang.Float")) {
            return 4;
        }
        if (cName.equals("java.lang.Double")) {
            return 5;
        }
        if (cName.equals("java.lang.Long")) {
            return 3;
        }
        if (cName.equals("java.math.BigDecimal")) {
            return 6;
        }
        if (cName.equals("java.math.BigInteger")) {
            return 7;
        }
        throw new IllegalArgumentException("classToIntType(Class), the parameter " + classValue + " is not supported!");
    }

    @Override
    public void setPercentingUsed(boolean newValue) {
        this.getNumberFeatureMode().setDisPercentingUsed(newValue);
    }

    @Override
    public void setPrecision(int newValue) {
        int old = this.precision;
        if (old == newValue) {
            return;
        }
        switch (this.dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                newValue = 0;
                break;
            }
            case 4: {
                if (newValue <= 6 && newValue >= 0) break;
                newValue = 6;
                break;
            }
            case 5: {
                if (newValue <= 10 && newValue >= 0) break;
                newValue = 10;
                break;
            }
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        this.precision = newValue;
        if (old != newValue && this.isImmediatelyValidate()) {
            this.createDisEdiFormatterAgain(12);
        }
    }

    public boolean isImmediatelyValidate() {
        return this.isImmediatelyValidate;
    }

    public void setImmediatelyValidate(boolean newValue) {
        this.isImmediatelyValidate = newValue;
    }

    public void immediatelyValidate() {
        this.createDisEdiFormatterAgain(30);
    }

    protected void createDisEdiFormatterAgain(int propertyType) {
        this.createFormatterFactoryByDataType(this.getDataType());
    }

    @Override
    public void setRoundingMode(int newValue) {
        switch (newValue) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                newValue = 4;
            }
        }
        int old = this.roundingMode;
        if (old != newValue) {
            this.roundingMode = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(13);
            }
        }
    }

    @Override
    public void setDataType(int newValue) {
        if (this.isCorrectDataType(newValue)) {
            int old = this.dataType;
            if (old != newValue) {
                this.dataType = newValue;
                switch (newValue) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        this.precision = 0;
                        break;
                    }
                    case 4: {
                        if (this.precision > 0 && this.precision <= 6) break;
                        this.precision = 6;
                        break;
                    }
                    case 5: {
                        if (this.precision > 0 && this.precision <= 10) break;
                        this.precision = 10;
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
                if (this.isImmediatelyValidate()) {
                    this.createDisEdiFormatterAgain(11);
                }
            }
        } else {
            throw new IllegalArgumentException("setDataType is illegal,please see BasicNumberTextField's constant .");
        }
    }

    private void createFormatterFactoryByDataType(int newDataType) {
        this.dataType = newDataType;
        this.setFormatterFactory(this.createDisplayFormatter(newDataType), this.createEditFormatter(newDataType));
    }

    private void setFormatterFactory(JFormattedTextField.AbstractFormatter disFormatter, JFormattedTextField.AbstractFormatter ediFormatter) {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory == null) {
            formatterFactory = new DefaultFormatterFactory();
        }
        boolean b = false;
        if (disFormatter != null) {
            ((DefaultFormatterFactory)formatterFactory).setDisplayFormatter(disFormatter);
            b = true;
        }
        if (ediFormatter != null) {
            ((DefaultFormatterFactory)formatterFactory).setEditFormatter(ediFormatter);
            b = true;
        }
        if (b) {
            this.setFormatterFactory(formatterFactory);
        }
    }

    protected NumberFormatter createDisplayFormatter(int newDataType) {
        DecimalFormatEx format = null;
        DecimalFormatEx sysFormat = CtrlFormatUtilities.getEditNumberFormat();
        format = this.isPercentingUsed() ? DecimalFormatEx.getPercentInstanceEx() : (sysFormat != null ? new DecimalFormatEx(sysFormat.toPattern()) : new DecimalFormatEx());
        format.setGroupingUsed(this.isGroupingUsed());
        format.setGroupingSize(this.getNumberFeatureMode().getGroupingSize());
        NumberFormatterEx formatter = new NumberFormatterEx();
        formatter.setDecimalPrecision(this.getPrecision());
        format.setMaximumFractionDigits(this.getPrecision());
        if (!this.isRemoveingZeroInDispaly()) {
            format.setMinimumFractionDigits(this.getPrecision());
        }
        formatter.setRemoveingZero(this.isRemoveingZeroInDispaly());
        format.setRemovingMinus(this.isRemovingMinusInDisplay());
        this.exConfigDisFormat(format);
        formatter.setFormat(format);
        return formatter;
    }

    protected void exConfigDisFormat(DecimalFormat format) {
    }

    protected NumberFormatter createEditFormatter(int newDataType) {
        DecimalFormatEx sysFormat = CtrlFormatUtilities.getEditNumberFormat();
        DecimalFormatEx format = null;
        format = sysFormat == null ? new DecimalFormatEx() : new DecimalFormatEx(sysFormat.toPattern());
        NumberFormatterEx formatter = new NumberFormatterEx();
        formatter.setDecimalPrecision(this.getPrecision());
        format.setMaximumFractionDigits(this.getPrecision());
        format.setGroupingUsed(this.getNumberFeatureMode().isEdiGroupingUsed());
        format.setGroupingSize(this.getNumberFeatureMode().getGroupingSize());
        formatter.setSupportedEmpty(this.isSupportedEmpty());
        if (this.getDataVerifyMode() == 8) {
            formatter.setAllowsInvalid(false);
            formatter.setSupportedEmpty(false);
            format.setMinimumFractionDigits(this.getPrecision());
        } else {
            formatter.setAllowsInvalid(true);
        }
        formatter.setRemoveingZero(this.isRemoveingZeroInEdit());
        if (!this.isRemoveingZeroInEdit()) {
            format.setMinimumFractionDigits(this.getPrecision());
        }
        formatter.setMaximum((Comparable)((Object)this.getMaximumNumber()));
        formatter.setMinimum((Comparable)((Object)this.getMinimumNumber()));
        formatter.setCommitsOnValidEdit(this.isCommitsOnValidEdit());
        this.exConfigEditFormat(format);
        formatter.setFormat(format);
        return formatter;
    }

    protected void exConfigEditFormat(DecimalFormat format) {
    }

    private boolean isCorrectDataType(int newValue) {
        boolean b = true;
        switch (newValue) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            default: {
                b = false;
            }
        }
        return b;
    }

    public void setDataType(Class c) {
        if (c != null) {
            int newDataType = 2;
            try {
                newDataType = this.classToIntType(c);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setDataType(newDataType);
        }
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataVerifyMode(int newValue) {
        switch (newValue) {
            case 8: {
                break;
            }
            case 9: {
                this.setFocusLostBehavior(1);
                break;
            }
            default: {
                this.setFocusLostBehavior(0);
                newValue = 10;
            }
        }
        int old = this.dataVerifyMode;
        if (old != newValue) {
            this.dataVerifyMode = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(14);
            }
        }
    }

    @Override
    public int getDataVerifyMode() {
        return this.dataVerifyMode;
    }

    public void setRemoveingZeroInDispaly(boolean newValue) {
        this.getNumberFeatureMode().setRemoveingZeroInDispaly(newValue);
    }

    public boolean isRemoveingZeroInDispaly() {
        return this.getNumberFeatureMode().isRemoveingZeroInDispaly();
    }

    public void setRemoveingZeroInEdit(boolean newValue) {
        this.getNumberFeatureMode().setRemoveingZeroInEdit(newValue);
    }

    public boolean isRemoveingZeroInEdit() {
        return this.getNumberFeatureMode().isRemoveingZeroInEdit();
    }

    public void setRemovingMinusInDisplay(boolean newValue) {
        this.getNumberFeatureMode().setRemovingMinusInDisplay(newValue);
    }

    public boolean isRemovingMinusInDisplay() {
        return this.getNumberFeatureMode().isRemovingMinusInDisplay();
    }

    public void setRemovingMinusInEdit(boolean newValue) {
    }

    public boolean isRemovingMinusInEdit() {
        return false;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object newValue) {
        this.userObject = newValue;
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    @Override
    public void handleTheComponentException(IHandleKDComponentException kdCompException) {
        this.defaultHandleKDComponentException = kdCompException == null ? HandleKDComponentnException : kdCompException;
    }

    @Override
    public void commitEdit() throws ParseException {
        ParseException pEx = null;
        try {
            super.commitEdit();
        }
        catch (ParseException p) {
            if (this.getDataVerifyMode() == 1 || this.getDataVerifyMode() == 9) {
                this.setValue(this.getValue());
            }
            pEx = p;
        }
        if (pEx == null) {
            return;
        }
        if (this.getDataVerifyMode() == 10 && this.defaultHandleKDComponentException != null && this.isFocusOwner()) {
            this.handleDefaultKDCompException(pEx, 0);
        }
        throw pEx;
    }

    private void handleDefaultKDCompException(final Exception pEx, int exType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicNumberTextField.this.defaultHandleKDComponentException.handleKDComponentExcepton(BasicNumberTextField.this, pEx, 0);
            }
        });
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    @Override
    public boolean isSupportedEmpty() {
        return this.isSupportedEmpty;
    }

    @Override
    public void setSupportedEmpty(boolean newValue) {
        boolean old = this.isSupportedEmpty;
        if (old != newValue) {
            this.isSupportedEmpty = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(32);
            }
        }
    }

    @Override
    public boolean isCommitsOnValidEdit() {
        return this.isCommitsOnValidEdit;
    }

    @Override
    public void setCommitsOnValidEdit(boolean newValue) {
        boolean old = this.isCommitsOnValidEdit;
        if (old != newValue) {
            this.isCommitsOnValidEdit = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(31);
            }
        }
    }

    @Override
    protected void invalidEdit() {
        String des;
        super.invalidEdit();
        if (this.getLabelContainer() != null && (des = this.getLabelContainer().getBoundLabelText()) != null && des.length() > 0) {
            SwingLogUtil.error((String)(des + "  \u6570\u5b57\u8f93\u5165\u65e0\u6548\u3002"));
        }
    }

    private void dataChangeOprt(Object oldVa, Object newVa) {
        DataChangeEvent event = new DataChangeEvent(this, newVa, oldVa);
        this.fireDataChangeListener(event);
    }

    @Override
    public boolean isNegatived() {
        return this.negatived;
    }

    @Override
    public void setNegatived(boolean newValue) {
        boolean old = this.negatived;
        if (old != newValue) {
            this.negatived = newValue;
            ICtrTextDocumentFilter textFilter = this.getCtrlTextDocumentFilter();
            if (textFilter != null && textFilter instanceof DefaultCtrlTextDocumentFilter) {
                ((DefaultCtrlTextDocumentFilter)textFilter).setNegativeble(this.negatived);
            }
        }
    }

    @Override
    public void setAllowdMouseProcessComponents(JComponent[] comps) {
        if (comps == null || comps.length == 0) {
            return;
        }
        int len = comps.length;
        if (this.allowedProcessMouseComps == null) {
            this.allowedProcessMouseComps = new JComponent[len];
            System.arraycopy(comps, 0, this.allowedProcessMouseComps, 0, len);
        } else {
            int len2 = this.allowedProcessMouseComps.length + len;
            JComponent[] tempComps = new JComponent[len2];
            System.arraycopy(this.allowedProcessMouseComps, 0, tempComps, 0, this.allowedProcessMouseComps.length);
            System.arraycopy(comps, 0, tempComps, this.allowedProcessMouseComps.length, len);
            this.allowedProcessMouseComps = new JComponent[len2];
            System.arraycopy(tempComps, 0, this.allowedProcessMouseComps, 0, len2);
            tempComps = null;
        }
    }

    @Override
    public boolean shouldProcessMouseOprt(JComponent comp) {
        if (this.allowedProcessMouseComps == null || this.allowedProcessMouseComps.length == 0) {
            return false;
        }
        if (comp != null) {
            int len = this.allowedProcessMouseComps.length;
            for (int i = 0; i < len; ++i) {
                if (this.allowedProcessMouseComps[i] != comp) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void setSelectAllOnFocus(boolean newValue) {
        this.isSelectAllOnFocus = newValue;
    }

    @Override
    public boolean isSelectAllOnFocus() {
        return this.isSelectAllOnFocus;
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public class FormattedTextFieldVerifier
    extends InputVerifier {
        @Override
        public boolean verify(JComponent input) {
            if (BasicNumberTextField.this.getDataVerifyMode() != 10) {
                return true;
            }
            boolean b = true;
            try {
                JFormattedTextField.AbstractFormatter formater = BasicNumberTextField.this.getFormatter();
                if (formater != null) {
                    formater.stringToValue(BasicNumberTextField.this.getText());
                }
            }
            catch (ParseException e) {
                b = false;
            }
            if (!b) {
                ((JFormattedTextField)input).selectAll();
            } else {
                ((JFormattedTextField)input).select(0, 0);
            }
            return b;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            return this.verify(input);
        }
    }

    class DataPropertyChangeListener
    implements PropertyChangeListener {
        DataPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object newVa;
            Object oldVa;
            String name = e.getPropertyName();
            if ("value".equals(name) && CtrlSwingUtilities.judgeNumberObject(oldVa = e.getOldValue(), newVa = e.getNewValue()) != 0) {
                BasicNumberTextField.this.dataChangeOprt(oldVa, newVa);
            }
        }
    }

    public static class DefaultCtrlTextDocumentFilter
    implements ICtrTextDocumentFilter {
        private String validateStr = "-+.%,";
        private boolean supportEmptyValue = false;

        public DefaultCtrlTextDocumentFilter() {
        }

        public DefaultCtrlTextDocumentFilter(boolean supportEmptyValue) {
            this();
            this.supportEmptyValue = supportEmptyValue;
        }

        @Override
        public boolean isValidateStr(String str) {
            boolean b = false;
            if (str != null && str.length() > 0) {
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    char tChar = str.charAt(i);
                    b = Character.isDigit(tChar) || this.validateStr.indexOf(tChar) != -1;
                }
            }
            if (this.supportEmptyValue && (str == null || str.length() == 0)) {
                b = true;
            }
            return b;
        }

        @Override
        public boolean isValidLength(Document doc) {
            return true;
        }

        @Override
        public void setValidateStr(String newValue) {
            if (newValue != null) {
                this.validateStr = newValue;
            }
        }

        @Override
        public String getValidateStr() {
            return this.validateStr;
        }

        @Override
        public void setValidLength(int len) {
        }

        public void setNegativeble(boolean newValue) {
            if (newValue) {
                String string = this.validateStr = this.validateStr == null ? "-+.%," : this.validateStr;
                if (this.validateStr.indexOf("-") == -1) {
                    this.validateStr = this.validateStr + "-";
                }
            } else {
                String string = this.validateStr = this.validateStr == null ? "+.%," : this.validateStr;
                if (this.validateStr.indexOf("-") != -1) {
                    this.validateStr = this.validateStr.replaceAll("-", "");
                }
            }
        }
    }

    private class InnerPropertyChangeListener
    implements PropertyChangeListener {
        private InnerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("nfmDisGroupingUsed")) {
                if (BasicNumberTextField.this.isImmediatelyValidate()) {
                    BasicNumberTextField.this.createDisEdiFormatterAgain(17);
                }
                return;
            }
            if (name.equals("nfmDisPercentingUsed")) {
                if (BasicNumberTextField.this.isImmediatelyValidate()) {
                    BasicNumberTextField.this.createDisEdiFormatterAgain(20);
                }
                return;
            }
            if (name.equals("nfmEdiGroupingUsed")) {
                if (BasicNumberTextField.this.isImmediatelyValidate()) {
                    BasicNumberTextField.this.createDisEdiFormatterAgain(18);
                }
                return;
            }
            if (name.equals("nfmEdiPercentingUsed")) {
                if (BasicNumberTextField.this.isImmediatelyValidate()) {
                    BasicNumberTextField.this.createDisEdiFormatterAgain(21);
                }
                return;
            }
            if (name.equals("nfmGroupingSize")) {
                if (BasicNumberTextField.this.isImmediatelyValidate()) {
                    BasicNumberTextField.this.createDisEdiFormatterAgain(19);
                }
                return;
            }
            if (name.equals("nfmRemoveingZeroInDispaly")) {
                if (BasicNumberTextField.this.isImmediatelyValidate()) {
                    BasicNumberTextField.this.createDisEdiFormatterAgain(23);
                }
                return;
            }
            if (name.equals("nfmRemoveingZeroInEdit")) {
                if (BasicNumberTextField.this.isImmediatelyValidate()) {
                    BasicNumberTextField.this.createDisEdiFormatterAgain(24);
                }
                return;
            }
            if (name.equals("nfmRemovingMinusInDisplay") && BasicNumberTextField.this.isImmediatelyValidate()) {
                BasicNumberTextField.this.createDisEdiFormatterAgain(26);
            }
        }
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 3270097260686324866L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (BasicNumberTextField.this.manager.canRedo()) {
                    BasicNumberTextField.this.manager.redo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -4905105762481594310L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (BasicNumberTextField.this.manager.canUndo()) {
                    BasicNumberTextField.this.manager.undo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

