/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.IBoundLabelControl;
import com.kingdee.bos.ctrl.swing.IKDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainerDialog;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class KDLabelContainer
extends JComponent
implements IKDLabelContainer {
    private static final long serialVersionUID = -7126196734016811212L;
    private static final String PROPERTY_BOUND_LABEL = "boundLabel";
    private static final String PROPERTY_BOUND_LABEL_ALIGNMENT = "boundLabelAlignment";
    private static final String PROPERTY_BOUND_LABEL_LENGTH = "boundLabelLength";
    private static final String PROPERTY_BOUND_LABEL_TEXT = "boundLabelText";
    private static final String PROPERTY_BOUND_LABEL_UNDERLINE = "boundLabelUnderLine";
    private static final String PROPERTY_BOUND_EDITOR = "boundEditor";
    private JLabel label;
    private JComponent editor;
    private JButton button;
    private boolean buttonVisible = false;
    protected KDLabelContainerDialog labelContainerDialog;
    private Image buttonIcon = KDResourceManager.getImageOfRapid("labelcontainer_button.gif");
    private Image buttonOverIcon = KDResourceManager.getImageOfRapid("labelcontainer_button_01.gif");
    private int labelAlignment = 7;
    private int labelLength = -1;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private LabelContainerMouseListener mouseListener = new LabelContainerMouseListener();

    public KDLabelContainer() {
        this("", null);
    }

    public KDLabelContainer(String labelText) {
        this(labelText, null);
    }

    public KDLabelContainer(JComponent editor) {
        this("", editor);
    }

    public KDLabelContainer(String labelText, JComponent editor) {
        this.setLayout(new CompositeLayout());
        this.setBoundLabelText(labelText);
        this.setBoundEditor(editor);
        this.install();
    }

    private void install() {
        this.installDefault();
        this.installComponent();
        this.installListener();
    }

    private void installDefault() {
    }

    private void installComponent() {
        this.removeAll();
        this.button = this.createButton();
        if (this.getBoundLabel() != null) {
            this.add((Component)this.getBoundLabel(), "label");
        }
        if (this.getBoundButton() != null) {
            this.add((Component)this.getBoundButton(), "button");
        }
        if (this.getBoundEditor() != null) {
            this.add((Component)this.getBoundEditor(), "editor");
        }
    }

    private void installListener() {
        this.addPropertyChangeListener(this.propertyChangeListener);
        this.button.addMouseListener(this.mouseListener);
    }

    @Override
    public void setBoundLabel(JLabel label) {
        JLabel old = this.getBoundLabel();
        if (old != label) {
            this.label = label;
            this.doChangeAlignment();
            this.firePropertyChange(PROPERTY_BOUND_LABEL, old, label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        return this.label;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        int old = this.getBoundLabelAlignment();
        if (old != alignment) {
            this.labelAlignment = alignment;
            this.doChangeAlignment();
            this.firePropertyChange(PROPERTY_BOUND_LABEL_ALIGNMENT, old, alignment);
        }
    }

    public void setBoundLabelAlignment(int alignment, boolean isFire) {
        if (isFire) {
            this.setBoundLabelAlignment(alignment);
        } else {
            this.labelAlignment = alignment;
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        return this.labelAlignment;
    }

    @Override
    public void setBoundLabelLength(int len) {
        int old = this.getBoundLabelLength();
        if (old != len) {
            this.labelLength = len;
            this.firePropertyChange(PROPERTY_BOUND_LABEL_LENGTH, old, len);
        }
    }

    public void setBoundLabelLength(int len, boolean isFire) {
        if (isFire) {
            this.setBoundLabelLength(len);
        } else {
            this.labelLength = len;
        }
    }

    @Override
    public int getBoundLabelLength() {
        return this.labelLength;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        String old;
        if (this.label == null) {
            this.setBoundLabel(new KDLabel());
        }
        if ((old = this.getBoundLabelText()) != labelText) {
            this.label.setText(labelText);
            this.firePropertyChange(PROPERTY_BOUND_LABEL_TEXT, old, labelText);
        }
    }

    public void setBoundLabelText(String labelText, boolean isFire) {
        if (isFire) {
            this.setBoundLabelText(labelText);
        } else {
            if (this.label == null) {
                this.setBoundLabel(new KDLabel());
            }
            this.label.setText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.label != null) {
            if (this.label.getText() != null) {
                return this.label.getText();
            }
            return "";
        }
        return "";
    }

    public void setBoundLabelUnderline(boolean b) {
        boolean old;
        if (this.label == null) {
            this.setBoundLabel(new KDLabel());
        }
        if ((old = this.isBoundLabelUnderline()) != b && this.label instanceof KDLabel) {
            ((KDLabel)this.label).setUnderline(b);
            this.firePropertyChange(PROPERTY_BOUND_LABEL_UNDERLINE, old, b);
        }
    }

    public void setBoundLabelUnderline(boolean b, boolean isFire) {
        if (isFire) {
            this.setBoundLabelUnderline(b);
        } else {
            ((KDLabel)this.label).setUnderline(b);
        }
    }

    public void setUnderlineColor(Color val) {
        if (val != null && this.label != null && this.label instanceof KDLabel) {
            ((KDLabel)this.label).setUnderlineColor(val);
        }
    }

    public Color getUnderlineColor() {
        return ((KDLabel)this.label).getUnderlineColor();
    }

    public boolean isBoundLabelUnderline() {
        if (this.label != null && this.label instanceof KDLabel) {
            return ((KDLabel)this.label).isUnderline();
        }
        return false;
    }

    @Override
    public void setBoundEditor(JComponent editor) {
        JComponent old = this.getBoundEditor();
        if (old != editor) {
            this.editor = editor;
            this.firePropertyChange(PROPERTY_BOUND_EDITOR, old, editor);
            if (editor instanceof IBoundLabelControl) {
                ((IBoundLabelControl)((Object)editor)).setLabelContainer(this);
            }
        }
    }

    private JButton createButton() {
        JButton btn = new JButton();
        btn.setIcon(new ImageIcon(this.buttonIcon));
        btn.setBorder(KingdeeBorders.createLabelContainerButtonBorder());
        btn.setBackground(this.getBoundLabel().getBackground());
        btn.setFocusable(false);
        return btn;
    }

    @Override
    public JComponent getBoundEditor() {
        return this.editor;
    }

    public JButton getBoundButton() {
        return this.button;
    }

    public void setButtonIcon(Image icon) {
        this.button.setIcon(new ImageIcon(icon));
        this.buttonIcon = icon;
    }

    public void setButtonOverIcon(Image icon) {
        this.buttonOverIcon = icon;
    }

    public boolean isButtonVisible() {
        return this.buttonVisible;
    }

    public void setButtonVisible(boolean buttonVisible) {
        this.buttonVisible = buttonVisible;
    }

    public void setLabelContainerDialog(KDLabelContainerDialog dialog) {
        this.labelContainerDialog = dialog;
    }

    public KDLabelContainerDialog getLabelContainerDialog() {
        return this.labelContainerDialog;
    }

    private void doChangeAlignment() {
        switch (this.getBoundLabelAlignment()) {
            case 3: {
                this.getBoundLabel().setHorizontalAlignment(4);
                this.getBoundLabel().setVerticalAlignment(3);
                break;
            }
            case 2: {
                this.getBoundLabel().setHorizontalAlignment(4);
                this.getBoundLabel().setVerticalAlignment(1);
                break;
            }
            case 1: {
                this.getBoundLabel().setHorizontalAlignment(0);
                this.getBoundLabel().setVerticalAlignment(1);
                break;
            }
            case 8: {
                this.getBoundLabel().setHorizontalAlignment(2);
                this.getBoundLabel().setVerticalAlignment(1);
                break;
            }
            default: {
                this.getBoundLabel().setHorizontalAlignment(2);
                this.getBoundLabel().setVerticalAlignment(3);
            }
        }
    }

    private void revalidateWithParent() {
        this.revalidate();
        Container ct = this.getParent();
        if (ct != null) {
            ct.validate();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JComponent comp = this.getBoundEditor();
        if (comp != null) {
            comp.setEnabled(enabled);
        }
    }

    protected void popupDialog() {
        if (this.labelContainerDialog == null) {
            this.labelContainerDialog = new DefaultLabelContainerDialog();
        }
        this.labelContainerDialog.show();
    }

    private class DefaultLabelContainerDialog
    implements KDLabelContainerDialog {
        private DefaultLabelContainerDialog() {
        }

        @Override
        public void show() {
        }
    }

    private class LabelContainerMouseListener
    implements MouseListener {
        private LabelContainerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            KDLabelContainer.this.popupDialog();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            KDLabelContainer.this.button.setIcon(new ImageIcon(KDLabelContainer.this.buttonOverIcon));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            KDLabelContainer.this.button.setIcon(new ImageIcon(KDLabelContainer.this.buttonIcon));
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(KDLabelContainer.PROPERTY_BOUND_LABEL) || name.equals(KDLabelContainer.PROPERTY_BOUND_EDITOR)) {
                KDLabelContainer.this.installComponent();
                KDLabelContainer.this.revalidateWithParent();
            } else if (name.equals(KDLabelContainer.PROPERTY_BOUND_LABEL_ALIGNMENT) || name.equals(KDLabelContainer.PROPERTY_BOUND_LABEL_LENGTH) || name.equals(KDLabelContainer.PROPERTY_BOUND_LABEL_TEXT) || name.equals(KDLabelContainer.PROPERTY_BOUND_LABEL_UNDERLINE) || name.equals("preferredSize")) {
                KDLabelContainer.this.revalidateWithParent();
            }
        }
    }

    private class CompositeLayout
    implements LayoutManager {
        public static final String LABEL = "label";
        public static final String EDITOR = "editor";
        public static final String BUTTON = "button";
        private JComponent lab = null;
        private JComponent edt = null;
        private JComponent btn = null;

        private CompositeLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals(LABEL)) {
                this.lab = (JComponent)comp;
            } else if (name.equals(EDITOR)) {
                this.edt = (JComponent)comp;
            } else if (name.equals(BUTTON)) {
                this.btn = (JComponent)comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp.equals(this.lab)) {
                this.lab = null;
            } else if (comp.equals(this.edt)) {
                this.edt = null;
            } else if (comp.equals(this.btn)) {
                this.btn = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension ediDim = this.getEdtDim();
            Dimension labDim = this.getLabDim();
            Dimension btnDim = this.getBtnDim();
            int w = insets.left + insets.right;
            int h = insets.top + insets.bottom;
            switch (KDLabelContainer.this.getBoundLabelAlignment()) {
                case 1: 
                case 2: 
                case 8: {
                    h += ediDim.height + labDim.height;
                    w += Math.max(ediDim.width, labDim.width);
                    break;
                }
                default: {
                    w += ediDim.width + labDim.width;
                    h += Math.max(ediDim.height, labDim.height);
                    h = Math.max(h, btnDim.height);
                }
            }
            return new Dimension(w, h);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension pDim = parent.getSize();
            Dimension labDim = this.getLabDim();
            Dimension btnDim = this.getBtnDim();
            int w = pDim.width - insets.left - insets.right;
            int h = pDim.height - insets.top - insets.bottom;
            int tempX = insets.left;
            int tempY = insets.top;
            if (!(this.isCompositeLabelVisible() || this.isCompositeEditorVisible() || KDLabelContainer.this.isButtonVisible())) {
                return;
            }
            if (!this.isCompositeLabelVisible() && !KDLabelContainer.this.isButtonVisible()) {
                this.edt.setBounds(tempX, tempY, w, h);
                return;
            }
            if (!this.isCompositeEditorVisible() && !KDLabelContainer.this.isButtonVisible()) {
                this.lab.setBounds(tempX, tempY, w, h);
                return;
            }
            int tempW = 0;
            int tempH = 0;
            switch (KDLabelContainer.this.getBoundLabelAlignment()) {
                case 1: 
                case 2: 
                case 8: {
                    tempW = w;
                    tempH = Math.min(h, labDim.height);
                    this.lab.setBounds(tempX, tempY, tempW, tempH);
                    tempY += tempH;
                    tempH = Math.max(h - labDim.height, 0);
                    this.edt.setBounds(tempX, tempY, tempW, tempH);
                    break;
                }
                case 3: {
                    tempH = h;
                    tempW = Math.max(w - labDim.width, 0);
                    this.edt.setBounds(tempX, tempY, tempW, tempH);
                    tempX += tempW;
                    tempW = w - tempW;
                    this.lab.setBounds(tempX, tempY, tempW, tempH);
                    break;
                }
                default: {
                    tempH = h;
                    tempW = Math.min(w, labDim.width);
                    tempW = KDLabelContainer.this.isButtonVisible() ? tempW - btnDim.width : tempW;
                    this.lab.setBounds(tempX, tempY, tempW, tempH);
                    if (KDLabelContainer.this.isButtonVisible()) {
                        this.btn.setBounds(tempX += tempW, tempY, btnDim.width, tempH);
                    }
                    tempX += tempW;
                    tempW = Math.max(w - labDim.width, 0);
                    this.edt.setBounds(tempX, tempY, tempW, tempH);
                }
            }
        }

        private Dimension getLabDim() {
            Dimension labDim = new Dimension(0, 0);
            if (this.lab != null) {
                Dimension labPrfDim = this.lab.getPreferredSize();
                if (KDLabelContainer.this.getBoundLabelAlignment() == 3 || KDLabelContainer.this.getBoundLabelAlignment() == 7) {
                    int labW = KDLabelContainer.this.getBoundLabelLength() == -1 ? labPrfDim.width : KDLabelContainer.this.getBoundLabelLength();
                    int labH = labPrfDim.height;
                    labDim = new Dimension(labW, labH);
                } else {
                    int labH = KDLabelContainer.this.getBoundLabelLength() == -1 ? labPrfDim.height : KDLabelContainer.this.getBoundLabelLength();
                    int labW = labPrfDim.width;
                    labDim = new Dimension(labW, labH);
                }
            }
            return labDim;
        }

        private Dimension getEdtDim() {
            if (this.edt == null) {
                return new Dimension(0, 0);
            }
            return this.edt.getPreferredSize();
        }

        private Dimension getBtnDim() {
            if (this.btn == null) {
                return new Dimension(0, 0);
            }
            return this.btn.getPreferredSize();
        }

        private boolean isCompositeLabelVisible() {
            if (this.lab == null) {
                return false;
            }
            return KDLabelContainer.this.getBoundLabelText().length() != 0 || KDLabelContainer.this.getBoundLabelLength() > 0;
        }

        private boolean isCompositeEditorVisible() {
            return this.edt != null;
        }
    }
}

