/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.plaf.UIResource;

public class KDScrollPane
extends JScrollPane
implements IKDComponent {
    private static final long serialVersionUID = -2632440482746488345L;
    protected Object userObject = null;
    private Insets customInsets = null;
    private UpAction upAction = new UpAction();
    private DownAction downAction = new DownAction();

    public KDScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.setKeyBoardControl(true);
    }

    public KDScrollPane(Component view) {
        super(view);
        this.setKeyBoardControl(true);
    }

    public KDScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.setKeyBoardControl(true);
    }

    public KDScrollPane() {
        this.setKeyBoardControl(true);
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        JScrollBar sb = super.createVerticalScrollBar();
        sb.setFocusable(false);
        return sb;
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        JScrollBar sb = super.createHorizontalScrollBar();
        sb.setFocusable(false);
        return sb;
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public void setKeyBoardControl(boolean b) {
        if (b) {
            InputMap im = this.getInputMap(1);
            im.put(KeyStroke.getKeyStroke(38, 2), "Up");
            im.put(KeyStroke.getKeyStroke(40, 2), "Down");
            ActionMap am = this.getActionMap();
            am.put("Up", this.upAction);
            am.put("Down", this.downAction);
        } else {
            InputMap im = this.getInputMap(1);
            im.remove(KeyStroke.getKeyStroke(38, 2));
            im.remove(KeyStroke.getKeyStroke(40, 2));
            ActionMap am = this.getActionMap();
            am.remove("UP");
            am.remove("Down");
        }
    }

    public void doDownAction() {
        this.downAction.actionPerformed(new ActionEvent(this, 0, ""));
    }

    public void doUpAction() {
        this.upAction.actionPerformed(new ActionEvent(this, 0, ""));
    }

    protected class ScrollBar
    extends KDScrollBar
    implements UIResource {
        private static final long serialVersionUID = -691696754849696506L;
        private boolean unitIncrementSet;
        private boolean blockIncrementSet;

        public ScrollBar(int orientation) {
            super(orientation);
        }

        @Override
        public void setUnitIncrement(int unitIncrement) {
            this.unitIncrementSet = true;
            super.setUnitIncrement(unitIncrement);
        }

        @Override
        public int getUnitIncrement(int direction) {
            JViewport vp = KDScrollPane.this.getViewport();
            if (!this.unitIncrementSet && vp != null && vp.getView() instanceof Scrollable) {
                Scrollable view = (Scrollable)((Object)vp.getView());
                Rectangle vr = vp.getViewRect();
                return view.getScrollableUnitIncrement(vr, this.getOrientation(), direction);
            }
            return super.getUnitIncrement(direction);
        }

        @Override
        public void setBlockIncrement(int blockIncrement) {
            this.blockIncrementSet = true;
            super.setBlockIncrement(blockIncrement);
        }

        @Override
        public int getBlockIncrement(int direction) {
            JViewport vp = KDScrollPane.this.getViewport();
            if (this.blockIncrementSet || vp == null) {
                return super.getBlockIncrement(direction);
            }
            if (vp.getView() instanceof Scrollable) {
                Scrollable view = (Scrollable)((Object)vp.getView());
                Rectangle vr = vp.getViewRect();
                return view.getScrollableBlockIncrement(vr, this.getOrientation(), direction);
            }
            if (this.getOrientation() == 1) {
                return vp.getExtentSize().height;
            }
            return vp.getExtentSize().width;
        }
    }

    private class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JScrollBar sb = KDScrollPane.this.getVerticalScrollBar();
            if (sb != null) {
                sb.setValue(sb.getValue() + sb.getBlockIncrement());
            }
        }
    }

    private class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JScrollBar sb = KDScrollPane.this.getVerticalScrollBar();
            if (sb != null) {
                sb.setValue(sb.getValue() - sb.getBlockIncrement());
            }
        }
    }
}

