/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.IAutoToolTipText;
import com.kingdee.bos.ctrl.swing.IBoundLabelControl;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.ITextLengthLimit;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.LimitedLengthDocument;
import com.kingdee.bos.ctrl.swing.TextLengthVerifier;
import com.kingdee.bos.ctrl.swing.ToolTipGenerator;
import com.kingdee.bos.ctrl.swing.desensitization.DesensitizationRule;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTextAreaUI;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.swing.util.JVM;
import com.kingdee.bos.ctrl.swing.util.TextComponentUtilities;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.im.InputMethodRequests;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;

public class KDTextArea
extends JTextArea
implements IKDComponent,
IBoundLabelControl,
IAutoToolTipText,
ITextLengthLimit,
IKDTextComponent {
    private static final long serialVersionUID = -8925904256253416685L;
    public static final String notifyAction = "notify-field-accept";
    public static final String insertTabAction = "insert-tab";
    public static final String tabAction = "tab-forward";
    public static final String undoAction = "undo-forward";
    public static final String redoAction = "redo-forward";
    protected static final Insets MARGIN = new Insets(1, 1, 1, 1);
    protected Object userObject = null;
    protected KDLabelContainer kdLabelContainer;
    private Insets customInsets;
    private boolean required = false;
    private boolean selectAllOnFocus = true;
    public UndoManager manager = null;
    private Color customForegroundColor;
    private Color customBackgroundColor;
    private boolean isAutoAdjustCaret = true;
    private String desensitizationBefore;
    protected TextLengthVerifier verifier = null;
    private boolean autoToolTipText = true;
    private boolean dirty = false;
    private DesensitizationRule desensitizationRule;
    private boolean isDesensitization = true;

    public KDTextArea() {
        this.init();
    }

    public KDTextArea(String text) {
        super(text);
        this.init();
    }

    public KDTextArea(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public KDTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.init();
    }

    public KDTextArea(Document doc) {
        super(doc);
        this.init();
    }

    public KDTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.init();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (JVM.current().isOverOneDotFive()) {
            return super.getInputMethodRequests();
        }
        return null;
    }

    private void init() {
        CtrlSwingUtilities.addManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke("ctrl ENTER"));
        CtrlSwingUtilities.addManagingFocusBackwardTraversalKeys(this, KeyStroke.getKeyStroke("ctrl shift ENTER"));
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
        TextComponentUtilities.storeOriginalData(this);
        this.setAutoToolTipText(true);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        boolean oldValue = this.required;
        this.required = required;
        this.firePropertyChange("required", new Boolean(oldValue), new Boolean(required));
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (TextComponentUtilities.setEnabled(this, enabled)) {
            super.setEnabled(enabled);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        if (TextComponentUtilities.setEditable(this, editable)) {
            super.setEditable(editable);
        }
    }

    @Override
    public void setText(String t) {
        this.desensitizationBefore = t;
        if (this.isDesensitization && this.desensitizationRule != null) {
            t = DesensitizationRule.desensitization(t, this.desensitizationRule);
        }
        if (TextComponentUtilities.setData(this, t)) {
            super.setText(t);
            if (this.isAutoAdjustCaret) {
                this.setCaretPosition(0);
            }
            if (t == null) {
                this.setDirty(false);
            } else {
                this.setDirty(true);
            }
        }
    }

    public void setText(String t, boolean fireListenner) {
        if (fireListenner) {
            this.setText(t);
        } else {
            DocumentListener[] savedDocumentListeners = ((AbstractDocument)this.getDocument()).getDocumentListeners();
            if (savedDocumentListeners != null) {
                int i;
                for (i = 0; i < savedDocumentListeners.length; ++i) {
                    this.getDocument().removeDocumentListener(savedDocumentListeners[i]);
                }
                this.setText(t);
                for (i = 0; i < savedDocumentListeners.length; ++i) {
                    this.getDocument().addDocumentListener(savedDocumentListeners[i]);
                }
                this.repaint();
            } else {
                this.setText(t);
            }
        }
    }

    @Override
    public String getText() {
        if (this.getAccessAuthority() == 2) {
            return (String)TextComponentUtilities.getData(this);
        }
        return super.getText();
    }

    public void setCustomForegroundColor(Color newColor) {
        Color oldColor = this.customForegroundColor;
        this.customForegroundColor = newColor;
        this.firePropertyChange("customForegroundColorChanged", oldColor, newColor);
    }

    public Color getCustomForegroundColor() {
        return this.customForegroundColor;
    }

    public void setCustomBackgroundColor(Color newColor) {
        Color oldColor = this.customBackgroundColor;
        this.customBackgroundColor = newColor;
        this.firePropertyChange("customBackgroundColorChanged", oldColor, newColor);
    }

    public Color getCustomBackgroundColor() {
        return this.customBackgroundColor;
    }

    @Override
    public void setAccessAuthority(int authority) {
        TextComponentUtilities.setAccessAuthority(this, authority);
    }

    @Override
    public int getAccessAuthority() {
        return TextComponentUtilities.getAccessAuthority(this);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent e = new ActionEvent(this, 1001, "KDTextArea", EventQueue.getMostRecentEventTime(), modifiers);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(KingdeeTextAreaUI.createUI(this));
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        this.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        this.setMargin(MARGIN);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    protected boolean hasActionListener() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            return true;
        }
        return false;
    }

    public void postActionEvent() {
        this.fireActionPerformed();
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    public void selectAllfromTheEnd() {
        Document doc = this.getDocument();
        if (doc != null) {
            this.setCaretPosition(doc.getLength());
            this.moveCaretPosition(0);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            if (e.getID() == 1005) {
                ((CtrlPlainDocument)document).setFocusing(false);
            } else {
                ((CtrlPlainDocument)document).setFocusing(true);
            }
        }
        super.processFocusEvent(e);
        if (e.getID() == 1004 && this.isSelectAllOnFocus()) {
            this.selectAllfromTheEnd();
        }
    }

    private LimitedLengthDocument getLimitedLengthDocument() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedLengthDocument) {
            return (LimitedLengthDocument)doc;
        }
        return null;
    }

    protected TextLengthVerifier getTextLengthVerifier() {
        if (this.verifier == null) {
            this.verifier = new TextLengthVerifier();
            this.setInputVerifier(this.verifier);
        }
        return this.verifier;
    }

    @Override
    public void setMaxLength(int len) {
        if (len < -1) {
            return;
        }
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            doc.setMaxLength(len);
        }
        this.getTextLengthVerifier().setMaxLength(len);
    }

    @Override
    public int getMaxLength() {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            return doc.getMaxLength();
        }
        return -1;
    }

    @Override
    public void setMinLength(int len) {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            doc.setMinLength(len);
        }
        this.getTextLengthVerifier().setMinLength(len);
    }

    @Override
    public int getMinLength() {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            return doc.getMinLength();
        }
        return 0;
    }

    @Override
    protected Document createDefaultModel() {
        LimitedLengthDocument doc = new LimitedLengthDocument();
        doc.addDocumentListener(new DirtyListener());
        return doc;
    }

    @Override
    public void setAutoToolTipText(boolean auto) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (auto) {
            toolTipManager.registerComponent(this);
        } else {
            toolTipManager.unregisterComponent(this);
        }
        this.autoToolTipText = auto;
    }

    @Override
    public boolean isAutoToolTipText() {
        return this.autoToolTipText;
    }

    @Override
    public String getToolTipText() {
        String str = super.getToolTipText();
        if (str == null && this.isAutoToolTipText()) {
            str = ToolTipGenerator.generate(this);
        }
        return str;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public void setStringValue(String str) {
        this.setText(str);
    }

    public String getStringValue() {
        String str = this.getText();
        if (StringUtil.isEmptyString((String)str)) {
            if (this.isDirty()) {
                return "";
            }
            return null;
        }
        return str;
    }

    public boolean isAutoAdjustCaret() {
        return this.isAutoAdjustCaret;
    }

    public void setAutoAdjustCaret(boolean isAutoAdjustCaret) {
        this.isAutoAdjustCaret = isAutoAdjustCaret;
    }

    public void setDesensitizationRule(DesensitizationRule desensitizationRule) {
        this.desensitizationRule = desensitizationRule;
    }

    public DesensitizationRule getDesensitizationRule() {
        return this.desensitizationRule;
    }

    public boolean getIsDesensitization() {
        return this.isDesensitization;
    }

    public void setIsDesensitization(boolean isDesensitization) {
        this.isDesensitization = isDesensitization;
    }

    public void desensitization(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("open".equalsIgnoreCase(actionCommand)) {
            this.isDesensitization = true;
        } else if ("close".equalsIgnoreCase(actionCommand)) {
            this.isDesensitization = false;
        }
        this.setText(this.desensitizationBefore);
    }

    private class DirtyListener
    implements DocumentListener {
        private DirtyListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            KDTextArea.this.setDirty(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            KDTextArea.this.setDirty(true);
        }
    }

    public static class NotifyAction
    extends TextAction {
        private static final long serialVersionUID = 40077795628021066L;

        public NotifyAction() {
            super(KDTextArea.notifyAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getFocusedComponent();
            if (target instanceof KDTextArea) {
                KDTextArea field = (KDTextArea)target;
                field.postActionEvent();
            }
        }

        @Override
        public boolean isEnabled() {
            JTextComponent target = this.getFocusedComponent();
            if (target instanceof KDTextArea) {
                return ((KDTextArea)target).hasActionListener();
            }
            return false;
        }
    }
}

