/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.desensitization;

import java.util.HashMap;

public class DesensitizationRule {
    private String fieldName;
    private Integer desensitizeMode;
    private String replaceTo;
    private String regExp;
    private Integer firstdDigits;
    private Integer lastDigits;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Integer getDesensitizeMode() {
        return this.desensitizeMode;
    }

    public void setDesensitizeMode(Integer desensitizeMode) {
        this.desensitizeMode = desensitizeMode;
    }

    public String getReplaceTo() {
        return this.replaceTo;
    }

    public void setReplaceTo(String replaceTo) {
        this.replaceTo = replaceTo;
    }

    public String getRegExp() {
        return this.regExp;
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    public Integer getFirstdDigits() {
        return this.firstdDigits;
    }

    public void setFirstdDigits(Integer firstdDigits) {
        this.firstdDigits = firstdDigits;
    }

    public Integer getLastDigits() {
        return this.lastDigits;
    }

    public void setLastDigits(Integer lastDigits) {
        this.lastDigits = lastDigits;
    }

    public static String desensitization(String source, DesensitizationRule dRule) {
        if (source == null || source.length() == 0 || "null".equals(source)) {
            return "";
        }
        int desensitizationType = dRule.getDesensitizeMode();
        int length = source.length();
        char[] chars = source.toCharArray();
        StringBuffer sb = new StringBuffer();
        switch (desensitizationType) {
            case 1: {
                for (int i = 0; i < length; ++i) {
                    if (i < dRule.getFirstdDigits() || i >= length - dRule.getLastDigits()) {
                        sb.append(chars[i]);
                        continue;
                    }
                    sb.append(dRule.getReplaceTo());
                }
                break;
            }
            case 2: {
                return source.replaceAll(dRule.getRegExp(), dRule.getReplaceTo());
            }
            case 3: {
                return dRule.getReplaceTo();
            }
        }
        return sb.toString();
    }

    public static DesensitizationRule from(HashMap<?, ?> item) {
        DesensitizationRule rule = new DesensitizationRule();
        rule.fieldName = (String)item.get("fieldName");
        if (item.get("desensitizeMode") != null) {
            rule.desensitizeMode = Integer.parseInt(item.get("desensitizeMode").toString());
        }
        rule.replaceTo = (String)item.get("replaceTo");
        rule.regExp = (String)item.get("regExp");
        if (item.get("firstdDigits") != null) {
            rule.firstdDigits = Integer.parseInt(item.get("firstdDigits").toString());
        }
        if (item.get("lastDigits") != null) {
            rule.lastDigits = Integer.parseInt(item.get("lastDigits").toString());
        }
        return rule;
    }
}

