/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import java.awt.Color;

public class CustomDialRange {
    public static final Double INFINITY = new Double(Double.POSITIVE_INFINITY);
    public static final Double INFINITESIMAL = new Double(Double.NEGATIVE_INFINITY);
    private String title;
    private Color color;
    private double lower;
    private double upper;

    public CustomDialRange(String title, Color color, double lower, double upper) {
        assert (lower <= upper);
        this.title = title;
        this.color = color;
        this.lower = lower;
        this.upper = upper;
    }

    public CustomDialRange(String title, Color color, Double lower, Double upper) {
        this(title, color, (double)lower, (double)upper);
    }

    public double getLength() {
        return this.upper - this.lower;
    }

    public double getCentralValue() {
        return this.lower / 2.0 + this.upper / 2.0;
    }

    public boolean contains(double value) {
        return value >= this.lower && value <= this.upper;
    }

    public static CustomDialRange combine(CustomDialRange range1, CustomDialRange range2) {
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        double l = Math.min(range1.getLowerBound(), range2.getLowerBound());
        double u = Math.max(range1.getUpperBound(), range2.getUpperBound());
        range1.setLowerBound(l);
        range1.setUpperBound(u);
        return range1;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CustomDialRange) {
            CustomDialRange range = (CustomDialRange)object;
            boolean b0 = this.lower == range.lower;
            boolean b1 = this.upper == range.upper;
            return b0 && b1;
        }
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Color getColor() {
        return this.color;
    }

    public double getLowerBound() {
        return this.lower;
    }

    public double getUpperBound() {
        return this.upper;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLowerBound(double lower) {
        this.lower = lower;
    }

    public void setUpperBound(double upper) {
        this.upper = upper;
    }

    public String toString() {
        return "CustomDialRange[title:" + this.title + ",color:" + this.color + ",lower:" + this.lower + ",upper:" + this.upper + "]";
    }

    public int hashCode() {
        return super.hashCode();
    }
}

