/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.ctrl.swing.KDFontChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.event.FontChangeEvent;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class KingdeeFontChooserUI
extends ComponentUI {
    private KDFontChooser chooser;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private ViewComboBoxHandler vCListener = new ViewComboBoxHandler();
    private ViewListHandler vLListener = new ViewListHandler();
    private ViewComboBoxKeyHandler vCKeyListener = new ViewComboBoxKeyHandler();
    private String[] sysFamilyName;
    private String[] sysFamilyNameExtend;
    private HashMap sizeStrMapToPt = new HashMap();
    private HashMap sizePtMapToStr = new HashMap();
    private String[] sysStyle = new String[4];
    private KDComboBox cFamily;
    private KDComboBox cSize;
    private KDToggleButton cBold;
    private KDToggleButton cItalic;
    private KDLabel lLabFamily;
    private KDTextField lTxtFamily;
    private KDList lLstFamily;
    private KDScrollPane lScpFamily;
    private KDLabel lLabStyle;
    private KDTextField lTxtStyle;
    private KDList lLstStyle;
    private KDScrollPane lScpStyle;
    private KDLabel lLabSize;
    private KDTextField lTxtSize;
    private KDList lLstSize;
    private KDScrollPane lScpSize;
    protected String[][] sysFontSizeAll = new String[][]{{this.getMLS("sizeValue0", "\u521d\u53f7"), "42"}, {this.getMLS("sizeValue1", "\u5c0f\u521d"), "36"}, {this.getMLS("sizeValue2", "\u4e00\u53f7"), "26"}, {this.getMLS("sizeValue3", "\u5c0f\u4e00"), "24"}, {this.getMLS("sizeValue4", "\u4e8c\u53f7"), "22"}, {this.getMLS("sizeValue5", "\u5c0f\u4e8c"), "18"}, {this.getMLS("sizeValue6", "\u4e09\u53f7"), "16"}, {this.getMLS("sizeValue7", "\u5c0f\u4e09"), "15"}, {this.getMLS("sizeValue8", "\u56db\u53f7"), "14"}, {this.getMLS("sizeValue9", "\u5c0f\u56db"), "12"}, {this.getMLS("sizeValue10", "\u4e94\u53f7"), "11"}, {this.getMLS("sizeValue11", "\u5c0f\u4e94"), "9"}, {this.getMLS("sizeValue12", "\u516d\u53f7"), "8"}, {this.getMLS("sizeValue13", "\u5c0f\u516d"), "7"}, {this.getMLS("sizeValue14", "\u4e03\u53f7"), "6"}, {this.getMLS("sizeValue15", "\u516b\u53f7"), "5"}, {"5", "5"}, {"6", "6"}, {"7", "7"}, {"8", "8"}, {"9", "9"}, {"10", "10"}, {"11", "11"}, {"12", "12"}, {"14", "14"}, {"16", "16"}, {"18", "18"}, {"20", "20"}, {"22", "22"}, {"24", "24"}, {"26", "26"}, {"28", "28"}, {"36", "36"}, {"48", "48"}, {"72", "72"}};
    protected String[][] sysFontSize;
    private boolean isNeedToFireValueChanged = true;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.chooser = (KDFontChooser)c;
        this.installDefaults(this.chooser);
        this.installComponents(this.chooser);
        this.installListeners(this.chooser);
        this.installKeyboardActions(this.chooser);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners(this.chooser);
        this.uninstallKeyboardActions(this.chooser);
        this.uninstallComponents(this.chooser);
    }

    protected void uninstallComponents(KDFontChooser c) {
        this.chooser = null;
    }

    protected void installDefaults(KDFontChooser c) {
        this.sysStyle[0] = this.getMLS("styleValue0", "\u5e38\u89c4");
        this.sysStyle[1] = this.getMLS("styleValue1", "\u7c97\u4f53");
        this.sysStyle[2] = this.getMLS("styleValue2", "\u659c\u4f53");
        this.sysStyle[3] = this.getMLS("styleValue3", "\u52a0\u7c97 \u503e\u659c");
        this.sysFamilyName = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.sysFamilyNameExtend = Arrays.copyOf(this.sysFamilyName, this.sysFamilyName.length + 1);
        this.sysFamilyNameExtend[this.sysFamilyNameExtend.length - 1] = LanguageManager.getLangMessage((String)"otherfont", KingdeeFontChooserUI.class, (String)"\u5176\u4ed6\u5b57\u4f53");
        this.sysFamilyName = this.sysFamilyNameExtend;
        for (int i = 0; i < this.sysFontSizeAll.length; ++i) {
            if (StringUtil.equalsIgnoreCase((String)Locale.getDefault().getLanguage(), (String)"en")) {
                if (i < 16) continue;
                if (this.sysFontSize == null) {
                    this.sysFontSize = new String[this.sysFontSizeAll.length - 16][2];
                }
                this.sysFontSize[i - 16] = this.sysFontSizeAll[i];
                this.sizeStrMapToPt.put(this.sysFontSizeAll[i][0], this.sysFontSizeAll[i][1]);
                continue;
            }
            if (this.sysFontSize == null) {
                this.sysFontSize = new String[this.sysFontSizeAll.length][2];
            }
            this.sysFontSize[i] = this.sysFontSizeAll[i];
            this.sizeStrMapToPt.put(this.sysFontSize[i][0], this.sysFontSize[i][1]);
            if (i >= 16) continue;
            this.sizePtMapToStr.put(this.sysFontSize[i][1], this.sysFontSize[i][0]);
        }
        Object[] tempStr = new String[this.sysFontSize.length];
        for (int i = 0; i < this.sysFontSize.length; ++i) {
            tempStr[i] = this.sysFontSize[i][0];
        }
        this.cFamily = new KDComboBox(this.sysFamilyName);
        this.cFamily.setToolTipText(LanguageManager.getLangMessage((String)"fontFamilyToolTips", KingdeeFontChooserUI.class, (String)"Font Family"));
        this.cSize = new KDComboBox(tempStr);
        this.cSize.setToolTipText(LanguageManager.getLangMessage((String)"fontSizeToolTips", KingdeeFontChooserUI.class, (String)"Font Size"));
        this.cBold = new KDToggleButton();
        this.cItalic = new KDToggleButton();
        this.cFamily.setEditable(true);
        this.cSize.setEditable(true);
        this.cBold.setOpaque(false);
        this.cBold.setBorder(null);
        this.cBold.setIcon(new ImageIcon(KDResourceManager.getImageOfRapid("tbtn_B_1.gif")));
        this.cBold.setFactType(0);
        this.cBold.setToolTipText(LanguageManager.getLangMessage((String)"boldFontToolTips", KingdeeFontChooserUI.class, (String)"Bold"));
        this.cItalic.setOpaque(false);
        this.cItalic.setBorder(null);
        this.cItalic.setIcon(new ImageIcon(KDResourceManager.getImageOfRapid("tbtn_I_1.gif")));
        this.cItalic.setFactType(0);
        this.cItalic.setToolTipText(LanguageManager.getLangMessage((String)"italicFontToolTips", KingdeeFontChooserUI.class, (String)"Italic"));
        this.lLabFamily = new KDLabel(this.getMLS("family", "\u5b57\u4f53"));
        this.lTxtFamily = new KDTextField();
        this.lLstFamily = new KDList(this.sysFamilyName);
        this.lScpFamily = new KDScrollPane(this.lLstFamily);
        this.lLabStyle = new KDLabel(this.getMLS("style", "\u5b57\u5f62"));
        this.lTxtStyle = new KDTextField();
        this.lLstStyle = new KDList(this.sysStyle);
        this.lScpStyle = new KDScrollPane(this.lLstStyle);
        this.lLabSize = new KDLabel(this.getMLS("size", "\u5b57\u53f7"));
        this.lTxtSize = new KDTextField();
        this.lLstSize = new KDList(tempStr);
        this.lScpSize = new KDScrollPane(this.lLstSize);
        this.lLstFamily.setSelectionMode(0);
        this.lLstStyle.setSelectionMode(0);
        this.lLstSize.setSelectionMode(0);
        this.lScpStyle.setVerticalScrollBarPolicy(22);
        this.lScpStyle.getVerticalScrollBar().setEnabled(false);
        this.lScpFamily.getVerticalScrollBar().setFocusable(false);
        this.lScpSize.getVerticalScrollBar().setFocusable(false);
        this.lLabFamily.setUnderline(true);
        this.lLabStyle.setUnderline(true);
        this.lLabSize.setUnderline(true);
        this.lTxtFamily.setEnabledPopup(false);
        this.lTxtStyle.setEnabledPopup(false);
        this.lTxtSize.setEnabledPopup(false);
        c.setLayout(new FontChooserLayout());
    }

    protected void installComponents(KDFontChooser c) {
        if (c.getViewType() == 1) {
            this.addComponentsViewComboBox(c);
            this.initComponentsViewComboBox(c);
        } else if (c.getViewType() == 2) {
            this.addComponentsViewList(c);
            this.initComponentsViewList(c);
        }
    }

    protected void addComponentsViewComboBox(KDFontChooser c) {
        c.add((Component)this.cFamily, "viewComboBox_family");
        c.add((Component)this.cSize, "viewComboBox_size");
        c.add((Component)this.cBold, "viewComboBox_bold");
        c.add((Component)this.cItalic, "viewComboBox_italic");
    }

    protected void initComponentsViewComboBox(KDFontChooser c) {
        Font font = c.getSelectionFont();
        this.cFamily.setSelectedItem(font.getFamily());
        this.cBold.setSelected(font.isBold());
        this.cItalic.setSelected(font.isItalic());
        Object oSize = this.sizePtMapToStr.get(String.valueOf(font.getSize()));
        if (oSize == null) {
            this.cSize.setSelectedItem(String.valueOf(font.getSize()));
        } else {
            this.cSize.setSelectedItem(oSize);
        }
    }

    protected void addComponentsViewList(KDFontChooser c) {
        c.add((Component)this.lLabFamily, "viewList_family_label");
        c.add((Component)this.lTxtFamily, "viewList_family_text");
        c.add((Component)this.lScpFamily, "viewList_family_list");
        c.add((Component)this.lLabStyle, "viewList_style_label");
        c.add((Component)this.lTxtStyle, "viewList_style_text");
        c.add((Component)this.lScpStyle, "viewList_style_list");
        c.add((Component)this.lLabSize, "viewList_size_label");
        c.add((Component)this.lTxtSize, "viewList_size_text");
        c.add((Component)this.lScpSize, "viewList_size_list");
        KDSeparator sprt1 = new KDSeparator(1);
        KDSeparator sprt2 = new KDSeparator(1);
        c.add((Component)sprt1, "viewList_separator1");
        c.add((Component)sprt2, "viewList_separator2");
    }

    protected void initComponentsViewList(KDFontChooser c) {
        Font font = c.getSelectionFont();
        this.lTxtFamily.setText(font.getFamily());
        this.lLstFamily.setSelectedValue(font.getFamily(), true);
        this.lLstStyle.setSelectedIndex(font.getStyle());
        this.lTxtStyle.setText(this.lLstStyle.getSelectedValue().toString());
        Object oSize = this.sizePtMapToStr.get(String.valueOf(font.getSize()));
        if (oSize == null) {
            this.lLstSize.clearSelection();
            this.lLstSize.setSelectedValue(String.valueOf(font.getSize()), true);
            this.lTxtSize.setText(String.valueOf(font.getSize()));
        } else {
            this.lTxtSize.setText(oSize.toString());
            this.lLstSize.setSelectedValue(oSize, true);
        }
    }

    protected void installListeners(KDFontChooser c) {
        c.addPropertyChangeListener(this.propertyChangeListener);
        this.cFamily.addActionListener(this.vCListener);
        this.cSize.addActionListener(this.vCListener);
        this.cBold.addActionListener(this.vCListener);
        this.cItalic.addActionListener(this.vCListener);
        this.lTxtFamily.addActionListener(this.vLListener);
        this.lTxtStyle.addActionListener(this.vLListener);
        this.lTxtSize.addActionListener(this.vLListener);
        this.lLstFamily.addListSelectionListener(this.vLListener);
        this.lLstStyle.addListSelectionListener(this.vLListener);
        this.lLstSize.addListSelectionListener(this.vLListener);
    }

    protected void uninstallListeners(KDFontChooser c) {
        c.removePropertyChangeListener(this.propertyChangeListener);
        this.cFamily.removeActionListener(this.vCListener);
        this.cSize.removeActionListener(this.vCListener);
        this.cBold.removeActionListener(this.vCListener);
        this.cItalic.removeActionListener(this.vCListener);
        this.lTxtFamily.removeActionListener(this.vLListener);
        this.lTxtStyle.removeActionListener(this.vLListener);
        this.lTxtSize.removeActionListener(this.vLListener);
        this.lLstFamily.removeListSelectionListener(this.vLListener);
        this.lLstStyle.removeListSelectionListener(this.vLListener);
        this.lLstSize.removeListSelectionListener(this.vLListener);
    }

    protected void installKeyboardActions(KDFontChooser c) {
        this.cFamily.getEditor().addActionListener(this.vCKeyListener);
        this.cSize.getEditor().addActionListener(this.vCKeyListener);
    }

    protected void uninstallKeyboardActions(KDFontChooser c) {
        this.cFamily.getEditor().removeActionListener(this.vCKeyListener);
        this.cSize.getEditor().removeActionListener(this.vCKeyListener);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeFontChooserUI();
    }

    private void revalidateWithParent() {
        this.chooser.revalidate();
        Container ct = this.chooser.getParent();
        if (ct != null) {
            ct.validate();
        }
    }

    protected boolean isSysFamilyName(String f) {
        if (this.sysFamilyName == null) {
            return false;
        }
        for (int i = 0; i < this.sysFamilyName.length; ++i) {
            if (!this.sysFamilyName[i].equals(f)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSysStyle(String style) {
        if (this.sysStyle == null) {
            return false;
        }
        for (int i = 0; i < this.sysStyle.length; ++i) {
            if (!this.sysStyle[i].equals(style)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSysFontSize(String size) {
        if (this.sysFontSize == null) {
            return false;
        }
        for (int i = 0; i < this.sysFontSize.length; ++i) {
            if (!this.sysFontSize[i][0].equals(size)) continue;
            return true;
        }
        return false;
    }

    private void setSelectionFont(String family, int style, int size) {
        this.setSelectionFont(family, style, size, 0);
    }

    private void setSelectionFont(String family, int style, int size, int changeBit) {
        KDFont font = new KDFont(family, style, size);
        this.chooser.getSelectionModel().setSelectedFont(font, changeBit);
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.swing.KDFontChooser", (String)defaultValue);
    }

    public void unsuredFamily() {
        this.isNeedToFireValueChanged = false;
        if (this.chooser.getViewType() == 2) {
            this.lTxtFamily.setText("");
            this.lLstFamily.setSelectedIndex(-1);
        } else if (this.chooser.getViewType() == 1) {
            this.cFamily.setSelectedIndex(-1);
        }
        this.isNeedToFireValueChanged = true;
    }

    public void unsuredSize() {
        this.isNeedToFireValueChanged = false;
        if (this.chooser.getViewType() == 2) {
            this.lTxtSize.setText("");
            this.lLstSize.setSelectedIndex(-1);
        } else if (this.chooser.getViewType() == 1) {
            this.cSize.setSelectedIndex(-1);
        }
        this.isNeedToFireValueChanged = true;
    }

    public void unsuredStyle() {
        this.isNeedToFireValueChanged = false;
        if (this.chooser.getViewType() == 2) {
            this.lTxtStyle.setText("");
            this.lLstStyle.setSelectedIndex(-1);
        } else if (this.chooser.getViewType() == 1) {
            // empty if block
        }
        this.isNeedToFireValueChanged = true;
    }

    protected class ViewComboBoxKeyHandler
    implements ActionListener {
        protected ViewComboBoxKeyHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source.equals(KingdeeFontChooserUI.this.cFamily.getEditor())) {
                KingdeeFontChooserUI.this.cFamily.requestFocus();
            } else if (source.equals(KingdeeFontChooserUI.this.cSize.getEditor())) {
                KingdeeFontChooserUI.this.cSize.requestFocus();
            }
        }
    }

    protected class ViewListHandler
    implements ActionListener,
    ListSelectionListener {
        protected ViewListHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            Font font = KingdeeFontChooserUI.this.chooser.getSelectionFont();
            String family = font.getFamily();
            int style = font.getStyle();
            int size = font.getSize();
            if (source.equals(KingdeeFontChooserUI.this.lTxtFamily)) {
                if (KingdeeFontChooserUI.this.isSysFamilyName(KingdeeFontChooserUI.this.lTxtFamily.getText())) {
                    KingdeeFontChooserUI.this.lLstFamily.setSelectedValue(KingdeeFontChooserUI.this.lTxtFamily.getText(), true);
                    KingdeeFontChooserUI.this.setSelectionFont(KingdeeFontChooserUI.this.lTxtFamily.getText(), style, size);
                } else {
                    KingdeeFontChooserUI.this.lTxtFamily.setText(family);
                }
            } else if (source.equals(KingdeeFontChooserUI.this.lTxtStyle)) {
                if (KingdeeFontChooserUI.this.isSysStyle(KingdeeFontChooserUI.this.lTxtStyle.getText())) {
                    KingdeeFontChooserUI.this.lLstStyle.setSelectedValue(KingdeeFontChooserUI.this.lTxtStyle.getText(), true);
                    KingdeeFontChooserUI.this.setSelectionFont(family, KingdeeFontChooserUI.this.lLstStyle.getSelectedIndex(), size);
                } else {
                    KingdeeFontChooserUI.this.lTxtStyle.setText(KingdeeFontChooserUI.this.lLstStyle.getSelectedValue().toString());
                }
            } else if (source.equals(KingdeeFontChooserUI.this.lTxtSize)) {
                if (KingdeeFontChooserUI.this.isSysFontSize(KingdeeFontChooserUI.this.lTxtSize.getText())) {
                    KingdeeFontChooserUI.this.lLstSize.setSelectedValue(KingdeeFontChooserUI.this.lTxtSize.getText(), true);
                    KingdeeFontChooserUI.this.setSelectionFont(family, style, Integer.parseInt(KingdeeFontChooserUI.this.sizeStrMapToPt.get(KingdeeFontChooserUI.this.lTxtSize.getText()).toString()));
                } else {
                    try {
                        int newSize = Integer.parseInt(KingdeeFontChooserUI.this.lTxtSize.getText());
                        if (newSize >= 1 && newSize <= 1638) {
                            KingdeeFontChooserUI.this.lLstSize.clearSelection();
                            KingdeeFontChooserUI.this.setSelectionFont(family, style, newSize);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!KingdeeFontChooserUI.this.isNeedToFireValueChanged) {
                return;
            }
            Object source = e.getSource();
            Font font = KingdeeFontChooserUI.this.chooser.getSelectionFont();
            String family = font.getFamily();
            int style = font.getStyle();
            int size = font.getSize();
            int changeBit = 0;
            if (source.equals(KingdeeFontChooserUI.this.lLstFamily)) {
                Object fontValue = KingdeeFontChooserUI.this.lLstFamily.getSelectedValue();
                if (fontValue != null) {
                    family = fontValue.toString();
                    KingdeeFontChooserUI.this.lTxtFamily.setText(family);
                } else {
                    KingdeeFontChooserUI.this.lTxtFamily.setText("");
                }
                changeBit = FontChangeEvent.Name_Changed;
            } else if (source.equals(KingdeeFontChooserUI.this.lLstStyle)) {
                String newValue = KingdeeFontChooserUI.this.lLstStyle.getSelectedValue().toString();
                style = KingdeeFontChooserUI.this.lLstStyle.getSelectedIndex();
                KingdeeFontChooserUI.this.lTxtStyle.setText(newValue);
                changeBit = FontChangeEvent.Style_Changed;
            } else if (source.equals(KingdeeFontChooserUI.this.lLstSize) && KingdeeFontChooserUI.this.lLstSize.getSelectedValue() != null) {
                Object oSelected = KingdeeFontChooserUI.this.lLstSize.getSelectedValue();
                Object oPtSize = KingdeeFontChooserUI.this.sizeStrMapToPt.get(oSelected);
                size = Integer.parseInt(oPtSize.toString());
                KingdeeFontChooserUI.this.lTxtSize.setText(oSelected.toString());
                changeBit = FontChangeEvent.Size_Changed;
            }
            KingdeeFontChooserUI.this.setSelectionFont(family, style, size, changeBit);
        }
    }

    protected class ViewComboBoxHandler
    implements ActionListener {
        protected ViewComboBoxHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int italic;
            if (!KingdeeFontChooserUI.this.isNeedToFireValueChanged) {
                return;
            }
            Object source = e.getSource();
            Font font = KingdeeFontChooserUI.this.chooser.getSelectionFont();
            String family = font.getFamily();
            int size = font.getSize();
            int bold = font.isBold() ? 1 : 0;
            int n = italic = font.isItalic() ? 2 : 0;
            if (source.equals(KingdeeFontChooserUI.this.cFamily)) {
                if (KingdeeFontChooserUI.this.isSysFamilyName(KingdeeFontChooserUI.this.cFamily.getEditor().getItem().toString())) {
                    family = KingdeeFontChooserUI.this.cFamily.getSelectedItem().toString();
                }
            } else if (source.equals(KingdeeFontChooserUI.this.cSize)) {
                if (KingdeeFontChooserUI.this.isSysFontSize(KingdeeFontChooserUI.this.cSize.getEditor().getItem().toString())) {
                    Object oPtSize = KingdeeFontChooserUI.this.sizeStrMapToPt.get(KingdeeFontChooserUI.this.cSize.getSelectedItem());
                    size = Integer.parseInt(oPtSize.toString());
                } else {
                    try {
                        int newSize = Integer.parseInt(KingdeeFontChooserUI.this.cSize.getEditor().getItem().toString());
                        if (newSize >= 1 && newSize <= 1638) {
                            size = newSize;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (source.equals(KingdeeFontChooserUI.this.cBold)) {
                bold = KingdeeFontChooserUI.this.cBold.isSelected() ? 1 : 0;
            } else if (source.equals(KingdeeFontChooserUI.this.cItalic)) {
                italic = KingdeeFontChooserUI.this.cItalic.isSelected() ? 2 : 0;
            }
            KingdeeFontChooserUI.this.setSelectionFont(family, bold + italic, size);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            KDFontChooser fc = (KDFontChooser)evt.getSource();
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("viewType")) {
                fc.removeAll();
                KingdeeFontChooserUI.this.installComponents(fc);
                KingdeeFontChooserUI.this.revalidateWithParent();
            }
            if (propertyName.equals("familyVisible") || propertyName.equals("sizeVisible") || propertyName.equals("italicVisible") || propertyName.equals("boldVisible")) {
                KingdeeFontChooserUI.this.revalidateWithParent();
            }
            if (propertyName.equals("familyEnabled")) {
                KingdeeFontChooserUI.this.cFamily.setEnabled(fc.isFamilyEnabled());
            }
            if (propertyName.equals("sizeEnabled")) {
                KingdeeFontChooserUI.this.cSize.setEnabled(fc.isSizeEnabled());
            }
            if (propertyName.equals("italicEnabled")) {
                KingdeeFontChooserUI.this.cItalic.setEnabled(fc.isItalicEnabled());
            }
            if (propertyName.equals("boldEnabled")) {
                KingdeeFontChooserUI.this.cBold.setEnabled(fc.isBoldEnabled());
            }
            if (propertyName.equals("selectionFont") || propertyName.equals("selectionModel")) {
                if (KingdeeFontChooserUI.this.chooser.getViewType() == 1) {
                    KingdeeFontChooserUI.this.initComponentsViewComboBox(KingdeeFontChooserUI.this.chooser);
                } else if (KingdeeFontChooserUI.this.chooser.getViewType() == 2) {
                    KingdeeFontChooserUI.this.initComponentsViewList(KingdeeFontChooserUI.this.chooser);
                }
            }
        }
    }

    protected class FontChooserLayout
    implements LayoutManager {
        public static final String C_FAMILY = "viewComboBox_family";
        public static final String C_SIZE = "viewComboBox_size";
        public static final String C_BOLD = "viewComboBox_bold";
        public static final String C_ITALIC = "viewComboBox_italic";
        Component cFamily;
        Component cSize;
        Component cBold;
        Component cItalic;
        static final int cTop = 1;
        static final int cLeft = 1;
        static final int cHeight = 21;
        static final int cWidthFamily = 120;
        static final int cWidthSize = 60;
        static final int cWidthButton = 25;
        static final int cGapH = 3;
        public static final String L_FAMILY_LABEL = "viewList_family_label";
        public static final String L_SIZE_LABEL = "viewList_size_label";
        public static final String L_STYLE_LABEL = "viewList_style_label";
        public static final String L_FAMILY_TEXT = "viewList_family_text";
        public static final String L_SIZE_TEXT = "viewList_size_text";
        public static final String L_STYLE_TEXT = "viewList_style_text";
        public static final String L_FAMILY_LIST = "viewList_family_list";
        public static final String L_SIZE_LIST = "viewList_size_list";
        public static final String L_STYLE_LIST = "viewList_style_list";
        public static final String L_SEPARATOR1 = "viewList_separator1";
        public static final String L_SEPARATOR2 = "viewList_separator2";
        Component lLabFamily;
        Component lTxtFamily;
        Component lLstFamily;
        Component lLabStyle;
        Component lTxtStyle;
        Component lLstStyle;
        Component lLabSize;
        Component lTxtSize;
        Component lLstSize;
        Component lSeparator1;
        Component lSeparator2;
        static final int lGapH = 8;
        static final int lGapV = 4;
        static final int lWidthFamily = 180;
        static final int lWidthStyle = 120;
        static final int lWidthSize = 100;
        static final int lWidthLabel = 40;
        static final int lWidthSprt = 2;
        static final int lHeightText = 20;
        static final int lHeightList = 120;
        static final int lLeft = 1;
        static final int lTop = 1;

        protected FontChooserLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (C_FAMILY.equals(name)) {
                this.cFamily = comp;
            } else if (C_SIZE.equals(name)) {
                this.cSize = comp;
            } else if (C_BOLD.equals(name)) {
                this.cBold = comp;
            } else if (C_ITALIC.equals(name)) {
                this.cItalic = comp;
            } else if (L_FAMILY_LABEL.equals(name)) {
                this.lLabFamily = comp;
            } else if (L_FAMILY_TEXT.equals(name)) {
                this.lTxtFamily = comp;
            } else if (L_FAMILY_LIST.equals(name)) {
                this.lLstFamily = comp;
            } else if (L_STYLE_LABEL.equals(name)) {
                this.lLabStyle = comp;
            } else if (L_STYLE_TEXT.equals(name)) {
                this.lTxtStyle = comp;
            } else if (L_STYLE_LIST.equals(name)) {
                this.lLstStyle = comp;
            } else if (L_SIZE_LABEL.equals(name)) {
                this.lLabSize = comp;
            } else if (L_SIZE_TEXT.equals(name)) {
                this.lTxtSize = comp;
            } else if (L_SIZE_LIST.equals(name)) {
                this.lLstSize = comp;
            } else if (L_SEPARATOR1.equals(name)) {
                this.lSeparator1 = comp;
            } else if (L_SEPARATOR2.equals(name)) {
                this.lSeparator2 = comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            int w = insets.left + insets.right;
            int h = insets.top + insets.bottom;
            if (((KDFontChooser)parent).getViewType() == 1) {
                ++w;
                w += KingdeeFontChooserUI.this.chooser.isFamilyVisible() ? 123 : 0;
                w += KingdeeFontChooserUI.this.chooser.isSizeVisible() ? 63 : 0;
                w += KingdeeFontChooserUI.this.chooser.isBoldVisible() ? 28 : 0;
                w += KingdeeFontChooserUI.this.chooser.isItalicVisible() ? 25 : 0;
                h += 22;
            } else if (((KDFontChooser)parent).getViewType() == 2) {
                w += 437;
                h += 145;
            }
            return new Dimension(w, h);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (((KDFontChooser)parent).getViewType() == 1) {
                this.doLayoutViewComboBox(parent);
            } else if (((KDFontChooser)parent).getViewType() == 2) {
                this.doLayoutViewList(parent);
            }
        }

        protected void doLayoutViewComboBox(Container parent) {
            Insets insets = parent.getInsets();
            Dimension parentDim = parent.getSize();
            int x = 1 + insets.left;
            int y = (parentDim.height - 21) / 2 + 1 + insets.top;
            if (this.cFamily != null) {
                if (KingdeeFontChooserUI.this.chooser.isFamilyVisible()) {
                    this.cFamily.setVisible(true);
                    this.cFamily.setEnabled(KingdeeFontChooserUI.this.chooser.isFamilyEnabled());
                    this.cFamily.setBounds(x, y + 1, 120, 19);
                    x = x + 120 + 3;
                } else {
                    this.cFamily.setVisible(false);
                }
            }
            if (this.cSize != null) {
                if (KingdeeFontChooserUI.this.chooser.isSizeVisible()) {
                    this.cSize.setVisible(true);
                    this.cSize.setEnabled(KingdeeFontChooserUI.this.chooser.isSizeEnabled());
                    this.cSize.setBounds(x, y + 1, 60, 19);
                    x = x + 60 + 3;
                } else {
                    this.cSize.setVisible(false);
                }
            }
            if (this.cBold != null) {
                if (KingdeeFontChooserUI.this.chooser.isBoldVisible()) {
                    this.cBold.setVisible(true);
                    this.cBold.setEnabled(KingdeeFontChooserUI.this.chooser.isBoldEnabled());
                    this.cBold.setBounds(x, y, 25, 21);
                    x = x + 25 + 3;
                } else {
                    this.cBold.setVisible(false);
                }
            }
            if (this.cItalic != null) {
                if (KingdeeFontChooserUI.this.chooser.isItalicVisible()) {
                    this.cItalic.setVisible(true);
                    this.cItalic.setEnabled(KingdeeFontChooserUI.this.chooser.isItalicEnabled());
                    this.cItalic.setBounds(x, y, 25, 21);
                } else {
                    this.cItalic.setVisible(false);
                }
            }
        }

        protected void doLayoutViewList(Container parent) {
            Insets insets = parent.getInsets();
            int labX = 1 + insets.left;
            int labY = 1 + insets.top;
            int labW = 40;
            int labH = 20;
            int txtX = labX + 40;
            int txtY = labY;
            int txtW = 140;
            int txtH = 20;
            int lstX = labX;
            int lstY = txtY + 20 + 4;
            int lstW = 180;
            int lstH = 120;
            if (this.lLabFamily != null) {
                this.lLabFamily.setBounds(labX, labY, labW, labH);
            }
            if (this.lTxtFamily != null) {
                this.lTxtFamily.setBounds(txtX, txtY, txtW, txtH);
            }
            if (this.lLstFamily != null) {
                this.lLstFamily.setBounds(lstX, lstY, lstW, lstH);
            }
            labX = labX + 180 + 8;
            if (this.lSeparator1 != null) {
                this.lSeparator1.setBounds(labX, labY, 2, 144);
            }
            labX = labX + 2 + 8;
            txtX = labX + 40;
            txtW = 80;
            lstX = labX;
            lstW = 120;
            if (this.lLabStyle != null) {
                this.lLabStyle.setBounds(labX, labY, labW, labH);
            }
            if (this.lTxtStyle != null) {
                this.lTxtStyle.setBounds(txtX, txtY, txtW, txtH);
            }
            if (this.lLstStyle != null) {
                this.lLstStyle.setBounds(lstX, lstY, lstW, lstH);
            }
            labX = labX + 120 + 8;
            if (this.lSeparator2 != null) {
                this.lSeparator2.setBounds(labX, labY, 2, 144);
            }
            labX = labX + 2 + 8;
            txtX = labX + 40;
            txtW = 60;
            lstX = labX;
            lstW = 100;
            if (this.lLabSize != null) {
                this.lLabSize.setBounds(labX, labY, labW, labH);
            }
            if (this.lTxtSize != null) {
                this.lTxtSize.setBounds(txtX, txtY, txtW, txtH);
            }
            if (this.lLstSize != null) {
                this.lLstSize.setBounds(lstX, lstY, lstW, lstH);
            }
        }
    }
}

