/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.util;

import com.kingdee.bos.ctrl.swing.EscCloseWindowAction;
import com.kingdee.bos.ctrl.swing.IAllowedMouseProcess;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDSkinRootPane;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.util.SwingLogUtil;
import com.sun.imageio.plugins.gif.GIFImageMetadata;
import java.applet.Applet;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.text.NumberFormatter;
import org.w3c.dom.NodeList;

public class CtrlSwingUtilities {
    public static final BigDecimal BUS_MAX_BIGDECIMAL = new BigDecimal("1.0E31").subtract(new BigDecimal("1"));
    public static final BigDecimal BUS_MIN_BIGDECIMAL = new BigDecimal("-1.0E31").add(new BigDecimal("1"));
    private static Date maxYearValue = null;
    private static Date minYearValue = null;
    public static final String EDITOR_MASK = "EditorForCompositeControl";
    private static int flag = 0;
    private static Method method;
    public static final int CONVERT_TO_SIMPLE_CHINESE = 0;
    public static final int CONVERT_TO_TRADITIONAL_CHINESE = 1;
    public static final int DO_NOT_CONVERT = 2;
    private static int converType;

    public static Date getMaxDateValue() {
        if (maxYearValue == null) {
            int year = 2999;
            try {
                Object obj = UIManager.get("DatePicker.maxYearValue");
                if (obj != null && obj instanceof Integer) {
                    year = (Integer)obj;
                    year = year >= 0 ? year : 2999;
                }
            }
            catch (Exception obj) {
                // empty catch block
            }
            Calendar cal = Calendar.getInstance();
            cal.set(year, 11, 31);
            maxYearValue = cal.getTime();
        }
        return maxYearValue;
    }

    public static Date getMinDateValue() {
        if (minYearValue == null) {
            int year = 0;
            try {
                Object obj = UIManager.get("DatePicker.minYearValue");
                if (obj != null && obj instanceof Integer) {
                    year = (Integer)obj;
                    year = year >= 0 ? year : 0;
                }
            }
            catch (Exception obj) {
                // empty catch block
            }
            Calendar cal = Calendar.getInstance();
            cal.set(year, 0, 1);
            minYearValue = cal.getTime();
        }
        return minYearValue;
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        if (month >= 12) {
            month = 11;
        } else if (month < 0) {
            month = 0;
        }
        cal.set(2, month);
        cal.set(5, day);
        return cal.getTime();
    }

    public static Calendar getCalendar(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        if (month >= 12) {
            month = 11;
        } else if (month < 0) {
            month = 0;
        }
        cal.set(2, month);
        cal.set(5, day);
        return cal;
    }

    public static Calendar getCurrentCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(System.currentTimeMillis()));
        return cal;
    }

    public static Calendar getYearHead(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getYearTail(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar theYearIncreasing(int theYear, int x) {
        Calendar cal = CtrlSwingUtilities.getYearHead(theYear);
        int year = cal.get(1) + x;
        cal.set(1, year);
        return cal;
    }

    public static Calendar theYearDecreasing(int theYear, int x) {
        Calendar cal = CtrlSwingUtilities.getYearHead(theYear);
        int year = cal.get(1) - x;
        if (year <= 0) {
            year = 0;
        }
        cal.set(1, year);
        return cal;
    }

    public static Calendar theYearIncreasing(Calendar theYear, int x) {
        if (theYear == null) {
            return null;
        }
        int year = theYear.get(1) + x;
        Calendar cal = (Calendar)theYear.clone();
        cal.set(1, year);
        return cal;
    }

    public static Calendar theYearDecreasing(Calendar theYear, int x) {
        if (theYear == null) {
            return null;
        }
        int year = theYear.get(1) - x;
        if (year <= 0) {
            year = 0;
        }
        Calendar cal = (Calendar)theYear.clone();
        cal.set(1, year);
        return cal;
    }

    public static void centerWindow(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension1 = window.getSize();
        window.setLocation((dimension.width - dimension1.width) / 2, (dimension.height - dimension1.height) / 2);
    }

    public static void centerWindow(Window wA, Window wB) {
        if (wA != null && wB != null) {
            wA.setLocationRelativeTo(wB);
        }
    }

    public static JDialog createDialog(Component parentComponent, String title) {
        JDialog dialog;
        Frame frame = CtrlSwingUtilities.getFrameForComponent(parentComponent);
        if (frame != null) {
            dialog = new JDialog(frame, title, true);
        } else {
            Dialog parentDialog = CtrlSwingUtilities.getDialogForComponent(parentComponent);
            dialog = new JDialog(parentDialog, title, true);
        }
        dialog.setLocationRelativeTo(parentComponent);
        return dialog;
    }

    public static KDDialog createKDDialog(Component parentComponent, String title) {
        KDDialog dialog;
        Frame frame = CtrlSwingUtilities.getFrameForComponent(parentComponent);
        if (frame != null) {
            dialog = new KDDialog(frame, title, true);
        } else {
            Dialog parentDialog = CtrlSwingUtilities.getDialogForComponent(parentComponent);
            dialog = new KDDialog(parentDialog, title, true);
        }
        dialog.setLocationRelativeTo(parentComponent);
        return dialog;
    }

    public static Frame getFrameForComponent(Component c) {
        if (c instanceof Frame) {
            return (Frame)c;
        }
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static Dialog getDialogForComponent(Component c) {
        if (c instanceof Dialog) {
            return (Dialog)c;
        }
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Dialog)) continue;
            return (Dialog)p;
        }
        return null;
    }

    public static void setFrameIcon(Window window, String iconPath) {
        if (window == null || iconPath == null) {
            return;
        }
        URL iconURL = null;
        ImageIcon icon = null;
        try {
            ClassLoader loader = CtrlSwingUtilities.class.getClassLoader();
            iconURL = loader.getResource(iconPath);
            icon = new ImageIcon(iconURL);
            CtrlSwingUtilities.setFrameIcon(window, icon);
        }
        catch (NullPointerException nu) {
            nu.printStackTrace();
        }
    }

    public static void setFrameIcon(Window window, Icon icon) {
        if (window == null || icon == null) {
            return;
        }
        try {
            if (!(window instanceof JDialog) && window instanceof JFrame) {
                ((JFrame)window).setIconImage(((ImageIcon)icon).getImage());
            }
        }
        catch (NullPointerException nu) {
            nu.printStackTrace();
        }
    }

    public static void setFrameIcon(Window window) {
        if (window == null) {
            return;
        }
        String iconPath = "";
        URL iconURL = null;
        ImageIcon icon = null;
        try {
            ClassLoader loader = CtrlSwingUtilities.class.getClassLoader();
            iconURL = loader.getResource(iconPath);
            icon = new ImageIcon(iconURL);
            CtrlSwingUtilities.setFrameIcon(window, icon);
        }
        catch (NullPointerException nu) {
            nu.printStackTrace();
        }
    }

    public static Point getScreenPointForComponent(Component c) {
        Point invokerScreenLocation;
        if (c == null) {
            throw new NullPointerException("relative component is null.");
        }
        Point p1 = c.getLocationOnScreen();
        if (p1 != null) {
            return p1;
        }
        Container root = null;
        if (c instanceof Window || c instanceof Applet) {
            root = (Container)c;
        } else {
            for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                root = parent;
                break;
            }
        }
        if (root instanceof Applet) {
            invokerScreenLocation = c.getLocationOnScreen();
        } else {
            invokerScreenLocation = new Point(0, 0);
            for (Component tc = c; tc != null; tc = tc.getParent()) {
                Point tcl = tc.getLocation();
                invokerScreenLocation.x += tcl.x;
                invokerScreenLocation.y += tcl.y;
                if (tc == root) break;
            }
        }
        int dx = invokerScreenLocation.x;
        int dy = invokerScreenLocation.y;
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        if (dx < 0) {
            dx = 0;
        } else if (dx > ss.width) {
            dx = ss.width - 5;
        }
        if (dy < 0) {
            dy = 0;
        } else if (dy > ss.height) {
            dy = ss.height - 5;
        }
        return new Point(dx, dy);
    }

    public static void locateWindowToComponent(Window w, Point compP, Component c, int orientation) {
        int x;
        if (w == null || c == null) {
            return;
        }
        if (compP == null) {
            compP = c.getLocationOnScreen();
        }
        if (compP == null) {
            return;
        }
        Dimension winDim = w.getSize();
        Dimension compDim = c.getSize();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int y = 0;
        if (orientation == 3) {
            y = compP.y + compDim.height + 1;
            if (y + winDim.height > screenDim.height - 50) {
                y = compP.y - winDim.height;
                y = y > 0 ? y : 0;
            }
        } else {
            y = compP.y - winDim.height - 1;
            if (y <= 0) {
                y = compP.y + compDim.height + winDim.height;
                if (y > screenDim.height) {
                    if (y < 0) {
                        y = 2;
                    }
                } else {
                    y = compP.y + compDim.height + 2;
                }
            }
        }
        x = (x = compP.x + winDim.width) > screenDim.width ? screenDim.width - winDim.width : compP.x;
        w.setLocation(x, y);
    }

    public static Point getPointForPopup(Component c, Component w, int orientation) {
        int x;
        Point p = new Point(2, 2);
        if (w == null || c == null) {
            return p;
        }
        Point compP = c.getLocationOnScreen();
        Dimension winDim = new Dimension(0, 0);
        if (!(w instanceof JPopupMenu)) {
            w.getSize();
        }
        Dimension compDim = c.getSize();
        Dimension dimSc = Toolkit.getDefaultToolkit().getScreenSize();
        int y = 0;
        if (orientation == 3) {
            y = compP.y + compDim.height + 1;
            if (y + winDim.height > dimSc.height) {
                y = compP.x - winDim.height;
                y = y > 0 ? y : 0;
            }
        } else {
            y = compP.y - winDim.height - 1;
            if (y <= 0) {
                y = compP.y + compDim.height + winDim.height;
                if (y > dimSc.height) {
                    if (y < 0) {
                        y = 2;
                    }
                } else {
                    y = compP.y + compDim.height + 2;
                }
            }
        }
        x = (x = compP.x + winDim.width) > dimSc.width ? dimSc.width - winDim.width : compP.x;
        p.x = x;
        p.y = y;
        return p;
    }

    public static String convertCurrencyToCN(BigDecimal number, Locale local) {
        String pVal = null;
        if (number != null) {
            String nagative = "";
            String nagVirText = "";
            boolean isNagativeB = false;
            if (number.toString().indexOf("-") >= 0) {
                nagative = "\u8d1f";
                isNagativeB = true;
            }
            try {
                String str;
                String index;
                Properties decimalPro = CtrlSwingUtilities.getDecimalUnitMapping(local);
                Properties integerPro = CtrlSwingUtilities.getIntegerUnitMapping(local);
                Properties numberPro = CtrlSwingUtilities.getNumberMapping(local);
                String valTemp = number.toString();
                if (isNagativeB) {
                    valTemp = valTemp.replace('-', ' ').trim();
                }
                int dotIndex = valTemp.indexOf(".");
                String integerStr = "";
                String integerTempStr = null;
                String decimalStr = "";
                String decimalTempStr = null;
                if (dotIndex == -1) {
                    integerTempStr = valTemp;
                } else {
                    integerTempStr = valTemp.substring(0, dotIndex);
                    decimalTempStr = valTemp.substring(dotIndex + 1);
                }
                if (integerTempStr != null) {
                    int integerLen;
                    for (int i = integerLen = integerTempStr.length() - 1; i >= 0; --i) {
                        index = String.valueOf(i);
                        str = String.valueOf(integerTempStr.charAt(integerLen - i));
                        String numStr = numberPro.getProperty(str);
                        String uombStr = integerPro.getProperty(index);
                        integerStr = integerStr + numStr + uombStr;
                    }
                    if (isNagativeB) {
                        // empty if block
                    }
                }
                if (decimalTempStr != null) {
                    int decimalLen = decimalTempStr.length();
                    for (int j = 0; j < decimalLen && j < 2; ++j) {
                        index = String.valueOf(j);
                        str = String.valueOf(decimalTempStr.charAt(j));
                        decimalStr = decimalStr + numberPro.getProperty(str) + decimalPro.getProperty(index);
                    }
                    if (decimalLen == 1) {
                        decimalStr = decimalStr + "\u96f6\u5206";
                    }
                } else {
                    decimalStr = "\u96f6\u89d2\u96f6\u5206";
                }
                pVal = nagative + nagVirText + integerStr + decimalStr + "\u6574";
            }
            catch (Exception ex) {
                ex.printStackTrace();
                pVal = null;
            }
        }
        return pVal;
    }

    private static Properties getDecimalUnitMapping(Locale local) {
        Properties decimalCurrencyUomb = new Properties();
        decimalCurrencyUomb.setProperty("0", "\u89d2");
        decimalCurrencyUomb.setProperty("1", "\u5206");
        return decimalCurrencyUomb;
    }

    private static Properties getIntegerUnitMapping(Locale local) {
        Properties integerCurrencyUomb = new Properties();
        integerCurrencyUomb.setProperty("0", "\u5143");
        integerCurrencyUomb.setProperty("1", "\u62fe");
        integerCurrencyUomb.setProperty("2", "\u4f70");
        integerCurrencyUomb.setProperty("3", "\u4edf");
        integerCurrencyUomb.setProperty("4", "\u4e07");
        integerCurrencyUomb.setProperty("5", "\u62fe");
        integerCurrencyUomb.setProperty("6", "\u4f70");
        integerCurrencyUomb.setProperty("7", "\u4edf");
        integerCurrencyUomb.setProperty("8", "\u4ebf");
        integerCurrencyUomb.setProperty("9", "\u62fe");
        integerCurrencyUomb.setProperty("10", "\u4f70");
        integerCurrencyUomb.setProperty("11", "\u4edf");
        integerCurrencyUomb.setProperty("12", "\u4e07");
        integerCurrencyUomb.setProperty("13", "\u62fe");
        integerCurrencyUomb.setProperty("14", "\u4f70");
        integerCurrencyUomb.setProperty("15", "\u4edf");
        integerCurrencyUomb.setProperty("16", "\u4e07");
        integerCurrencyUomb.setProperty("17", "\u4ebf");
        integerCurrencyUomb.setProperty("18", "\u62fe");
        return integerCurrencyUomb;
    }

    private static Properties getNumberMapping(Locale local) {
        Properties numberMapping = new Properties();
        numberMapping.setProperty("0", "\u96f6");
        numberMapping.setProperty("1", "\u58f9");
        numberMapping.setProperty("2", "\u8d30");
        numberMapping.setProperty("3", "\u53c1");
        numberMapping.setProperty("4", "\u8086");
        numberMapping.setProperty("5", "\u4f0d");
        numberMapping.setProperty("6", "\u9646");
        numberMapping.setProperty("7", "\u67d2");
        numberMapping.setProperty("8", "\u634c");
        numberMapping.setProperty("9", "\u7396");
        return numberMapping;
    }

    public static Timestamp clearTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(timestamp);
        tempCal.set(11, 0);
        tempCal.set(12, 0);
        tempCal.set(13, 0);
        tempCal.set(14, 0);
        timestamp = new Timestamp(tempCal.getTime().getTime());
        timestamp.setNanos(0);
        return timestamp;
    }

    public static Object[] convertToArray(Vector sourceVec) {
        if (sourceVec == null) {
            return null;
        }
        Object[] returnObj = new Object[sourceVec.size()];
        for (int i = 0; i < returnObj.length; ++i) {
            returnObj[i] = sourceVec.elementAt(i);
        }
        return returnObj;
    }

    public static Vector convertToVector(Object[][] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Vector> v = new Vector<Vector>(anArray.length);
        for (int i = 0; i < anArray.length; ++i) {
            v.addElement(CtrlSwingUtilities.convertToVector(anArray[i]));
        }
        return v;
    }

    public static Vector convertToVector(Object[] anArray) {
        if (anArray == null || anArray.length == 0) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(anArray.length);
        for (int i = 0; i < anArray.length; ++i) {
            v.addElement(anArray[i]);
        }
        return v;
    }

    public static String getUnicode(String source) {
        String returnUniCode = null;
        String uniCodeTemp = null;
        for (int i = 0; i < source.length(); ++i) {
            uniCodeTemp = "\\u" + Integer.toHexString(source.charAt(i));
            returnUniCode = returnUniCode == null ? uniCodeTemp : returnUniCode + uniCodeTemp;
        }
        return returnUniCode;
    }

    public static boolean judgeEquals(int source, int toCompare) {
        return source == toCompare;
    }

    public static boolean judgeEquals(Object source, Object toCompare) {
        if (source == null) {
            return toCompare == null;
        }
        return source.equals(toCompare);
    }

    public static boolean judgeEquals(String source, String toCompare) {
        source = source == null ? "" : source;
        toCompare = toCompare == null ? "" : toCompare;
        return source.equals(toCompare);
    }

    public static boolean judgeEquals(BigDecimal source, BigDecimal toCompare) {
        if (source == null || toCompare == null) {
            return source == toCompare;
        }
        boolean b = source.equals(toCompare);
        if (source.scale() != toCompare.scale()) {
            b = false;
        }
        return b;
    }

    public static boolean judgeEquals(Timestamp source, Timestamp toCompare) {
        if (source == null) {
            return toCompare == null;
        }
        if (toCompare == null) {
            return false;
        }
        Calendar cSource = Calendar.getInstance();
        Calendar cToCompare = Calendar.getInstance();
        cSource.setTime(source);
        cToCompare.setTime(toCompare);
        return cSource.get(1) == cToCompare.get(1) && cSource.get(2) == cToCompare.get(2) && cSource.get(5) == cToCompare.get(5) && cSource.get(10) == cToCompare.get(10) && cSource.get(12) == cToCompare.get(12) && cSource.get(13) == cToCompare.get(13);
    }

    public static boolean judgeEquals(Date source, Date toCompare) {
        int res = CtrlSwingUtilities.judgeDate(source, toCompare);
        return res == 0;
    }

    public static boolean judgeEqualsDateObj(Object source, Object toCompare) {
        int res = -1;
        if (source instanceof Date && toCompare instanceof Date) {
            res = CtrlSwingUtilities.judgeDate((Date)source, (Date)toCompare);
        } else if (source == null && toCompare == null) {
            res = 0;
        }
        return res == 0;
    }

    public static int judgeNumber(Number source, Number toCompare) {
        if (source == null && toCompare == null) {
            return 0;
        }
        if (source == null && toCompare != null) {
            return -1;
        }
        if (source != null && toCompare == null) {
            return 1;
        }
        try {
            double sourceDou = source.doubleValue();
            double toCompareDou = toCompare.doubleValue();
            if (sourceDou > toCompareDou) {
                return 1;
            }
            if (sourceDou < toCompareDou) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int judgeNumberObject(Object source, Object toCompare) {
        if (source == null && toCompare == null) {
            return 0;
        }
        if (source == null && toCompare != null) {
            return -1;
        }
        if (source != null && toCompare == null) {
            return 1;
        }
        if (source instanceof Number && toCompare instanceof Number) {
            return CtrlSwingUtilities.judgeNumber((Number)source, (Number)toCompare);
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int judgeDate(Date source, Date toCompare) {
        int res = 0;
        if (source != null && toCompare != null) {
            long anotherTime;
            if (source instanceof Timestamp && toCompare instanceof Timestamp) {
                return ((Timestamp)source).compareTo((Timestamp)toCompare);
            }
            long thisTime = source.getTime();
            if (thisTime < (anotherTime = toCompare.getTime())) {
                return -1;
            }
            if (thisTime != anotherTime) return 1;
            return 0;
        }
        if (source == null && toCompare == null) {
            return 0;
        }
        if (source != null && toCompare == null) {
            return 1;
        }
        if (source != null) return res;
        if (toCompare == null) return res;
        return -1;
    }

    public static boolean judgeEquals(Hashtable source, Hashtable toCompare) {
        if (source == null) {
            return toCompare == null;
        }
        return source.equals(toCompare);
    }

    public static boolean judgeEquals(Vector vOne, Vector vAnother) {
        if (vOne != vAnother) {
            int i;
            if (vOne == null || vAnother == null) {
                return false;
            }
            if (vOne.size() != vAnother.size()) {
                return false;
            }
            int[] whichWill = new int[vAnother.size()];
            for (i = 0; i < whichWill.length; ++i) {
                whichWill[i] = i;
            }
            for (i = 0; i < vOne.size(); ++i) {
                boolean equals = true;
                for (int j = 0; j < whichWill.length; ++j) {
                    if (whichWill[j] != -1 && (vOne.elementAt(i) == null ? vOne.elementAt(i) == vAnother.elementAt(j) : vOne.elementAt(i).equals(vAnother.elementAt(j)))) {
                        equals = true;
                        whichWill[j] = -1;
                        break;
                    }
                    equals = false;
                }
                if (equals) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean judgeEquals(short source, short toCompare) {
        return source == toCompare;
    }

    public static boolean judgeEquals(boolean source, boolean toCompare) {
        return source == toCompare;
    }

    public static void putHashtableToAnother(Hashtable htSource, Hashtable htAnother) {
        Enumeration enum1 = htAnother.keys();
        while (enum1.hasMoreElements()) {
            Object obj = enum1.nextElement();
            htSource.put(obj, htAnother.get(obj));
        }
    }

    public static Object[] removeNullElement(Object[] array) {
        if (array == null) {
            return null;
        }
        Vector<Object> vecResult = new Vector<Object>(0);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            vecResult.addElement(array[i]);
        }
        if (vecResult.size() == 0) {
            return null;
        }
        try {
            Object[] result = (Object[])Array.newInstance(vecResult.firstElement().getClass(), vecResult.size());
            for (int i = 0; i < vecResult.size(); ++i) {
                result[i] = vecResult.elementAt(i);
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The class type in array parameter is not same!!!");
        }
    }

    public static void transferDataFromVectorToArray(Vector sourceVector, Object[] destinationArray) {
        if (sourceVector == null || destinationArray == null) {
            return;
        }
        if (sourceVector.size() != destinationArray.length) {
            throw new IllegalArgumentException("Vector.size must equals Array.lenth");
        }
        for (int i = 0; i < sourceVector.size(); ++i) {
            destinationArray[i] = sourceVector.elementAt(i);
        }
    }

    public static String getDateString(Date date, String pattern, Locale l) {
        if (date == null) {
            return null;
        }
        String lS = "zh";
        if (l != null) {
            lS = l.getLanguage();
        }
        if (pattern == null) {
            pattern = lS.equals("en") ? "MM/dd/yyyy" : "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat();
            sdf.applyPattern(pattern);
            return sdf.format(date);
        }
        catch (Exception e) {
            sdf.applyPattern("yyyy-MM-dd");
            return sdf.format(date);
        }
    }

    public static void configNumberFormatter(NumberFormatter formatter, int propertyType, Object propertyValue) {
    }

    public static boolean runCtrlInputVerifier(JComponent comp) {
        if (comp == null) {
            return true;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == comp) {
            return true;
        }
        if (!comp.getVerifyInputWhenFocusTarget()) {
            return true;
        }
        if (focusOwner == null || !(focusOwner instanceof JComponent)) {
            return true;
        }
        JComponent jFocusOwner = (JComponent)focusOwner;
        InputVerifier iv = jFocusOwner.getInputVerifier();
        if (iv == null) {
            return true;
        }
        boolean b = iv.shouldYieldFocus(jFocusOwner);
        if (!b && jFocusOwner instanceof IAllowedMouseProcess) {
            return ((IAllowedMouseProcess)((Object)jFocusOwner)).shouldProcessMouseOprt(comp);
        }
        return b;
    }

    public static void putActionMap(Object key, Window w) {
        if (w == null || key == null) {
            return;
        }
        JRootPane rootPane = null;
        if (w instanceof JDialog) {
            rootPane = ((JDialog)w).getRootPane();
        } else if (w instanceof JFrame) {
            rootPane = ((JFrame)w).getRootPane();
        } else {
            return;
        }
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), key);
        actionMap.put(key, new EscCloseWindowAction());
    }

    public static void putActionMapForInternalFrame(Object key, JInternalFrame w) {
    }

    public static void setGlobalTextIconStyleOnButton(short style) {
        if (style != 2 && style != 1 && style != 3 && style != -1) {
            throw new IllegalArgumentException("style is illegal.");
        }
        KDToolBar.setTextIconDisStyleByParent(style);
    }

    public static boolean isEditorForCompositeControl(Component comp) {
        Object obj;
        if (comp instanceof JComponent && (obj = ((JComponent)comp).getClientProperty(EDITOR_MASK)) instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static void egisterEscapeAction(JRootPane pane, Action action) {
        InputMap inputMap = pane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "esc");
        ActionMap actionMap = pane.getActionMap();
        actionMap.put("esc", action);
    }

    public static void printInputMap(InputMap map) {
        SwingLogUtil.info((String)"---inputmap---");
        KeyStroke[] keys = map.allKeys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                KeyStroke key = keys[i];
                Object actionName = map.get(key);
                SwingLogUtil.info((String)("key:<" + key + ">\t actionname:" + actionName));
            }
        }
    }

    public static void printActionMap(ActionMap map) {
        SwingLogUtil.info((String)"---actionmap---");
        Object[] keys = map.allKeys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                Action action = map.get(key);
                SwingLogUtil.info((String)("key:<" + key + ">\t actionname:" + action.getClass().getName()));
            }
        }
    }

    public static Set getManagingFocusForwardTraversalKeys(JComponent comp) {
        return comp.getFocusTraversalKeys(0);
    }

    public static Set getManagingFocusBackwardTraversalKeys(JComponent comp) {
        return comp.getFocusTraversalKeys(1);
    }

    public static void addManagingFocusForwardTraversalKeys(JComponent comp, KeyStroke keyStroke) {
        if (comp == null) {
            return;
        }
        Set sets = CtrlSwingUtilities.getManagingFocusForwardTraversalKeys(comp);
        HashSet<KeyStroke> treeset = new HashSet<KeyStroke>(sets);
        treeset.add(keyStroke);
        comp.setFocusTraversalKeys(0, treeset);
    }

    public static void addManagingFocusBackwardTraversalKeys(JComponent comp, KeyStroke keyStroke) {
        if (comp == null) {
            return;
        }
        Set sets = CtrlSwingUtilities.getManagingFocusBackwardTraversalKeys(comp);
        HashSet<KeyStroke> treeset = new HashSet<KeyStroke>(sets);
        treeset.add(keyStroke);
        comp.setFocusTraversalKeys(1, treeset);
    }

    public static void removeManagingFocusForwardTraversalKeys(JComponent comp, KeyStroke keyStroke) {
        if (comp == null) {
            return;
        }
        Set sets = CtrlSwingUtilities.getManagingFocusForwardTraversalKeys(comp);
        HashSet treeset = new HashSet(sets);
        treeset.remove(keyStroke);
        comp.setFocusTraversalKeys(0, treeset);
    }

    public static void removeManagingFocusBackwardTraversalKeys(JComponent comp, KeyStroke keyStroke) {
        if (comp == null) {
            return;
        }
        Set sets = CtrlSwingUtilities.getManagingFocusBackwardTraversalKeys(comp);
        HashSet treeset = new HashSet(sets);
        treeset.remove(keyStroke);
        comp.setFocusTraversalKeys(1, treeset);
    }

    public static void addTotalDefaultFocusTraversalKeys(int id, KeyStroke keyStroke) {
        if (id != 0 && id != 1) {
            throw new IllegalArgumentException("id must be KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS or KeyboardFocusManager.BACKWARD_TRAVERSAL_KEYS.");
        }
        Set<AWTKeyStroke> set = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
        hashSet.add(keyStroke);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, hashSet);
    }

    public static void resetAppDefaultFocusTraversalKeys() {
        Set set = (Set)UIManager.get("extendforwardkeys");
        Set set1 = (Set)UIManager.get("extendbackwardkeys");
        int id = 0;
        if (set != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, Collections.EMPTY_SET);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, set);
        }
        if (set1 != null) {
            id = 1;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, Collections.EMPTY_SET);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, set1);
        }
    }

    public static void loadAllImages() {
        UIManager.getIcon("kingdee.logo");
        UIManager.getIcon("ArrowButton.initIcon");
        UIManager.getIcon("ArrowButton.activieIcon");
        UIManager.getIcon("ArrowButton.deactivieIcon");
        UIManager.getIcon("ArrowButton.upInitIcon");
        UIManager.getIcon("ArrowButton.upActivieIcon");
        UIManager.getIcon("ArrowButton.upDeactivieIcon");
        UIManager.getIcon("ArrowButton.littleInitIcon");
        UIManager.getIcon("ArrowButton.littleActivieIcon");
        UIManager.getIcon("ArrowButton.littleDeactivieIcon");
        UIManager.getIcon("checkbox.icon");
        UIManager.getIcon("RadioButton.icon");
        UIManager.getIcon("RadioButton.initIcon");
        UIManager.getIcon("RadioButton.clickIcon");
        UIManager.getIcon("RadioButton.disableIcon");
        UIManager.getIcon("RadioButton.selectedIcon");
        UIManager.getIcon("RadioButton.selectedClickIcon");
        UIManager.getIcon("RadioButton.selectedDisableIcon");
        UIManager.getIcon("LittleArrowButton.horiIcon");
        UIManager.getIcon("FileView.directoryIcon");
        UIManager.getIcon("FileView.fileIcon");
        UIManager.getIcon("FileView.computerIcon");
        UIManager.getIcon("FileView.hardDriveIcon");
        UIManager.getIcon("FileView.floppyDriveIcon");
        UIManager.getIcon("FileChooser.detailsViewIcon");
        UIManager.getIcon("FileChooser.homeFolderIcon");
        UIManager.getIcon("FileChooser.listViewIcon");
        UIManager.getIcon("FileChooser.upFolderIcon");
        UIManager.getIcon("InternalFrame.icon");
        UIManager.getIcon("InternalFrame.paletteCloseIcon");
        UIManager.getIcon("InternalFrame.closeIcon");
        UIManager.getIcon("InternalFrame.maximizeIcon");
        UIManager.getIcon("InternalFrame.iconifyIcon");
        UIManager.getIcon("InternalFrame.minimizeIcon");
        UIManager.getIcon("ScrollBar.fillErectback");
        UIManager.getIcon("ScrollBar.fillErectback2");
        UIManager.getIcon("ScrollBar.fillAcrossback");
        UIManager.getIcon("ScrollBar.fillAcrossback2");
        UIManager.getIcon("ScrollBar.topA");
        UIManager.getIcon("ScrollBar.fillErect");
        UIManager.getIcon("ScrollBar.downA");
        UIManager.getIcon("ScrollBar.left3");
        UIManager.getIcon("ScrollBar.fillAcross3");
        UIManager.getIcon("ScrollBar.right3");
        UIManager.getIcon("ScrollBar.left2");
        UIManager.getIcon("ScrollBar.fillAcross2");
        UIManager.getIcon("ScrollBar.right2");
        UIManager.getIcon("ScrollBar.left1");
        UIManager.getIcon("ScrollBar.fillAcross");
        UIManager.getIcon("ScrollBar.right1");
        UIManager.getIcon("ScrollBar.top3");
        UIManager.getIcon("ScrollBar.fillErect3");
        UIManager.getIcon("ScrollBar.down3");
        UIManager.getIcon("ScrollBar.top2");
        UIManager.getIcon("ScrollBar.fillErect2");
        UIManager.getIcon("ScrollBar.down2");
        UIManager.getIcon("ScrollBar.btntop1");
        UIManager.getIcon("ScrollBar.btntop2");
        UIManager.getIcon("ScrollBar.btntop3");
        UIManager.getIcon("ScrollBar.btntop4");
        UIManager.getIcon("ScrollBar.btndown1");
        UIManager.getIcon("ScrollBar.btndown2");
        UIManager.getIcon("ScrollBar.btndown3");
        UIManager.getIcon("ScrollBar.btndown4");
        UIManager.getIcon("ScrollBar.btnleft1");
        UIManager.getIcon("ScrollBar.btnleft2");
        UIManager.getIcon("ScrollBar.btnleft3");
        UIManager.getIcon("ScrollBar.btnleft4");
        UIManager.getIcon("ScrollBar.btnright1");
        UIManager.getIcon("ScrollBar.btnright2");
        UIManager.getIcon("ScrollBar.btnright3");
        UIManager.getIcon("ScrollBar.btnright4");
        UIManager.getIcon("Tab_1.label_fill_3");
        UIManager.getIcon("Tab_1.label_left_more");
        UIManager.getIcon("Tab_1.label_right_more");
        UIManager.getIcon("Tab_1.label_menubutton_1");
        UIManager.getIcon("Tab_1.label_menubutton_2");
        UIManager.getIcon("Tab_1.label_menubutton_3");
        UIManager.getIcon("Tab_1.label_closebutton_1");
        UIManager.getIcon("Tab_1.label_closebutton_2");
        UIManager.getIcon("Tab_1.label_closebutton_3");
        UIManager.getIcon("Tab_1.label_leftbutton_1");
        UIManager.getIcon("Tab_1.label_leftbutton_2");
        UIManager.getIcon("Tab_1.label_leftbutton_3");
        UIManager.getIcon("Tab_1.label_leftbutton_forbit");
        UIManager.getIcon("Tab_1.label_rightbutton_1");
        UIManager.getIcon("Tab_1.label_rightbutton_2");
        UIManager.getIcon("Tab_1.label_rightbutton_3");
        UIManager.getIcon("Tab_1.label_rightbutton_3");
        UIManager.getIcon("Tab_1.label_rightbutton_3");
        UIManager.getIcon("Tab_1.label_rightbutton_3");
        UIManager.getIcon("Tab_1.label_right_1");
        UIManager.getIcon("Tab_1.label_left_2");
        UIManager.getIcon("Tab_1.label_fill_2");
        UIManager.getIcon("Tab_1.label_right_2");
        UIManager.getIcon("Tab_1.label_closebutton_forbit");
        UIManager.getIcon("Tab_2.2label_left");
        UIManager.getIcon("Tab_2.2label_fill_3");
        UIManager.getIcon("Tab_2.2label_right");
        UIManager.getIcon("Tab_2.2label_left_more");
        UIManager.getIcon("Tab_2.2label_right_more");
        UIManager.getIcon("Tab_2.2label_menubutton_1");
        UIManager.getIcon("Tab_2.2label_menubutton_2");
        UIManager.getIcon("Tab_2.2label_menubutton_3");
        UIManager.getIcon("Tab_2.2label_leftbutton_1");
        UIManager.getIcon("Tab_2.2label_leftbutton_2");
        UIManager.getIcon("Tab_2.2label_leftbutton_3");
        UIManager.getIcon("Tab_2.2label_leftbutton_forbit");
        UIManager.getIcon("Tab_2.2label_rightbutton_1");
        UIManager.getIcon("Tab_2.2label_rightbutton_2");
        UIManager.getIcon("Tab_2.2label_rightbutton_3");
        UIManager.getIcon("Tab_2.2label_rightbutton_forbit");
        UIManager.getIcon("Tab_2.2label_left_1");
        UIManager.getIcon("Tab_2.2label_fill_1");
        UIManager.getIcon("Tab_2.2label_right_1");
        UIManager.getIcon("Tab_2.2label_left_2");
        UIManager.getIcon("Tab_2.2label_fill_2");
        UIManager.getIcon("Tab_2.2label_right_2");
        UIManager.getIcon("Menu.checkIcon");
        UIManager.getIcon("Menu.arrowIcon");
        UIManager.getIcon("MenuItem.checkIcon");
        UIManager.getIcon("MenuItem.arrowIcon");
        UIManager.getIcon("OptionPane.errorIcon");
        UIManager.getIcon("OptionPane.informationIcon");
        UIManager.getIcon("OptionPane.warningIcon");
        UIManager.getIcon("OptionPane.questionIcon");
        UIManager.getIcon("CheckBoxMenuItem.checkIcon");
        UIManager.getIcon("CheckBoxMenuItem.arrowIcon");
        UIManager.getIcon("RadioButtonMenuItem.checkIcon");
        UIManager.getIcon("RadioButtonMenuItem.arrowIcon");
        UIManager.getIcon("Tree.openIcon");
        UIManager.getIcon("Tree.closedIcon");
        UIManager.getIcon("Tree.leafIcon");
        UIManager.getIcon("Tree.expandedIcon");
        UIManager.getIcon("Tree.collapsedIcon");
        UIManager.getIcon("Tree.treeTitlePic");
        UIManager.getIcon("Tree.treeTitleBg");
        UIManager.getIcon("Tree.tbtn_open_menu");
        UIManager.getIcon("Tree.tbtn_close_menu");
        UIManager.getIcon("Tree.tbtn_openlowerlever_menu");
        UIManager.getIcon("Tree.tbtn_allopen_menu");
        UIManager.getIcon("Tree.tbtn_allclose_menu");
        UIManager.getIcon("Tree.horizontalLineIcon");
        UIManager.getIcon("Tree.verticalLineIcon");
        UIManager.getIcon("DatePicker.initIcon");
        UIManager.getIcon("DatePicker.activeIcon");
        UIManager.getIcon("DatePickerDownList.currentDateIcon");
        UIManager.getIcon("DatePickerDownList.pichonIcon");
        UIManager.getIcon("KDContainer.openIcon");
        UIManager.getIcon("KDContainer.closeIcon");
        UIManager.getIcon("KDContainer.forbitIcon");
        UIManager.getIcon("KDContainer.upOpenIcon");
        UIManager.getIcon("WorkCalendar.yearMonthIcon");
        UIManager.getIcon("WorkCalendar.buttonIcon");
        UIManager.getIcon("WorkCalendar.upArrowIcon");
        UIManager.getIcon("WorkCalendar.downArrowIcon");
        UIManager.getIcon("Calculator.calculatorIcon");
        UIManager.getIcon("Calculator.calculatorDisableIcon");
        UIManager.getIcon("Frame.Icon");
        UIManager.getIcon("ImageArrowButton.northIcon");
        UIManager.getIcon("ImageArrowButton.southIcon");
        UIManager.getIcon("ImageArrowButton.westIcon");
        UIManager.getIcon("ImageArrowButton.disableNorthIcon");
        UIManager.getIcon("ImageArrowButton.disableSouthIcon");
        UIManager.getIcon("eas.searchbox.icon1");
        UIManager.getIcon("eas.searchbox.icon2");
        UIManager.getIcon("eas.searchbox.icon3");
        UIManager.getIcon("eas.statusbar.inf");
        UIManager.getIcon("eas.statusbar.msg.static");
        UIManager.getIcon("eas.statusbar.msg.dynamic");
        UIManager.getIcon("eas.statusbar.help");
        UIManager.getIcon("eas.infopanel.close.init");
        UIManager.getIcon("eas.infopanel.close.mouseover");
        UIManager.getIcon("eas.infopanel.close.click");
    }

    public static void appendActionToComponent(JComponent target, int condition, KeyStroke keyStroke, String oprtStr, Action action) {
        if (target == null || keyStroke == null || action == null) {
            throw new NullPointerException("target or keyStroke or action don't is null .");
        }
        InputMap inputMap = target.getInputMap(condition);
        ActionMap actionMap = target.getActionMap();
        String pOprtStr = (String)inputMap.get(keyStroke);
        if (pOprtStr != null) {
            inputMap.remove(keyStroke);
            actionMap.remove(pOprtStr);
        }
        inputMap.put(keyStroke, oprtStr);
        actionMap.put(oprtStr, action);
    }

    public static void removeActionToComponent(JComponent target, int condition, KeyStroke keyStroke) {
        if (target == null || keyStroke == null) {
            throw new NullPointerException("target or keyStroke or action don't is null .");
        }
        InputMap inputMap = target.getInputMap(condition);
        ActionMap actionMap = target.getActionMap();
        String pOprtStr = (String)inputMap.get(keyStroke);
        if (pOprtStr != null) {
            inputMap.remove(keyStroke);
            actionMap.remove(pOprtStr);
        }
    }

    public static void clearMenuKeyboardHelper() {
        Field field = null;
        try {
            field = BasicPopupMenuUI.class.getDeclaredField("menuKeyboardHelper");
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field != null) {
            field.setAccessible(true);
            try {
                Object menuKeyboardHelper = field.get(null);
                try {
                    field = menuKeyboardHelper.getClass().getDeclaredField("menuInputMap");
                    field.setAccessible(true);
                    field.set(menuKeyboardHelper, null);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void checkFocusAndCommit() throws ParseException {
        Component compCommit = null;
        for (Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof KDPromptBox) && !(comp instanceof JFormattedTextField) && !(comp instanceof KDDatePicker) && !(comp instanceof KDSpinner)) continue;
            compCommit = comp;
        }
        if (compCommit != null) {
            if (compCommit instanceof KDPromptBox) {
                KDPromptBox pb = (KDPromptBox)compCommit;
                try {
                    if (pb.isDirty() && !pb.isHasCommitEdit()) {
                        pb.commitEdit();
                    }
                }
                catch (ParseException e1) {
                    pb.setText("");
                    pb.setData(null);
                    pb.setLabelText("");
                }
            } else if (compCommit instanceof JFormattedTextField) {
                ((JFormattedTextField)compCommit).commitEdit();
            } else if (compCommit instanceof KDDatePicker) {
                ((KDDatePicker)compCommit).commitEdit();
                ((KDDatePicker)compCommit).getEditor().hideInfoTip();
            } else if (compCommit instanceof KDSpinner) {
                ((KDSpinner)compCommit).commitEdit();
            }
        }
    }

    public static KDLabelContainer createLabelContainer(JComponent ctrl, String text, int labelWidth) {
        KDLabelContainer lc = new KDLabelContainer(ctrl);
        lc.setBoundLabelText(text);
        lc.setBoundLabelLength(labelWidth);
        lc.setBoundLabelUnderline(true);
        return lc;
    }

    public static String bigDecimalToPlainString(BigDecimal number) {
        if (flag == 0) {
            Class<?> cls = number.getClass();
            try {
                method = cls.getMethod("toPlainString", null);
            }
            catch (SecurityException e) {
                method = null;
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
            ++flag;
        }
        if (method != null) {
            try {
                return (String)method.invoke((Object)number, null);
            }
            catch (IllegalArgumentException e) {
                return number.toString();
            }
            catch (IllegalAccessException e) {
                return number.toString();
            }
            catch (InvocationTargetException e) {
                return number.toString();
            }
        }
        return number.toString();
    }

    public static void setConvertType(int conver) {
        converType = conver;
    }

    public static int getConvertType() {
        return converType;
    }

    public static void projectToScreenSurface(Component comp, Container refSys) {
        Window w = SwingUtilities.getWindowAncestor(refSys);
        if (!(w instanceof RootPaneContainer)) {
            return;
        }
        JRootPane rootPane = ((RootPaneContainer)((Object)w)).getRootPane();
        if (!(rootPane instanceof KDSkinRootPane)) {
            return;
        }
        KDSkinRootPane kdskinRootPane = (KDSkinRootPane)rootPane;
        Point p = comp.getLocation();
        p = SwingUtilities.convertPoint(refSys, p, kdskinRootPane);
        if (comp.getParent() == null) {
            kdskinRootPane.getLayeredPane().add(comp);
        }
        comp.setBounds(p.x, p.y, comp.getWidth(), comp.getHeight());
    }

    public static Image readImgFromFile(String sFile, short time) {
        if (sFile == null || !new File(sFile).exists()) {
            return null;
        }
        File img = new File(sFile);
        Image awtImg = null;
        try {
            if (sFile.substring(sFile.length() - 4).equalsIgnoreCase(".gif")) {
                ImageReader irImgRead = ImageIO.getImageReadersByFormatName("gif").next();
                irImgRead.setInput(ImageIO.createImageInputStream(img));
                GIFImageMetadata metadatazero = (GIFImageMetadata)irImgRead.getImageMetadata(0);
                if (metadatazero.delayTime != 0) {
                    awtImg = Toolkit.getDefaultToolkit().createImage(img.getAbsolutePath());
                } else {
                    irImgRead.setInput(ImageIO.createImageInputStream(img));
                    ImageWriter iwImgWrit = ImageIO.getImageWriter(irImgRead);
                    ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
                    ImageOutputStream ios = ImageIO.createImageOutputStream(baoStream);
                    iwImgWrit.setOutput(ios);
                    iwImgWrit.prepareWriteSequence(null);
                    for (int i = 0; i < irImgRead.getNumImages(true); ++i) {
                        BufferedImage src = irImgRead.read(i);
                        IIOMetadata metadata = iwImgWrit.getDefaultImageMetadata(new ImageTypeSpecifier(src), null);
                        IIOMetadataNode root = (IIOMetadataNode)irImgRead.getImageMetadata(i).getAsTree("javax_imageio_gif_image_1.0");
                        NodeList children = root.getChildNodes();
                        for (int j = 0; j < children.getLength(); ++j) {
                            if (!children.item(j).getNodeName().equals("GraphicControlExtension")) continue;
                            IIOMetadataNode gce = (IIOMetadataNode)children.item(j);
                            gce.setAttribute("delayTime", Short.toString(time));
                            break;
                        }
                        metadata.setFromTree(metadata.getNativeMetadataFormatName(), root);
                        IIOImage ii = new IIOImage(src, null, metadata);
                        iwImgWrit.writeToSequence(ii, iwImgWrit.getDefaultWriteParam());
                    }
                    iwImgWrit.endWriteSequence();
                    ios.close();
                    awtImg = Toolkit.getDefaultToolkit().createImage(baoStream.toByteArray());
                }
            } else {
                awtImg = ImageIO.read(ImageIO.createImageInputStream(img));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return awtImg;
    }

    public static Image readImgFromFile2(File sFile, short time, File saveFile) {
        if (sFile == null || !sFile.exists()) {
            return null;
        }
        Image awtImg = null;
        try {
            String path = sFile.getAbsolutePath();
            if (path.substring(path.length() - 4).equalsIgnoreCase(".gif")) {
                ImageInputStream gifInputStream = ImageIO.createImageInputStream(sFile);
                awtImg = CtrlSwingUtilities.setFrameForGif(gifInputStream, time, saveFile);
                if (awtImg == null) {
                    awtImg = Toolkit.getDefaultToolkit().createImage(path);
                }
            } else {
                awtImg = ImageIO.read(ImageIO.createImageInputStream(sFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return awtImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image setFrameForGif(ImageInputStream gifInputStream, short time, File saveFile) {
        int BlockSize = 65536;
        Image image = null;
        ImageOutputStream outputStream = null;
        File tempFile = null;
        try {
            tempFile = saveFile != null && saveFile.exists() ? saveFile : File.createTempFile("Temp", ".gif");
            outputStream = ImageIO.createImageOutputStream(tempFile);
            outputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            gifInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            boolean isOver = false;
            long offset = 0L;
            long t = System.currentTimeMillis();
            long length = gifInputStream.length();
            int size = 0;
            do {
                byte[] b = null;
                if (offset + (long)BlockSize > length) {
                    size = (int)(length - offset);
                    isOver = true;
                } else {
                    size = BlockSize;
                }
                b = new byte[size];
                gifInputStream.read(b, 0, size);
                offset += (long)BlockSize;
                boolean isFirstSign = false;
                boolean isSign = false;
                for (int i = 0; i < size; ++i) {
                    if (isFirstSign) {
                        if (b[i] == -7) {
                            isSign = true;
                        } else {
                            isFirstSign = false;
                        }
                    }
                    if (b[i] == 33) {
                        isFirstSign = true;
                    }
                    if (!isSign) continue;
                    if (i > size - 4) {
                        outputStream.write(b, 0, size - 4);
                        gifInputStream.seek(offset -= 4L);
                        break;
                    }
                    if (b[i + 3] == 0 && b[i + 4] == 0) {
                        b[i + 3] = (byte)(time >>> 0 & 0xFF);
                        b[i + 4] = (byte)(time >>> 8 & 0xFF);
                    }
                    isFirstSign = false;
                    isSign = false;
                }
                outputStream.write(b, 0, size);
            } while (!isOver);
            System.out.println("gif\u56fe\u7247\u6539\u53d8\u5e27\u9891\u4f7f\u7528\u65f6\u95f4\uff1a");
            System.out.print(System.currentTimeMillis() - t);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != gifInputStream) {
                    gifInputStream.close();
                }
                if (null != outputStream) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        image = Toolkit.getDefaultToolkit().createImage(tempFile.getAbsolutePath());
        MediaTracker tracker = new MediaTracker(new JPanel());
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return image;
    }

    public static void makeAlignBounds(boolean isHorizontal, boolean isVertical, Component own) {
        Rectangle rc = new Rectangle(own.getBounds());
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        int x = 0;
        int y = 0;
        int width = sz.width;
        int height = sz.height;
        if (isHorizontal) {
            rc.x = x + (width - rc.width) / 2;
            if (rc.x < 0) {
                rc.x = 0;
            }
        }
        if (isVertical) {
            rc.y = y + (height - rc.height) / 2;
            if (rc.y < 0) {
                rc.y = 0;
            }
        }
        own.setBounds(rc);
    }

    static {
        converType = 2;
    }
}

