/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.persist;

import com.kingdee.bos.ctrl.workbench.persist.Trinity;
import com.kingdee.bos.ctrl.workbench.ui.ITrimView;
import com.kingdee.bos.ctrl.workbench.ui.ITrimWidget;
import com.kingdee.bos.ctrl.workbench.ui.TrimWidgetViewport;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

class TrimWidgetDescriptor
extends HashMap {
    private ArrayList trinities = new ArrayList();
    private String trimId;
    private String trimClsName;
    private String category;
    private String trimTitle;
    private URL trimIconURL;
    private static final boolean DEBUG = false;

    TrimWidgetDescriptor(ITrimWidget trimWidget) {
        this.trimId = trimWidget.getId();
        this.trimClsName = trimWidget.getClass().getName();
        String title = trimWidget.getTitle();
        URL url = trimWidget.getIconURL();
        boolean closeable = trimWidget.isCloseable();
        String category = trimWidget.getCategory();
        this.trimTitle = title;
        this.trimIconURL = url;
        this.category = category;
        this.addTrinity(new Trinity(16, "Id", this.trimId));
        this.addTrinity(new Trinity(16, "Title", title));
        if (url != null) {
            this.addTrinity(new Trinity(15, "IconURL", url.toString()));
        }
        this.addTrinity(new Trinity(1, "Closeable", new Boolean(closeable).toString()));
        this.addTrinity(new Trinity(16, "Category", category));
        if (trimWidget instanceof TrimWidgetViewport) {
            String viewClsName = ((TrimWidgetViewport)trimWidget).getView().getClass().getName();
            this.addTrinity(new Trinity(17, "View", viewClsName));
        }
    }

    TrimWidgetDescriptor(String trimId, String trimClsName) {
        this.trimId = trimId;
        this.trimClsName = trimClsName;
    }

    void addTrinity(Trinity trinity) {
        if ("Title".equals(trinity.key)) {
            this.trimTitle = trinity.value;
        } else if ("Category".equals(trinity.key)) {
            this.category = trinity.value;
        } else if ("IconURL".equals(trinity.key)) {
            try {
                this.trimIconURL = new URL(trinity.value);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.trinities.add(trinity);
    }

    String getId() {
        return this.trimId;
    }

    String getTitle() {
        return this.trimTitle;
    }

    URL getIconURL() {
        return this.trimIconURL;
    }

    String getCategory() {
        return this.category;
    }

    public ITrimWidget toTrimWidget() {
        ITrimWidget trim;
        long t1 = System.currentTimeMillis();
        try {
            trim = (ITrimWidget)Class.forName(this.trimClsName).newInstance();
        }
        catch (Exception e) {
            return null;
        }
        for (Trinity trinity : this.trinities) {
            try {
                String key = trinity.getKey();
                Method m = "View".equals(key) ? trim.getClass().getMethod("set" + key, ITrimView.class) : trim.getClass().getMethod("set" + key, trinity.getType());
                m.invoke((Object)trim, trinity.getValue());
            }
            catch (Exception exception) {}
        }
        return trim;
    }

    public Element toXmlElement() {
        Element trimNode = new Element("trim");
        trimNode.setAttribute(new Attribute("id", this.trimId));
        trimNode.setAttribute(new Attribute("clsName", this.trimClsName));
        Iterator iterator = this.trinities.iterator();
        while (iterator.hasNext()) {
            Element trinityEle = new Element("trinity");
            trimNode.addContent((Content)trinityEle);
            Trinity trinity = (Trinity)iterator.next();
            trinityEle.addContent((Content)new Element("type").setText("" + trinity.type));
            trinityEle.addContent((Content)new Element("key").setText(trinity.key));
            trinityEle.addContent((Content)new Element("value").setText(trinity.value));
        }
        return trimNode;
    }
}

