/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.splash;

import com.kingdee.bos.ctrl.workbench.splash.StartDialog;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

public class SplashScreen {
    private StartDialog dialog = new StartDialog(1, 100, 1);
    private Object delegate;
    private Rectangle splashBounds;
    private Graphics2D splashGraphics;

    private SplashScreen() {
    }

    public static SplashScreen getInstance() {
        return new SplashScreen();
    }

    public static SplashScreen getInstance(boolean overOneDotFive) {
        SplashScreen s = new SplashScreen();
        if (overOneDotFive) {
            try {
                Class<?> c = Class.forName("java.awt.SplashScreen");
                Method m = c.getMethod("getSplashScreen", null);
                Object obj = m.invoke(c, null);
                if (obj == null) {
                    return s;
                }
                s.delegate = obj;
                m = obj.getClass().getDeclaredMethod("getBounds", null);
                s.splashBounds = (Rectangle)m.invoke(obj, null);
                m = obj.getClass().getDeclaredMethod("createGraphics", null);
                s.splashGraphics = (Graphics2D)m.invoke(obj, null);
                s.splashGraphics.setColor(Color.YELLOW);
                s.splashGraphics.drawRect(0, 0, s.splashBounds.width - 1, s.splashBounds.height - 1);
                s.setStatus("", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private void updateSplash(String status, int progress) {
        if (this.delegate == null) {
            return;
        }
        if (this.splashGraphics == null) {
            return;
        }
        this.drawSplash(this.splashGraphics, status, progress);
        try {
            Method m = this.delegate.getClass().getDeclaredMethod("update", null);
            m.invoke(this.delegate, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawSplash(Graphics2D splashGraphics, String status, int progress) {
        int barWidth = this.splashBounds.width * 50 / 100;
        splashGraphics.setComposite(AlphaComposite.Clear);
        splashGraphics.fillRect(1, 10, this.splashBounds.width - 2, 20);
        splashGraphics.setPaintMode();
        splashGraphics.setColor(Color.BLACK);
        splashGraphics.drawString(status, 10, 20);
        splashGraphics.setColor(Color.BLACK);
        splashGraphics.drawRect(10, 25, barWidth + 2, 10);
        splashGraphics.setColor(Color.YELLOW);
        int width = progress * barWidth / 100;
        splashGraphics.fillRect(11, 26, width + 1, 9);
        splashGraphics.setColor(Color.WHITE);
        splashGraphics.fillRect(11 + width + 1, 26, barWidth - width, 9);
        Color c = splashGraphics.getColor();
        if (status != null) {
            splashGraphics.setColor(Color.white);
            splashGraphics.drawString(status, 400, 300);
        }
        splashGraphics.drawString("(c)\u672c\u8f6f\u4ef6\u7248\u6743\u53ca\u6700\u7ec8\u89e3\u91ca\u6743\u7531\u91d1\u8776\u8f6f\u4ef6\u516c\u53f8(\u4e2d\u56fd)\u6240\u6709", 20, 320);
        Font f = splashGraphics.getFont();
        splashGraphics.setFont(new Font(null, 3, 25));
        splashGraphics.drawString("\u91d1 \u8776 \u6269 \u5c55 \u62a5 \u8868", 80, 200);
        splashGraphics.setFont(f);
        splashGraphics.setColor(c);
    }

    public void setStatus(String message, int progress) {
        if (this.delegate == null) {
            this.dialog.imagePanel.message = message;
            int value = this.dialog.progress.getValue();
            if (progress == 0) {
                value += 5;
            }
            this.dialog.progress.setValue(progress > value ? progress : value);
            this.repaintChildren();
            if (progress == 100) {
                try {
                    Thread.sleep(500L);
                    this.hide();
                }
                catch (Exception exception) {}
            }
        } else {
            this.updateSplash(message == null ? "" : message, progress);
        }
    }

    public void show() {
        if (this.delegate == null) {
            this.dialog.showDialog();
        }
    }

    public void hide() {
        if (this.delegate == null) {
            this.dialog.hideDialog();
        } else {
            try {
                Method m = this.delegate.getClass().getDeclaredMethod("close", null);
                m.invoke(this.delegate, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        if (this.delegate == null) {
            this.dialog.dispose();
        } else {
            try {
                Method m = this.delegate.getClass().getDeclaredMethod("close", null);
                m.invoke(this.delegate, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void repaintChildren() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.dialog.repaint();
            }
        });
    }
}

