/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IServiceHandlerFacade;
import com.kingdee.eas.framework.ServiceHandlerFacade;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.batchaction.IBatchExecutor;
import com.kingdee.eas.framework.batchaction.app.MultiObjectsLockHelper;
import com.kingdee.eas.framework.batchaction.service.AllInWFException;
import com.kingdee.eas.framework.batchaction.service.BatchExecuteParams;
import com.kingdee.eas.framework.batchaction.util.ResourceUtils;
import com.kingdee.util.BaseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BatchExecutor
extends AbstractBOSObject
implements IBatchExecutor {
    static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"EXECUTOR");
    private static final HashSet moveActionSet = new HashSet(4);

    public BatchExecutor() {
        this.registerInterface(IBatchExecutor.class, this);
    }

    public BatchExecutor(Context ctx) {
        super(ctx);
        this.registerInterface(IBatchExecutor.class, this);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchExecuteResult execute(BatchExecuteParams params) throws BOSException, EASBizException {
        BatchExecuteResult batchExecuteResult;
        block12: {
            boolean shouldNotRequestLocks;
            List lockList;
            block10: {
                BatchExecuteResult batchExecuteResult2;
                block11: {
                    BatchExecuteParamsEntry[] toDoParams;
                    List toLockList;
                    BatchExecuteResult result;
                    List toDoList;
                    block8: {
                        BatchExecuteResult batchExecuteResult3;
                        block9: {
                            lockList = null;
                            toDoList = params.getBatchEntries().getToDoIdList();
                            if ((params.getBatchAction().equals(BatchActionEnum.AUDIT) || params.getBatchAction().equals(BatchActionEnum.ENTRYAUDIT)) && this.isAllInWFWhenAudit(toDoList)) {
                                throw new AllInWFException(null);
                            }
                            this.checkExists(params);
                            BatchActionEnum batchAction = params.getBatchAction();
                            shouldNotRequestLocks = params.getContextType().equals((Object)ContextTypeEnum.INMAINTAINING) && (BatchActionEnum.SAVE.equals(batchAction) || BatchActionEnum.SUBMIT.equals(batchAction));
                            try {
                                result = null;
                                toLockList = params.getBatchEntries().getToDoHeadIdList();
                                lockList = shouldNotRequestLocks ? toLockList : MultiObjectsLockHelper.requestLocks(this.getContext(), toLockList, params.getBatchEntries().getEntries());
                                if (!moveActionSet.contains(params.getBatchAction())) break block8;
                                batchExecuteResult3 = this.processMoving(params);
                                if (shouldNotRequestLocks) break block9;
                            }
                            catch (Throwable throwable) {
                                if (!shouldNotRequestLocks) {
                                    MultiObjectsLockHelper.releaseLocks(this.getContext(), lockList);
                                }
                                throw throwable;
                            }
                            MultiObjectsLockHelper.releaseLocks(this.getContext(), lockList);
                        }
                        return batchExecuteResult3;
                    }
                    if (lockList == null || lockList.size() <= 0 || (toDoParams = this.processParams(params)).length <= 0) break block10;
                    try {
                        result = params.getBizInterface(this.getContext()).batchExecute(params.getName(), params.getParamTypes(), toDoParams);
                    }
                    catch (BaseException e) {
                        result = new BatchExecuteResult(toDoParams.length);
                        result.setException(0, (Throwable)e);
                    }
                    batchExecuteResult2 = this.processResult(toLockList, lockList, result, params, toDoList);
                    if (shouldNotRequestLocks) break block11;
                    MultiObjectsLockHelper.releaseLocks(this.getContext(), lockList);
                }
                return batchExecuteResult2;
            }
            batchExecuteResult = this.processResult(params);
            if (shouldNotRequestLocks) break block12;
            MultiObjectsLockHelper.releaseLocks(this.getContext(), lockList);
        }
        return batchExecuteResult;
    }

    private BatchExecuteResult processMoving(BatchExecuteParams params) {
        BatchExecuteResult realResult = new BatchExecuteResult(1);
        BatchActionResults batchResults = new BatchActionResults();
        batchResults.addSuccess(params.getMoveToId());
        try {
            this.executeHandler(batchResults, params);
        }
        catch (BaseException e) {
            realResult.setException(0, (Throwable)e);
        }
        realResult.setBatchResult((Object)batchResults);
        return realResult;
    }

    private boolean isAllInWFWhenAudit(List toDoList) throws BOSException {
        String[] ids = new String[toDoList.size()];
        toDoList.toArray(ids);
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.getContext());
        String[] wfIds = service.checkBizObjInWfProcess(ids);
        return wfIds != null && wfIds.length == ids.length;
    }

    private BatchExecuteParamsEntry[] processParams(BatchExecuteParams batchParams) {
        List params = batchParams.getParams();
        List toDoList = batchParams.getBatchEntries().getToDoIdList();
        ArrayList<BatchExecuteParamsEntry> toDoParams = new ArrayList<BatchExecuteParamsEntry>(toDoList.size());
        for (BatchExecuteParamsEntry entry : params) {
            toDoParams.add(entry);
        }
        return toDoParams.toArray(new BatchExecuteParamsEntry[0]);
    }

    private BatchExecuteResult processResult(List toLockList, List lockList, BatchExecuteResult result, BatchExecuteParams params, List toDoList) throws BOSException {
        int size = params.getBatchEntries().size();
        BatchExecuteResult realResult = result != null && size == result.size() ? result : new BatchExecuteResult(size);
        BatchSelectionEntries entries = params.getBatchEntries();
        boolean isHead = entries.isHead();
        int realIdx = 0;
        int resultIdx = 0;
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = entries.get(idxOfEntry);
            String headId = entry.getId();
            String id = isHead ? entry.getId() : entry.getEntryId();
            int idx = toDoList.indexOf(id);
            if (idx < 0) continue;
            int idxLock = lockList.indexOf(headId);
            if (idxLock >= 0) {
                realResult.setReturnValue(realIdx, result.getReturnValue(resultIdx));
                realResult.setException(realIdx, result.getException(resultIdx));
                ++resultIdx;
                ++realIdx;
                continue;
            }
            if (entry.getActionResult().getException() != null) {
                realResult.setException(realIdx, (Throwable)entry.getActionResult().getException());
                ++realIdx;
                continue;
            }
            if (!entry.getResult().equals(ActionResultEnum.ERROR) || entry.getResultMsg() == null) continue;
            realResult.setException(idxOfEntry, (Throwable)((Object)new ActionCommonException(null, entry.getResultMsg())));
        }
        BatchActionResults batchResults = (BatchActionResults)realResult.getBatchResult();
        if (batchResults == null) {
            batchResults = params.getContextType().equals((Object)ContextTypeEnum.INMAINTAINING) && (params.getBatchAction().equals(BatchActionEnum.SAVE) || params.getBatchAction().equals(BatchActionEnum.SUBMIT)) ? (result.getReturnValues() != null && result.getReturnValues().length > 0 && result.getReturnValues()[0] == null && size == result.getReturnValues().length ? BatchActionResults.populateActionResults(params.getBatchEntries().getIdArray()) : BatchActionResults.populateActionResults(result.getReturnValues())) : BatchActionResults.populateActionResults(params.getBatchEntries().getIdArray());
        }
        int countSuccess = BatchActionUtil.resolveActionResults(batchResults, realResult, params.getBatchEntries().getEntries(), toDoList, params.getBatchAction().getActionLevel());
        realResult.setBatchResult(result.getBatchResult());
        if (countSuccess > 0) {
            try {
                this.executeHandler(batchResults, params);
            }
            catch (BaseException e) {
                realResult.setException(0, (Throwable)e);
            }
            realResult.setBatchResult((Object)batchResults);
        }
        return realResult;
    }

    private void executeHandler(BatchActionResults batchResults, BatchExecuteParams params) throws BaseException {
        String[] ids;
        IServiceHandlerFacade handler = null;
        RequestContext request = params.getRequestContext();
        if (request == null) {
            return;
        }
        if (params.getContextType().equals((Object)ContextTypeEnum.INMAINTAINING) && (params.getBatchAction().equals(BatchActionEnum.SAVE) || params.getBatchAction().equals(BatchActionEnum.SUBMIT)) && (ids = batchResults.getToDoIdsArray()).length == 1 && !ids[0].equals("NEWID")) {
            request.put("_BATCHSUBMITID", (Object)new ObjectUuidPK(BOSUuid.read((String)ids[0])));
            request.put("BATCH_ACTION", (Object)params.getBatchAction());
            if (params.getBatchAction().equals(BatchActionEnum.SAVE) || !request.isSubmitAddNew()) {
                request.setState("EDIT");
            }
        }
        if (params.getBatchAction().equals(BatchActionEnum.AUDIT) || params.getBatchAction().equals(BatchActionEnum.UNAUDIT) || params.getBatchAction().equals(BatchActionEnum.SUBMIT)) {
            request.put("BATCH_ACTION", (Object)params.getBatchAction());
        }
        if (params.getMoveToId() != null) {
            request.setOldId(params.getMoveFromId());
            request.setNewId(params.getMoveToId());
            request.setMethodName("handleActionNext");
        }
        handler = (IServiceHandlerFacade)BOSObjectFactory.createBOSObject((Context)this.getContext(), (String)ServiceHandlerFacade.class.getName());
        ResponseContext response = (ResponseContext)handler.Execute((Object)this.initParameter(request));
        batchResults.setResponse(response);
    }

    private RequestContext initParameter(RequestContext request) {
        if (request == null) {
            request = new RequestContext();
        }
        request.setItemActionHandler("com.kingdee.eas.framework.app.ItemActionUIHandler");
        request.setItemAction("actionPerformed");
        if (request.get("Fw_MethodName") == null) {
            request.put("Fw_MethodName", (Object)"handleInit");
        }
        request.put("ActionOnLoad", (Object)"ActionOnLoad");
        return request;
    }

    private void checkExists(BatchExecuteParams params) throws BOSException, EASBizException {
        Object[] ids = params.getBatchEntries().getToDoIdArray();
        if (ids.length == 0 || "NEWID".equals(ids[0])) {
            return;
        }
        if (params.getBatchAction().equals(BatchActionEnum.SAVE) || params.getBatchAction().equals(BatchActionEnum.SUBMIT)) {
            return;
        }
        ICoreBase icorebase = (ICoreBase)params.getBizInterface(this.getContext());
        String oql = "where id in (" + BatchExecutor.getKeyIdList(ids) + ")";
        IObjectPK[] pkList = icorebase.getPKList(oql);
        boolean isHead = params.getBatchAction().getActionLevel().equals(ActionLevelEnum.HEAD);
        if (ids.length > pkList.length) {
            HashSet<String> idSet = new HashSet<String>(pkList.length);
            for (int i = 0; i < pkList.length; ++i) {
                idSet.add(pkList[i].toString());
            }
            int size = params.getBatchEntries().size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                BatchSelectionEntry entry = params.getBatchEntries().get(idxOfEntry);
                if (idSet.contains(isHead ? entry.getId() : entry.getEntryId())) continue;
                entry.setActionResult(new ActionResult(ActionResultEnum.ERROR, ResourceUtils.getMessage(this.getContext(), "com.kingdee.eas.framework.BatchActionResource", "BILL_NOT_FOUND")));
            }
        }
    }

    private BatchExecuteResult processResult(BatchExecuteParams params) {
        BatchExecuteResult realResult = null;
        int size = params.getBatchEntries().size();
        realResult = new BatchExecuteResult(size);
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = params.getBatchEntries().get(idxOfEntry);
            if (entry.getResult().equals(ActionResultEnum.SUCCESS)) continue;
            ActionResult result = entry.getActionResult();
            if (result.getException() != null) {
                realResult.setException(idxOfEntry, (Throwable)result.getException());
                continue;
            }
            if (entry.getResultMsg() == null) continue;
            realResult.setException(idxOfEntry, (Throwable)((Object)new ActionCommonException(null, entry.getResultMsg())));
        }
        return realResult;
    }

    public static String getKeyIdList(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(ids[i]);
            sb.append("'");
        }
        return sb.toString();
    }

    static {
        moveActionSet.add(BatchActionEnum.FIRST);
        moveActionSet.add(BatchActionEnum.PREVIOUS);
        moveActionSet.add(BatchActionEnum.NEXT);
        moveActionSet.add(BatchActionEnum.LAST);
    }
}

