/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.batchaction.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class MultiObjectsLockHelper {
    private static final String LOCKFAILED = "ERROR_MUTEX";
    public static ActionCommonException MUTEXEXCEPTION;

    private static ActionCommonException getMutexException(Context ctx) {
        if (MUTEXEXCEPTION == null) {
            MUTEXEXCEPTION = new ActionCommonException(null, ResourceUtils.getMessage(ctx, "com.kingdee.eas.framework.BatchActionResource", LOCKFAILED));
        }
        return MUTEXEXCEPTION;
    }

    public static List requestLocks(Context ctx, List toLockList, List selectionEntry) throws BOSException {
        if (toLockList == null || toLockList.size() == 0) {
            return null;
        }
        Map map = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(toLockList);
        return MultiObjectsLockHelper.processLockResults(ctx, selectionEntry, map);
    }

    public static void releaseLocks(Context ctx, List lockList) throws BOSException {
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockList);
        }
    }

    private static List processLockResults(Context ctx, List selectionEntry, Map lockMap) {
        ArrayList<String> lockList = new ArrayList<String>(selectionEntry.size());
        int size = selectionEntry.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
            if (!lockMap.containsKey(entry.getId())) continue;
            if (!((Boolean)lockMap.get(entry.getId())).booleanValue()) {
                entry.setActionResult(new ActionResult(ActionResultEnum.ERROR, (Exception)((Object)MultiObjectsLockHelper.getMutexException(ctx))));
                continue;
            }
            lockList.add(entry.getId());
        }
        return lockList;
    }
}

