/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction.service;

import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.batchaction.service.ActionProxy;
import com.kingdee.eas.framework.batchaction.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiObjectsLockHelper {
    private static MultiObjectsLockHelper lockHelper = new MultiObjectsLockHelper();
    private static final String LOCKFAILED = "ERROR_MUTEX";

    private MultiObjectsLockHelper() {
    }

    public static MultiObjectsLockHelper getInstance() {
        return lockHelper;
    }

    public List requestLocks(ActionProxy actionProxy, List selectionEntry) {
        Map map = MutexServiceControlFactory.getRemoteInstance().batchRequestObjIDForUpdate(this.getToLockList(actionProxy, selectionEntry));
        return this.processLockResults(selectionEntry, map);
    }

    private List getToLockList(ActionProxy actionProxy, List selectionEntry) {
        ArrayList<String> toLockList = null;
        if (actionProxy.getLevel().equals(ActionLevelEnum.HEAD)) {
            toLockList = new ArrayList(selectionEntry.size());
            int size = selectionEntry.size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                toLockList.add(((BatchSelectionEntry)selectionEntry.get(idxOfEntry)).getId());
            }
        } else {
            toLockList = new ArrayList<String>();
            int size = selectionEntry.size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                String id = ((BatchSelectionEntry)selectionEntry.get(idxOfEntry)).getId();
                if (toLockList.contains(id)) continue;
                toLockList.add(id);
            }
        }
        return toLockList;
    }

    private List processLockResults(List selectionEntry, Map lockMap) {
        ArrayList<String> lockList = new ArrayList<String>(selectionEntry.size());
        int size = selectionEntry.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
            if (!((Boolean)lockMap.get(entry.getId())).booleanValue()) {
                entry.setResult(ActionResultEnum.ERROR);
                entry.setResultMsg(ResourceUtils.getMessage(null, "com.kingdee.eas.framework.BatchActionResource", LOCKFAILED));
                continue;
            }
            lockList.add(entry.getId());
        }
        return lockList;
    }

    public void releaseLocks(List lockList) {
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(lockList);
        }
    }
}

