/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.dupont;

import com.kingdee.bos.bi.model.common.dupont.DupontConfig;
import com.kingdee.bos.bi.model.common.list.ListUtil;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureTreeModel;
import com.kingdee.bos.bi.model.common.mm.metric.MetricDimensionNode;
import com.kingdee.bos.bi.model.common.mm.metric.MetricModel;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.common.mm.period.PeriodTreeModel;
import com.kingdee.bos.bi.model.common.mm.year.YearTreeModel;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class DupontModel {
    private static final Logger log = LogUtil.getPackageLogger(DupontModel.class);
    public static final OrgModel DEFAULT_ORG = new OrgModel();
    public static final YearTreeModel DEFAULT_YEAR_NEW = new YearTreeModel();
    public static final PeriodTreeModel DEFAULT_PERIOD_NEW = new PeriodTreeModel();
    public static final String ATTR_EXPAND = "expand";
    private static final Set ALL_ORG_DEFAULT = new HashSet();
    private static final Set ALL_YEAR_DEFAULT = new HashSet();
    private static final Set ALL_PERIOD_DEFAULT = new HashSet();
    private String _title;
    private String _refAppModelId;
    private MetricDimensionNode _metricTree;
    private DupontConfig _dupontConfig;
    private Filter _orgFilter = new Filter();
    private Filter _yearFilter = new Filter();
    private Filter _periodFilter = new Filter();
    private Filter _measureFilter = new Filter();
    private ArrayList _syncNodePairs;

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public DupontConfig getDupontConfig() {
        return this._dupontConfig;
    }

    public void setDupontConfig(DupontConfig dc) {
        this._dupontConfig = dc;
    }

    public void setRefAppModel(String appModelId) {
        this._refAppModelId = appModelId;
    }

    public String getRefAppModel() {
        return this._refAppModelId;
    }

    public void setMetricTree(MetricDimensionNode root) {
        this._metricTree = root;
    }

    public MetricDimensionNode getMetricTree() {
        return this._metricTree;
    }

    public boolean isShowOrgFilter() {
        return this._orgFilter.isShowFilter();
    }

    public void setShowOrgFilter(boolean isShow) {
        this._orgFilter.setShowFilter(isShow);
    }

    public OrgModel getDefaultOrg() {
        AbstractMainModel[] mm = this._orgFilter.getDefaultValues();
        if (mm == null || mm.length == 0) {
            return null;
        }
        return (OrgModel)mm[0];
    }

    public void setDefaultOrg(OrgModel org) {
        OrgModel[] orgModelArray;
        if (org == null) {
            orgModelArray = null;
        } else {
            OrgModel[] orgModelArray2 = new OrgModel[1];
            orgModelArray = orgModelArray2;
            orgModelArray2[0] = org;
        }
        this._orgFilter.setDefaultValues(orgModelArray);
    }

    public boolean isShowYearFilter() {
        return true;
    }

    public YearTreeModel getDefaultYear() {
        AbstractMainModel[] mm = this._yearFilter.getDefaultValues();
        if (mm == null || mm.length == 0) {
            return null;
        }
        return (YearTreeModel)mm[0];
    }

    public void setDefaultYear(YearTreeModel year) {
        YearTreeModel[] yearTreeModelArray;
        if (year == null) {
            yearTreeModelArray = null;
        } else {
            YearTreeModel[] yearTreeModelArray2 = new YearTreeModel[1];
            yearTreeModelArray = yearTreeModelArray2;
            yearTreeModelArray2[0] = year;
        }
        this._yearFilter.setDefaultValues(yearTreeModelArray);
    }

    public boolean isShowPeriodFilter() {
        return this._periodFilter.isShowFilter();
    }

    public void setShowPeriodFilter(boolean isShow) {
        this._periodFilter.setShowFilter(isShow);
    }

    public PeriodTreeModel getDefaultPeriod() {
        AbstractMainModel[] mm = this._periodFilter.getDefaultValues();
        if (mm == null || mm.length == 0) {
            return null;
        }
        return (PeriodTreeModel)mm[0];
    }

    public void setDefaultPeriod(PeriodTreeModel period) {
        PeriodTreeModel[] periodTreeModelArray;
        if (period == null) {
            periodTreeModelArray = null;
        } else {
            PeriodTreeModel[] periodTreeModelArray2 = new PeriodTreeModel[1];
            periodTreeModelArray = periodTreeModelArray2;
            periodTreeModelArray2[0] = period;
        }
        this._periodFilter.setDefaultValues(periodTreeModelArray);
    }

    public boolean isShowMeasureFilter() {
        return this._measureFilter.isShowFilter();
    }

    public void setShowMeasureFilter(boolean isShow) {
        this._measureFilter.setShowFilter(isShow);
    }

    public MeasureTreeModel[] getDefaultMeasures() {
        AbstractMainModel[] mm = this._measureFilter.getDefaultValues();
        if (mm == null || mm.length == 0) {
            return null;
        }
        MeasureTreeModel[] result = new MeasureTreeModel[mm.length];
        for (int i = 0; i < mm.length; ++i) {
            result[i] = (MeasureTreeModel)mm[i];
        }
        return result;
    }

    public void setDefaultMeasures(MeasureTreeModel[] values) {
        this._measureFilter.setDefaultValues(values);
    }

    public void addSyncNodePair(SyncNodePair snp) {
        if (this._syncNodePairs == null) {
            this._syncNodePairs = new ArrayList();
        }
        this._syncNodePairs.add(snp);
    }

    public SyncNodePair[] getSyncNodePairs() {
        if (this._syncNodePairs == null) {
            return new SyncNodePair[0];
        }
        return this._syncNodePairs.toArray(new SyncNodePair[0]);
    }

    public void clearAllSyncNodePairs() {
        if (this._syncNodePairs != null) {
            this._syncNodePairs.clear();
        }
    }

    public Element toXml() {
        Element org = this._orgFilter.toXml("Org", ALL_ORG_DEFAULT);
        Element measure = this._measureFilter.toXml("Measure", null);
        Element year = this._yearFilter.toXml("Year", ALL_YEAR_DEFAULT);
        Element period = this._periodFilter.toXml("Period", ALL_PERIOD_DEFAULT);
        Element filters = new Element("Filters");
        filters.addContent((Content)org);
        filters.addContent((Content)measure);
        filters.addContent((Content)year);
        filters.addContent((Content)period);
        Element tree = DupontModel.treeToXml(this._metricTree);
        tree.setName("MetricTree");
        Element title = new Element("Title");
        if (!StringUtil.isEmptyString((String)this.getTitle())) {
            title.addContent((Content)new CDATA(this.getTitle()));
        }
        Element prop = this._dupontConfig.toXML();
        Element root = new Element("Dupont");
        root.setAttribute("version", "1.0.0");
        root.addContent((Content)title);
        root.addContent((Content)prop);
        root.addContent((Content)filters);
        root.addContent((Content)tree);
        if (this._syncNodePairs != null) {
            Element syncNodes = new Element("SyncNodes");
            int c = this._syncNodePairs.size();
            for (int i = 0; i < c; ++i) {
                SyncNodePair snp = (SyncNodePair)this._syncNodePairs.get(i);
                syncNodes.addContent((Content)snp.toXml());
            }
            root.addContent((Content)syncNodes);
        }
        return root;
    }

    private static Element treeToXml(MetricDimensionNode node) {
        MetricModel model = node.getMetricModel();
        String number = model.getNumber();
        Boolean expand = (Boolean)model.getExtProps(ATTR_EXPAND);
        Element xmlNode = new Element("Metric");
        xmlNode.setAttribute("number", number);
        if (Boolean.TRUE.equals(expand)) {
            xmlNode.setAttribute(ATTR_EXPAND, "true");
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            xmlNode.addContent((Content)DupontModel.treeToXml(node.getChild(i)));
        }
        return xmlNode;
    }

    public void fromXml(Element xmlRoot) {
        Element config;
        Element title = xmlRoot.getChild("Title");
        if (title != null) {
            this.setTitle(title.getText());
        }
        this._dupontConfig = (config = xmlRoot.getChild("Config")) != null ? DupontConfig.fromXML(config) : DupontConfig.createOldConfig();
        Element tree = xmlRoot.getChild("MetricTree");
        this._metricTree = DupontModel.treeFromXml(tree);
        Element filters = xmlRoot.getChild("Filters");
        this._orgFilter.fromXml(filters.getChild("Org"), ALL_ORG_DEFAULT, OrgModel.class);
        this._measureFilter.fromXml(filters.getChild("Measure"), null, MeasureTreeModel.class);
        this._yearFilter.fromXml(filters.getChild("Year"), ALL_YEAR_DEFAULT, YearTreeModel.class);
        this._periodFilter.fromXml(filters.getChild("Period"), ALL_PERIOD_DEFAULT, PeriodTreeModel.class);
        Element syncNodes = xmlRoot.getChild("SyncNodes");
        if (syncNodes != null) {
            Iterator it = syncNodes.getChildren().iterator();
            while (it.hasNext()) {
                SyncNodePair snp = new SyncNodePair();
                snp.fromXml((Element)it.next());
                this.addSyncNodePair(snp);
            }
        }
    }

    private static MetricDimensionNode treeFromXml(Element xmlNode) {
        MetricModel model = new MetricModel();
        model.setNumber(xmlNode.getAttributeValue("number"));
        model.setExtProps(ATTR_EXPAND, "true".equals(xmlNode.getAttributeValue(ATTR_EXPAND)) ? Boolean.TRUE : Boolean.FALSE);
        MetricDimensionNode node = new MetricDimensionNode();
        node.setMetricModel(model);
        for (Element xmlMetric : xmlNode.getChildren("Metric")) {
            node.addChild(DupontModel.treeFromXml(xmlMetric));
        }
        return node;
    }

    public static void save(IManagementFacade facade, String id, DupontModel model) throws BIModelRemoteException {
        byte[] xml = null;
        try {
            xml = XmlUtil.saveXmlBytes((Element)model.toXml());
        }
        catch (IOException e) {
            throw new BIModelRemoteException("Dupont model to xml error.", e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update ");
        sb.append(ListUtil.getViewTablename("dupont"));
        sb.append(" set FDPSchema=?, FAMID=? where FID=?");
        try {
            facade.executeUpdate(sb.toString(), new Object[]{new String(xml, "UTF-8"), model.getRefAppModel(), id});
        }
        catch (SQLException e) {
            throw new BIModelRemoteException("Save Dupont model error.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BIModelRemoteException("Save Dupont model error.", e);
        }
    }

    public static DupontModel load(IManagementFacade facade, String id) throws BIModelRemoteException {
        RDRowSet rowset;
        StringBuffer sb = new StringBuffer();
        sb.append("select FDPSchema, FAMID from ");
        sb.append(ListUtil.getViewTablename("dupont"));
        sb.append(" where FID='");
        sb.append(id);
        sb.append("'");
        try {
            rowset = facade.executeQuery(sb.toString());
        }
        catch (SQLException e) {
            throw new BIModelRemoteException("Load Dupont model error.", e);
        }
        if (!rowset.first()) {
            throw new BIModelRemoteException("Load Dupont model error. Id not exist: " + id);
        }
        String refAppModelId = rowset.getString("FAMID");
        String xml = rowset.getString("FDPSchema");
        Element xmlRoot = null;
        if (!StringUtil.isEmptyString((String)xml)) {
            try {
                xmlRoot = XmlUtil.loadXmlBytes((byte[])xml.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new BIModelRemoteException("Dupont model from xml error.", e);
            }
        }
        DupontModel model = new DupontModel();
        if (xmlRoot != null) {
            model.fromXml(xmlRoot);
        }
        model.setRefAppModel(refAppModelId);
        return model;
    }

    static {
        DEFAULT_ORG.setNumber("CurrentOrg");
        DEFAULT_ORG.setName("\u5f53\u524d\u7ec4\u7ec7");
        DEFAULT_YEAR_NEW.setNumber("NewYear");
        DEFAULT_YEAR_NEW.setName("\u6700\u65b0\u5e74");
        DEFAULT_PERIOD_NEW.setNumber("NewPeriod");
        DEFAULT_PERIOD_NEW.setName("\u6700\u65b0\u671f\u95f4");
        ALL_ORG_DEFAULT.add(DEFAULT_ORG);
        ALL_YEAR_DEFAULT.add(DEFAULT_YEAR_NEW);
        ALL_PERIOD_DEFAULT.add(DEFAULT_PERIOD_NEW);
    }

    public static class Filter {
        private boolean _isShow;
        private AbstractMainModel[] _defaultValues;

        public boolean isShowFilter() {
            return this._isShow;
        }

        public void setShowFilter(boolean isShow) {
            this._isShow = isShow;
        }

        public AbstractMainModel[] getDefaultValues() {
            return this._defaultValues;
        }

        public void setDefaultValues(AbstractMainModel[] values) {
            this._defaultValues = values;
        }

        public Element toXml(String name, Set systemDefaults) {
            Element node = new Element(name);
            if (this.isShowFilter()) {
                node.setAttribute("show", "true");
            }
            if (this._defaultValues != null) {
                for (int i = 0; i < this._defaultValues.length; ++i) {
                    String value = this._defaultValues[i].getNumber();
                    if (StringUtil.isEmptyString((String)value)) continue;
                    Element item = new Element("DefaultValue");
                    item.addContent((Content)new CDATA(value));
                    if (systemDefaults != null && systemDefaults.contains(this._defaultValues[i])) {
                        item.setAttribute("system", "true");
                    }
                    node.addContent((Content)item);
                }
            }
            return node;
        }

        public void fromXml(Element node, Set systemDefaults, Class clazz) {
            this.setShowFilter("true".equals(node.getAttributeValue("show")));
            List items = node.getChildren("DefaultValue");
            ArrayList<AbstractMainModel> defaultValues = new ArrayList<AbstractMainModel>();
            for (int i = 0; i < items.size(); ++i) {
                Element item = (Element)items.get(i);
                String value = item.getTextTrim();
                AbstractMainModel mm = null;
                if (systemDefaults != null && "true".equals(item.getAttributeValue("system"))) {
                    for (AbstractMainModel sys : systemDefaults) {
                        if (!StringUtil.equals((String)sys.getNumber(), (String)value)) continue;
                        mm = sys;
                    }
                } else {
                    try {
                        mm = (AbstractMainModel)clazz.newInstance();
                        mm.setNumber(value);
                    }
                    catch (Exception ex) {
                        log.error((Object)"Load Dupont model error.", (Throwable)ex);
                    }
                }
                if (mm != null) {
                    defaultValues.add(mm);
                }
                this.setDefaultValues(defaultValues.toArray(new AbstractMainModel[0]));
            }
        }
    }

    public static class SyncNodePair {
        private ArrayList _metricNumbers = new ArrayList();

        public void addMetricNumber(String number) {
            this._metricNumbers.add(number);
        }

        public String[] getOthers(String number) {
            if (this._metricNumbers.contains(number)) {
                ArrayList result = new ArrayList();
                int c = this._metricNumbers.size();
                for (int i = 0; i < c; ++i) {
                    Object o = this._metricNumbers.get(i);
                    if (number.equals(o)) continue;
                    result.add(o);
                }
                return result.toArray(new String[0]);
            }
            return null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int c = this._metricNumbers.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sb.append(" = ");
                }
                sb.append("[");
                sb.append(this._metricNumbers.get(i));
                sb.append("]");
            }
            return sb.toString();
        }

        public Element toXml() {
            Element xmlSyncNode = new Element("SyncNode");
            int c = this._metricNumbers.size();
            for (int i = 0; i < c; ++i) {
                Element xmlNode = new Element("Node");
                xmlNode.setAttribute("number", (String)this._metricNumbers.get(i));
                xmlSyncNode.addContent((Content)xmlNode);
            }
            return xmlSyncNode;
        }

        public void fromXml(Element xmlSyncNode) {
            for (Element xmlNode : xmlSyncNode.getChildren()) {
                this.addMetricNumber(xmlNode.getAttributeValue("number"));
            }
        }
    }
}

