/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.formularengine.expr;

import com.kingdee.bos.bi.model.common.formularengine.IVarValueProvider;
import com.kingdee.bos.bi.model.common.formularengine.exception.FormulaComputingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.ICompositeExpr;
import com.kingdee.bos.bi.model.common.formularengine.oper.IDualisticOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.IOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.IUnitaryOper;

public class CompositeExpr
extends AbstractExpr
implements ICompositeExpr {
    private AbstractExpr _leftExpr;
    private IOper _op;
    private AbstractExpr _rightExpr;

    private CompositeExpr(AbstractExpr leftExpr, IOper op, AbstractExpr rightExpr) {
        this._leftExpr = leftExpr;
        this._op = op;
        this._rightExpr = rightExpr;
    }

    public CompositeExpr(AbstractExpr leftExpr, IDualisticOper op, AbstractExpr rightExpr) {
        this(leftExpr, (IOper)op, rightExpr);
    }

    public CompositeExpr(IUnitaryOper op, AbstractExpr expr) {
        this(null, op, expr);
    }

    @Override
    public AbstractExpr getLeftExpr() {
        return this._leftExpr;
    }

    @Override
    public AbstractExpr getRightExpr() {
        return this._rightExpr;
    }

    @Override
    public IOper getOper() {
        return this._op;
    }

    @Override
    public String getExprString() {
        StringBuffer result = new StringBuffer();
        if (this._leftExpr != null) {
            boolean bracketLeftExpr = false;
            if (this._leftExpr instanceof ICompositeExpr && ((ICompositeExpr)((Object)this._leftExpr)).getOper().getPriority() < this._op.getPriority()) {
                bracketLeftExpr = true;
                result.append("(");
            }
            result.append(this._leftExpr.getExprString());
            if (bracketLeftExpr) {
                result.append(")");
            }
        }
        if (this._op instanceof IDualisticOper) {
            result.append(" ");
            result.append(this._op.getOperString());
            result.append(" ");
        } else if (this._op instanceof IUnitaryOper) {
            result.append(this._op.getOperString());
        }
        boolean bracketRightExpr = false;
        if (this._rightExpr instanceof ICompositeExpr && ((ICompositeExpr)((Object)this._rightExpr)).getOper().getPriority() < this._op.getPriority()) {
            bracketRightExpr = true;
            result.append("(");
        }
        result.append(this._rightExpr.getExprString());
        if (bracketRightExpr) {
            result.append(")");
        }
        return result.toString();
    }

    @Override
    protected void doComputing(IVarValueProvider valueProvider) throws FormulaComputingException {
        if (this._leftExpr != null && this._leftExpr.isReturnValueUnsure()) {
            this._leftExpr.computing(valueProvider);
        }
        if (this._rightExpr.isReturnValueUnsure()) {
            this._rightExpr.computing(valueProvider);
        }
        if (this._op instanceof IUnitaryOper) {
            this._returnValue = ((IUnitaryOper)this._op).computing(this._rightExpr.getReturnValue());
        } else if (this._op instanceof IDualisticOper) {
            this._returnValue = ((IDualisticOper)this._op).computing(this._leftExpr.getReturnValue(), this._rightExpr.getReturnValue());
        } else {
            throw new RuntimeException("Error oper");
        }
    }
}

