/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.appmodel;

import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.FormularsLevelSortor;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.mm.appmodel.AbstractSchemeModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.FinanceCellObject;
import com.kingdee.bos.bi.model.common.mm.appmodel.FinanceDRDetailModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.FinanceSchemeModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.FormulaParamModel;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureDimensionNode;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureTreeModel;
import com.kingdee.bos.bi.model.common.mm.metric.MetricDimensionNode;
import com.kingdee.bos.bi.model.common.mm.metric.MetricModel;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.common.mm.period.PeriodDimensionNode;
import com.kingdee.bos.bi.model.common.mm.period.PeriodTreeModel;
import com.kingdee.bos.bi.model.common.mm.year.YearDimensionNode;
import com.kingdee.bos.bi.model.common.mm.year.YearTreeModel;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public class FinanceDRDetailXmlModel {
    private static final Logger log = LogUtil.getPackageLogger(FinanceDRDetailXmlModel.class);
    private String type;
    private String formula;
    private FinanceCellObject org;
    private FinanceCellObject metric;
    private FinanceCellObject measure;
    private FinanceCellObject year;
    private FinanceCellObject period;
    private FormulaParamModel formulaParam;
    private static List list;
    private static Map dimCache;
    private static Object objCache;
    private static String cacheMark;

    public String getType() {
        return this.type;
    }

    public void setType(String typeString) {
        this.type = typeString;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public FinanceCellObject getOrg() {
        return this.org;
    }

    public void setOrg(FinanceCellObject orgList) {
        this.org = orgList;
    }

    public FinanceCellObject getMetric() {
        return this.metric;
    }

    public void setMetric(FinanceCellObject metricList) {
        this.metric = metricList;
    }

    public FinanceCellObject getMeasure() {
        return this.measure;
    }

    public void setMeasure(FinanceCellObject measureList) {
        this.measure = measureList;
    }

    public FinanceCellObject getYear() {
        return this.year;
    }

    public void setYear(FinanceCellObject yearList) {
        this.year = yearList;
    }

    public FinanceCellObject getPeriod() {
        return this.period;
    }

    public void setPeriod(FinanceCellObject periodList) {
        this.period = periodList;
    }

    public FormulaParamModel getFormulaParam() {
        return this.formulaParam;
    }

    public void setFormulaParam(FormulaParamModel formulaParam) {
        this.formulaParam = formulaParam;
    }

    public static String toXml(FinanceDRDetailXmlModel dRDetailXmlModel, String type) {
        AbstractMainModel m;
        int i;
        int n;
        List l;
        FinanceCellObject cb;
        Element rootElement = new Element("rule");
        Document ruleDocument = new Document(rootElement);
        rootElement.setAttribute("type", type);
        rootElement.setAttribute("version", "1.0");
        if (dRDetailXmlModel.getFormula() != null) {
            Element formulaElement = new Element("formula");
            formulaElement.addContent((Content)new CDATA(dRDetailXmlModel.getFormula()));
            rootElement.addContent((Content)formulaElement);
            FormulaParamModel paramModel = dRDetailXmlModel.getFormulaParam();
            if (paramModel != null) {
                formulaElement.setAttribute("unpassedVoucher", paramModel.getUnpassedVoucher());
            }
        }
        if (dRDetailXmlModel.getOrg() != null) {
            Element orgElement = new Element("org");
            cb = dRDetailXmlModel.getOrg();
            if (cb.getAllDimName() == null) {
                l = cb.getDimList();
                n = l.size();
                for (i = 0; i < n; ++i) {
                    m = (OrgModel)((Object)l.get(i));
                    orgElement.addContent((Content)new Element("item").setAttribute("value", m.getNumber()));
                }
            }
            rootElement.addContent((Content)orgElement);
        }
        if (dRDetailXmlModel.getMetric() != null) {
            Element metricElement = new Element("metric");
            cb = dRDetailXmlModel.getMetric();
            if (cb.getAllDimName() == null) {
                l = cb.getDimList();
                n = l.size();
                for (i = 0; i < n; ++i) {
                    m = (MetricModel)((Object)l.get(i));
                    metricElement.addContent((Content)new Element("item").setAttribute("value", m.getNumber()));
                }
            }
            rootElement.addContent((Content)metricElement);
        }
        if (dRDetailXmlModel.getYear() != null) {
            Element yearElement = new Element("year");
            cb = dRDetailXmlModel.getYear();
            if (cb.getAllDimName() == null) {
                l = cb.getDimList();
                n = l.size();
                for (i = 0; i < n; ++i) {
                    m = (YearTreeModel)((Object)l.get(i));
                    yearElement.addContent((Content)new Element("item").setAttribute("value", m.getCode()));
                }
            }
            rootElement.addContent((Content)yearElement);
        }
        if (dRDetailXmlModel.getPeriod() != null) {
            Element periodElement = new Element("period");
            cb = dRDetailXmlModel.getPeriod();
            if (cb.getAllDimName() == null) {
                l = cb.getDimList();
                n = l.size();
                for (i = 0; i < n; ++i) {
                    m = (PeriodTreeModel)((Object)l.get(i));
                    periodElement.addContent((Content)new Element("item").setAttribute("value", m.getCode()));
                }
            }
            rootElement.addContent((Content)periodElement);
        }
        if (dRDetailXmlModel.getMeasure() != null) {
            Element measureElement = new Element("measure");
            cb = dRDetailXmlModel.getMeasure();
            if (cb.getAllDimName() == null) {
                l = cb.getDimList();
                n = l.size();
                for (i = 0; i < n; ++i) {
                    m = (MeasureTreeModel)((Object)l.get(i));
                    measureElement.addContent((Content)new Element("item").setAttribute("value", m.getCode()));
                }
            }
            rootElement.addContent((Content)measureElement);
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding("GBK");
        XMLOutputter out = new XMLOutputter(format);
        ByteArrayOutputStream bop = new ByteArrayOutputStream();
        try {
            out.output(ruleDocument, (OutputStream)bop);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return bop.toString();
    }

    public static FinanceDRDetailXmlModel toArrayList(IManagementFacade facade, boolean isPublished, String famId, String xml, String schemeId, String cacheMarkId) {
        if (xml == null) {
            return null;
        }
        if (cacheMark == null || !cacheMark.equals(cacheMarkId)) {
            cacheMark = cacheMarkId;
            dimCache = new HashMap();
        }
        FinanceDRDetailXmlModel detailModel = new FinanceDRDetailXmlModel();
        StringReader read = new StringReader(xml);
        InputSource source = new InputSource(read);
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        try {
            doc = sb.build(source);
        }
        catch (JDOMException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        Element rootElement = doc.getRootElement();
        List sonList = null;
        List grandsonList = null;
        Element sonElement = null;
        Element grandsonElement = null;
        sonList = rootElement.getChildren();
        int n = sonList.size();
        for (int i = 0; i < n; ++i) {
            sonElement = (Element)sonList.get(i);
            grandsonList = sonElement.getChildren();
            String dimName = sonElement.getName();
            if (dimName.equals("formula")) {
                detailModel.setFormula(sonElement.getText());
                FormulaParamModel paramModel = new FormulaParamModel();
                String unpassedVoucher = sonElement.getAttributeValue("unpassedVoucher");
                paramModel.setUnpassedVoucher(unpassedVoucher == null ? "default" : unpassedVoucher);
                detailModel.setFormulaParam(paramModel);
                continue;
            }
            FinanceCellObject dimCO = new FinanceCellObject();
            ArrayList<Object> dimLi = new ArrayList<Object>();
            int m = grandsonList.size();
            for (int k = 0; k < m; ++k) {
                String key;
                grandsonElement = (Element)grandsonList.get(k);
                String dimId = grandsonElement.getAttributeValue("value");
                if (!isPublished) {
                    key = cacheMark + schemeId + dimName + dimId;
                    objCache = dimCache.get(key) == null ? FinanceDRDetailXmlModel.load(facade, schemeId, dimName, dimId) : dimCache.get(key);
                    dimCache.put(key, objCache);
                    dimLi.add(objCache);
                    continue;
                }
                key = cacheMark + famId + dimName + dimId;
                objCache = dimCache.get(key) == null ? FinanceDRDetailXmlModel.load2(facade, famId, dimName, dimId) : dimCache.get(key);
                dimCache.put(key, objCache);
                dimLi.add(objCache);
            }
            if (dimName.equals("org")) {
                if (dimLi.size() == 0) {
                    dimCO.setAllDimName("\u6240\u6709\u7ec4\u7ec7");
                } else {
                    dimCO.setDimList(dimLi);
                }
                detailModel.setOrg(dimCO);
                continue;
            }
            if (dimName.equals("metric")) {
                if (dimLi.size() == 0) {
                    dimCO.setAllDimName("\u6240\u6709\u6307\u6807");
                } else {
                    dimCO.setDimList(dimLi);
                }
                detailModel.setMetric(dimCO);
                continue;
            }
            if (dimName.equals("year")) {
                if (dimLi.size() == 0) {
                    dimCO.setAllDimName("\u6240\u6709\u5e74");
                } else {
                    dimCO.setDimList(dimLi);
                }
                detailModel.setYear(dimCO);
                continue;
            }
            if (dimName.equals("period")) {
                if (dimLi.size() == 0) {
                    dimCO.setAllDimName("\u6240\u6709\u671f\u95f4");
                } else {
                    dimCO.setDimList(dimLi);
                }
                detailModel.setPeriod(dimCO);
                continue;
            }
            if (!dimName.equals("measure")) continue;
            if (dimLi.size() == 0) {
                dimCO.setAllDimName("\u6240\u6709\u5ea6\u91cf");
            } else {
                dimCO.setDimList(dimLi);
            }
            detailModel.setMeasure(dimCO);
        }
        return detailModel;
    }

    public static Object load(IManagementFacade facade, String SchemaID, String type, String number) {
        Object obj = "Error";
        String tableName = null;
        if (type.equals("org")) {
            tableName = "T_BI_MM_Org";
            String sql = "select FNumber,FName from " + tableName + " where FViewID=(select FDimViewID from T_BI_AM_DimRef where FDimType='" + "org" + "' and FAMID=(select FAMID from T_BI_AM_DR_Schema where FSchemaID='" + SchemaID + "' )) and FNumber='" + number + "'";
            RDRowSet rs = FinanceDRDetailXmlModel.executeQuery(facade, sql);
            OrgModel m = new OrgModel();
            if (rs.next()) {
                m.setNumber(rs.getString("FNumber"));
                m.setName(rs.getString("FName"));
            } else {
                m.setNumber("Error");
                m.setName("Error");
            }
            obj = m;
        } else if (type.equals("metric")) {
            tableName = "T_BI_MM_Metric";
            String sql = "select FNumber,FName from " + tableName + " where FViewID=(select FDimViewID from T_BI_AM_DimRef where FDimType='" + "metric" + "' and FAMID=(select FAMID from T_BI_AM_DR_Schema where FSchemaID='" + SchemaID + "' )) and FNumber='" + number + "'";
            RDRowSet rs = FinanceDRDetailXmlModel.executeQuery(facade, sql);
            MetricModel m = new MetricModel();
            if (rs.next()) {
                m.setNumber(rs.getString("FNumber"));
                m.setName(rs.getString("FName"));
            } else {
                m.setNumber("Error");
                m.setName("Error");
            }
            obj = m;
        } else if (type.equals("year")) {
            YearTreeModel m = new YearTreeModel();
            m.setCode(number);
            m.setName(number + "\u5e74");
            obj = m;
        } else if (type.equals("period")) {
            PeriodTreeModel m = new PeriodTreeModel();
            m.setCode(number);
            if (Integer.parseInt(number) > 100) {
                m.setName("\u7b2c" + (Integer.parseInt(number) - 100) + "\u5b63\u5ea6");
            } else {
                m.setName("\u7b2c" + number + "\u671f");
            }
            obj = m;
        } else if (type.equals("measure")) {
            tableName = "T_BI_MM_Measure";
            String sql = "select FNumber,FName from " + tableName + " where FViewID=(select FDimViewID from T_BI_AM_DimRef where FDimType='" + "measure" + "' and FAMID=(select FAMID from T_BI_AM_DR_Schema where FSchemaID='" + SchemaID + "' )) and FNumber='" + number + "'";
            RDRowSet rs = FinanceDRDetailXmlModel.executeQuery(facade, sql);
            MeasureTreeModel m = new MeasureTreeModel();
            if (rs.next()) {
                m.setCode(rs.getString("FNumber"));
                m.setName(rs.getString("FName"));
            } else {
                m.setCode("Error");
                m.setName("Error");
            }
            obj = m;
        }
        return obj;
    }

    private static RDRowSet executeQuery(IManagementFacade facade, String sql) {
        RDRowSet rs = null;
        try {
            rs = facade.executeQuery(sql);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        return rs;
    }

    public static Object load2(IManagementFacade facade, String famid, String type, String number) {
        Object obj = "Error";
        String pubnumber = null;
        String tablename = null;
        StringBuffer sql = null;
        RDRowSet rs = null;
        if (type.equals("org")) {
            pubnumber = FinanceDRDetailXmlModel.getPubnumber(facade, famid);
            tablename = DimensionMeta.getTablename(pubnumber, "org");
            sql = new StringBuffer();
            sql.append("select FNumber,FName from ").append(tablename).append(" where FNumber='").append(number);
            sql.append("' order by FParentNumber, FOrder");
            rs = FinanceDRDetailXmlModel.executeQuery(facade, sql.toString());
            if (rs.next()) {
                OrgModel m = new OrgModel();
                m.setNumber(rs.getString("FNumber"));
                m.setName(rs.getString("FName"));
                obj = m;
            }
        } else if (type.equals("metric")) {
            pubnumber = FinanceDRDetailXmlModel.getPubnumber(facade, famid);
            tablename = DimensionMeta.getTablename(pubnumber, "metric");
            sql = new StringBuffer();
            sql.append("select FNumber,FName from ").append(tablename).append(" where FNumber='").append(number);
            sql.append("' order by FParentNumber, FOrder");
            rs = FinanceDRDetailXmlModel.executeQuery(facade, sql.toString());
            if (rs.next()) {
                MetricModel m = new MetricModel();
                m.setNumber(rs.getString("FNumber"));
                m.setName(rs.getString("FName"));
                obj = m;
            }
        } else if (type.equals("year")) {
            YearTreeModel m = new YearTreeModel();
            m.setCode(number);
            m.setName(number + "\u5e74");
            obj = m;
        } else if (type.equals("period")) {
            PeriodTreeModel m = new PeriodTreeModel();
            m.setCode(number);
            m.setName("\u7b2c" + number + "\u671f");
            obj = m;
        } else if (type.equals("measure")) {
            pubnumber = FinanceDRDetailXmlModel.getPubnumber(facade, famid);
            tablename = DimensionMeta.getTablename(pubnumber, type);
            sql = new StringBuffer();
            sql.append("select FNumber, FName from ").append(tablename).append(" where FNumber='").append(number).append("'");
            rs = FinanceDRDetailXmlModel.executeQuery(facade, sql.toString());
            if (rs.next()) {
                MeasureTreeModel m = new MeasureTreeModel();
                m.setCode(rs.getString("FNumber"));
                m.setName(rs.getString("FName"));
                obj = m;
            }
        }
        return obj;
    }

    private static String getPubnumber(IManagementFacade facade, String famid) {
        String pubnumber = null;
        try {
            pubnumber = (String)facade.getAppmodelInfo(famid, "pubnumber");
        }
        catch (BIModelRemoteException e) {
            log.error((Object)e);
        }
        return pubnumber;
    }

    public static List toDimList(Object[] selectedNodes) {
        if (selectedNodes == null || selectedNodes.length == 0) {
            return null;
        }
        list = new ArrayList();
        int n = selectedNodes.length;
        for (int i = 0; i < n; ++i) {
            FinanceDRDetailXmlModel.getModel(selectedNodes[i]);
        }
        if (list.size() == 1) {
            return list;
        }
        ArrayList listAnti = new ArrayList();
        for (int i = list.size() - 1; i >= 0; --i) {
            listAnti.add(list.get(i));
        }
        if (selectedNodes[0] instanceof MeasureDimensionNode) {
            try {
                FormularParser parser = new FormularParser();
                FormularsLevelSortor sorter = new FormularsLevelSortor();
                int n2 = listAnti.size();
                for (int i = 0; i < n2; ++i) {
                    MeasureTreeModel m = (MeasureTreeModel)((Object)listAnti.get(i));
                    if (m.getFormula() != null && m.getFormula().trim().length() != 0) {
                        AbstractExpr exp = parser.parse(m.getFormula());
                        sorter.addVar(m.getNumber(), exp);
                        continue;
                    }
                    sorter.addVar(m.getNumber(), null);
                }
                sorter.sort();
                String[] result = sorter.getSortedVars();
                ArrayList<MeasureTreeModel> listSort = new ArrayList<MeasureTreeModel>();
                int n3 = result.length;
                for (int i = 0; i < n3; ++i) {
                    for (int k = 0; k < listAnti.size(); ++k) {
                        MeasureTreeModel m = (MeasureTreeModel)((Object)listAnti.get(k));
                        if (result[i] != m.getNumber()) continue;
                        listSort.add(m);
                        listAnti.remove(k);
                        k = 0;
                    }
                }
                return listSort;
            }
            catch (StringParsingException e) {
                log.error((Object)e);
            }
        }
        if (selectedNodes[0] instanceof MetricDimensionNode) {
            try {
                FormularParser parser = new FormularParser();
                FormularsLevelSortor sorter = new FormularsLevelSortor();
                int n4 = listAnti.size();
                for (int i = 0; i < n4; ++i) {
                    MetricModel m = (MetricModel)((Object)listAnti.get(i));
                    if (m.getFormula() != null && m.getFormula().trim().length() != 0) {
                        AbstractExpr exp = parser.parse(m.getFormula());
                        sorter.addVar(m.getNumber(), exp);
                        continue;
                    }
                    sorter.addVar(m.getNumber(), null);
                }
                sorter.sort();
                String[] result = sorter.getSortedVars();
                ArrayList<MetricModel> listSort = new ArrayList<MetricModel>();
                int n5 = result.length;
                for (int i = 0; i < n5; ++i) {
                    for (int k = 0; k < listAnti.size(); ++k) {
                        MetricModel m = (MetricModel)((Object)listAnti.get(k));
                        if (!StringUtil.equalsIgnoreCase(result[i], m.getNumber())) continue;
                        listSort.add(m);
                        listAnti.remove(k);
                        k = 0;
                    }
                }
                return listSort;
            }
            catch (StringParsingException e) {
                log.error((Object)e);
            }
        }
        return listAnti;
    }

    private static void getModel(Object node) {
        if (node instanceof OrgDimensionNode) {
            OrgDimensionNode nodeOrg = (OrgDimensionNode)node;
            list.add(nodeOrg.getOrgModel());
        } else if (node instanceof MetricDimensionNode) {
            MetricDimensionNode nodeMetric = (MetricDimensionNode)node;
            list.add(nodeMetric.getMetricModel());
        } else if (node instanceof YearDimensionNode) {
            YearDimensionNode nodeYear = (YearDimensionNode)node;
            list.add(nodeYear.getYearModel());
        } else if (node instanceof PeriodDimensionNode) {
            PeriodDimensionNode nodePeriod = (PeriodDimensionNode)node;
            list.add(nodePeriod.getPeriodModel());
        } else if (node instanceof MeasureDimensionNode) {
            MeasureDimensionNode nodeMeasure = (MeasureDimensionNode)node;
            list.add(nodeMeasure.getMeasureModel());
        }
    }

    public static void save(IManagementFacade facade, FinanceSchemeModel sm) throws SQLException {
        String[] sqls = new String[]{"delete from T_BI_AM_DR_Schema where FAMID='" + sm.getFAMID() + "' and FSchemaID='" + sm.getFSchemeID() + "'", "delete from T_BI_AM_DR_Detail where FSchemaID='" + sm.getFSchemeID() + "'", "INSERT INTO T_BI_AM_DR_Schema Values('" + sm.getFAMID() + "','" + sm.getFSchemeID() + "','" + sm.getFSchemeName() + "')"};
        facade.executeBatch(sqls);
        List l = sm.getDRDetailModel();
        FinanceDRDetailModel m = null;
        String xml = null;
        String sqlIns2 = null;
        int n = l.size();
        for (int i = 0; i < n; ++i) {
            m = (FinanceDRDetailModel)l.get(i);
            xml = FinanceDRDetailXmlModel.toXml(m.getFParameters(), m.getFType());
            sqlIns2 = "INSERT INTO T_BI_AM_DR_Detail Values('" + m.getFSchemaID() + "','" + m.getFType() + "'," + i + ",'" + xml + "')";
            facade.executeUpdate(sqlIns2);
        }
    }

    public static int[] remove(IManagementFacade facade, AbstractSchemeModel sm) throws SQLException {
        String[] sqls = new String[]{"delete from T_BI_AM_DR_Schema where FAMID='" + sm.getFAMID() + "' and FSchemaID='" + sm.getFSchemeID() + "'", "delete from T_BI_AM_DR_Detail where FSchemaID='" + sm.getFSchemeID() + "'"};
        return facade.executeBatch(sqls);
    }

    static {
        dimCache = null;
        objCache = null;
        cacheMark = null;
    }
}

