/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.customdim;

import com.kingdee.bos.bi.model.DB.Field;
import com.kingdee.bos.bi.model.common.mm.customdim.CustomDimUtil;
import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCustomDimModel {
    private String id;
    private String type;
    private String number;
    private String name;
    private String description;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public void createTable(IManagementFacade facade) throws SQLException {
        facade.createTable(this.getTablename(), this.number, this.getFields(false), false, this.getPK(), this.getPKName());
    }

    private String getPK() {
        return CustomDimUtil.getPK(this.type);
    }

    private String getPKName() {
        return CustomDimUtil.getPKName(this.type, this.number);
    }

    private String getTablename() {
        return CustomDimUtil.getTableName(this.type, this.number);
    }

    public abstract List getFields(boolean var1);

    public void alertColumn(IManagementFacade facade, List fieldList) throws SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        String dbType = facade.getDBType();
        if (StringUtil.equals((String)dbType, (String)"sqlServer")) {
            sqls.add(this.dropPK(this.getTablename(), this.getPKName()));
        }
        List existColumns = this.getExistColumns(facade);
        Field field2 = null;
        Column column = null;
        block0: for (Field field2 : fieldList) {
            int n = existColumns.size();
            for (int i = 0; i < n; ++i) {
                column = (Column)existColumns.get(i);
                if (StringUtil.equalsIgnoreCase((String)column.getName(), (String)field2.name)) {
                    if (!field2.isInner) {
                        sqls.add(this.updateColumn(field2, dbType));
                    }
                    existColumns.remove(column);
                    continue block0;
                }
                if (i != n - 1) continue;
                sqls.add(this.addColumn(field2));
                continue block0;
            }
        }
        int n = existColumns.size();
        for (int i = 0; i < n; ++i) {
            sqls.add(this.dropColumn((Column)existColumns.get(i)));
        }
        if (StringUtil.equals((String)dbType, (String)"sqlServer")) {
            sqls.add(this.createPK(this.getTablename(), this.getPK(), this.getPKName()));
        }
        facade.executeBatch(sqls.toArray(new String[0]));
    }

    public String dropPK(String tablename, String pkname) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tablename);
        sb.append(" DROP CONSTRAINT ").append(pkname);
        return sb.toString();
    }

    public String createPK(String tablename, String pkfield, String pkname) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tablename);
        sb.append(" ADD CONSTRAINT ").append(pkname);
        sb.append(" PRIMARY KEY (").append(pkfield).append(")");
        return sb.toString();
    }

    private List getExistColumns(IManagementFacade facade) throws SQLException {
        return facade.getColumnsFromEAS("SELECT * FROM " + this.getTablename());
    }

    public String addColumn(Field field) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(this.getTablename()).append(" ADD ");
        sb.append(field.name).append(" ").append(field.type).append(" ").append(field.isnull ? "" : "not null");
        sb.append(field.defaultValue != null ? " default " + field.defaultValue : "").append(" ");
        return sb.toString();
    }

    public String dropColumn(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(this.getTablename()).append(" DROP COLUMN ").append(column.getName()).append(" ");
        return sb.toString();
    }

    public String updateColumn(Field field, String dbType) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(this.getTablename()).append(" ALTER ");
        sb.append(field.name).append(" ").append(field.type).append(" ");
        if (!StringUtil.equalsIgnoreCase((String)"oracle", (String)dbType)) {
            sb.append(field.isnull ? "" : "not null");
        }
        sb.append(field.defaultValue != null ? " default " + field.defaultValue : "").append(" ");
        return sb.toString();
    }

    public boolean isExistView(IManagementFacade facade, String dimId) throws SQLException {
        String sql = "select * from T_BI_CSTM_List where fcstmid='" + dimId + "'";
        return facade.executeQuery(sql).getRowCount() > 0;
    }
}

