/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time;

import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.builder.AbstractTimeLevel;
import com.kingdee.bos.bi.model.common.mm.time.builder.DateLevel;
import com.kingdee.bos.bi.model.common.mm.time.builder.HalfYearLevel;
import com.kingdee.bos.bi.model.common.mm.time.builder.MonthLevel;
import com.kingdee.bos.bi.model.common.mm.time.builder.QuarterLevel;
import com.kingdee.bos.bi.model.common.mm.time.builder.YearLevel;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TimeDimensionNode
extends AbstractTreeNode
implements Serializable {
    private static final long serialVersionUID = 5797912863919817025L;

    public void setTimeModel(TimeTreeModel mm) {
        super.setModel((AbstractMainModel)mm);
    }

    public TimeDimensionNode getParent() {
        return (TimeDimensionNode)super.getParentNode();
    }

    public TimeTreeModel getTimeModel() {
        return (TimeTreeModel)super.getModel();
    }

    public TimeDimensionNode getChild(int idx) {
        return (TimeDimensionNode)super.getChildNode(idx);
    }

    public void addChild(TimeDimensionNode node) {
        super.addChildNode((AbstractTreeNode)node);
    }

    public void setParent(TimeDimensionNode node) {
        super.setParentNode((AbstractTreeNode)node);
    }

    public static TimeDimensionNode load(IManagementFacade facade, String viewId, DimensionType dt) throws BIModelRemoteException {
        TimeModel timeModel = null;
        try {
            timeModel = TimeModel.load2(facade, viewId, dt.getName());
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        TimeDimensionNode rootNode = new TimeDimensionNode();
        TimeTreeModel m = new TimeTreeModel();
        m.setDimensionType(dt.getName());
        rootNode.setTimeModel(m);
        List timeList = TimeDimensionNode.createTimeLevelChain(timeModel);
        if (timeList.size() > 0) {
            AbstractTimeLevel yearLevel = (AbstractTimeLevel)timeList.get(0);
            yearLevel.builder(rootNode);
        }
        return rootNode;
    }

    public static List createTimeLevelChain(TimeModel timeModel) {
        ArrayList<AbstractTimeLevel> chain = new ArrayList<AbstractTimeLevel>();
        if (timeModel.getUseYear()) {
            chain.add(new YearLevel(timeModel));
        }
        if (timeModel.getUseHalfYear()) {
            chain.add(new HalfYearLevel(timeModel));
        }
        if (timeModel.getUseQuarter()) {
            chain.add(new QuarterLevel(timeModel));
        }
        if (timeModel.getUseMonth()) {
            chain.add(new MonthLevel(timeModel));
        }
        if (timeModel.getUseDay()) {
            chain.add(new DateLevel(timeModel));
        }
        int n = chain.size();
        for (int i = 0; i < n; ++i) {
            AbstractTimeLevel level = (AbstractTimeLevel)chain.get(i);
            if (i - 1 >= 0) {
                level.setPrevLevel((AbstractTimeLevel)chain.get(i - 1));
            }
            if (i + 1 >= n) continue;
            level.setNextLevel((AbstractTimeLevel)chain.get(i + 1));
        }
        return chain;
    }

    public static List createTimeLevelChain(TimeModel timeModel, Map params) {
        ArrayList<AbstractTimeLevel> chain = new ArrayList<AbstractTimeLevel>();
        if (timeModel.getUseYear()) {
            chain.add(new YearLevel(timeModel, params));
        }
        if (timeModel.getUseHalfYear()) {
            chain.add(new HalfYearLevel(timeModel, params));
        }
        if (timeModel.getUseQuarter()) {
            chain.add(new QuarterLevel(timeModel, params));
        }
        if (timeModel.getUseMonth()) {
            chain.add(new MonthLevel(timeModel, params));
        }
        if (timeModel.getUseDay()) {
            chain.add(new DateLevel(timeModel, params));
        }
        int n = chain.size();
        for (int i = 0; i < n; ++i) {
            AbstractTimeLevel level = (AbstractTimeLevel)chain.get(i);
            if (i - 1 >= 0) {
                level.setPrevLevel((AbstractTimeLevel)chain.get(i - 1));
            }
            if (i + 1 >= n) continue;
            level.setNextLevel((AbstractTimeLevel)chain.get(i + 1));
        }
        return chain;
    }
}

