/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time.builder;

import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public abstract class AbstractTimeLevel {
    protected int levelCode;
    protected String levelName = null;
    protected String levelBriefNumber = null;
    protected AbstractTimeLevel prevLevel = null;
    protected AbstractTimeLevel nextLevel = null;
    protected int value;
    protected TimeModel timeModel = null;
    protected Calendar calendar = null;
    protected boolean isStart;
    protected boolean isEnd;
    protected Calendar startTime = null;
    protected Calendar endTime = null;
    protected Map params = null;
    public static final int CODE_YEAR = 1;
    public static final int CODE_HALFYEAR = 2;
    public static final int CODE_QUARTER = 3;
    public static final int CODE_MONTH = 4;
    public static final int CODE_DATE = 5;
    public static final String NAME_YEAR = "year";
    public static final String NAME_HALFYEAR = "halfyear";
    public static final String NAME_QUARTER = "quarter";
    public static final String NAME_MONTH = "month";
    public static final String NAME_DATE = "date";
    public static final String BRIEF_YEAR = "Y";
    public static final String BRIEF_HALFYEAR = "H";
    public static final String BRIEF_QUARTER = "Q";
    public static final String BRIEF_MONTH = "M";
    public static final String BRIEF_DATE = "D";

    public AbstractTimeLevel(TimeModel timeModel) {
        this.timeModel = timeModel;
        this.startTime = TimeUtil.createCalendar(timeModel.getDateBegin());
        this.endTime = TimeUtil.createCalendar(timeModel.getDateEnd());
        this.calendar = TimeUtil.createCalendar(new Date());
    }

    public AbstractTimeLevel(TimeModel timeModel, Map params) {
        this(timeModel);
        this.params = params;
    }

    public AbstractTimeLevel getPrevLevel() {
        return this.prevLevel;
    }

    public void setPrevLevel(AbstractTimeLevel prevLevel) {
        this.prevLevel = prevLevel;
    }

    public AbstractTimeLevel getNextLevel() {
        return this.nextLevel;
    }

    public void setNextLevel(AbstractTimeLevel nextLevel) {
        this.nextLevel = nextLevel;
    }

    public void builder(TimeDimensionNode parentNode) {
        if (this.prevLevel == null) {
            this.doBuilderFromYear(parentNode);
            return;
        }
        switch (this.prevLevel.levelCode) {
            case 1: {
                this.doBuilderFromYear(parentNode);
                break;
            }
            case 2: {
                this.doBuilderFromHalfYear(parentNode);
                break;
            }
            case 3: {
                this.doBuilderFromQuarter(parentNode);
                break;
            }
            case 4: {
                this.doBuilderFromMonth(parentNode);
                break;
            }
            case 5: {
                this.doBuilderFromDate(parentNode);
            }
        }
    }

    protected int getYear() {
        AbstractTimeLevel yearLevel = this;
        while (yearLevel.levelCode != 1) {
            yearLevel = yearLevel.prevLevel;
        }
        return yearLevel.value;
    }

    protected abstract void doBuilderFromYear(TimeDimensionNode var1);

    protected abstract void doBuilderFromHalfYear(TimeDimensionNode var1);

    protected abstract void doBuilderFromQuarter(TimeDimensionNode var1);

    protected abstract void doBuilderFromMonth(TimeDimensionNode var1);

    protected abstract void doBuilderFromDate(TimeDimensionNode var1);

    protected void addParamsForDashBoard(AbstractMainModel model) {
        if (this.params == null || this.params.size() == 0) {
            return;
        }
        String disPlayNameField = (String)this.params.get("alias");
        String returnValueField = (String)this.params.get("value");
        String displayName = "FID".equalsIgnoreCase(disPlayNameField) ? model.getNumber() : model.getName();
        String returnValue = "FID".equalsIgnoreCase(returnValueField) ? model.getNumber() : model.getName();
        model.setExtProps((Object)"alias", (Object)displayName);
        model.setExtProps((Object)"value", (Object)returnValue);
    }
}

