/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time.builder;

import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.common.mm.time.builder.AbstractTimeLevel;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class DateLevel
extends AbstractTimeLevel {
    public DateLevel(TimeModel timeModel) {
        super(timeModel);
        this.levelCode = 5;
        this.levelName = "date";
        this.levelBriefNumber = "D";
    }

    public DateLevel(TimeModel timeModel, Map params) {
        super(timeModel, params);
        this.levelCode = 5;
        this.levelName = "date";
        this.levelBriefNumber = "D";
    }

    private Calendar getCalendar(boolean isCursor, int year, int month) {
        Calendar calendar = TimeUtil.createCalendar(new Date());
        TimeUtil.resetCalendarYearMonth(calendar, year, month);
        if (isCursor) {
            TimeUtil.resetCalendarDay(calendar, calendar.getActualMinimum(5));
            return this.startTime.after(calendar) ? TimeUtil.createCalendar(this.startTime) : calendar;
        }
        TimeUtil.resetCalendarDay(calendar, calendar.getActualMaximum(5));
        return this.endTime.after(calendar) ? calendar : TimeUtil.createCalendar(this.endTime);
    }

    @Override
    protected void doBuilderFromYear(TimeDimensionNode parentNode) {
        int year = this.getYear();
        Calendar cursor = this.getCalendar(true, year, 1);
        Calendar theEnd = this.getCalendar(false, year, 12);
        this.createDateTreeNodes(parentNode, cursor, theEnd, false);
    }

    @Override
    protected void doBuilderFromHalfYear(TimeDimensionNode parentNode) {
        int year = this.getYear();
        int month = (this.prevLevel.value - 1) * 6 + 1;
        Calendar cursor = this.getCalendar(true, year, month);
        Calendar theEnd = this.getCalendar(false, year, month + 5);
        this.createDateTreeNodes(parentNode, cursor, theEnd, false);
    }

    @Override
    protected void doBuilderFromQuarter(TimeDimensionNode parentNode) {
        int year = this.getYear();
        int month = (this.prevLevel.value - 1) * 3 + 1;
        Calendar cursor = this.getCalendar(true, year, month);
        Calendar theEnd = this.getCalendar(false, year, month + 2);
        this.createDateTreeNodes(parentNode, cursor, theEnd, false);
    }

    @Override
    protected void doBuilderFromMonth(TimeDimensionNode parentNode) {
        int year = this.getYear();
        int month = this.prevLevel.value;
        Calendar cursor = this.getCalendar(true, year, month);
        Calendar theEnd = this.getCalendar(false, year, month);
        this.createDateTreeNodes(parentNode, cursor, theEnd, true);
    }

    @Override
    protected void doBuilderFromDate(TimeDimensionNode parentNode) {
    }

    private void createDateTreeNodes(TimeDimensionNode parentNode, Calendar cursor, Calendar theEnd, boolean isFromMonth) {
        long theEndTime = theEnd.getTimeInMillis();
        while (cursor.getTimeInMillis() <= theEndTime) {
            TimeDimensionNode dateNode = new TimeDimensionNode();
            TimeTreeModel dateModel = new TimeTreeModel();
            dateModel.setDimensionType(parentNode.getTimeModel().getDimensionType());
            dateNode.setTimeModel(dateModel);
            StringBuffer name = new StringBuffer();
            if (isFromMonth) {
                name.append(TimeUtil.getDay(cursor)).append("\u65e5");
            } else {
                name.append(TimeUtil.getMonth(cursor)).append("\u6708").append(TimeUtil.getDay(cursor)).append("\u65e5");
            }
            dateModel.setName(name.toString());
            dateModel.setNumber(TimeUtil.getStringTime(cursor));
            dateModel.setLevelName("date");
            dateModel.setShortNumber(Integer.toString(TimeUtil.getDay(cursor)));
            this.addParamsForDashBoard(dateModel);
            parentNode.addChild(dateNode);
            cursor.add(5, 1);
        }
    }
}

