/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.contentree.panel.view;

import com.kingdee.bos.bi.model.commonui.contentree.panel.view.AbstractTreeView;
import com.kingdee.bos.bi.model.ui.resource.Resource;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultTreeView
extends AbstractTreeView {
    private static final long serialVersionUID = 3387045141936218358L;
    protected KDWorkButton btnNew;
    protected KDWorkButton btnNewChild;
    protected KDWorkButton btnReName;
    protected KDWorkButton btnEdit;
    protected KDWorkButton btnDelete;
    protected KDWorkButton btnSave;
    protected KDWorkButton btnMoveUp;
    protected KDWorkButton btnMoveDown;
    protected ActionListener lstNew;
    protected ActionListener lstNewChild;
    protected ActionListener lstReName;
    protected ActionListener lstEdit;
    protected ActionListener lstDelete;
    protected ActionListener lstSave;
    protected ActionListener lstMoveUp;
    protected ActionListener lstMoveDown;
    protected Hashtable btnRegister;

    public DefaultTreeView(KDTree tree) {
        super(tree);
    }

    @Override
    protected void installButtonComponent() {
        this.btnNew = this.createDefaultButtons("new", "\u65b0\u589e", Resource.ICON_NEW_FILE, this.lstNew);
        this.btnNewChild = this.createDefaultButtons("newChild", "\u65b0\u5b50", Resource.ICON_NEW_FILE, this.lstNewChild);
        this.btnReName = this.createDefaultButtons("reName", "\u91cd\u547d\u540d", Resource.ICON_RENAME, this.lstReName);
        this.btnEdit = this.createDefaultButtons("edit", "\u7f16\u8f91", Resource.ICON_EDIT, this.lstEdit);
        this.btnSave = this.createDefaultButtons("save", "\u4fdd\u5b58", Resource.ICON_SAVE, this.lstSave);
        this.btnDelete = this.createDefaultButtons("delete", "\u5220\u9664", Resource.ICON_DELETE, this.lstDelete);
        this.btnMoveUp = this.createDefaultButtons("moveUp", "\u4e0a\u79fb", Resource.ICON_MOVE_UP, this.lstMoveUp);
        this.btnMoveDown = this.createDefaultButtons("moveDown", "\u4e0b\u79fb", Resource.ICON_MOVE_DOWN, this.lstMoveDown);
    }

    private KDWorkButton createDefaultButtons(String key, String text, ImageIcon icon, ActionListener l) {
        if (this.getBtnRegister().containsKey(key)) {
            return this.createButtonInstance(text, icon, l);
        }
        return null;
    }

    @Override
    protected void initButtonListener() {
        this.lstNewChild = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeView.this.action_NewChild();
            }
        };
        this.lstNew = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeView.this.action_New();
            }
        };
        this.lstReName = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeView.this.action_ReName();
            }
        };
        this.lstEdit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeView.this.action_Edit();
            }
        };
        this.lstSave = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeView.this.action_Save();
            }
        };
        this.lstDelete = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeView.this.action_Delete();
            }
        };
        this.lstMoveUp = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeView.this.action_MoveUp();
            }
        };
        this.lstMoveDown = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeView.this.action_MoveDown();
            }
        };
    }

    protected void action_NewChild() {
    }

    protected void action_New() {
    }

    protected void action_ReName() {
    }

    protected void action_Edit() {
    }

    protected void action_Save() {
    }

    protected void doDelete() {
    }

    protected void action_Delete() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node.getChildCount() == 0) {
            if (WindowUtil.msgboxYesNo((Component)this.getTree(), (Object)"\u60a8\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684\u8282\u70b9\u5417\uff1f", (String)"\u5220\u9664\u8282\u70b9")) {
                DefaultKingdeeTreeNode nextNode = (DefaultKingdeeTreeNode)node.getNextNode();
                if (nextNode == null) {
                    nextNode = (DefaultKingdeeTreeNode)node.getPreviousNode();
                }
                this.doDelete();
                this.getTree().removeNodeFromParent((MutableTreeNode)node);
                if (nextNode != null && nextNode != this.getTree().getModel().getRoot()) {
                    this.getTree().setSelectionNode(nextNode);
                }
            }
        } else {
            int i = WindowUtil.msgboxYesNoCancel((Component)this.getTree(), (Object)"\u662f\u5426\u8981\u5220\u9664\u9009\u4e2d\u8282\u70b9\u548c\u5b50\u8282\u70b9\uff1f\r\n\u662f\uff1a\u540c\u65f6\u5220\u9664\u9009\u4e2d\u8282\u70b9\u53ca\u5176\u5b50\u8282\u70b9\r\n\u5426\uff1a\u4fdd\u7559\u9009\u4e2d\u8282\u70b9\uff0c\u4ec5\u5220\u9664\u5b50\u8282\u70b9\r\n", (String)"\u5220\u9664\u8282\u70b9");
            if (i == 0) {
                DefaultKingdeeTreeNode nextNode = (DefaultKingdeeTreeNode)node.getNextNode();
                if (nextNode == null) {
                    nextNode = (DefaultKingdeeTreeNode)node.getPreviousNode();
                }
                this.getTree().removeNodeFromParent((MutableTreeNode)node);
                if (nextNode != null && nextNode != this.getTree().getModel().getRoot()) {
                    this.getTree().setSelectionNode(nextNode);
                }
            } else if (i == 1) {
                this.getTree().removeAllChildrenFromParent((MutableTreeNode)node);
                this.getTree().setSelectionNode((DefaultKingdeeTreeNode)node.getPreviousNode());
                this.getTree().setSelectionNode(node);
            } else if (i == 2) {
                // empty if block
            }
        }
    }

    protected void action_MoveUp() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        int idx = parentNode.getIndex((TreeNode)node);
        this.getTree().removeNodeFromParent((MutableTreeNode)node);
        this.getTree().insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parentNode, --idx);
        this.getTree().setSelectionNode(node);
    }

    protected void action_MoveDown() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        int idx = parentNode.getIndex((TreeNode)node);
        this.getTree().removeNodeFromParent((MutableTreeNode)node);
        this.getTree().insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parentNode, ++idx);
        this.getTree().setSelectionNode(node);
    }

    @Override
    protected void syncTreeViewButtonStatus() {
        if (this.btnNew != null) {
            this.btnNew.setEnabled(this.canNew());
        }
        if (this.btnNewChild != null) {
            this.btnNewChild.setEnabled(true);
        }
        if (this.btnReName != null) {
            this.btnReName.setEnabled(true);
        }
        if (this.btnEdit != null) {
            this.btnEdit.setEnabled(true);
        }
        if (this.btnDelete != null) {
            this.btnDelete.setEnabled(this.canDelete());
        }
        if (this.btnSave != null) {
            this.btnSave.setEnabled(this.canSave());
        }
        if (this.btnMoveUp != null) {
            this.btnMoveUp.setEnabled(this.canMoveUp());
        }
        if (this.btnMoveDown != null) {
            this.btnMoveDown.setEnabled(this.canMoveDown());
        }
    }

    protected boolean canNew() {
        return true;
    }

    protected boolean canSave() {
        return true;
    }

    protected boolean canDelete() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node == null) {
            return false;
        }
        if (node == this.getTree().getModel().getRoot()) {
            return false;
        }
        return node.getParent() != this.getTree().getModel().getRoot();
    }

    protected boolean canMoveUp() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node == null) {
            return false;
        }
        TreeNode parentNode = node.getParent();
        if (parentNode == null) {
            return false;
        }
        return parentNode.getIndex((TreeNode)node) != 0;
    }

    protected boolean canMoveDown() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node == null) {
            return false;
        }
        TreeNode parentNode = node.getParent();
        if (parentNode == null) {
            return false;
        }
        return parentNode.getIndex((TreeNode)node) != parentNode.getChildCount() - 1;
    }

    protected DefaultKingdeeTreeNode getSelectedNode() {
        TreePath path = this.getTree().getSelectionPath();
        if (path != null) {
            return (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    protected Map getBtnRegister() {
        if (this.btnRegister == null || this.btnRegister.size() == 0) {
            this.btnRegister = new Hashtable();
            this.btnRegister.put("new", "\u65b0\u589e\u6309\u94ae");
            this.btnRegister.put("newChild", "\u65b0\u5b50\u6309\u94ae");
            this.btnRegister.put("reName", "\u91cd\u547d\u540d\u6309\u94ae");
            this.btnRegister.put("edit", "\u7f16\u8f91\u6309\u94ae");
            this.btnRegister.put("delete", "\u5220\u9664\u6309\u94ae");
            this.btnRegister.put("save", "\u4fdd\u5b58\u6309\u94ae");
            this.btnRegister.put("moveUp", "\u4e0a\u79fb\u6309\u94ae");
            this.btnRegister.put("moveDown", "\u4e0b\u79fb\u6309\u94ae");
        }
        return this.btnRegister;
    }
}

