/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.beans.editor;

import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.DoubleValue;
import java.awt.Component;
import javax.swing.JFormattedTextField;

public class DoublePropertyEditor {
    protected JFormattedTextField fTxtField = new JFormattedTextField();
    protected Object lastGoodValue;
    private final Class type;

    public DoublePropertyEditor(Class type) {
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type must be a subclass of Number");
        }
        this.type = type;
        this.fTxtField.setValue(this.getDefaultValue());
    }

    public DoublePropertyEditor() {
        this(Double.class);
    }

    protected Object getDefaultValue() {
        try {
            return this.type.getConstructor(String.class).newInstance("0");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object getNumberByText() {
        String text = this.fTxtField.getText();
        if (text == null || text.trim().length() == 0) {
            return this.getDefaultValue();
        }
        text = text.replace(',', '.');
        StringBuffer number = new StringBuffer();
        number.ensureCapacity(text.length());
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char character = text.charAt(i);
            if ('.' == character || '-' == character || Double.class.equals((Object)this.type) && 'E' == character || Float.class.equals((Object)this.type) && 'E' == character || Character.isDigit(character)) {
                number.append(character);
                continue;
            }
            if (' ' != character) break;
        }
        try {
            this.lastGoodValue = this.type.getConstructor(String.class).newInstance(number.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastGoodValue;
    }

    public void setValue(Object value) {
        if (value instanceof DoubleValue) {
            Object v = ((DoubleValue)value).getValue();
            if (v != null) {
                this.fTxtField.setText(v.toString());
            } else {
                this.fTxtField.setText("");
            }
            this.lastGoodValue = v;
        } else {
            Object v = this.getDefaultValue();
            this.fTxtField.setText(v.toString());
            this.lastGoodValue = v;
        }
    }

    public Object getValue() {
        DoubleValue vfp = new DoubleValue();
        vfp.setValue((Double)this.getNumberByText());
        return vfp;
    }

    public Component getCustomEditor() {
        return this.fTxtField;
    }
}

