/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.panel;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumn;

public class HeaderlessColumnResizer
extends MouseInputAdapter {
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private int mouseXOffset;
    private Cursor otherCursor = resizeCursor;
    private JTable table;

    public HeaderlessColumnResizer(JTable table) {
        this.table = table;
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    private boolean canResize(TableColumn column) {
        return column != null && this.table.getTableHeader().getResizingAllowed() && column.getResizable();
    }

    private TableColumn getResizingColumn(Point p) {
        return this.getResizingColumn(p, this.table.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(Point p, int column) {
        if (column == -1) {
            return null;
        }
        int row = this.table.rowAtPoint(p);
        Rectangle r = this.table.getCellRect(row, column, true);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int valve = r.x + r.width / 20;
        int columnIndex = this.table.getTableHeader().getComponentOrientation().isLeftToRight() ? (p.x < valve ? column - 1 : (p.x > r.x + r.width - valve ? column : -1)) : (p.x < valve ? column : (p.x > r.x + r.width - valve ? column - 1 : -1));
        if (columnIndex == -1) {
            return null;
        }
        return this.table.getTableHeader().getColumnModel().getColumn(columnIndex);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TableColumn resizingColumn;
        this.table.getTableHeader().setDraggedColumn(null);
        this.table.getTableHeader().setResizingColumn(null);
        this.table.getTableHeader().setDraggedDistance(0);
        Point p = e.getPoint();
        int index = this.table.columnAtPoint(p);
        if (index != -1 && this.canResize(resizingColumn = this.getResizingColumn(p, index))) {
            this.table.getTableHeader().setResizingColumn(resizingColumn);
            this.mouseXOffset = this.table.getTableHeader().getComponentOrientation().isLeftToRight() ? p.x - resizingColumn.getWidth() : p.x + resizingColumn.getWidth();
        }
    }

    private void swapCursor() {
        Cursor tmp = this.table.getCursor();
        this.table.setCursor(this.otherCursor);
        this.otherCursor = tmp;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.canResize(this.getResizingColumn(e.getPoint())) != (this.table.getCursor() == resizeCursor)) {
            this.swapCursor();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int mouseX = e.getX();
        TableColumn resizingColumn = this.table.getTableHeader().getResizingColumn();
        boolean headerLeftToRight = this.table.getTableHeader().getComponentOrientation().isLeftToRight();
        if (resizingColumn != null) {
            Container container;
            int oldWidth = resizingColumn.getWidth();
            int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
            resizingColumn.setWidth(newWidth);
            if (this.table.getTableHeader().getParent() == null || (container = this.table.getTableHeader().getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                return;
            }
            if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight && this.table != null) {
                JViewport viewport = ((JScrollPane)container).getViewport();
                int viewportWidth = viewport.getWidth();
                int diff = newWidth - oldWidth;
                int newHeaderWidth = this.table.getWidth() + diff;
                Dimension tableSize = this.table.getSize();
                tableSize.width += diff;
                this.table.setSize(tableSize);
                if (newHeaderWidth >= viewportWidth && this.table.getAutoResizeMode() == 0) {
                    Point p = viewport.getViewPosition();
                    p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                    viewport.setViewPosition(p);
                    this.mouseXOffset += diff;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.table.getTableHeader().setResizingColumn(null);
        this.table.getTableHeader().setDraggedColumn(null);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

