/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.appmodel.DimensionViewRef;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionFactory;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.measure.MeasureDimensionMeta;
import com.kingdee.bos.bi.model.rt.fact.Fact;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AppModel
implements Serializable {
    private static final long serialVersionUID = -8932269381544171817L;
    private static final Logger log = LogUtil.getPackageLogger(AppModel.class);
    private AppModelView apv;
    private Map mapDimension;

    public AppModel(AppModelView apv, Context ctx) throws SQLException {
        this.apv = apv;
        this.mapDimension = new HashMap();
        DimensionViewRef dvr = apv.getDimRef();
        int len = dvr.getSize();
        for (int i = 0; i < len; ++i) {
            DimensionView dv = dvr.getDimensionView(i);
            String type = dv.getDimensionDef().getType();
            DimensionType dt = DimensionType.getObj(ctx, type);
            Dimension dim = DimensionFactory.createDimension(dt, this, ctx);
            this.mapDimension.put(type, dim);
        }
    }

    public Dimension getDimension(String type) {
        return (Dimension)this.mapDimension.get(type);
    }

    public String getId() {
        return this.apv.getId();
    }

    public AppModelView getAppModelView() {
        return this.apv;
    }

    public String getDBCenterId() {
        return this.apv.getDbCenterId();
    }

    public String getDBCenterName() {
        return this.apv.getDbCenterName();
    }

    public Dimension getMeasure() {
        return (Dimension)this.mapDimension.get("measure");
    }

    public String getPubnumber() {
        return this.apv.getPubnumber();
    }

    public DimensionType[] getDimTypes() {
        return this.getDimTypes(this.apv.getType());
    }

    public Map findInnerKey(Map mapBizKey, Connection cn) throws SQLException {
        HashMap<String, String> innerKeyMap = new HashMap<String, String>();
        Iterator it = mapBizKey.keySet().iterator();
        String pubnumber = this.getPubnumber();
        while (it.hasNext()) {
            String dimType = (String)it.next();
            DimensionView dv = this.apv.getDimRef().getDimensionView(dimType);
            Dimension dim = (Dimension)this.mapDimension.get(dimType);
            String bizKey = mapBizKey.get(dimType).toString();
            String innerKey = dim.findInnerKey(pubnumber, bizKey, cn);
            innerKeyMap.put(dimType, innerKey);
        }
        return innerKeyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryMeasuresByBizkey(String[] measures, Map mapParameter, Connection cn) throws SQLException {
        ArrayList<Object> lstRet = new ArrayList<Object>();
        if (measures == null || measures.length == 0) {
            return lstRet;
        }
        String orgNumber = (String)mapParameter.get("org");
        String metricNumber = (String)mapParameter.get("metric");
        int period = Integer.parseInt(((String)mapParameter.get("period")).trim());
        int year = Integer.parseInt(((String)mapParameter.get("year")).trim());
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        for (int i = 0; i < measures.length; ++i) {
            sb.append(MeasureDimensionMeta.getMeasureField(measures[i]));
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        String factTablename = Fact.getTablename(this.apv.getPubnumber());
        sb.append(" from " + factTablename);
        Dimension orgDim = (Dimension)this.mapDimension.get("org");
        String orgTablename = orgDim.getTablename();
        String bizKeyOrg = orgDim.getDimensionDef().getBizKey();
        String pKeyOrg = orgDim.getDimensionDef().getPK();
        Dimension metricDim = (Dimension)this.mapDimension.get("metric");
        String metricTablename = metricDim.getTablename();
        String bizKeyMetric = metricDim.getDimensionDef().getBizKey();
        String pKeyMetric = metricDim.getDimensionDef().getPK();
        sb.append(",");
        sb.append(orgTablename);
        sb.append(",");
        sb.append(metricTablename);
        sb.append(" where ");
        sb.append(orgTablename + "." + bizKeyOrg + "='" + orgNumber + "'");
        sb.append(" and ");
        sb.append(orgTablename + "." + pKeyOrg + "=" + factTablename + "." + orgDim.getDimensionDef().getFKFieldName());
        sb.append(" and ");
        sb.append(metricTablename + "." + bizKeyMetric + "='" + metricNumber + "'");
        sb.append(" and ");
        sb.append(metricTablename + "." + pKeyMetric + "=" + factTablename + "." + metricDim.getDimensionDef().getFKFieldName());
        sb.append(" and ");
        sb.append(DimensionMeta.getFKFieldName("period") + "=" + period);
        sb.append(" and ");
        sb.append(DimensionMeta.getFKFieldName("year") + "=" + year);
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sb.toString());
            rs = stmt.executeQuery(sb.toString());
            if (rs.next()) {
                int len = rs.getMetaData().getColumnCount();
                for (int i = 0; i < len; ++i) {
                    lstRet.add(rs.getObject(i + 1));
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return lstRet;
    }

    public Variant query(Map keyMap, Connection cn) throws SQLException {
        StringBuffer sb = new StringBuffer();
        String measureNumber = (String)keyMap.get("measure");
        sb.append("select " + MeasureDimensionMeta.getMeasureField(measureNumber));
        sb.append(" from " + Fact.getTablename(this.getPubnumber()));
        sb.append(" where ");
        Iterator it = this.mapDimension.keySet().iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            Dimension dim = (Dimension)this.mapDimension.get((String)it.next());
            if (dim.getDimensionDef().isMeasure()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(" and ");
            }
            String type = dim.getDimensionDef().getType();
            sb.append(DimensionMeta.getFKFieldName(type) + "=");
            sb.append(keyMap.get(type));
        }
        Object o = DBUtil.getRecord(sb.toString(), cn);
        if (o == null) {
            return null;
        }
        return new Variant(o);
    }

    public DimensionType[] getDimTypes(String appType) {
        if ("finance".equalsIgnoreCase(appType)) {
            return new DimensionType[]{DimensionType.org, DimensionType.metric, DimensionType.period, DimensionType.year, DimensionType.measure};
        }
        if ("common".equalsIgnoreCase(appType)) {
            ArrayList<DimensionType> list = new ArrayList<DimensionType>();
            AppModelView appModelView = this.getAppModelView();
            DimensionViewRef dimViewRef = appModelView.getDimRef();
            for (DimensionView dimView : dimViewRef.getDimensionViews()) {
                DimensionMeta dimMeta = dimView.getDimensionDef();
                DimensionType dimType = dimMeta.getDimensionType();
                list.add(dimType);
            }
            return list.toArray(new DimensionType[0]);
        }
        return null;
    }

    public RDRowSet getFirstRowDataByPeriod(Context ctx) {
        return this.getOneRowDataByPeriod(ctx, true);
    }

    public RDRowSet getLastRowDataByPeriod(Context ctx) {
        return this.getOneRowDataByPeriod(ctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RDRowSet getOneRowDataByPeriod(Context ctx, boolean isFirst) {
        DimensionView dvYear = this.apv.getDimRef().getDimensionView("year");
        if (dvYear == null) {
            return null;
        }
        DimensionView dvPeriod = this.apv.getDimRef().getDimensionView("period");
        if (dvPeriod == null) {
            return null;
        }
        Connection cn = null;
        try {
            cn = this.getJDBCConnection(ctx);
            StringBuffer sbSql = new StringBuffer();
            String fieldYear = dvYear.getDimensionDef().getFKFieldName();
            String fieldPeriod = dvPeriod.getDimensionDef().getFKFieldName();
            sbSql.append("select top 1 " + fieldYear);
            sbSql.append("," + fieldPeriod);
            sbSql.append(" from " + Fact.getTablename(this.apv.getPubnumber()));
            sbSql.append(" where " + fieldPeriod + "<100 ");
            String order = "";
            order = isFirst ? "asc" : "desc";
            sbSql.append(" order by " + fieldYear + " " + order + "," + fieldPeriod + " " + order);
            RDRowSet rDRowSet = DBUtil.executeQuery(sbSql.toString(), cn);
            return rDRowSet;
        }
        catch (SQLException sQLException) {
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return null;
    }

    private Connection getJDBCConnection(Context ctx) throws SQLException {
        return BISystem.getJdbcConnection((Context)ctx);
    }
}

