/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.calmember;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMemberFactory;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalculatorType;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class CalMember
extends Member {
    protected DimensionType dt;
    protected CalculatorType ct;
    protected Context ctx;
    protected String appmodelId;
    protected Dimension dim;
    private static final long serialVersionUID = 1L;

    public CalMember(Context ctx, String appmodelId, Dimension dim, String number, String name, DimensionType dt, CalculatorType ct) {
        super(number, name);
        this.ctx = ctx;
        this.appmodelId = appmodelId;
        this.dim = dim;
        this.dt = dt;
        this.ct = ct;
    }

    public Dimension getDim() {
        return this.dim;
    }

    public DimensionType getDimensionType() {
        return this.dt;
    }

    public CalculatorType getCalType() {
        return this.ct;
    }

    public String getSchema() {
        return "<xml >";
    }

    public String getAssignSet() {
        return null;
    }

    public String[] getRefCalMembers() {
        return null;
    }

    public abstract String toMDX();

    public abstract String toMDX(Dimension var1, Context var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalMember[] getCalMembers(Context ctx, String modelId, String dimType, String parent) {
        String sql = "select FCalName,FCalCaption,FCalType,FCalSchema from T_BI_AppModel_Cal where FAppModelID=? and FDimension=? ";
        Connection cn = null;
        ArrayList<CalMember> retMembers = new ArrayList<CalMember>();
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            RDRowSet rs = DBUtil.executeQuery(sql, new Object[]{modelId, dimType}, cn);
            while (rs.next()) {
                CalculatorType ct = CalculatorType.getObj(rs.getString("FCalType"));
                DimensionType dt = DimensionType.getObj(ctx, dimType);
                String schema = rs.getString("FCalSchema");
                CalMember cm = CalMemberFactory.createCalMember(null, null, null, rs.getString("FCalName"), rs.getString("FCalCaption"), dt, ct, schema);
                retMembers.add(cm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return retMembers.toArray(new CalMember[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalMember getCalMember(Context ctx, String modelId, String dimType, String parent, String calName) {
        String sql = "select FCalName,FCalCaption,FCalType,FCalSchema from T_BI_AppModel_Cal where FAppModelID=? and FDimension=? and FCalName=? ";
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            RDRowSet rs = DBUtil.executeQuery(sql, new Object[]{modelId, dimType, calName}, cn);
            if (rs.next()) {
                CalculatorType ct = CalculatorType.getObj(rs.getString("FCalType"));
                DimensionType dt = DimensionType.getObj(ctx, dimType);
                String schema = rs.getString("FCalSchema");
                CalMember calMember = CalMemberFactory.createCalMember(null, null, null, rs.getString("FCalName"), rs.getString("FCalCaption"), dt, ct, schema);
                return calMember;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return null;
    }
}

