/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.calmember.agg;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.bireport.DimensionSet;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalculatorType;
import com.kingdee.bos.bi.model.rt.bireport.calmember.agg.AggFunction;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.FormatString;
import com.kingdee.bos.bi.model.rt.dim.FormatStringUtil;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class AggCalMember
extends CalMember {
    private AggFunction af;
    private String asignSet;
    private int solveOrder;
    private FormatString formatString;
    private List advances;
    private String appModelType;

    public AggCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, String schema) {
        super(ctx, appmodelId, dim, name, caption, dt, CalculatorType.agg);
        try {
            this.fromXML(schema);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    public AggFunction getAggFunction() {
        return this.af;
    }

    @Override
    public String getAssignSet() {
        return this.asignSet;
    }

    public FormatString getFormatString() {
        return this.formatString;
    }

    public int getSolveOrder() {
        return this.solveOrder;
    }

    @Override
    public String toMDX(Dimension dim, Context ctx) {
        StringBuffer sb = new StringBuffer();
        try {
            Connection cn = BISystem.getJdbcConnection((Context)ctx);
            DimensionSet dimSet = new DimensionSet(dim, "", this.asignSet);
            sb.append(this.af.toMDX(dimSet.toMDX(ctx)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("'");
        sb.append(",solveOrder=" + this.solveOrder + "");
        if (this.formatString != null) {
            sb.append(",formatString='" + this.formatString.getName() + "'");
        }
        if (!StringUtil.isEmpty(this.name)) {
            sb.append(",caption='" + this.name + "'");
        }
        return sb.toString();
    }

    @Override
    public String toMDX() {
        StringBuffer sb = new StringBuffer();
        sb.append(" member [");
        sb.append(this.dt.getName() + "].[" + this.number);
        sb.append("] as '");
        try {
            Connection cn = BISystem.getJdbcConnection((Context)this.ctx);
            DimensionSet dimSet = new DimensionSet(this.dim, "", this.asignSet);
            sb.append(this.af.toMDX(dimSet.toMDX(this.ctx)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("'");
        sb.append(",solveOrder=" + this.solveOrder + "");
        if (this.formatString != null) {
            sb.append(",formatString='" + this.formatString.getName() + "'");
        }
        if (!StringUtil.isEmpty(this.name)) {
            sb.append(",caption='" + this.name + "'");
        }
        return sb.toString();
    }

    private void fromXML(String xml) throws IOException, JDOMException {
        if (StringUtil.isEmpty(xml)) {
            this.solveOrder = 0;
            this.asignSet = "";
            this.af = AggFunction.sum;
            this.formatString = FormatStringUtil.f1;
            return;
        }
        Element e = XmlUtil.toRootElement(xml);
        this.af = AggFunction.getObj(e.getAttributeValue("type"));
        this.asignSet = e.getAttributeValue("asign");
        this.solveOrder = 0;
        try {
            this.solveOrder = Integer.parseInt(e.getAttributeValue("solveOrder"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.appModelType = e.getAttributeValue("appModelType");
        this.formatString = FormatStringUtil.getObj(e.getAttributeValue("formatString"));
        List eles = e.getChildren("measure");
        if (eles == null || eles.size() > 0) {
            // empty if block
        }
    }

    @Override
    public String getSchema() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<Agg ");
        sb.append(" type=\"" + this.af.getName() + "\" ");
        sb.append(" asign=\"" + this.asignSet + "\" ");
        sb.append(" formatString=\"" + this.formatString + "\" ");
        sb.append(" appModelType=\"" + this.appModelType + "\" ");
        sb.append("solveOrder=\"" + this.solveOrder + "\" >");
        sb.append("</Agg>");
        return sb.toString();
    }
}

