/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.calmember.lastmonth;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.bireport.BIReportMDXUtils;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalculatorType;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.FormatString;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.ui.dialog.bireport.calmember.lastmonth.LastMonthDetailPanel;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class LastMonthCalMember
extends CalMember {
    private String calMode;
    private String calMeasure;
    private int solveOrder;
    private String formatString;
    private List advances;
    private String appModelType;

    public LastMonthCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, String schema) {
        super(ctx, appmodelId, dim, name, caption, dt, CalculatorType.lastMonth);
        try {
            this.fromXML(schema);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toMDX() {
        StringBuffer sb = new StringBuffer();
        sb.append(" member [");
        sb.append("Measures].[" + this.number);
        sb.append("] as '");
        sb.append(this.getMdx());
        sb.append("'");
        sb.append(",solveOrder=" + this.solveOrder + "");
        if (this.formatString != null) {
            sb.append(",formatString='" + this.formatString + "'");
        }
        if (!StringUtil.isEmpty(this.name)) {
            sb.append(",caption='" + this.name + "'");
        }
        return sb.toString();
    }

    private String getMdx() {
        StringBuffer sb = new StringBuffer();
        if (!"common".equalsIgnoreCase(this.appModelType)) {
            if ("Dif".equalsIgnoreCase(this.calMode)) {
                sb.append("(measures.[" + this.calMeasure + "])-(measures.[" + this.calMeasure + "],Period.PrevMember)");
            } else if ("Rate".equalsIgnoreCase(this.calMode)) {
                sb.append("(measures.[" + this.calMeasure + "]) / (measures.[" + this.calMeasure + "], Period.PrevMember)");
            } else if ("Growth".equalsIgnoreCase(this.calMode)) {
                sb.append("((measures.[" + this.calMeasure + "])-(measures.[" + this.calMeasure + "], Period.PrevMember) ) / (measures.[" + this.calMeasure + "], Period.PrevMember)");
            }
        } else {
            String mem = BIReportMDXUtils.addSquareBrackets(this.calMeasure);
            String timeDim = this.getTimeDim();
            if ("Dif".equalsIgnoreCase(this.calMode)) {
                sb.append("(measures." + mem + ")-(measures." + mem + "," + timeDim + ".PrevMember)");
            } else if ("Rate".equalsIgnoreCase(this.calMode)) {
                sb.append("(measures." + mem + ")/(measures." + mem + "," + timeDim + ".PrevMember)");
            } else if ("Growth".equalsIgnoreCase(this.calMode)) {
                sb.append("((measures." + mem + ")-(measures." + mem + "," + timeDim + ".PrevMember))/(measures." + mem + ",ParallelPeriod())");
            }
        }
        return sb.toString();
    }

    private String getTimeDim() {
        try {
            AppModelView views = AppModelView.fromDB(this.appmodelId, this.ctx);
            AppModel apm = new AppModel(views, this.ctx);
            int len = apm.getDimTypes().length;
            for (int i = 0; i < len; ++i) {
                String innerTime = apm.getDimTypes()[i].getInnerType();
                if (!"time".equalsIgnoreCase(innerTime)) continue;
                return apm.getDimTypes()[i].getName();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    private void fromXML(String xml) throws IOException, JDOMException {
        if (StringUtil.isEmpty(xml)) {
            this.solveOrder = 1;
            return;
        }
        Element e = XmlUtil.toRootElement(xml);
        this.calMode = e.getAttributeValue("calMode");
        this.calMeasure = e.getAttributeValue("calMeasure");
        this.appModelType = e.getAttributeValue("appModelType");
        this.formatString = e.getAttributeValue("formatString");
        this.solveOrder = 1;
        try {
            this.solveOrder = Integer.parseInt(e.getAttributeValue("solveOrder"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List eles = e.getChildren("measure");
        if (eles == null || eles.size() > 0) {
            // empty if block
        }
    }

    @Override
    public String getSchema() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        sb.append("");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<LastMonth");
        sb.append(" calMode=\"" + this.calMode + "\"");
        sb.append(" calMeasure=\"" + this.calMeasure + "\"");
        sb.append(" formatString=\"" + this.formatString + "\"");
        sb.append(" appModelType=\"" + this.appModelType + "\" ");
        sb.append(" solveOrder=\"" + this.solveOrder + "\" >");
        sb.append("</LastMonth>");
        return sb.toString();
    }

    public int getSolveOrder() {
        return this.solveOrder;
    }

    public int getCalMeasureIndex(LastMonthDetailPanel lastMonthDetailPanel) {
        int i = lastMonthDetailPanel.calMeasure.getItemCount();
        for (int y = 0; y < i; ++y) {
            Member measure = (Member)lastMonthDetailPanel.calMeasure.getItemAt(y);
            String number = measure.getNumber();
            if (!number.equals(this.calMeasure)) continue;
            return y;
        }
        return 0;
    }

    public int getFormatStringIndex(LastMonthDetailPanel lastMonthDetailPanel) {
        int i = lastMonthDetailPanel.cmbFormatString.getItemCount();
        for (int y = 0; y < i; ++y) {
            FormatString format = (FormatString)lastMonthDetailPanel.cmbFormatString.getItemAt(y);
            if (!format.getName().equals(this.formatString)) continue;
            return y;
        }
        return 0;
    }

    public int getCalModeIndex(LastMonthDetailPanel lastMonthDetailPanel) {
        int i = lastMonthDetailPanel.calMode.getItemCount();
        for (int y = 0; y < i; ++y) {
            EnumObj mode = (EnumObj)lastMonthDetailPanel.calMode.getItemAt(y);
            if (!mode.getName().equals(this.calMode)) continue;
            return y;
        }
        return 0;
    }

    @Override
    public String toMDX(Dimension dim, Context ctx) {
        return null;
    }
}

