/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim;

import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.DB.Field;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.Property;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class DimensionMeta
implements Serializable {
    private static final long serialVersionUID = 2592334274902252106L;
    protected DimensionType dt;
    private String bizKey;
    private boolean createInnerID;
    protected List fields;
    protected String index;
    protected List sortFields = new ArrayList();
    protected boolean isSortASC = true;
    protected List properties = new ArrayList();
    private static final String TABLE_PREFIX_DIM = "T_BI_D_";

    public List getSortFields() {
        return this.sortFields;
    }

    public boolean sortIsASC() {
        return this.isSortASC;
    }

    public DimensionType getDimensionType() {
        return this.dt;
    }

    public String toString() {
        return this.dt.getAlias();
    }

    public List getProperties() {
        return this.properties;
    }

    public String getNameField() {
        for (Property p : this.properties) {
            if (!p.getName().equalsIgnoreCase("name")) continue;
            return p.getField();
        }
        return null;
    }

    public Property findProperty(String propName) {
        if (this.properties == null) {
            return null;
        }
        for (Property prop : this.properties) {
            if (!prop.getName().equals(propName)) continue;
            return prop;
        }
        return null;
    }

    protected DimensionMeta(DimensionType dt, String bizKey, boolean createInnerID) {
        this.dt = dt;
        this.bizKey = bizKey;
        this.createInnerID = createInnerID;
    }

    public String getBizKey() {
        return this.bizKey;
    }

    public abstract String getParentNumber();

    protected boolean hasCreateInnerID() {
        return this.createInnerID;
    }

    public String getType() {
        return this.dt.getName();
    }

    public String getTypename() {
        return this.dt.getAlias();
    }

    private String getTypeNumber() {
        return this.dt.getNubmer();
    }

    public abstract List getFields();

    public String getPK() {
        if (this.hasCreateInnerID()) {
            return "FID";
        }
        return this.bizKey;
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexName(String pubNumber, int order) {
        if (this.dt.isInnerType()) {
            return "I" + this.getTypeNumber() + pubNumber;
        }
        return "P" + order + pubNumber;
    }

    public String getPKName(String pubNumber, int order) {
        if (this.dt.isInnerType()) {
            return "P" + this.getTypeNumber() + pubNumber;
        }
        return "P" + order + pubNumber;
    }

    public boolean isMeasure() {
        return this.dt.equals(DimensionType.measure);
    }

    public String getFKFieldName() {
        return DimensionMeta.getFKFieldName(this.dt.getName());
    }

    public static String getFKFieldName(String typename) {
        return "F" + typename + "ID";
    }

    public String getTablename(String pubnumber) {
        return DimensionMeta.getTablename(pubnumber, this.getType());
    }

    public static String getTablename(String pubnumber, String type) {
        return TABLE_PREFIX_DIM + pubnumber + "_" + type;
    }

    public String findFieldType(String fieldname) {
        if ("FID".equals(fieldname)) {
            return "int";
        }
        if (this.fields == null) {
            return null;
        }
        for (Field f : this.fields) {
            if (!fieldname.equals(f.name)) continue;
            return f.type;
        }
        return null;
    }

    protected String getIndexSql(String tablename, String pubNumber) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionMeta) {
            return ((DimensionMeta)obj).getDimensionType().equals(this.dt);
        }
        return false;
    }

    public void publish(String amId, String viewId, Connection cn) throws SQLException {
    }

    public void unPublish(String amId, Connection cn) throws SQLException {
        String sql = "delete from T_BI_AM_MetaData where FAMID='" + amId + "'";
        DBUtil.executeUpdate(sql, cn);
    }
}

