/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DimensionType
extends EnumObj
implements Serializable {
    private String number;
    private String innerType;
    public static final String TYPENAME_ORG = "org";
    public static final String TYPENAME_METRIC = "metric";
    public static final String TYPENAME_YEAR = "year";
    public static final String TYPENAME_PERIOD = "period";
    public static final String TYPENAME_MEASURE = "measure";
    public static final String INNERTYPE_TIME = "time";
    public static final String INNERTYPE_GENERALE = "general";
    public static final DimensionType org = new DimensionType("org", "\u7ec4\u7ec7", "001", null);
    public static final DimensionType metric = new DimensionType("metric", "\u6307\u6807", "002", null);
    public static final DimensionType year = new DimensionType("year", "\u5e74", "003", null);
    public static final DimensionType period = new DimensionType("period", "\u671f\u95f4", "004", null);
    public static final DimensionType measure = new DimensionType("measure", "\u5ea6\u91cf", "000", null);
    private static Map AllDT = new Hashtable();
    private static Map AllSystemDT = new Hashtable();
    private static final Logger log;
    private static final long serialVersionUID = 1493371126834889329L;

    public boolean isMeasure() {
        return measure.equals(this);
    }

    public boolean isTime() {
        return StringUtil.equalsIgnoreCase(INNERTYPE_TIME, this.getInnerType());
    }

    public boolean isGenerale() {
        return StringUtil.equalsIgnoreCase(INNERTYPE_GENERALE, this.getInnerType());
    }

    public boolean isFinance() {
        return org.equals(this) || metric.equals(this) || year.equals(this) || period.equals(this);
    }

    public String getMdxName() {
        return this.isMeasure() ? "measures" : this.getName();
    }

    public boolean isNameMatch(String str) {
        return StringUtil.equalsIgnoreCase(this.getName(), str);
    }

    public boolean isInnerType() {
        return StringUtils.isEmpty((String)this.innerType);
    }

    public static void add(DimensionType dt, Context ctx) {
        Map<String, DimensionType> mapDT;
        String key = ctx.getAIS();
        if (AllDT.containsKey(key)) {
            mapDT = (Map)AllDT.get(key);
        } else {
            mapDT = new Hashtable();
            AllDT.put(key, mapDT);
        }
        mapDT.put(dt.getName(), dt);
    }

    public static void del(DimensionType dt, Context ctx) {
        String key = ctx.getAIS();
        if (AllDT.containsKey(key)) {
            Map mapDT = (Map)AllDT.get(key);
            mapDT.remove(dt.getName());
        }
    }

    private DimensionType(String name, String alias, String number, String innerType) {
        super(name, alias);
        this.number = number;
        this.innerType = innerType;
    }

    public String getInnerType() {
        return this.innerType;
    }

    public static DimensionType[] getAll(Context ctx) {
        String key = ctx.getAIS();
        if (!AllDT.containsKey(key)) {
            return null;
        }
        Map mapDT = (Map)AllDT.get(key);
        Iterator it = mapDT.keySet().iterator();
        ArrayList lst = new ArrayList();
        while (it.hasNext()) {
            DimensionType dt = (DimensionType)it.next();
            lst.add(mapDT.get(dt));
        }
        return lst.toArray(new DimensionType[0]);
    }

    public String getNubmer() {
        return this.number;
    }

    @Override
    public int hashCode() {
        if (this.number != null) {
            return this.number.hashCode();
        }
        return this.getName().hashCode();
    }

    public static DimensionType getObj(Context ctx, String name) throws SQLException {
        Map mapDT;
        String key = ctx.getAIS();
        if (AllDT.containsKey(key)) {
            mapDT = (Map)AllDT.get(key);
        } else {
            mapDT = new Hashtable();
            AllDT.put(key, mapDT);
            mapDT.putAll(AllSystemDT);
            try {
                mapDT.putAll(DimensionType.getCustomDimensionType(ctx, null));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (!mapDT.containsKey(name)) {
            mapDT.putAll(DimensionType.getCustomDimensionType(ctx, name));
        }
        return (DimensionType)mapDT.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getCustomDimensionType(Context ctx, String number) throws SQLException {
        Hashtable<String, DimensionType> AllCustomDT = new Hashtable<String, DimensionType>();
        Connection con = BISystem.getJdbcConnection((Context)ctx);
        StringBuffer sb = new StringBuffer();
        sb.append("select FNumber,FName,FType from T_BI_MM_CUSTOM ");
        if (!StringUtil.isEmpty(number)) {
            sb.append("where FNumber='").append(number).append("' ");
        }
        sb.append("order by FLastUpdateTime desc");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(sb.toString());
            rs = stmt.executeQuery();
            String dtName = null;
            String dtAlias = null;
            String dtNumber = null;
            String dtInnerType = null;
            DimensionType dt = null;
            while (rs.next()) {
                dtName = rs.getString("FNumber");
                dtAlias = rs.getString("FName");
                dtInnerType = rs.getString("FType");
                dt = new DimensionType(dtName, dtAlias, dtNumber, dtInnerType);
                AllCustomDT.put(dtName, dt);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return AllCustomDT;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DimensionType) {
            DimensionType dt = (DimensionType)o;
            return this.getName().equals(dt.getName());
        }
        return false;
    }

    static {
        AllSystemDT.put(org.getName(), org);
        AllSystemDT.put(metric.getName(), metric);
        AllSystemDT.put(year.getName(), year);
        AllSystemDT.put(period.getName(), period);
        AllSystemDT.put(measure.getName(), measure);
        log = LogUtil.getPackageLogger(DimensionType.class);
    }
}

