/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dupont;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.dupont.DupontConfig;
import com.kingdee.bos.bi.model.common.dupont.DupontModel;
import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.exception.FormulaComputingException;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.CompositeExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.ConstantExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.ICompositeExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.VarExpr;
import com.kingdee.bos.bi.model.common.formularengine.oper.DualisticOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.IDualisticOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.IOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.IUnitaryOper;
import com.kingdee.bos.bi.model.common.list.ListUtil;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureDimensionNode;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureTreeModel;
import com.kingdee.bos.bi.model.common.mm.metric.MetricDimensionNode;
import com.kingdee.bos.bi.model.common.mm.metric.MetricModel;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.common.mm.period.PeriodDimensionNode;
import com.kingdee.bos.bi.model.common.mm.period.PeriodTreeModel;
import com.kingdee.bos.bi.model.common.mm.year.YearDimensionNode;
import com.kingdee.bos.bi.model.common.mm.year.YearTreeModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.metric.MetricDimensionMeta;
import com.kingdee.bos.bi.model.rt.dupont.MetricRtModel;
import com.kingdee.bos.bi.model.rt.dupont.RtTreeModel;
import com.kingdee.bos.bi.model.rt.dupont.RtTreeNode;
import com.kingdee.bos.bi.model.security.SecureUtil;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.ModelIOHelper;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.analysis.web.dupont.IDupontReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class DupontExecutor
implements IDupontReport {
    private static final Logger log = LogUtil.getPackageLogger(DupontExecutor.class);
    private static final String KEY_YEAR_CAPTION = "year_Caption";
    private static final String KEY_PERIOD_CAPTION = "period_Caption";
    private static final String KEY_ORG_CAPTION = "org_Caption";
    private static final String KEY_MEASURE_CAPTION = "measure_Caption";
    private static final String PARAM_PREDICT_STATUS = "predictStatus";
    private static final String PARAM_MEMBERS = "members";
    private static final String PARAM_DIMENSION = "dimension";
    private static final String PARAM_NODE_ID = "node";
    private static final String PARAM_MEASURE_NUMBER = "measures";
    private static final String PARAM_NEW_VALUE = "value";
    private static final String PARAM_RECOVER_VALUE = "recover";
    private String _repositoryPath;
    private DupontModel _model;
    private RtTreeModel _rtTreeModel;
    private Map _currentFilterValues = new HashMap();
    private Map _mapYearFilterTree;
    private Map _mapMeasureFilterTree;
    private Map _mapPeriodFilterTree;
    private Map _mapOrgFilterTree;
    private Map _mapYearFilter;
    private Map _mapPeriodFilter;
    private Map _mapOrgFilter;
    private Map _mapMeasureFilter;
    private Map _mapMeasureFormatString = new HashMap();

    public DupontExecutor(String dupontId, String repositoryPath, HttpServletRequest request) throws BIReportException {
        this._repositoryPath = repositoryPath;
        this._model = this.loadModel(request, dupontId);
    }

    private Connection getDBConnection(HttpServletRequest request) throws BIReportException {
        Connection conn;
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        try {
            conn = BISystem.getJdbcConnection((Context)ctx);
        }
        catch (SQLException e) {
            throw new BIReportException("Get connection error.", (Throwable)e);
        }
        return conn;
    }

    private DupontModel loadModel(HttpServletRequest request, String id) throws BIReportException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FName, FDPSchema, FAMID from ");
        sb.append(ListUtil.getViewTablename("dupont"));
        sb.append(" where FID='");
        sb.append(id);
        sb.append("'");
        String refAppModelId = null;
        String xml = null;
        Connection conn = null;
        Statement stam = null;
        ResultSet rs = null;
        try {
            conn = this.getDBConnection(request);
            stam = conn.createStatement();
            stam.execute(sb.toString());
            rs = stam.getResultSet();
            while (rs.next()) {
                refAppModelId = rs.getString("FAMID");
                xml = rs.getString("FDPSchema");
            }
        }
        catch (SQLException e) {
            try {
                throw new BIReportException("Load Dupont model error.", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stam, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stam, (Connection)conn);
        Element xmlRoot = null;
        if (null != xml) {
            try {
                xmlRoot = XmlUtil.loadXmlBytes((byte[])xml.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new BIReportException("Dupont model from xml error.", (Throwable)e);
            }
        }
        DupontModel model = new DupontModel();
        if (xmlRoot != null) {
            model.fromXml(xmlRoot);
        }
        model.setRefAppModel(refAppModelId);
        return model;
    }

    public String getRepositoryPath() {
        return this._repositoryPath;
    }

    private String[] initDefaultYear(HttpServletRequest request, AppModel appmodel) throws BIReportException {
        YearDimensionNode root;
        ModelIOHelper modelIOHelper = new ModelIOHelper(request);
        try {
            root = modelIOHelper.getRTYearTree(this._model.getRefAppModel());
        }
        catch (BIModelRemoteException e) {
            throw new BIReportException((Throwable)((Object)e));
        }
        String defaultValue = null;
        YearTreeModel year = this._model.getDefaultYear();
        if (year == DupontModel.DEFAULT_YEAR_NEW || year == null) {
            RDRowSet rs = appmodel.getLastRowDataByPeriod(BISystem.getContext((HttpServletRequest)request));
            if (rs.next()) {
                defaultValue = rs.getInt(0) + "";
            }
        } else {
            defaultValue = year.getNumber();
        }
        int len = root.getChildCount();
        boolean find = false;
        for (int i = 0; i < len; ++i) {
            YearDimensionNode child = root.getChild(i);
            if (!child.getYearModel().getNumber().equals(defaultValue)) continue;
            find = true;
            break;
        }
        if (!find) {
            YearDimensionNode lastChild = root.getChild(root.getChildCount() - 1);
            defaultValue = lastChild.getYearModel().getNumber();
        }
        HashMap mapYearFilter = new HashMap();
        HashMap mapYearFilterTree = new HashMap();
        DupontExecutor.keepTurbo(false, root, mapYearFilter, mapYearFilterTree);
        if (this._model.isShowYearFilter()) {
            this._mapYearFilterTree = mapYearFilterTree;
            this._mapYearFilter = mapYearFilter;
        }
        return new String[]{defaultValue, (String)mapYearFilter.get(defaultValue)};
    }

    private String[] initDefaultOrg(HttpServletRequest request) throws BIReportException {
        OrgDimensionNode root;
        ModelIOHelper modelIOHelper = new ModelIOHelper(request);
        try {
            root = modelIOHelper.getRTOrgTree(this._model.getRefAppModel());
        }
        catch (BIModelRemoteException e) {
            throw new BIReportException((Throwable)((Object)e));
        }
        if (root == null) {
            throw new BIReportException("\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7(\u53ef\u80fd\u662f\u65e0\u76f8\u5e94\u7684\u6743\u9650)\uff01");
        }
        OrgModel org = this._model.getDefaultOrg();
        String defaultValue = org == DupontModel.DEFAULT_ORG || org == null ? BISystem.getCurrentOrgUnit((HttpServletRequest)request).getNumber() : org.getNumber();
        if (!DupontExecutor.checkCurrentNodeExist(defaultValue, root)) {
            AbstractTreeNode defaultNode = this.getFirstNode(root);
            if (defaultNode != null) {
                defaultValue = defaultNode.getModel().getNumber();
            } else {
                throw new BIReportException("\u6ca1\u6709\u53ef\u7528\u7684\u7ec4\u7ec7\uff01");
            }
        }
        HashMap mapOrgFilter = new HashMap();
        HashMap mapOrgFilterTree = new HashMap();
        DupontExecutor.keepTurbo(true, root, mapOrgFilter, mapOrgFilterTree);
        if (this._model.isShowOrgFilter()) {
            this._mapOrgFilterTree = mapOrgFilterTree;
            this._mapOrgFilter = mapOrgFilter;
        }
        return new String[]{defaultValue, (String)mapOrgFilter.get(defaultValue)};
    }

    private String[] initDefaultPeriod(HttpServletRequest request, AppModel appmodel) throws BIReportException {
        PeriodDimensionNode root;
        ModelIOHelper modelIOHelper = new ModelIOHelper(request);
        try {
            root = modelIOHelper.getRTPeriodTree(this._model.getRefAppModel());
        }
        catch (BIModelRemoteException e) {
            throw new BIReportException((Throwable)((Object)e));
        }
        String defaultValue = null;
        PeriodTreeModel period = this._model.getDefaultPeriod();
        if (period == DupontModel.DEFAULT_PERIOD_NEW || period == null) {
            RDRowSet rs = appmodel.getLastRowDataByPeriod(BISystem.getContext((HttpServletRequest)request));
            if (rs.next()) {
                defaultValue = rs.getInt(1) + "";
            }
        } else {
            defaultValue = period.getNumber();
        }
        defaultValue = this.getAppropriatePeriod(defaultValue, root);
        if (defaultValue == null) {
            throw new BIReportException("\u6ca1\u6709\u53ef\u7528\u7684\u671f\u95f4\uff01");
        }
        HashMap mapPeriodFilter = new HashMap();
        HashMap mapPeriodFilterTree = new HashMap();
        DupontExecutor.keepTurbo(false, root, mapPeriodFilter, mapPeriodFilterTree);
        if (this._model.isShowPeriodFilter()) {
            this._mapPeriodFilterTree = mapPeriodFilterTree;
            this._mapPeriodFilter = mapPeriodFilter;
        }
        return new String[]{defaultValue, (String)mapPeriodFilter.get(defaultValue)};
    }

    private String getAppropriatePeriod(String period, PeriodDimensionNode root) {
        int i;
        try {
            int nPeriod;
            for (i = nPeriod = Integer.parseInt(period); i > 0; --i) {
                if (!this.checkPeriodExist(i + "", root)) continue;
                return i + "";
            }
        }
        catch (NumberFormatException nPeriod) {
            // empty catch block
        }
        AbstractTreeNode findNode = null;
        int c = root.getChildCount();
        for (i = 0; i < c && (findNode = this.getFirstNode(root.getChildNode(i))) == null; ++i) {
        }
        if (findNode != null) {
            PeriodTreeModel p = (PeriodTreeModel)findNode.getModel();
            return p.getNumber();
        }
        return null;
    }

    private boolean checkPeriodExist(String period, PeriodDimensionNode root) {
        int len = root.getChildCount();
        for (int i = 0; i < len; ++i) {
            PeriodDimensionNode child = root.getChild(i);
            if (child.isLeaf()) {
                if (!child.getPeriodModel().getNumber().equals(period)) continue;
                return true;
            }
            int len2 = child.getChildCount();
            for (int j = 0; j < len2; ++j) {
                PeriodDimensionNode period_child = child.getChild(j);
                if (!period_child.getPeriodModel().getNumber().equals(period)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] initDefaultMeasures(HttpServletRequest request) throws BIReportException {
        String defaultNames;
        String defaultNumbers;
        MeasureDimensionNode root;
        ModelIOHelper modelIOHelper = new ModelIOHelper(request);
        try {
            root = modelIOHelper.getRTMeasureTree(this._model.getRefAppModel());
        }
        catch (BIModelRemoteException e) {
            throw new BIReportException((Throwable)((Object)e));
        }
        HashMap mapMeasureFilter = new HashMap();
        HashMap mapMeasureFilterTree = new HashMap();
        DupontExecutor.keepTurbo(false, root, mapMeasureFilter, mapMeasureFilterTree);
        if (this._model.isShowMeasureFilter()) {
            this._mapMeasureFilterTree = mapMeasureFilterTree;
        }
        this._mapMeasureFilter = mapMeasureFilter;
        MeasureTreeModel[] measures = this._model.getDefaultMeasures();
        if (measures == null) {
            MeasureTreeModel mtm = root.getChild(0).getMeasureModel();
            defaultNumbers = mtm.getNumber();
            defaultNames = mtm.getName();
        } else {
            MeasureTreeModel[] mtms = this._model.getDefaultMeasures();
            StringBuffer sbNumbers = new StringBuffer();
            StringBuffer sbNames = new StringBuffer();
            boolean isFirst = true;
            int c = mtms.length;
            for (int i = 0; i < c; ++i) {
                String name = (String)mapMeasureFilter.get(mtms[i].getNumber());
                if (name == null) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sbNumbers.append("\u0001");
                    sbNames.append("\u0001");
                }
                sbNames.append(name);
                sbNumbers.append(mtms[i].getNumber());
            }
            if (isFirst) {
                MeasureTreeModel mtm = root.getChild(0).getMeasureModel();
                defaultNumbers = mtm.getNumber();
                defaultNames = mtm.getName();
            } else {
                defaultNumbers = sbNumbers.toString();
                defaultNames = sbNames.toString();
            }
        }
        return new String[]{defaultNumbers, defaultNames};
    }

    private static void keepTurbo(boolean isWithRoot, AbstractTreeNode node, Map mapKeepCaption, Map mapKeepParent) {
        if (isWithRoot || node.getParentNode() != null) {
            String name = node.getModel().getName();
            String number = node.getModel().getNumber();
            mapKeepCaption.put(number, name);
            String parnetNumber = isWithRoot ? (node.getParentNode() == null ? "" : node.getParentNode().getModel().getNumber()) : (node.getParentNode().getParentNode() == null ? "" : node.getParentNode().getModel().getNumber());
            ArrayList<AbstractTreeNode> list = (ArrayList<AbstractTreeNode>)mapKeepParent.get(parnetNumber);
            if (list == null) {
                list = new ArrayList<AbstractTreeNode>();
                mapKeepParent.put(parnetNumber, list);
            }
            list.add(node);
        }
        int c = node.getChildCount();
        for (int i = 0; i < c; ++i) {
            DupontExecutor.keepTurbo(isWithRoot, node.getChildNode(i), mapKeepCaption, mapKeepParent);
        }
    }

    private void keepMeasuresFormatString(AppModel appmodel, Connection cn) throws SQLException {
        String[] measures = (String[])this._currentFilterValues.get("measure");
        for (int i = 0; i < measures.length; ++i) {
            if (this._mapMeasureFormatString.containsKey(measures[i])) continue;
            Dimension dim = appmodel.getDimension("measure");
            String formatString = (String)dim.findProperty(measures[i], "FFormat", cn);
            this._mapMeasureFormatString.put(measures[i], formatString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(HttpServletRequest request, Map parameters) throws BIReportException {
        Connection cn = null;
        try {
            Context ctx = BISystem.getContext((HttpServletRequest)request);
            AppModel appmodel = new AppModel(AppModelView.fromDB(this._model.getRefAppModel(), ctx), ctx);
            cn = BISystem.getJdbcConnection((HttpServletRequest)request);
            String[] defaultYear = this.initDefaultYear(request, appmodel);
            String[] defaultPeriod = this.initDefaultPeriod(request, appmodel);
            String[] defaultOrg = this.initDefaultOrg(request);
            String[] defaultMeasure = this.initDefaultMeasures(request);
            this._currentFilterValues.put("year", defaultYear[0]);
            this._currentFilterValues.put(KEY_YEAR_CAPTION, defaultYear[1]);
            this._currentFilterValues.put("period", defaultPeriod[0]);
            this._currentFilterValues.put(KEY_PERIOD_CAPTION, defaultPeriod[1]);
            this._currentFilterValues.put("org", defaultOrg[0]);
            this._currentFilterValues.put(KEY_ORG_CAPTION, defaultOrg[1]);
            this._currentFilterValues.put("measure", defaultMeasure[0].split("\u0001"));
            this._currentFilterValues.put(KEY_MEASURE_CAPTION, defaultMeasure[1].split("\u0001"));
            this.keepMeasuresFormatString(appmodel, cn);
            HashMap idIndexer = new HashMap();
            List metricNodeList = new ModelIOHelper(request).getRTMetricList(appmodel.getId());
            RtTreeNode root = this.prepareModel(this._model.getMetricTree(), appmodel, cn, idIndexer, metricNodeList, ctx);
            this._rtTreeModel = new RtTreeModel(root, idIndexer);
            this._rtTreeModel.setSyncNodePairs(this._model.getSyncNodePairs());
            SQLUtils.cleanup((Connection)cn);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new BIReportException("", (Throwable)e);
            catch (SyntaxErrorException e2) {
                log.error((Object)"", (Throwable)e2);
                throw new BIReportException("", (Throwable)e2);
            }
            catch (BIModelRemoteException e3) {
                e3.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup(cn);
        }
        this._model.setMetricTree(null);
        this._model.clearAllSyncNodePairs();
        return this.makeResponse(request, parameters);
    }

    private RtTreeNode prepareModel(MetricDimensionNode designNode, AppModel appmodel, Connection cn, Map idIndexer, List metricNodeList, Context ctx) throws BIReportException, SQLException, SyntaxErrorException {
        AbstractExpr expr;
        String[] measures = (String[])this._currentFilterValues.get("measure");
        RtTreeNode rtNode = RtTreeNode.createVar(measures.length);
        MetricModel designMetric = designNode.getMetricModel();
        String metricNumber = designMetric.getNumber();
        idIndexer.put(metricNumber, rtNode);
        rtNode.setNumber(metricNumber);
        rtNode.setExpanded(Boolean.TRUE.equals(designMetric.getExtProps("expand")));
        rtNode.setPermission(DupontExecutor.checkCurrentNodeExist(metricNumber, metricNodeList));
        MetricRtModel rtMetric = rtNode.getModel();
        Dimension dim = appmodel.getDimension("metric");
        String metricName = (String)dim.findProperty(metricNumber, MetricDimensionMeta.getField("name"), cn);
        rtMetric.setCaption(metricName);
        String formatString = null;
        dim = appmodel.getDimension("metric");
        try {
            formatString = (String)dim.findProperty(metricNumber, "FFormat", cn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rtMetric.setFormatString(formatString);
        int c = measures.length;
        for (int i = 0; i < c; ++i) {
            String fs = formatString;
            if (StringUtil.isEmptyString((String)fs)) {
                fs = (String)this._mapMeasureFormatString.get(measures[i]);
            }
            MetricRtModel.Measure m = rtMetric.getMeasure(i);
            m.setFormatString(fs);
        }
        this.queryMeasures(rtNode, measures, appmodel, cn, false, ctx);
        dim = appmodel.getDimension("metric");
        String metricFormula = (String)dim.findProperty(metricNumber, MetricDimensionMeta.getField("formula"), cn);
        if (StringUtil.isEmptyString((String)metricFormula)) {
            return rtNode;
        }
        FormularParser fp = new FormularParser();
        try {
            expr = fp.parse(metricFormula);
        }
        catch (StringParsingException e) {
            log.error((Object)"DupontExecutor parse formula error.", (Throwable)e);
            return rtNode;
        }
        ArrayList subContents = new ArrayList();
        HashMap map = new HashMap();
        DupontExecutor.confirmChildren(expr, subContents, map);
        if (map.get("isCanShowBeanpod") != Boolean.FALSE && this.isCanShowBeanpod(designNode)) {
            rtNode.setBeanpod(true);
        }
        RtTreeNode rtChild = null;
        int c2 = subContents.size();
        for (int i = 0; i < c2; ++i) {
            Object sub = subContents.get(i);
            if (sub instanceof String) {
                rtChild = RtTreeNode.createSign((String)sub);
            } else if (sub instanceof BigDecimal) {
                rtChild = RtTreeNode.createConst();
                String id = String.valueOf(Math.random());
                idIndexer.put(id, rtChild);
                rtChild.setNumber(id);
                expr = this.changeConstToVar(expr, id);
                MetricRtModel.Measure m = rtChild.getModel().getMeasure(0);
                m.setOriDigital(new Variant((Object)((BigDecimal)sub)));
            } else {
                VarExpr varExpr = (VarExpr)sub;
                String key = varExpr.getVarName();
                if (key.startsWith("[") && key.endsWith("]")) {
                    key = key.substring(1, key.length() - 1);
                }
                boolean isBingo = false;
                int jc = designNode.getChildCount();
                for (int j = 0; j < jc; ++j) {
                    MetricDimensionNode childNode = designNode.getChild(j);
                    if (!key.equals(childNode.getMetricModel().getNumber())) continue;
                    rtChild = this.prepareModel(childNode, appmodel, cn, idIndexer, metricNodeList, ctx);
                    isBingo = true;
                    break;
                }
                if (!isBingo) {
                    throw new BIReportException("\u6307\u6807\u201c" + designMetric.getText4UI() + "\u201d\u7684\u516c\u5f0f\u4e2d\u5305\u542b" + varExpr.getVarName() + "\uff0c\u4f46\u672a\u5728\u5176\u5b50\u8282\u70b9\u4e2d\u53d1\u73b0\u3002\u53ef\u80fd\u539f\u56e0\u662f\u53d7\u6307\u6807\u7ef4\u5ea6\u4fee\u6539\u5f71\u54cd\u3002\u8bf7\u5236\u4f5c\u4eba\u5458\u91cd\u65b0\u6821\u9a8c\u675c\u90a6\u6a21\u578b\uff0c\u53ef\u80fd\u9700\u8981\u4fee\u6539\u6307\u6807\u7ef4\u5ea6\u3002");
                }
            }
            rtNode.addChild(rtChild);
        }
        rtMetric.setFormula(expr);
        return rtNode;
    }

    private AbstractExpr changeConstToVar(AbstractExpr expr, String var) {
        if (expr instanceof ConstantExpr) {
            return new VarExpr(var);
        }
        if (expr instanceof ICompositeExpr) {
            ICompositeExpr ce = (ICompositeExpr)((Object)expr);
            AbstractExpr result = this.changeConstToVar(ce.getLeftExpr(), var);
            if (result != null) {
                return new CompositeExpr(result, (IDualisticOper)ce.getOper(), ce.getRightExpr());
            }
            result = this.changeConstToVar(ce.getRightExpr(), var);
            if (result != null) {
                if (ce.getOper() instanceof IUnitaryOper) {
                    return new CompositeExpr((IUnitaryOper)ce.getOper(), result);
                }
                return new CompositeExpr(ce.getLeftExpr(), (IDualisticOper)ce.getOper(), result);
            }
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reQueryMeasures(HttpServletRequest request) throws BIReportException {
        String[] measures = (String[])this._currentFilterValues.get("measure");
        Connection cn = null;
        try {
            Context ctx = BISystem.getContext((HttpServletRequest)request);
            AppModel appmodel = new AppModel(AppModelView.fromDB(this._model.getRefAppModel(), ctx), ctx);
            cn = BISystem.getJdbcConnection((HttpServletRequest)request);
            this.keepMeasuresFormatString(appmodel, cn);
            this.queryMeasures(this._rtTreeModel.getRoot(), measures, appmodel, cn, true, ctx);
        }
        catch (SQLException e) {
            try {
                log.error((Object)"", (Throwable)e);
                throw new BIReportException("", (Throwable)e);
                catch (SyntaxErrorException e2) {
                    log.error((Object)"", (Throwable)e2);
                    throw new BIReportException("", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
    }

    private void queryMeasures(RtTreeNode rtNode, String[] measures, AppModel appmodel, Connection cn, boolean isDeep, Context ctx) throws SQLException, SyntaxErrorException {
        int i;
        MetricRtModel mrm = rtNode.getModel();
        this._currentFilterValues.put("metric", rtNode.getNumber());
        List values = appmodel.queryMeasuresByBizkey(measures, this._currentFilterValues, cn);
        for (i = 0; i < measures.length; ++i) {
            MetricRtModel.Measure m = mrm.getMeasure(i);
            String formatString = m.getFormatString();
            if (StringUtil.isEmptyString((String)formatString)) {
                formatString = mrm.getFormatString();
                if (StringUtil.isEmptyString((String)formatString)) {
                    formatString = (String)this._mapMeasureFormatString.get(measures[i]);
                }
                m.setFormatString(formatString);
            }
            Number value = null;
            if (values.size() > 0) {
                value = (Number)values.get(i);
                m.setOriDigital(new Variant((Object)value));
            } else {
                m.setOriDigital(null);
            }
            boolean isForbidden = false;
            try {
                isForbidden = SecureUtil.cellIsForbidden(value, ctx, appmodel, this._currentFilterValues, measures[i]);
            }
            catch (BIModelRemoteException e) {
                e.printStackTrace();
            }
            m.setForbidden(isForbidden);
        }
        if (isDeep && rtNode.getChildCount() > 0) {
            int c = rtNode.getChildCount();
            for (i = 0; i < c; ++i) {
                RtTreeNode child = rtNode.getChild(i);
                if (child.getType() != 3) continue;
                this.queryMeasures(child, measures, appmodel, cn, true, ctx);
            }
        }
    }

    private String makeResponse(HttpServletRequest request, Map parameters) throws BIReportException {
        String result;
        byte[] xmlBytes;
        String[] measures = (String[])this._currentFilterValues.get("measure");
        Element xmlRoot = new Element("DupontView");
        DupontConfig dc = this._model.getDupontConfig();
        if (dc == null) {
            dc = DupontConfig.createOldConfig();
        }
        xmlRoot.addContent((Content)dc.toXML());
        Element xmlView = new Element("View");
        for (int i = 0; i < measures.length; ++i) {
            Element xmlMeasure = new Element("Measure");
            xmlMeasure.addContent((String)this._mapMeasureFilter.get(measures[i]));
            xmlView.addContent((Content)xmlMeasure);
        }
        xmlRoot.addContent((Content)xmlView);
        Element rootMetric = this._rtTreeModel.toXml();
        xmlRoot.addContent((Content)rootMetric);
        try {
            xmlBytes = XmlUtil.saveXmlBytes((Element)xmlRoot);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
        try {
            result = new String(xmlBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result = new String(xmlBytes);
        }
        List conditions = this.createConditions();
        String uiid = (String)parameters.get("uiid");
        return this.wrapJson(conditions, uiid) + result;
    }

    private List createConditions() {
        ArrayList<Map> conditions = new ArrayList<Map>();
        conditions.add(this.createCondition("\u7ec4\u7ec7", "org", "single", String.valueOf(this._model.isShowOrgFilter()), this._currentFilterValues.get("org"), this._currentFilterValues.get(KEY_ORG_CAPTION)));
        conditions.add(this.createCondition("\u5ea6\u91cf", "measure", "multi", String.valueOf(this._model.isShowMeasureFilter()), this._currentFilterValues.get("measure"), this._currentFilterValues.get(KEY_MEASURE_CAPTION)));
        conditions.add(this.createCondition("\u5e74", "year", "single", String.valueOf(this._model.isShowYearFilter()), this._currentFilterValues.get("year"), this._currentFilterValues.get(KEY_YEAR_CAPTION)));
        conditions.add(this.createCondition("\u671f\u95f4", "period", "single", String.valueOf(this._model.isShowPeriodFilter()), this._currentFilterValues.get("period"), this._currentFilterValues.get(KEY_PERIOD_CAPTION)));
        return conditions;
    }

    private Map createCondition(String title, String dim, String type, String canChange, Object defaultValue, Object defaultCaption) {
        if (defaultValue instanceof String[]) {
            defaultValue = DupontExecutor.wrapMultiValue((String[])defaultValue);
        }
        if (defaultCaption instanceof String[]) {
            defaultCaption = DupontExecutor.wrapMultiValue((String[])defaultCaption);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        map.put(PARAM_DIMENSION, dim);
        map.put("type", type);
        map.put("canChange", canChange);
        map.put("defaultValue", defaultValue);
        map.put("defaultCaption", defaultCaption);
        return map;
    }

    private static String wrapMultiValue(String[] values) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append("\u0001");
            }
            sb.append(values[i]);
        }
        return sb.toString();
    }

    public boolean hasFilter(HttpServletRequest request) throws BIReportException {
        return false;
    }

    public BIReportFilter getFilter(HttpServletRequest request) throws BIReportException {
        return null;
    }

    public void close() {
    }

    public String service(HttpServletRequest request, String action, Map parameters) throws BIReportException {
        if ("refresh".equalsIgnoreCase(action)) {
            return this.makeResponse(request, parameters);
        }
        if ("getDimensionChildren".equalsIgnoreCase(action)) {
            return this.getDimensionChildren(request);
        }
        if ("changeDimensionMember".equalsIgnoreCase(action)) {
            this.changeDimensionMember(request);
            String uiid = (String)parameters.get("uiid");
            return uiid;
        }
        if ("submitTreeStatus".equalsIgnoreCase(action)) {
            this.commitTreeStatus(request);
            return "";
        }
        if ("changeValue".equalsIgnoreCase(action)) {
            this.changeValue(request);
            String uiid = (String)parameters.get("uiid");
            return uiid;
        }
        throw new BIReportException("\u672a\u77e5\u8bf7\u6c42\uff1a" + action);
    }

    private void commitTreeStatus(HttpServletRequest request) {
        String status = request.getParameter("treeStatus");
        String[] numbers = status.split("\u0001");
        ArrayList<String> listNumbers = new ArrayList<String>();
        int c = numbers.length;
        for (int i = 0; i < c; ++i) {
            listNumbers.add(numbers[i]);
        }
        this._rtTreeModel.updateExpandedStatus(listNumbers);
    }

    private String getDimensionChildren(HttpServletRequest request) throws BIReportException {
        Map mapTree;
        String parentNumber;
        String dim = request.getParameter(PARAM_DIMENSION);
        String nodeValue = request.getParameter("nodeValue");
        String string = parentNumber = nodeValue == null ? "" : nodeValue;
        if ("org".equalsIgnoreCase(dim)) {
            mapTree = this._mapOrgFilterTree;
        } else if ("measure".equalsIgnoreCase(dim)) {
            mapTree = this._mapMeasureFilterTree;
        } else if ("year".equalsIgnoreCase(dim)) {
            mapTree = this._mapYearFilterTree;
        } else if ("period".equalsIgnoreCase(dim)) {
            mapTree = this._mapPeriodFilterTree;
        } else {
            throw new BIReportException("Invalid dimension.");
        }
        return this.getDimensionChildren(dim, parentNumber, mapTree);
    }

    private String getDimensionChildren(String dim, String parentNumber, Map mapTree) {
        StringBuffer sb = new StringBuffer();
        List children = (List)mapTree.get(parentNumber);
        int c = children.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append("\u0001");
            }
            AbstractTreeNode node = (AbstractTreeNode)children.get(i);
            AbstractMainModel model = node.getModel();
            sb.append(dim);
            sb.append("\u0001");
            sb.append(model.getName());
            sb.append("\u0001");
            sb.append(model.getName() + (node.canSelect() ? "" : "(\u65e0\u6743\u67e5\u770b)"));
            sb.append("\u0001");
            sb.append(model.getNumber());
            sb.append("\u0001");
            sb.append(mapTree.containsKey(model.getNumber()) ? "0" : "1");
            sb.append("\u0001");
            sb.append(node.canSelect() ? "1" : "0");
        }
        return sb.toString();
    }

    private void changeDimensionMember(HttpServletRequest request) throws BIReportException {
        Object caption;
        String[] number;
        Map captionMap;
        String captionKey;
        String dim = request.getParameter(PARAM_DIMENSION);
        String[] members = request.getParameterValues(PARAM_MEMBERS);
        boolean predict = "true".equalsIgnoreCase(request.getParameter(PARAM_PREDICT_STATUS));
        boolean isMultiValue = false;
        boolean isToUpdateModel = false;
        if ("org".equalsIgnoreCase(dim)) {
            captionKey = KEY_ORG_CAPTION;
            captionMap = this._mapOrgFilter;
        } else if ("measure".equalsIgnoreCase(dim)) {
            captionKey = KEY_MEASURE_CAPTION;
            captionMap = this._mapMeasureFilter;
            isMultiValue = true;
            isToUpdateModel = true;
        } else if ("year".equalsIgnoreCase(dim)) {
            captionKey = KEY_YEAR_CAPTION;
            captionMap = this._mapYearFilter;
        } else if ("period".equalsIgnoreCase(dim)) {
            captionKey = KEY_PERIOD_CAPTION;
            captionMap = this._mapPeriodFilter;
        } else {
            throw new BIReportException("Invalid dimension.");
        }
        if (isMultiValue) {
            String[] captions = new String[members.length];
            int c = members.length;
            for (int i = 0; i < c; ++i) {
                captions[i] = (String)captionMap.get(members[i]);
            }
            number = members;
            caption = captions;
        } else {
            number = members[0];
            caption = captionMap.get(number);
        }
        this._currentFilterValues.put(dim, number);
        this._currentFilterValues.put(captionKey, caption);
        if (isToUpdateModel) {
            this._rtTreeModel.resetMeasures(members.length);
        }
        this.reQueryMeasures(request);
        if (predict) {
            try {
                this._rtTreeModel.reCalculate();
            }
            catch (FormulaComputingException e) {
                log.error((Object)"", (Throwable)e);
                throw new BIReportException((Throwable)e);
            }
        }
    }

    private void changeValue(HttpServletRequest request) throws BIReportException {
        String nodeId = request.getParameter(PARAM_NODE_ID);
        String measure = request.getParameter(PARAM_MEASURE_NUMBER);
        String strValue = request.getParameter(PARAM_NEW_VALUE);
        String strRecover = request.getParameter(PARAM_RECOVER_VALUE);
        int measureIdx = new BigDecimal(measure).intValue();
        if (Boolean.valueOf(strRecover).booleanValue()) {
            this._rtTreeModel.clearPredictValue(nodeId, measureIdx);
        } else {
            BigDecimal value;
            try {
                value = new BigDecimal(strValue);
            }
            catch (NumberFormatException ex) {
                log.error((Object)"", (Throwable)ex);
                return;
            }
            this._rtTreeModel.setPredictValue(nodeId, measureIdx, value);
        }
        try {
            this._rtTreeModel.reCalculate();
        }
        catch (FormulaComputingException e) {
            log.error((Object)"", (Throwable)e);
            throw new BIReportException((Throwable)e);
        }
    }

    private String wrapJson(List lstConditions, String uiid) {
        StringBuffer sb = new StringBuffer();
        for (Map map : lstConditions) {
            sb.append("json{");
            sb.append("uiid:" + uiid + ",");
            sb.append("title:'" + map.get("title") + "',");
            sb.append("dimension:'" + map.get(PARAM_DIMENSION) + "',");
            sb.append("type:'" + map.get("type") + "',");
            sb.append("canChange:'" + map.get("canChange") + "',");
            sb.append("defaultValue:'" + map.get("defaultValue") + "',");
            sb.append("defaultCaption:'" + map.get("defaultCaption") + "'");
            sb.append("}json:end");
            sb.append(" ");
        }
        sb.append(" ");
        return sb.toString();
    }

    private static void confirmChildren(AbstractExpr expr, List result, Map extResult) {
        if (expr instanceof ICompositeExpr) {
            AbstractExpr left;
            ICompositeExpr ce = (ICompositeExpr)((Object)expr);
            IOper op = ce.getOper();
            if (op != DualisticOper.PLUS) {
                extResult.put("isCanShowBeanpod", Boolean.FALSE);
            }
            if ((left = ce.getLeftExpr()) != null) {
                boolean bracketLeftExpr = false;
                if (left instanceof ICompositeExpr && ((ICompositeExpr)((Object)left)).getOper().getPriority() < op.getPriority()) {
                    DupontExecutor.appendString(result, "(");
                    bracketLeftExpr = true;
                }
                DupontExecutor.confirmChildren(left, result, extResult);
                if (bracketLeftExpr) {
                    DupontExecutor.appendString(result, ")");
                }
            }
            DupontExecutor.appendString(result, op.getDisplayString());
            AbstractExpr right = ce.getRightExpr();
            boolean bracketRightExpr = false;
            if (right instanceof ICompositeExpr && ((ICompositeExpr)((Object)right)).getOper().getPriority() < op.getPriority()) {
                bracketRightExpr = true;
                DupontExecutor.appendString(result, "(");
            }
            DupontExecutor.confirmChildren(right, result, extResult);
            if (bracketRightExpr) {
                DupontExecutor.appendString(result, ")");
            }
        } else if (expr instanceof ConstantExpr) {
            result.add(((ConstantExpr)expr).getValue());
        } else {
            result.add(expr);
        }
    }

    private static void appendString(List list, String str) {
        if (list.size() == 0) {
            list.add(str);
        } else {
            int lastIdx = list.size() - 1;
            Object last = list.get(lastIdx);
            if (last instanceof String) {
                list.set(lastIdx, (String)last + " " + str);
            } else {
                list.add(str);
            }
        }
    }

    private static boolean checkCurrentNodeExist(String number, AbstractTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node.canSelect() && StringUtil.equals((String)number, (String)node.getModel().getNumber())) {
            return true;
        }
        int c = node.getChildCount();
        for (int i = 0; i < c; ++i) {
            if (!DupontExecutor.checkCurrentNodeExist(number, node.getChildNode(i))) continue;
            return true;
        }
        return false;
    }

    private AbstractTreeNode getFirstNode(AbstractTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.canSelect()) {
            return node;
        }
        AbstractTreeNode findNode = null;
        int c = node.getChildCount();
        for (int i = 0; i < c; ++i) {
            findNode = this.getFirstNode(node.getChildNode(i));
            if (findNode == null) continue;
            return findNode;
        }
        return findNode;
    }

    private static boolean checkCurrentNodeExist(String number, List nodeList) {
        if (nodeList == null) {
            return false;
        }
        for (AbstractTreeNode node : nodeList) {
            if (node == null || !StringUtil.equals((String)number, (String)node.getModel().getNumber())) continue;
            return true;
        }
        return false;
    }

    public String getPropValue(String prop_name) {
        if ("tilte".equalsIgnoreCase(prop_name)) {
            return this._model.getTitle() == null ? "" : this._model.getTitle();
        }
        return null;
    }

    private boolean isCanShowBeanpod(MetricDimensionNode designNode) {
        int c = designNode.getChildCount();
        for (int i = 0; i < c; ++i) {
            MetricDimensionNode child = designNode.getChild(i);
            if (child.getChildCount() <= 0) continue;
            return false;
        }
        return true;
    }
}

