/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dupont;

import com.kingdee.bos.bi.model.common.dupont.DupontModel;
import com.kingdee.bos.bi.model.common.formularengine.FormularEngine;
import com.kingdee.bos.bi.model.common.formularengine.IVarValueProvider;
import com.kingdee.bos.bi.model.common.formularengine.exception.FormulaComputingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.ICompositeExpr;
import com.kingdee.bos.bi.model.rt.dupont.MetricRtModel;
import com.kingdee.bos.bi.model.rt.dupont.RtTreeNode;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

class RtTreeModel {
    private RtTreeNode _root;
    private Map _idIndexer;
    private DupontModel.SyncNodePair[] _syncNodePairs;
    private List _currentNodeIds;
    private int _currentMeasureIdx;

    public RtTreeModel(RtTreeNode root, Map idIndexer) {
        this._root = root;
        this._idIndexer = idIndexer;
    }

    public void setSyncNodePairs(DupontModel.SyncNodePair[] syncNodePairs) {
        this._syncNodePairs = syncNodePairs;
    }

    private String[] getSyncNodeNumbers(String metricNumber) {
        if (this._syncNodePairs == null) {
            return null;
        }
        int c = this._syncNodePairs.length;
        for (int i = 0; i < c; ++i) {
            String[] others = this._syncNodePairs[i].getOthers(metricNumber);
            if (others == null) continue;
            return others;
        }
        return null;
    }

    public RtTreeNode getRoot() {
        return this._root;
    }

    public void setPredictValue(String id, int measureIdx, BigDecimal value) {
        this.changePredictValue(id, measureIdx, value, false);
    }

    public void clearPredictValue(String id, int measureIdx) {
        this.changePredictValue(id, measureIdx, null, true);
    }

    private List findTreeNodes(String id) {
        ArrayList lstRet = new ArrayList();
        this.findTreeNodesX(this._root, lstRet, id);
        return lstRet;
    }

    private void findTreeNodesX(RtTreeNode node, List lstRet, String id) {
        if (id.equals(node.getNumber())) {
            lstRet.add(node);
        }
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            RtTreeNode childNode = node.getChild(i);
            if (childNode.getChildCount() > 0) {
                this.findTreeNodesX(childNode, lstRet, id);
                continue;
            }
            if (!id.equals(childNode.getNumber())) continue;
            lstRet.add(childNode);
        }
    }

    private void changePredictValue(String id, int measureIdx, BigDecimal value, boolean isClear) {
        RtTreeNode node = (RtTreeNode)this._idIndexer.get(id);
        this._currentMeasureIdx = node.getType() == 2 ? -1 : measureIdx;
        this._currentNodeIds = new ArrayList();
        this._currentNodeIds.add(id);
        String[] syncs = this.getSyncNodeNumbers(id);
        if (syncs != null) {
            this._currentNodeIds.addAll(Arrays.asList(syncs));
        }
        int c = this._currentNodeIds.size();
        for (int i = 0; i < c; ++i) {
            List lstRtTreeNode = this.findTreeNodes((String)this._currentNodeIds.get(i));
            int len = lstRtTreeNode.size();
            for (int j = 0; j < len; ++j) {
                node = (RtTreeNode)lstRtTreeNode.get(j);
                if (isClear) {
                    if (measureIdx == -1) {
                        int measureCount = this._root.getModel().getMeasureCount();
                        for (int idx = 0; idx < measureCount; ++idx) {
                            node.getModel().getMeasure(idx).clearChangeState();
                        }
                    } else {
                        node.getModel().getMeasure(measureIdx).clearChangeState();
                    }
                } else {
                    node.getModel().getMeasure(measureIdx).setEditingDigital(value);
                }
                this.clearDescendant(node);
            }
        }
    }

    public void reCalculate() throws FormulaComputingException {
        int measureIdxTo;
        int measureIdxFrom;
        if (this._currentNodeIds == null) {
            return;
        }
        if (this._currentMeasureIdx == -1) {
            measureIdxFrom = 0;
            measureIdxTo = this._root.getModel().getMeasureCount() - 1;
        } else {
            measureIdxFrom = this._currentMeasureIdx;
            measureIdxTo = this._currentMeasureIdx;
        }
        for (int measureIdx = measureIdxFrom; measureIdx <= measureIdxTo; ++measureIdx) {
            FormularEngine formularEngine = new FormularEngine();
            formularEngine.setVarValueProvider(new CalculateAux(measureIdx));
            for (String id : this._currentNodeIds) {
                List lstRtTreeNodes = this.findTreeNodes(id);
                int len = lstRtTreeNodes.size();
                for (int i = 0; i < len; ++i) {
                    RtTreeNode node = (RtTreeNode)lstRtTreeNodes.get(i);
                    while (node.getParent() != null) {
                        node = node.getParent();
                        AbstractExpr expr = node.getModel().getFormula();
                        this.clearFormulaExprReturnValue(expr);
                        MetricRtModel.Measure m = node.getModel().getMeasure(measureIdx);
                        if (this.isAnyChildrenChanged(node, measureIdx)) {
                            Variant formulaResult = formularEngine.calculate(expr);
                            m.setDigitalCalculated(formulaResult);
                            continue;
                        }
                        m.clearChangeState();
                    }
                }
            }
        }
    }

    private void clearDescendant(RtTreeNode node) {
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            RtTreeNode child = node.getChild(i);
            if (child.getType() == 2) {
                child.getModel().getMeasure(0).clearChangeState();
            }
            if (child.getType() != 3) continue;
            if (this._currentMeasureIdx == -1) {
                int measureCount = child.getModel().getMeasureCount();
                for (int idx = 0; idx < measureCount; ++idx) {
                    child.getModel().getMeasure(idx).clearChangeState();
                }
            } else {
                child.getModel().getMeasure(this._currentMeasureIdx).clearChangeState();
            }
            this.clearDescendant(child);
        }
    }

    private boolean isAnyChildrenChanged(RtTreeNode node, int targetMeasureIdx) {
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            MetricRtModel.Measure m;
            int measureIdx = targetMeasureIdx;
            RtTreeNode child = node.getChild(i);
            if (child.getType() == 1) continue;
            if (child.getType() == 2) {
                measureIdx = 0;
            }
            if ((m = node.getChild(i).getModel().getMeasure(measureIdx)).getChangeState() == 0) continue;
            return true;
        }
        return false;
    }

    private void clearFormulaExprReturnValue(AbstractExpr expr) {
        expr.makeReturnValueUnsure();
        if (expr instanceof ICompositeExpr) {
            ICompositeExpr ce = (ICompositeExpr)((Object)expr);
            this.clearFormulaExprReturnValue(ce.getLeftExpr());
            this.clearFormulaExprReturnValue(ce.getRightExpr());
        }
    }

    public Element toXml() {
        return this.buildXml(this._root);
    }

    private Element buildXml(RtTreeNode rtNode) {
        int i;
        MetricRtModel rtMetric = rtNode.getModel();
        boolean isConst = rtNode.getType() == 2;
        Element xmlMetric = new Element("Metric");
        xmlMetric.setAttribute("number", rtNode.getNumber());
        if (!isConst && !rtNode.isExpanded()) {
            xmlMetric.setAttribute("expanded", "false");
        }
        if (!rtNode.hasPermission()) {
            xmlMetric.setAttribute("permission", "false");
        }
        Element xmlItem = new Element("Item");
        xmlMetric.addContent((Content)xmlItem);
        if (isConst) {
            xmlItem.setAttribute("constant", "true");
        } else {
            Element xmlCaption = new Element("Caption");
            xmlItem.addContent((Content)xmlCaption);
            xmlCaption.setText(rtMetric.getCaption());
        }
        Element xmlValues = new Element("Values");
        xmlItem.addContent((Content)xmlValues);
        int c = rtMetric.getMeasureCount();
        for (i = 0; i < c; ++i) {
            String unit;
            String digital;
            String ori;
            Element xmlValue = new Element("Value");
            xmlValues.addContent((Content)xmlValue);
            MetricRtModel.Measure m = rtMetric.getMeasure(i);
            if (m.getText() != null) {
                xmlValue.setText(m.getText());
            }
            if ((ori = m.getEditingOriDigital()) != null) {
                xmlValue.setAttribute("ori", ori);
            }
            if ((digital = m.getEditingDigital()) != null) {
                xmlValue.setAttribute("digital", digital);
            }
            if ((unit = m.getUnitText()) != null) {
                xmlValue.setAttribute("unit", unit);
            }
            int changeState = m.getChangeState();
            switch (changeState) {
                case 1: {
                    xmlValue.setAttribute("changed", "edited");
                    break;
                }
                case 2: {
                    xmlValue.setAttribute("changed", "calculated");
                    break;
                }
            }
            if (m.isForbidden()) {
                xmlValue.setAttribute("forbidden", "true");
                continue;
            }
            xmlValue.setAttribute("forbidden", "false");
        }
        int childrenCount = rtNode.getChildCount();
        if (childrenCount > 0) {
            Element xmlChildren = new Element("Children");
            if (rtNode.isBeanpod()) {
                xmlChildren.setAttribute("beanpod", "true");
            }
            xmlMetric.addContent((Content)xmlChildren);
            for (i = 0; i < childrenCount; ++i) {
                RtTreeNode sub = rtNode.getChild(i);
                if (sub.getType() == 1) {
                    Element xmlSign = new Element("Sign");
                    xmlSign.addContent(sub.getSign().getText());
                    xmlChildren.addContent((Content)xmlSign);
                    continue;
                }
                xmlChildren.addContent((Content)this.buildXml(sub));
            }
        }
        return xmlMetric;
    }

    public void updateExpandedStatus(List unExpandedNodes) {
        for (RtTreeNode node : this._idIndexer.values()) {
            if (node.getType() != 3 || node.getChildCount() <= 0) continue;
            node.setExpanded(!unExpandedNodes.contains(node.getNumber()));
        }
    }

    public void resetMeasures(int measureCount) {
        for (RtTreeNode node : this._idIndexer.values()) {
            if (node.getType() == 3) {
                node.getModel().reset(measureCount);
                continue;
            }
            if (node.getType() != 2) continue;
            node.getModel().getMeasure(0).clearChangeState();
        }
    }

    private class CalculateAux
    implements IVarValueProvider {
        private int targetMeasureIdx;

        public CalculateAux(int measureIdx) {
            this.targetMeasureIdx = measureIdx;
        }

        @Override
        public AbstractExpr getFormula(String key) {
            return null;
        }

        @Override
        public Variant getValue(String key) throws FormulaComputingException {
            if (key.startsWith("[") && key.endsWith("]")) {
                key = key.substring(1, key.length() - 1);
            }
            RtTreeNode node = (RtTreeNode)RtTreeModel.this._idIndexer.get(key);
            int measureIdx = this.targetMeasureIdx;
            if (node.getType() == 2) {
                measureIdx = 0;
            }
            Variant value = node.getModel().getMeasure(measureIdx).getDigitalForCalculate();
            return value;
        }
    }
}

