/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.rt.dim.Property;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Operator
extends EnumObj
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String METHOD_SEL_SIGNLE = "single";
    public static String METHOD_SEL_MULTI = "multi";
    public static String METHOD_INPUT = "input";
    public static final Operator equals = new Operator("=", "\u7b49\u4e8e");
    public static final Operator less = new Operator("<", "\u5c0f\u4e8e");
    public static final Operator above = new Operator(">", "\u5927\u4e8e");
    public static final Operator lessEquals = new Operator("<=", "\u5c0f\u4e8e\u7b49\u4e8e");
    public static final Operator aboveEquals = new Operator(">=", "\u5927\u4e8e\u7b49\u4e8e");
    public static final Operator include = new Operator("in", "\u5305\u62ec", METHOD_SEL_MULTI, false);
    public static final Operator notInclude = new Operator("not in", "\u4e0d\u5305\u62ec", METHOD_SEL_MULTI, false);
    public static final Operator like = new Operator("like", "\u7c7b\u4f3c\u4e8e", METHOD_INPUT, false);
    public static final Operator llike = new Operator("llike", "\u5de6\u7c7b\u4f3c", METHOD_INPUT, false);
    public static final Operator rlike = new Operator("rlike", "\u53f3\u7c7b\u4f3c", METHOD_INPUT, false);
    private boolean isOprNumeric;
    private String method;
    private static ArrayList AllObjs = new ArrayList();

    public Operator(String name, String alias, String method, boolean isOprNumeric) {
        super(name, alias);
        this.method = method;
        this.isOprNumeric = isOprNumeric;
    }

    public Operator(String name, String alias) {
        this(name, alias, METHOD_SEL_SIGNLE, true);
    }

    public Object clone() {
        return new Operator(this.getName(), this.getAlias(), this.method, this.isOprNumeric);
    }

    public String toSql(Context ctx, Property prop, Object value) {
        StringBuffer sb = new StringBuffer();
        String sOP = "";
        if (!"decimal".equals(prop.getDataType()) && !"int".equals(prop.getDataType())) {
            if ("nvarchar".equals(prop.getDataType())) {
                sOP = "'";
            } else if ("datetime".equals(prop.getDataType())) {
                sOP = "{";
            }
        }
        StringBuffer sbValue = new StringBuffer();
        if (value instanceof List) {
            Iterator it = ((List)value).iterator();
            boolean isFirst = true;
            while (it.hasNext()) {
                Object n;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sbValue.append(",");
                }
                Object userObj = ((DefaultKingdeeTreeNode)it.next()).getUserObject();
                String number = "";
                if (userObj instanceof AbstractTreeNode) {
                    n = (AbstractTreeNode)userObj;
                    number = n.getModel().getNumber();
                } else if (userObj instanceof Member) {
                    n = (Member)userObj;
                    number = ((Member)n).getNumber();
                }
                sbValue.append(sOP);
                sbValue.append(number);
                sbValue.append(sOP);
            }
        } else {
            sbValue.append(sOP);
            sbValue.append(value);
            sbValue.append(sOP);
        }
        String opr = this.getName();
        if ("=".equals(opr) || "<".equals(opr) || ">".equals(opr) || "<=".equals(opr) || ">=".equals(opr)) {
            sb.append(prop.getField());
            sb.append(opr);
            sb.append(sbValue.toString());
        } else if ("in".equals(opr) || "not in".equals(opr)) {
            sb.append(prop.getField());
            sb.append(" ");
            sb.append(opr);
            sb.append("(");
            sb.append(sbValue.toString());
            sb.append(")");
        } else if ("like".equals(opr)) {
            sb.append("charindex(");
            sb.append(prop.getField());
            sb.append(",");
            sb.append(sbValue.toString());
            sb.append(")>0");
        } else if ("llike".equals(opr)) {
            sb.append("charindex(");
            sb.append(prop.getField());
            sb.append(",");
            sb.append(sbValue.toString());
            sb.append(")=1");
        } else if ("rlike".equals(opr)) {
            sb.append("charindex(");
            sb.append(prop.getField());
            sb.append(",");
            sb.append(sbValue.toString());
            sb.append(")=len(" + prop.getName() + ")-" + sbValue.length());
        }
        return sb.toString();
    }

    public boolean match(Object compareValue, Object value) {
        if (compareValue == null) {
            return false;
        }
        ArrayList<Object> lstValue = new ArrayList<Object>();
        if (value instanceof List) {
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                Object n;
                Object userObj = ((DefaultKingdeeTreeNode)it.next()).getUserObject();
                String number = "";
                if (userObj instanceof AbstractTreeNode) {
                    n = (AbstractTreeNode)userObj;
                    number = n.getModel().getNumber();
                } else if (userObj instanceof Member) {
                    n = (Member)userObj;
                    number = ((Member)n).getNumber();
                }
                lstValue.add(number);
            }
        } else {
            lstValue.add(value);
        }
        String opr = this.getName();
        if ("=".equals(opr)) {
            return lstValue.indexOf(compareValue) != -1;
        }
        if ("<".equals(opr)) {
            return ((Number)compareValue).doubleValue() < ((Number)value).doubleValue();
        }
        if (">".equals(opr)) {
            return ((Number)compareValue).doubleValue() > ((Number)value).doubleValue();
        }
        if ("<=".equals(opr)) {
            return ((Number)compareValue).doubleValue() <= ((Number)value).doubleValue();
        }
        if (">=".equals(opr)) {
            return ((Number)compareValue).doubleValue() >= ((Number)value).doubleValue();
        }
        if ("in".equals(opr)) {
            return lstValue.indexOf(compareValue) != -1;
        }
        if ("not in".equals(opr)) {
            return lstValue.indexOf(compareValue) == -1;
        }
        if ("like".equals(opr)) {
            return ((String)compareValue).indexOf((String)value) != -1;
        }
        if ("llike".equals(opr)) {
            return ((String)compareValue).indexOf((String)value) == 0;
        }
        if ("rlike".equals(opr)) {
            int i = ((String)compareValue).indexOf((String)value);
            return i == ((String)value).length() - ((String)compareValue).length();
        }
        return false;
    }

    public String toXML() {
        return StringUtils.replace((String)StringUtils.replace((String)this.getName(), (String)"<", (String)"&lt;"), (String)">", (String)"&gt;");
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isOprNumber() {
        return this.isOprNumeric;
    }

    public static Operator getObj(String name) {
        Operator ta = new Operator(name, null);
        int idx = AllObjs.indexOf(ta);
        if (idx >= 0) {
            return (Operator)AllObjs.get(idx);
        }
        return null;
    }

    public static Operator[] getAllObjs() {
        return AllObjs.toArray(new Operator[0]);
    }

    static {
        AllObjs.add(equals);
        AllObjs.add(less);
        AllObjs.add(above);
        AllObjs.add(lessEquals);
        AllObjs.add(aboveEquals);
        AllObjs.add(include);
        AllObjs.add(notInclude);
        AllObjs.add(like);
        AllObjs.add(llike);
        AllObjs.add(rlike);
    }
}

