/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.ui;

import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.security.SecureFilterItems;
import com.kingdee.bos.bi.model.security.SecurityObjectType;
import com.kingdee.bos.bi.model.security.SelSecurityObjects;
import com.kingdee.bos.bi.model.security.cell.CellSecureFilter;
import com.kingdee.bos.bi.model.security.ui.CellSecureConditionDialog;
import com.kingdee.bos.bi.model.security.ui.SecurityObjectSelectorListener;
import com.kingdee.bos.bi.model.security.ui.editor.ConditionStyledEditorModel;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.analysis.util.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.analysis.util.editor.StyledEditor;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CellSecureDialog
extends TypicalDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger log = CommonLogger.getLogger(CellSecureDialog.class);
    private KDLabel lblList;
    private KDLabel lblInfo;
    private KDScrollPane scrInfo;
    private StyledEditor txtInfo;
    private KDWorkButton btnAddRow;
    private KDWorkButton btnDelRow;
    private KDTable tblList;
    private IManagementFacade facade;
    private AppModelView apv;
    private CellSecureFilter csfCopy;
    private static final String COL_KEY_TYPE = "FType";
    private static final String COL_KEY_OBJECTS = "FObjects";
    private static final String COL_KEY_MEASURE = "FMeasure";
    private static final String COL_KEY_CONDITION = "FCondition";

    public CellSecureDialog() {
    }

    public CellSecureDialog(Dialog dlg) {
        super(dlg);
    }

    public CellSecureDialog(Frame frame) {
        super(frame);
    }

    public void setFacade(IManagementFacade facade) {
        this.facade = facade;
    }

    public void setAppModelView(AppModelView apv) {
        this.apv = apv;
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table tbl = thisCell.splitRow(4);
        tbl.rowStyle(0).lockHeight(30);
        tbl.rowStyle(0).setMarginBottom(5);
        tbl.rowStyle(1).setMarginBottom(5);
        tbl.rowStyle(2).lockHeight(25);
        tbl.rowStyle(2).setMarginTop(5);
        tbl.rowStyle(3).lockHeight(180);
        Table tbl01 = tbl.cell(0).splitCol(4);
        parent.add((Component)this.lblList, tbl01.cell(0));
        parent.add((Component)this.btnAddRow, tbl01.cell(1));
        parent.add((Component)this.btnDelRow, tbl01.cell(3));
        tbl01.colStyle(1).lockWidth(80);
        tbl01.colStyle(2).lockWidth(10);
        tbl01.colStyle(3).lockWidth(80);
        parent.add((Component)this.tblList, tbl.cell(1));
        parent.add((Component)this.lblInfo, tbl.cell(2));
        parent.add((Component)this.scrInfo, tbl.cell(3));
        List lstCellSecurityItems = null;
        try {
            lstCellSecurityItems = this.facade.getCellSecureItems(this.apv.getId());
            for (CellSecureFilter csf : lstCellSecurityItems) {
                this.addFilterRow(csf);
            }
        }
        catch (BIModelRemoteException e) {
            log.error((Object)"\u4ece\u6570\u636e\u5e93\u88c5\u8f7d\u5355\u5143\u683c\u6743\u9650\u65f6\u51fa\u9519", (Throwable)((Object)e));
        }
    }

    protected void todoInit() {
        this.lblList = new KDLabel("\u5ea6\u91cf\u503c\u5c4f\u853d\u89c4\u5219\u5217\u8868\uff1a");
        this.lblInfo = new KDLabel("\u9009\u4e2d\u884c\u7684\u5c4f\u853d\u6761\u4ef6\u8be6\u60c5\uff1a");
        this.btnAddRow = new KDWorkButton("\u65b0\u589e\u884c");
        this.btnAddRow.addActionListener((ActionListener)new addRowActionHandler());
        this.btnDelRow = new KDWorkButton("\u5220\u9664\u884c");
        this.btnDelRow.addActionListener((ActionListener)new delRowActionHandler());
        this.tblList = new KDTable();
        this.tblList.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int curCol = e.getColIndex();
                String curColKey = CellSecureDialog.this.tblList.getColumnKey(curCol);
                int curRow = e.getRowIndex();
                if (CellSecureDialog.COL_KEY_MEASURE.equalsIgnoreCase(curColKey) && e.getOldValue() != null && !e.getOldValue().equals(e.getValue())) {
                    CellSecureDialog.this.tblList.getCell(curRow, CellSecureDialog.COL_KEY_CONDITION).setValue(null);
                } else if (CellSecureDialog.COL_KEY_TYPE.equalsIgnoreCase(curColKey) && e.getOldValue() != null && !e.getOldValue().equals(e.getValue())) {
                    CellSecureDialog.this.tblList.getCell(curRow, CellSecureDialog.COL_KEY_OBJECTS).setValue(null);
                }
            }
        });
        this.tblList.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int row = e.getSelectBlock().getEndRow();
                if (row == -1) {
                    return;
                }
                CellSecureFilter csf = (CellSecureFilter)CellSecureDialog.this.tblList.getRow(row).getCell(CellSecureDialog.COL_KEY_CONDITION).getValue();
                CellSecureDialog.this.showTipInfo(csf);
            }
        });
        this.txtInfo = new StyledEditor((EditorStyleModel)new ConditionStyledEditorModel());
        this.txtInfo.setText("");
        this.txtInfo.setEditable(false);
        this.scrInfo = new KDScrollPane((Component)this.txtInfo);
        this.scrInfo.setVerticalScrollBarPolicy(20);
        String[] columnKeys = new String[]{COL_KEY_TYPE, COL_KEY_OBJECTS, COL_KEY_MEASURE, COL_KEY_CONDITION};
        Object[] headNames = new String[]{"\u5bf9\u8c61\u7c7b\u578b", "\u8bbe\u7f6e\u5bf9\u8c61", "\u5ea6\u91cf", "\u5c4f\u853d\u6761\u4ef6"};
        Object[][] bodyDatas = null;
        KDTableHelper.initTable((KDTable)this.tblList, (String[])columnKeys, (Object[])headNames, (Object[][])bodyDatas);
        this.tblList.getColumn(COL_KEY_TYPE).setWidth(100);
        this.tblList.getColumn(COL_KEY_OBJECTS).setWidth(150);
        this.tblList.getColumn(COL_KEY_MEASURE).setWidth(100);
        this.tblList.getColumn(COL_KEY_CONDITION).setWidth(380);
    }

    public void save() throws SQLException {
        String view_id = this.apv.getId();
        this.facade.delCellSecurityFilterItems(view_id);
        int rows = this.tblList.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IRow row_RX = this.tblList.getRow(i);
            SelSecurityObjects so = (SelSecurityObjects)row_RX.getCell(COL_KEY_OBJECTS).getValue();
            Member member = (Member)row_RX.getCell(COL_KEY_MEASURE).getValue();
            CellSecureFilter csf = (CellSecureFilter)row_RX.getCell(COL_KEY_CONDITION).getValue();
            if (csf == null) {
                csf = new CellSecureFilter(member, new SecureFilterItems(new ArrayList()), null, new HashMap());
            }
            csf.setSecurityObjects(so);
            this.facade.saveCellSecurityFilterItem(view_id, i, so, member.getNumber(), csf);
        }
    }

    private void addFilterRow(CellSecureFilter csf) {
        IRow row_RX = this.tblList.addRow();
        SecurityObjectType st = SecurityObjectType.user;
        ICell cell = row_RX.getCell(COL_KEY_TYPE);
        KDComboBox cmbType = new KDComboBox();
        SecurityObjectType[] types = SecurityObjectType.getAllObjs();
        for (int i = 0; i < types.length; ++i) {
            cmbType.addItem((Object)types[i]);
        }
        cmbType.setSelectedIndex(0);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbType));
        if (csf != null) {
            st = csf.getSecurityObjects().getType();
        }
        cell.setValue((Object)st);
        cell = row_RX.getCell(COL_KEY_OBJECTS);
        KDPromptBox promFilterObject = new KDPromptBox();
        promFilterObject.setEditable(false);
        promFilterObject.addSelectorListener((SelectorListener)new SecurityObjectSelectorListener(row_RX.getCell(COL_KEY_TYPE), cell, this.getRootPane(), this.facade));
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promFilterObject));
        if (csf != null) {
            cell.setValue((Object)csf.getSecurityObjects());
        }
        cell = row_RX.getCell(COL_KEY_MEASURE);
        KDComboBox cmbMeasures = new KDComboBox();
        DimensionView dv = this.apv.getDimRef().getDimensionView("measure");
        if (dv == null) {
            WindowUtil.msgboxError((Object)"\u5e94\u7528\u6a21\u578b\u6ca1\u6709\u5ea6\u91cf\u7ef4\uff0c\u4e0d\u80fd\u5b9a\u4e49\u6743\u9650\uff01", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return;
        }
        try {
            Object[] m = dv.getMembers(this.facade);
            cmbMeasures.addItems(m);
        }
        catch (SQLException e) {
            log.error((Object)"\u67e5\u627e\u5ea6\u91cf\u6210\u5458\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
        }
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbMeasures));
        if (csf != null) {
            cell.setValue((Object)csf.getMeasure());
        }
        cell = row_RX.getCell(COL_KEY_CONDITION);
        KDPromptBox promFilterCondition = new KDPromptBox();
        promFilterCondition.setEditable(false);
        promFilterCondition.addSelectorListener((SelectorListener)new CellFilterListerner(cell, row_RX));
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promFilterCondition));
        if (csf != null) {
            cell.setValue((Object)csf);
        }
        promFilterCondition.getEditor().getInputMap().put(KeyStroke.getKeyStroke(67, 128), "KEY_COPY_CSF");
        promFilterCondition.getEditor().getActionMap().put("KEY_COPY_CSF", new CopyAction(cell));
        promFilterCondition.getEditor().getInputMap().put(KeyStroke.getKeyStroke(86, 128), "KEY_PASTE_CSF");
        promFilterCondition.getEditor().getActionMap().put("KEY_PASTE_CSF", new PasteAction(cell, row_RX.getCell(COL_KEY_MEASURE)));
    }

    private void showTipInfo(CellSecureFilter csf) {
        this.txtInfo.setText(csf == null ? "" : csf.getFilterInfo());
    }

    private void delFilterRow() {
        if (this.checkSelectedTbl(this.tblList)) {
            ArrayList selectBlocks = this.tblList.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            for (int i = 0; i < selectBlocks.size(); ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)((Object)this));
                    return;
                }
                this.tblList.removeRow(selectBlock.getTop());
            }
        }
    }

    private boolean checkSelectedTbl(KDTable tblMain) {
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    protected boolean verify() {
        int rows = this.tblList.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IRow row_RX = this.tblList.getRow(i);
            SelSecurityObjects sos = (SelSecurityObjects)row_RX.getCell(COL_KEY_OBJECTS).getValue();
            if (sos == null) {
                WindowUtil.msgboxError((Object)("\u7b2c" + (i + 1) + "\u884c\u7b5b\u9009\u5bf9\u8c61\u672a\u9009\u62e9\uff01"), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
                return false;
            }
            Member member = (Member)row_RX.getCell(COL_KEY_MEASURE).getValue();
            if (member == null) {
                WindowUtil.msgboxError((Object)("\u7b2c" + (i + 1) + "\u672a\u6307\u5b9a\u5ea6\u91cf\uff01"), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
                return false;
            }
            CellSecureFilter csf = (CellSecureFilter)row_RX.getCell(COL_KEY_CONDITION).getValue();
            if (csf != null || WindowUtil.msgboxYesNo((Component)this.getRootPane(), (Object)("\u7b2c" + (i + 1) + "\u884c [" + member.getName() + "] \u5c4f\u853d\u6761\u4ef6\u672a\u9009\u62e9\uff0c\u662f\u5426\u7ee7\u7eed\uff1f(\u65e0\u6761\u4ef6\u8868\u793a\u5c4f\u853d\u8be5\u5ea6\u91cf\u7684\u6240\u6709\u6570\u636e)"), (String)"\u7cfb\u7edf\u8b66\u544a")) continue;
            return false;
        }
        return true;
    }

    class delRowActionHandler
    implements ActionListener {
        delRowActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellSecureDialog.this.delFilterRow();
        }
    }

    class addRowActionHandler
    implements ActionListener {
        addRowActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellSecureDialog.this.addFilterRow(null);
        }
    }

    class CellFilterListerner
    implements SelectorListener {
        ICell cell;
        IRow row;

        public CellFilterListerner(ICell cell, IRow row) {
            this.cell = cell;
            this.row = row;
        }

        public void willShow(SelectorEvent e) {
            SelSecurityObjects sos = (SelSecurityObjects)this.row.getCell(CellSecureDialog.COL_KEY_OBJECTS).getValue();
            if (this.row.getCell(CellSecureDialog.COL_KEY_MEASURE).getValue() == null) {
                WindowUtil.msgboxError((Object)"\u8bf7\u5148\u9009\u62e9\u5ea6\u91cf!", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)CellSecureDialog.this.getRootPane());
                return;
            }
            CellSecureConditionDialog dlg = (CellSecureConditionDialog)((Object)WindowUtil.createWindow(CellSecureConditionDialog.class, (Component)CellSecureDialog.this.getRootPane()));
            dlg.setSize(800, 600);
            dlg.setTitle("\u7b5b\u9009\u6761\u4ef6\u5b9a\u4e49");
            dlg.setFacade(CellSecureDialog.this.facade);
            dlg.setAppModelView(CellSecureDialog.this.apv);
            dlg.setMeasureMember((Member)this.row.getCell(CellSecureDialog.COL_KEY_MEASURE).getValue());
            dlg.setCurrentValue((CellSecureFilter)this.cell.getValue());
            if (dlg.showDialog()) {
                CellSecureFilter csf = new CellSecureFilter((Member)this.row.getCell(CellSecureDialog.COL_KEY_MEASURE).getValue(), dlg.getMeasureFilterItems(), sos, dlg.getDimFilterItems());
                this.cell.setValue((Object)csf);
                CellSecureDialog.this.showTipInfo(csf);
            }
        }
    }

    class MeasureItemListener
    implements ItemListener {
        private IRow row;

        public MeasureItemListener(IRow row) {
            this.row = row;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ICell cell = this.row.getCell(CellSecureDialog.COL_KEY_CONDITION);
                cell.setValue(null);
            }
        }
    }

    class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ICell conditionCell;
        private ICell measureCell;

        public PasteAction(ICell conditionCell, ICell measureCell) {
            this.conditionCell = conditionCell;
            this.measureCell = measureCell;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CellSecureDialog.this.csfCopy == null) {
                return;
            }
            Member measure = (Member)this.measureCell.getValue();
            if (measure == null) {
                WindowUtil.msgboxError((Object)"\u672a\u6307\u5b9a\u5ea6\u91cf\uff0c\u8bf7\u9009\u62e9\u5ea6\u91cf\u540e\u518d\u7c98\u8d34\uff01", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)CellSecureDialog.this.getRootPane());
            } else {
                CellSecureFilter newCsf = (CellSecureFilter)CellSecureDialog.this.csfCopy.clone();
                newCsf.setMeasure((Member)measure.clone());
                this.conditionCell.setValue((Object)newCsf);
            }
        }
    }

    class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ICell cell;

        public CopyAction(ICell cell) {
            this.cell = cell;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellSecureDialog.this.csfCopy = (CellSecureFilter)this.cell.getValue();
        }
    }
}

