/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.ui;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SelViewMemberDialog
extends TypicalDialog {
    private static final long serialVersionUID = 1L;
    private KDTree _tree;
    private KDWorkButton btnSyncSibling;
    private KDWorkButton btnSyncSon;
    private KDWorkButton btnSyncDescenance;
    private KDTreeView tv;
    private boolean isSingle;
    private DefaultKingdeeTreeNode root;
    private List defaultMembers;

    public SelViewMemberDialog() {
    }

    public SelViewMemberDialog(Frame owner) {
        super(owner);
    }

    public SelViewMemberDialog(Dialog owner) {
        super(owner);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        this._tree = new KDTree(!this.isSingle);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(1);
        KingdeeTreeModel mo = new KingdeeTreeModel((TreeNode)this.root);
        this._tree.setModel((TreeModel)mo);
        if (this.defaultMembers != null && this.defaultMembers.size() != 0) {
            if (this.isSingle) {
                this._tree.setSelectionNode((DefaultKingdeeTreeNode)this.defaultMembers.get(0));
            } else {
                this.setCheckedMember((DefaultKingdeeTreeNode)this._tree.getModel().getRoot(), this.defaultMembers);
            }
        }
        this.tv = new KDTreeView(this._tree);
        this.tv.setTitle("\u6210\u5458\u5217\u8868");
        this.tv.setMinimumSize(new Dimension(100, 50));
        if (this.isSingle) {
            parent.add((Component)this.tv, thisCell);
        } else {
            Table tbl01 = thisCell.splitRow(2);
            parent.add((Component)this.tv, tbl01.cell(0));
            tbl01.rowStyle(0).setMarginBottom(5);
            tbl01.rowStyle(1).lockHeight(20);
            Table tbl02 = tbl01.cell(1).splitCol(6);
            parent.add((Component)this.btnSyncSibling, tbl02.cell(1));
            parent.add((Component)this.btnSyncSon, tbl02.cell(3));
            parent.add((Component)this.btnSyncDescenance, tbl02.cell(5));
            tbl02.colStyle(1).lockWidth(80);
            tbl02.colStyle(2).lockWidth(10);
            tbl02.colStyle(3).lockWidth(80);
            tbl02.colStyle(4).lockWidth(10);
            tbl02.colStyle(5).lockWidth(80);
        }
    }

    public void setRoot(DefaultKingdeeTreeNode root, boolean isSingle) {
        this.root = root;
        this.isSingle = isSingle;
    }

    public void setRoot(DefaultKingdeeTreeNode[] nodes, boolean isSingle) {
        this.root = new DefaultKingdeeTreeNode();
        for (int i = 0; i < nodes.length; ++i) {
            this.root.add((MutableTreeNode)nodes[i]);
        }
        this.isSingle = isSingle;
    }

    protected void todoInit() {
        this.btnSyncSibling = new KDWorkButton("\u540c\u7ea7");
        this.btnSyncSon = new KDWorkButton("\u5b50\u4ee3");
        this.btnSyncDescenance = new KDWorkButton("\u540e\u4ee3");
        SyncCheckActionHandler handler = new SyncCheckActionHandler();
        this.btnSyncSibling.addActionListener((ActionListener)handler);
        this.btnSyncSon.addActionListener((ActionListener)handler);
        this.btnSyncDescenance.addActionListener((ActionListener)handler);
    }

    protected boolean verify() {
        if (this.isSingle) {
            return this._tree.getSelectionPath() != null;
        }
        ArrayList lstRet = new ArrayList();
        this.getCheckedMember((DefaultKingdeeTreeNode)this._tree.getModel().getRoot(), lstRet);
        return lstRet.size() > 0;
    }

    public void setCurrentSelected(List members) {
        this.defaultMembers = members;
    }

    public List getSelectedMembers() {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (this.isSingle) {
            ret.add(this._tree.getSelectionPath().getLastPathComponent());
        } else {
            this.getCheckedMember((DefaultKingdeeTreeNode)this._tree.getModel().getRoot(), ret);
        }
        return ret;
    }

    private void setCheckedMember(DefaultKingdeeTreeNode parent, List members) {
        if (this.checkExistNode(members, parent)) {
            parent.setChecked(true);
        }
        if (!parent.isLeaf()) {
            int len = parent.getChildCount();
            for (int i = 0; i < len; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parent.getChildAt(i);
                if (node.isLeaf()) {
                    if (!this.checkExistNode(members, node)) continue;
                    node.setChecked(true);
                    continue;
                }
                this.setCheckedMember(node, members);
            }
        }
    }

    private boolean checkExistNode(List members, DefaultKingdeeTreeNode node) {
        for (Object obj : members) {
            if (!(obj instanceof DefaultKingdeeTreeNode ? ((DefaultKingdeeTreeNode)obj).getUserObject().equals(node.getUserObject()) : obj == null && node == null)) continue;
            return true;
        }
        return false;
    }

    private void getCheckedMember(DefaultKingdeeTreeNode parent, List lst) {
        if (parent.isChecked()) {
            lst.add(parent);
        }
        if (!parent.isLeaf()) {
            int len = parent.getChildCount();
            for (int i = 0; i < len; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parent.getChildAt(i);
                if (node.isLeaf()) {
                    if (!node.isChecked()) continue;
                    lst.add(node);
                    continue;
                }
                this.getCheckedMember(node, lst);
            }
        }
    }

    private class SyncCheckActionHandler
    implements ActionListener {
        private SyncCheckActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = SelViewMemberDialog.this._tree.getSelectionPath();
            if (path == null) {
                WindowUtil.msgboxWarning((Object)"\u8bf7\u9009\u4e2d\u76ee\u6807\u8282\u70b9\u3002", (String)"\u9009\u62e9\u6210\u5458", (Component)SelViewMemberDialog.this.getRootPane());
                return;
            }
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            boolean isChecked = node.isChecked();
            if (e.getSource() == SelViewMemberDialog.this.btnSyncSibling) {
                DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
                if (parent == null) {
                    return;
                }
                this.syncSon(parent, isChecked, false);
            } else if (e.getSource() == SelViewMemberDialog.this.btnSyncSon) {
                this.syncSon(node, isChecked, false);
            } else if (e.getSource() == SelViewMemberDialog.this.btnSyncDescenance) {
                this.syncSon(node, isChecked, true);
            }
            SelViewMemberDialog.this._tree.repaint();
        }

        private void syncSon(DefaultKingdeeTreeNode node, boolean isChecked, boolean toDeepLevel) {
            int c = node.getChildCount();
            for (int i = 0; i < c; ++i) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
                child.setChecked(isChecked);
                if (!toDeepLevel) continue;
                this.syncSon(child, isChecked, toDeepLevel);
            }
        }
    }
}

