/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.content;

import com.kingdee.bos.bi.model.common.list.ListUtil;
import com.kingdee.bos.bi.model.security.ui.CellSecureDialog;
import com.kingdee.bos.bi.model.security.ui.RowSecureDialog;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.NameDialog;
import com.kingdee.bos.bi.model.ui.actions.AbstractMCAction;
import com.kingdee.bos.bi.model.ui.actions.DeleteAction;
import com.kingdee.bos.bi.model.ui.actions.EditAction;
import com.kingdee.bos.bi.model.ui.actions.PublishAction;
import com.kingdee.bos.bi.model.ui.actions.RenameAction;
import com.kingdee.bos.bi.model.ui.actions.ViewAction;
import com.kingdee.bos.bi.model.ui.content.AbstractContent;
import com.kingdee.bos.bi.model.ui.content.ContentTable;
import com.kingdee.bos.bi.model.ui.content.ILeafViewOperator;
import com.kingdee.bos.bi.model.ui.dialog.dupont.PublishDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.ui.resource.Resource;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.util.Util;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.console.content.IConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.CMenu;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.CMenuItem;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.CWorkButton;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;

public abstract class AbstractLeafViewUI
extends AbstractContent
implements ILeafViewOperator {
    private ContentTable _table;
    private Action publishAction = null;

    public AbstractLeafViewUI(String caption) {
        super(caption);
        this.addMenuItem(new EditAction());
        this.addMenuItem(new ViewAction());
        this.addMenuItem(new RenameAction());
        this.publishAction = new PublishAction();
        this.addMenuItem((AbstractMCAction)((Object)this.publishAction));
        this.addMenuItem(new DeleteAction());
    }

    protected void addMenuItem(AbstractMCAction action) {
        action.setUI((IConsoleContent)this);
        this.getTable().getPopMenu().add((JMenuItem)new KDMenuItem((Action)((Object)action)));
    }

    @Override
    protected ContentTable getTable() {
        if (this._table == null) {
            this._table = new ContentTable();
            this._table.addColumns(new String[]{"ID", "NAME", "CREATOR", "LASTUPDATE", "USEFLAG", "DISCRIPTION"});
            this._table.setHeadText("ID", "ID");
            this._table.setHeadText("NAME", "\u89c6\u56fe\u540d\u79f0");
            this._table.setHeadText("CREATOR", "\u521b\u5efa\u4eba");
            this._table.setHeadText("LASTUPDATE", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
            this._table.setHeadText("USEFLAG", "\u53d1\u5e03\u72b6\u6001");
            this._table.setHeadText("DISCRIPTION", "\u8bf4\u660e");
            this._table.setColumnWidth("ID", 0);
            this._table.setColumnWidth("NAME", 200);
            this._table.setColumnWidth("CREATOR", 100);
            this._table.setColumnWidth("LASTUPDATE", 170);
            this._table.setColumnWidth("USEFLAG", 100);
            this._table.setColumnWidth("DISCRIPTION", 200);
            this._table.getStyleAttributes().setLocked(true);
            this.sort(this._table);
        }
        return this._table;
    }

    @Override
    protected void updateTable(Map allAttrs) {
        ContentTable t = this.getTable();
        String[] ids = (String[])allAttrs.get("ID");
        int r = 0;
        for (int i = 0; i < ids.length; ++i) {
            HashMap attrs = Util.makeRowAtts((int)i, (HashMap)((HashMap)allAttrs));
            t.addRow(r);
            t.setRowUserObject(r, attrs);
            t.setCellValue(r, "ID", attrs.get("ID"));
            t.setCellValue(r, "NAME", attrs.get("NAME"));
            t.setCellValue(r, "CREATOR", attrs.get("CREATOR"));
            t.setCellValue(r, "LASTUPDATE", attrs.get("LASTUPDATE"));
            t.setCellValue(r, "USEFLAG", "1".equalsIgnoreCase((String)attrs.get("USEFLAG")) ? "\u662f" : "\u5426");
            t.setCellValue(r, "DISCRIPTION", attrs.get("DISCRIPTION"));
            ++r;
        }
    }

    protected boolean getPubFlag() {
        int r = this.getTable().getSelectionRow();
        if (r != -1) {
            return this.isPublish(r);
        }
        return false;
    }

    @Override
    protected void selChanged(Map rowAttrs) {
        Action action;
        String status = (String)rowAttrs.get("USEFLAG");
        List toolBarList = this.getToolBarList();
        for (CWorkButton wb : toolBarList) {
            action = wb.getAction();
            if (!(action instanceof PublishAction)) continue;
            this.changePublishButtonStatus(status, (AbstractButton)wb, action);
            break;
        }
        CMenu menu = (CMenu)this.getMenuBarList().get(0);
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            CMenuItem mib = (CMenuItem)menu.getItem(i);
            action = mib.getAction();
            if (!(action instanceof PublishAction)) continue;
            this.changePublishButtonStatus(status, (AbstractButton)mib, this.publishAction);
            break;
        }
    }

    void changePublishButtonStatus(String status, AbstractButton button, Action action) {
        if ("1".equalsIgnoreCase(status)) {
            button.setText("\u53d6\u6d88\u53d1\u5e03");
            action.putValue("Name", "\u53d6\u6d88\u53d1\u5e03");
            action.putValue("ShortDescription", "\u53d6\u6d88\u53d1\u5e03");
            action.putValue("SmallIcon", Resource.ICON_UNPUBLISH);
        } else {
            button.setText("\u53d1\u5e03");
            action.putValue("Name", "\u53d1\u5e03");
            action.putValue("ShortDescription", "\u53d1\u5e03");
            action.putValue("SmallIcon", Resource.ICON_PUBLISH);
        }
    }

    private NameDialog createNameDialog() {
        NameDialog dlg = (NameDialog)((Object)WindowUtil.createWindow(NameDialog.class, (Component)this.getRootCtrl()));
        dlg.setChecker(new NameDialog.IChecker(){

            @Override
            public boolean verify(String name, String dialogTitle, Component parentCtrl) {
                boolean isNameExist;
                try {
                    isNameExist = AbstractLeafViewUI.this.checkViewNameExist(name);
                }
                catch (BIModelRemoteException ex) {
                    AbstractContent.log.error((Object)"\u6821\u9a8c\u540d\u79f0\u5b58\u5728\u65f6\u51fa\u9519\u3002", (Throwable)((Object)ex));
                    return false;
                }
                if (isNameExist) {
                    WindowUtil.msgboxWarning((Object)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\u3002", (String)dialogTitle, (Component)parentCtrl);
                    return false;
                }
                return true;
            }
        });
        return dlg;
    }

    protected boolean checkViewIdExist(String viewId) throws BIModelRemoteException {
        RDRowSet rowSet;
        StringBuffer sb = new StringBuffer();
        String tablename = ListUtil.getViewTablename(this.getViewType());
        sb.append("select FID from " + tablename + " where FID='");
        sb.append(viewId);
        sb.append("'");
        try {
            rowSet = this.getManFacade().executeQuery(sb.toString());
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        return rowSet.getRowCount() > 0;
    }

    protected boolean checkViewNameExist(String viewName) throws BIModelRemoteException {
        RDRowSet rowSet;
        StringBuffer sb = new StringBuffer();
        String tablename = ListUtil.getViewTablename(this.getViewType());
        sb.append("select FID from ").append(tablename);
        sb.append(" where FName='");
        sb.append(viewName).append("'");
        if (ListUtil.isMainModel(this.getViewType())) {
            sb.append(" and FType='").append(this.getViewType()).append("'");
        }
        try {
            rowSet = this.getManFacade().executeQuery(sb.toString());
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        return rowSet.getRowCount() > 0;
    }

    @Override
    public void addNew() {
        NameDialog dlg = this.createNameDialog();
        dlg.setTitle("\u65b0\u5efa" + this.getCaption());
        if (dlg.showDialog()) {
            String name = dlg.getEditName();
            try {
                String id = this.getManFacade().addView(this.getViewType(), name, this.getAddNewParam());
                if (this.innerEdit(id, name, "\u65b0\u5efa", false, null)) {
                    this.refresh();
                    this.getTable().setSelectionRow(this.findRow(id));
                } else {
                    this.getManFacade().delView(this.getViewType(), id);
                }
            }
            catch (BIModelRemoteException ex) {
                log.error((Object)"\u65b0\u589e\u89c6\u56fe\u5931\u8d25.", (Throwable)((Object)ex));
                WindowUtil.msgboxInfo((Object)"\u65b0\u5efa\u89c6\u56fe\u5931\u8d25\u3002", (String)this.createTitle("\u65b0\u5efa", name), (Component)this.getRootCtrl());
            }
        }
    }

    @Override
    public void edit() {
        String title = "\u7f16\u8f91" + this.getCaption();
        int rowIdx = this.checkTableSingleSelection(title);
        if (rowIdx < 0) {
            return;
        }
        String viewId = this.getRowID(rowIdx);
        String viewName = this.getRowName(rowIdx);
        try {
            if (!this.checkViewIdExist(viewId)) {
                WindowUtil.msgboxWarning((Object)(viewName + "\r\n\u8be5\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5c1d\u8bd5\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002"), (String)title, (Component)this.getRootCtrl());
                return;
            }
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"", (Throwable)((Object)ex));
            return;
        }
        this.doEdit(viewId, viewName);
    }

    @Override
    public void view() {
        int rowIdx = this.checkTableSingleSelection("\u67e5\u770b" + this.getCaption());
        if (rowIdx >= 0) {
            this.viewDetail(rowIdx);
        }
    }

    @Override
    public void delete() {
        List indexList = this.getSelectedRow();
        if (indexList == null || indexList.size() == 0) {
            return;
        }
        String title = "\u5220\u9664" + this.getCaption();
        StringBuffer viewNameSb = new StringBuffer();
        ArrayList<String> viewIdList = new ArrayList<String>();
        for (int i = 0; i < indexList.size(); ++i) {
            int rowIdx = Integer.parseInt((String)indexList.get(i));
            viewNameSb.append(this.getRowName(rowIdx)).append(",");
            viewIdList.add(this.getRowID(rowIdx));
        }
        viewNameSb.deleteCharAt(viewNameSb.length() - 1);
        if (!WindowUtil.msgboxYesNo(null, (Object)("\u60a8\u771f\u7684\u8981\u5220\u9664\u3010" + viewNameSb.toString() + "\u3011\u5417\uff1f"), (String)title)) {
            return;
        }
        try {
            for (int j = 0; j < viewIdList.size(); ++j) {
                this.getManFacade().delView(this.getViewType(), (String)viewIdList.get(j));
            }
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            WindowUtil.msgboxError((Object)("\u5220\u9664\u3010" + viewNameSb.toString() + "\u3011\u5931\u8d25\uff01\u539f\u56e0\uff1a" + ex.getMessage()), (String)title, (Component)this.getRootCtrl());
            return;
        }
        this.refresh();
    }

    private List getSelectedRow() {
        ContentTable t = this.getTable();
        ArrayList selectBlocks = t.getSelectManager().getBlocks();
        KDTSelectBlock selectBlock = null;
        ArrayList<String> lst = null;
        int sum = 0;
        for (int i = 0; i < selectBlocks.size(); ++i) {
            if (lst == null) {
                lst = new ArrayList<String>();
            }
            selectBlock = (KDTSelectBlock)selectBlocks.get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                if (!this.isPublish(j)) {
                    lst.add(j + "");
                }
                ++sum;
            }
        }
        String title = "\u5220\u9664" + this.getCaption();
        if (sum == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u5728\u5217\u8868\u4e2d\u9009\u4e2d\u64cd\u4f5c\u7684\u76ee\u6807\u884c\u3002", (String)title, (Component)this.getRootCtrl());
        } else if (sum > 0 && lst.size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u5df2\u53d1\u5e03\u7684\u6761\u76ee\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)title, (Component)this.getRootCtrl());
            return null;
        }
        return lst;
    }

    @Override
    public void rename() {
        String title = "\u91cd\u547d\u540d" + this.getCaption();
        int rowIdx = this.checkTableSingleSelection(title);
        if (rowIdx < 0) {
            return;
        }
        String viewId = this.getRowID(rowIdx);
        NameDialog dlg = this.createNameDialog();
        dlg.setTitle(title);
        dlg.setEditName(this.getRowName(rowIdx));
        if (dlg.showDialog()) {
            String newName = dlg.getEditName();
            try {
                this.getManFacade().renameView(this.getViewType(), newName, viewId);
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                WindowUtil.msgboxError((Object)("\u91cd\u547d\u540d\u5931\u8d25\u3002\u539f\u56e0\uff1a" + ex.getMessage()), (String)dlg.getTitle(), (Component)this.getRootCtrl());
                this.refresh();
                return;
            }
            this.getTable().getCell(rowIdx, "NAME").setValue((Object)newName);
            this.getRowAttrs(rowIdx).put("NAME", newName);
        }
    }

    @Override
    public void publish() {
        String publishMsg;
        String title = "\u53d1\u5e03/\u53d6\u6d88\u53d1\u5e03" + this.getCaption();
        int rowIdx = this.checkTableSingleSelection(title);
        if (rowIdx < 0) {
            return;
        }
        String viewId = this.getRowID(rowIdx);
        String viewName = this.getRowName(rowIdx);
        boolean publish = !this.isPublish(rowIdx);
        String string = publishMsg = publish ? "\u53d1\u5e03" : "\u53d6\u6d88\u53d1\u5e03";
        if (!(this.getViewType().equals("dupont") && publish || WindowUtil.msgboxYesNo((Component)this.getRootCtrl(), (Object)("\u60a8\u771f\u7684\u8981" + publishMsg + "\u3010" + viewName + "\u3011\u5417\uff1f"), (String)title))) {
            return;
        }
        try {
            if (!this.getViewType().equals("dupont")) {
                this.getManFacade().publish(this.getViewType(), publish, viewId, null);
            } else {
                HashMap<String, String> params = null;
                if (publish) {
                    PublishDialog pubDlg = (PublishDialog)((Object)WindowUtil.createWindow(PublishDialog.class, (Component)this.getRootCtrl()));
                    pubDlg.setSupply(this.getManFacade().getMenuPathTreeModel());
                    if (pubDlg.showDialog()) {
                        params = new HashMap<String, String>();
                        params.put("path", pubDlg.getSelectedPath());
                        params.put("name", pubDlg.getPublishName());
                    }
                    if (params == null || params.size() == 0) {
                        return;
                    }
                    this.getManFacade().publish(this.getViewType(), publish, viewId, params);
                } else {
                    this.getManFacade().publish(this.getViewType(), publish, viewId, params);
                }
            }
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"", (Throwable)((Object)ex));
            WindowUtil.msgboxError((Object)(publishMsg + "\u3010" + viewName + "\u3011\u5931\u8d25\uff01\u539f\u56e0\uff1a" + ex.getMessage()), (String)title, (Component)this.getRootCtrl());
            return;
        }
        catch (BIModelBizException ex) {
            WindowUtil.msgboxInfo((Object)ex.getMessage(), (String)title, (Component)this.getRootCtrl());
            return;
        }
        this.refresh();
        WindowUtil.msgboxInfo((Object)(publishMsg + "\u3010" + viewName + "\u3011\u6210\u529f!"), (String)title, (Component)this.getRootCtrl());
    }

    protected Map getAddNewParam() {
        return null;
    }

    protected abstract void doEdit(String var1, String var2);

    protected abstract boolean innerEdit(String var1, String var2, String var3, boolean var4, Object var5);

    protected String createTitle(String operate, String viewName) {
        return operate + this.getCaption() + "  " + viewName;
    }

    @Override
    public void importData() {
        this.doImport("viewId", "viewName");
    }

    protected void doImport(String viewId, String viewName) {
    }

    @Override
    public void dataSecurity() {
        String viewType = this.getViewType();
        IManagementFacade facade = null;
        try {
            facade = this.getManFacade();
        }
        catch (BIModelRemoteException e1) {
            e1.printStackTrace();
        }
        if (this.getDimensionType() != null) {
            String title = "\u6570\u636e\u6743\u9650\u8bbe\u7f6e " + this.getCaption();
            int rowIdx = this.checkTableSingleSelection(title);
            if (rowIdx < 0) {
                return;
            }
            String viewId = this.getRowID(rowIdx);
            String viewName = this.getRowName(rowIdx);
            RowSecureDialog dlg = (RowSecureDialog)((Object)WindowUtil.createWindow(RowSecureDialog.class, (Component)this.getRootCtrl()));
            try {
                dlg.setFacade(this.getManFacade());
                dlg.setView(viewId, viewName, this.getDimensionType());
                dlg.setSize(800, 600);
            }
            catch (BIModelRemoteException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (dlg.showDialog()) {
                try {
                    dlg.save();
                }
                catch (SQLException e) {
                    log.error((Object)"\u4fdd\u5b58\u6743\u9650\u884c\u7b5b\u9009\u5b9a\u4e49\u5931\u8d25\uff01", (Throwable)e);
                    WindowUtil.msgboxError((Object)"\u4fdd\u5b58\u5931\u8d25!", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootCtrl());
                }
            }
        } else if ("finance".equalsIgnoreCase(viewType) || "common".equalsIgnoreCase(viewType)) {
            String title = "\u5e94\u7528\u6a21\u578b\u6570\u636e\u6743\u9650\u8bbe\u7f6e [" + this.getCaption() + "]";
            int rowIdx = this.checkTableSingleSelection(title);
            if (rowIdx < 0) {
                return;
            }
            String viewId = this.getRowID(rowIdx);
            String viewName = this.getRowName(rowIdx);
            CellSecureDialog dlg = (CellSecureDialog)((Object)WindowUtil.createWindow(CellSecureDialog.class, (Component)this.getRootCtrl()));
            dlg.setSize(800, 600);
            dlg.setTitle(title);
            try {
                dlg.setFacade(facade);
                dlg.setAppModelView(facade.getAppModelViewFromId(viewId));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (dlg.showDialog()) {
                try {
                    dlg.save();
                }
                catch (SQLException e) {
                    log.error((Object)"\u4fdd\u5b58\u6743\u9650\u5355\u5143\u683c\u7b5b\u9009\u5b9a\u4e49\u5931\u8d25\uff01", (Throwable)e);
                    WindowUtil.msgboxError((Object)"\u4fdd\u5b58\u5931\u8d25!", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootCtrl());
                }
            }
        }
    }
}

