/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.content;

import com.kingdee.bos.bi.model.ui.actions.AbstractMCAction;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class ContentTable
extends KDTable {
    private static final long serialVersionUID = 1L;
    private ComponentAdapter parentListener;
    private KDPopupMenu popmenu;
    private boolean isPopMenuShow = true;

    public ContentTable() {
        this.init();
    }

    private void init() {
        this.setBackground(Color.WHITE);
        this.getIndexColumn().getStyleAttributes().setHided(true);
        this.setHorizonGridLineVisible(false);
        this.setVerticalGridLineVisible(false);
        this.getSelectManager().setSelectMode(10);
        this.getLayoutManager().setHSplitButtonVisible(false);
        this.getLayoutManager().setVSplitButtonVisible(false);
        this.addHeadRow();
        this.getHeadRow(0).setResizeable(false);
        this.setPreferredSize(new Dimension(80, 60));
    }

    public void setParent(Component parent) {
        parent.removeComponentListener(this.parentListener);
        if (this.parentListener == null) {
            this.parentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Component prt = (Component)e.getSource();
                    int newWidth = 0;
                    for (int i = 0; i < ContentTable.this.getColumnCount() - 1; ++i) {
                        newWidth += ContentTable.this.getColumn(i).getWidth();
                    }
                    newWidth = prt.getWidth() - newWidth - 2;
                    if (newWidth > 0) {
                        ContentTable.this.getColumn(ContentTable.this.getColumnCount() - 1).setWidth(newWidth);
                    }
                }
            };
        }
        parent.addComponentListener(this.parentListener);
    }

    public KDPopupMenu getPopMenu() {
        if (this.popmenu == null) {
            this.popmenu = new KDPopupMenu();
            this.installPopMenuListener();
        }
        return this.popmenu;
    }

    private void installPopMenuListener() {
        this.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (SwingUtilities.isRightMouseButton((MouseEvent)e) && ContentTable.this.isPopMenuShow()) {
                    ContentTable.this.verifyMenuItem();
                    ContentTable.this.getPopMenu().show(e.getOriginView(), e.getX(), e.getY());
                }
            }
        });
    }

    private void verifyMenuItem() {
        for (int i = 0; i < this.getPopMenu().getComponentCount(); ++i) {
            Action action;
            if (!(this.getPopMenu().getComponent(i) instanceof JMenuItem) || !((action = ((JMenuItem)this.getPopMenu().getComponent(i)).getAction()) instanceof AbstractMCAction)) continue;
            ((AbstractMCAction)((Object)action)).verifyEnabled();
        }
    }

    public boolean isPopMenuShow() {
        return this.isPopMenuShow;
    }

    public void setPopMenuShow(boolean isPopMenuShow) {
        this.isPopMenuShow = isPopMenuShow;
    }

    public void addColumns(int colCount) {
        super.addColumns(colCount);
    }

    public void addColumns(String[] keys) {
        this.addColumns(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            this.setColumnKey(i, keys[i]);
        }
    }

    public void setColumnKey(int col, String key) {
        this.getColumn(col).setKey(key);
    }

    public void setHeadText(String key, String text) {
        this.getHeadRow(0).getCell(key).setValue((Object)text);
    }

    public void setColumnWidth(String key, int width) {
        this.getColumn(key).setWidth(width);
    }

    public void setColumnVisible(String key, boolean b) {
        this.getColumn(key).getStyleAttributes().setHided(!b);
    }

    public void setColumnEditable(String key, boolean b) {
        this.getColumn(key).getStyleAttributes().setLocked(!b);
    }

    public void setRowUserObject(int row, Object userObj) {
        this.getRow(row).setUserObject(userObj);
    }

    public Object getRowUserObject(int row) {
        return this.getRow(row).getUserObject();
    }

    public void setCellValue(int row, String key, Object value) {
        this.getRow(row).getCell(key).setValue(value);
    }

    public Object getCellValue(int row, String key) {
        return this.getRow(row).getCell(key).getValue();
    }

    public int getSelectionRow() {
        if (this.getSelectManager().get() != null) {
            return this.getSelectManager().get().getBeginRow();
        }
        return -1;
    }

    public int[] getSelectionRows() {
        KDTBlock block;
        ArrayList blocks = this.getSelectManager().getBlocks();
        int sum = 0;
        for (int i = 0; i < blocks.size(); ++i) {
            block = (KDTBlock)blocks.get(i);
            sum += block.getBottom() - block.getTop() + 1;
        }
        int[] rows = new int[sum];
        int k = 0;
        for (int i = 0; i < blocks.size(); ++i) {
            block = (KDTBlock)blocks.get(i);
            int j = block.getTop();
            while (j <= block.getBottom()) {
                rows[k++] = j++;
            }
        }
        return rows;
    }

    public void setSelectionRow(int row) {
        if (row < 0) {
            if (this.getSelectionRow() != -1) {
                this.getSelectManager().remove();
            }
        } else {
            this.getSelectManager().select(row, 0);
        }
    }

    public Object[] getColumnValues(String key) {
        Object[] values = new Object[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            values[i] = this.getRow(i).getCell(key).getValue();
        }
        return values;
    }
}

