/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.monitor;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.monitor.MetricMonitorConst;
import com.kingdee.bos.bi.model.common.mm.monitor.MetricMonitorModel;
import com.kingdee.bos.bi.model.common.mm.monitor.MetricMonitorXmlModel;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.monitor.AbstractMetricMonitorDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import org.jdom2.JDOMException;

public class MetricMonitorDialog
extends AbstractMetricMonitorDialog {
    private static final long serialVersionUID = 6424107880931913603L;
    private Vector kpiMetricVector = null;
    private Vector showTypeVector = null;
    private Vector drilDowOrgVector = null;
    private Vector drilDowYearVector = null;
    private Vector drilDowPeriodVector = null;
    private Vector drilDowDefaultVector = null;

    public MetricMonitorDialog() {
    }

    public MetricMonitorDialog(Dialog owner) {
        super(owner);
    }

    public MetricMonitorDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected void todoInit() {
        super.todoInit();
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        this.loadModel(this.facade, this.fid, null);
        this.loadComboBoxIteams(this.model == null ? "" : this.model.getKPIId());
        this.loadKpiModelList();
        super.todoAddControls(parent, thisCell);
        this.initPbxSelectedKpiModelInfo();
        this.initTblSelectMonitorInfo();
        this.initFilterInfo();
    }

    @Override
    protected void action_Add() {
        this.addTblSelectMonitorInfo(null);
    }

    @Override
    protected void action_KpiModelChanged() {
        if (!this.getKPISelected()) {
            return;
        }
        this.loadModel(this.facade, this.fid, this.kpiId);
        this.loadComboBoxIteams(this.kpiId);
        this.initTblSelectMonitorInfo();
        this.initFilterInfo();
        this.setInitialStateOrgInfo();
        this.setInitialStateYearInfo();
        this.setInitialStatePeriodInfo();
    }

    private boolean getKPISelected() {
        if (this.pbxSelectKPIModel.getSelector().getData() == null) {
            return false;
        }
        ComboBoxObject obj = (ComboBoxObject)this.pbxSelectKPIModel.getSelector().getData();
        this.kpiId = obj.getCode();
        this.amId = obj.getInfo();
        return true;
    }

    private void loadModel(IManagementFacade facade, String id, String kpiId) {
        try {
            this.model = MetricMonitorModel.load(facade, id, kpiId);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        catch (JDOMException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    @Override
    protected List loadKpiModelList() {
        try {
            if (this.kpiModelList == null) {
                this.kpiModelList = MetricMonitorModel.loadKpiModelList(this.facade);
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        ComboBoxObject obj = null;
        int n = this.kpiModelList.size();
        for (int i = 0; i < n; ++i) {
            obj = (ComboBoxObject)this.kpiModelList.get(i);
            if (!obj.getCode().equals(this.model.getKPIId())) continue;
            this.kpiId = obj.getCode();
            this.amId = obj.getInfo();
            break;
        }
        return this.kpiModelList;
    }

    @Override
    protected void loadComboBoxIteams(String kpiId) {
        try {
            this.kpiMetricVector = MetricMonitorModel.loadKpiModelInfo(this.facade, kpiId);
            this.showTypeVector = this.showTypeVector == null ? MetricMonitorConst.getShowTypeIteams() : this.showTypeVector;
            this.drilDowOrgVector = this.drilDowOrgVector == null ? MetricMonitorConst.getOrgIteams() : this.drilDowOrgVector;
            this.drilDowYearVector = this.drilDowYearVector == null ? MetricMonitorConst.getYearIteams() : this.drilDowYearVector;
            this.drilDowPeriodVector = this.drilDowPeriodVector == null ? MetricMonitorConst.getPeriodIteams() : this.drilDowPeriodVector;
            this.drilDowDefaultVector = this.drilDowDefaultVector == null ? MetricMonitorConst.getDefaultIteams() : this.drilDowDefaultVector;
        }
        catch (BIModelRemoteException e) {
            log.error((Object)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
    }

    private void initFilterInfo() {
        if (this.model.getId() == null) {
            this.setInitialStateOrgInfo();
            this.pbxInitialStateOrg.setData(null);
            this.pbxInitialStateYear.setData(null);
            this.pbxInitialStatePeriod.setData(null);
            this.chbxFilterOrg.setSelected(false);
            this.chbxFilterYear.setSelected(true);
            this.chbxFilterPeriod.setSelected(false);
            this.chbxDisplayOrg.setSelected(true);
            this.chbxDisplayYear.setSelected(true);
            this.chbxDisplayPeriod.setSelected(true);
        } else if (this.model.getXmlModel() != null) {
            this.pbxInitialStateOrg.setData(this.defaultOrg);
            this.pbxInitialStateYear.setData(this.defaultYear);
            this.pbxInitialStatePeriod.setData(this.defaultPeriod);
            boolean displayOrg = this.model.getXmlModel().getCanDispalyOrg();
            boolean displayYear = this.model.getXmlModel().getCanDispalyYear();
            boolean displayPeriod = this.model.getXmlModel().getCanDispalyPeriod();
            this.chbxDisplayOrg.setSelected(displayOrg);
            this.chbxDisplayYear.setSelected(displayYear);
            this.chbxDisplayPeriod.setSelected(displayPeriod);
            this.enableFilterCheckBox(this.chbxFilterOrg, displayOrg ? 1 : 0, false);
            this.enableFilterCheckBox(this.chbxFilterYear, displayYear ? 1 : 0, true);
            this.enableFilterCheckBox(this.chbxFilterPeriod, displayPeriod ? 1 : 0, false);
            this.chbxFilterOrg.setSelected(this.model.getXmlModel().getCanShowOrgFilter());
            this.chbxFilterYear.setSelected(this.model.getXmlModel().getCanShowYearFilter());
            this.chbxFilterPeriod.setSelected(this.model.getXmlModel().getCanShowPeriodFilter());
        }
    }

    private void initPbxSelectedKpiModelInfo() {
        if (this.model == null) {
            return;
        }
        ComboBoxObject kpiModelObj = null;
        int n = this.kpiModelList.size();
        for (int i = 0; i < n; ++i) {
            kpiModelObj = (ComboBoxObject)this.kpiModelList.get(i);
            if (!kpiModelObj.getCode().equals(this.model.getKPIId())) continue;
            this.pbxSelectKPIModel.setData((Object)kpiModelObj);
            break;
        }
    }

    private void initTblSelectMonitorInfo() {
        this.tblSelectMonitor.removeRows();
        List metricList = null;
        if (this.model != null && this.model.getXmlModel() != null) {
            metricList = this.model.getXmlModel().getMetricList();
        }
        if (metricList != null) {
            int n = metricList.size();
            for (int i = 0; i < n; ++i) {
                this.addTblSelectMonitorInfo((MetricMonitorXmlModel.Metric)metricList.get(i));
            }
        }
    }

    private void addTblSelectMonitorInfo(MetricMonitorXmlModel.Metric metric) {
        IRow row = null;
        ICell cell = null;
        KDComboBox cbx = null;
        row = this.tblSelectMonitor.addRow();
        cell = row.getCell("kpiMetric");
        cbx = new KDComboBox();
        cbx.addItems(this.kpiMetricVector);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbx));
        if (metric != null) {
            this.setTblSelectMonitorData(cell, cbx, this.kpiMetricVector, metric.getMetricNumber());
        }
        cell = row.getCell("showType");
        cbx = new KDComboBox();
        cbx.addItems(this.showTypeVector);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbx));
        if (metric != null) {
            this.setTblSelectMonitorData(cell, cbx, this.showTypeVector, metric.getShowType());
        }
    }

    private void setTblSelectMonitorData(ICell cell, KDComboBox cbx, Vector iteams, String value) {
        ComboBoxObject comBox_Select = null;
        int n = iteams.size();
        for (int i = 0; i < n; ++i) {
            comBox_Select = (ComboBoxObject)iteams.get(i);
            if (!comBox_Select.getCode().equals(value)) continue;
            cbx.setSelectedItem((Object)comBox_Select);
            cell.setValue((Object)comBox_Select);
            break;
        }
    }

    @Override
    protected void action_Del() {
        if (this.checkSelectedTblMain()) {
            ArrayList selectBlocks = this.tblSelectMonitor.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int n = selectBlocks.size();
            for (int i = 0; i < n; ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)((Object)this));
                    return;
                }
                this.tblSelectMonitor.removeRow(selectBlock.getTop());
            }
        }
    }

    private boolean checkSelectedTblMain() {
        if (this.tblSelectMonitor.getRowCount() == 0 || this.tblSelectMonitor.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    @Override
    protected void action_Down() {
        if (this.checkSelectedTblMain()) {
            ArrayList selectBlocks = this.tblSelectMonitor.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int rowIndex = -1;
            IRow row = null;
            for (int i = 0; i < selectBlocks.size(); ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u79fb\u52a8\uff01", (String)this.getTitle(), (Component)((Object)this));
                    break;
                }
                if (this.tblSelectMonitor.getRowCount() == rowIndex) {
                    return;
                }
                rowIndex = selectBlock.getTop();
                if (rowIndex == -1 || rowIndex == this.tblSelectMonitor.getRowCount() - 1) {
                    return;
                }
                int targetRowIndex = rowIndex + 1;
                row = this.tblSelectMonitor.removeRow(rowIndex);
                this.tblSelectMonitor.addRow(targetRowIndex, row);
                this.tblSelectMonitor.getSelectManager().setActiveRowIndex(targetRowIndex);
                this.tblSelectMonitor.getSelectManager().select(targetRowIndex, 0);
            }
        }
    }

    @Override
    protected void action_Up() {
        if (this.checkSelectedTblMain()) {
            ArrayList selectBlocks = this.tblSelectMonitor.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int rowIndex = -1;
            IRow row = null;
            for (int i = 0; i < selectBlocks.size(); ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u79fb\u52a8\uff01", (String)this.getTitle(), (Component)((Object)this));
                    break;
                }
                if (this.tblSelectMonitor.getRowCount() == rowIndex) {
                    return;
                }
                rowIndex = selectBlock.getTop();
                if (rowIndex == -1 || rowIndex == 0) {
                    return;
                }
                int targetRowIndex = rowIndex - 1;
                row = this.tblSelectMonitor.removeRow(rowIndex);
                this.tblSelectMonitor.addRow(targetRowIndex, row);
                this.tblSelectMonitor.getSelectManager().setActiveRowIndex(targetRowIndex);
                this.tblSelectMonitor.getSelectManager().select(targetRowIndex, 0);
            }
        }
    }

    @Override
    public MetricMonitorModel getModel() {
        if (this.model == null) {
            this.model = new MetricMonitorModel();
        }
        this.model.setId(this.fid);
        this.model.setKPIId(((ComboBoxObject)this.pbxSelectKPIModel.getData()).getCode());
        this.model.setDiscription("");
        IRow row = null;
        MetricMonitorXmlModel xmlModel = new MetricMonitorXmlModel();
        xmlModel.setDefaultOrg(((ComboBoxObject)this.pbxInitialStateOrg.getData()).getCode());
        xmlModel.setDefaultYear(((ComboBoxObject)this.pbxInitialStateYear.getData()).getCode());
        xmlModel.setDefaultPeriod(((ComboBoxObject)this.pbxInitialStatePeriod.getData()).getCode());
        xmlModel.setCanDispalyOrg(this.chbxDisplayOrg.getSelected() == 32);
        xmlModel.setCanDispalyYear(this.chbxDisplayYear.getSelected() == 32);
        xmlModel.setCanDispalyPeriod(this.chbxDisplayPeriod.getSelected() == 32);
        xmlModel.setCanShowOrgFilter(this.chbxFilterOrg.getSelected() == 32);
        xmlModel.setCanShowYearFilter(this.chbxFilterYear.getSelected() == 32);
        xmlModel.setCanShowPeriodFilter(this.chbxFilterPeriod.getSelected() == 32);
        MetricMonitorXmlModel.Metric metric = null;
        ArrayList<MetricMonitorXmlModel.Metric> metricList = null;
        Object tmp = null;
        int n = this.tblSelectMonitor.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (metricList == null) {
                metricList = new ArrayList<MetricMonitorXmlModel.Metric>();
            }
            row = this.tblSelectMonitor.getRow(i);
            metric = xmlModel.new MetricMonitorXmlModel.Metric();
            tmp = row.getCell("kpiMetric").getValue();
            metric.setMetricNumber(tmp == null ? "" : ((ComboBoxObject)tmp).getCode());
            tmp = row.getCell("showType").getValue();
            metric.setShowType(tmp == null ? "" : ((ComboBoxObject)tmp).getCode());
            metricList.add(metric);
        }
        xmlModel.setMetricList(metricList == null ? new ArrayList<MetricMonitorXmlModel.Metric>() : metricList);
        this.model.setXmlModel(xmlModel);
        return this.model;
    }

    @Override
    protected AbstractTreeNode loadDimModel(String dimType) {
        AbstractTreeNode rootDim = null;
        try {
            if ("org".equals(dimType) && !StringUtil.isEmpty(this.amId)) {
                rootDim = this.facade.getPublishedOrgTree(this.amId);
            } else if ("year".equals(dimType) && !StringUtil.isEmpty(this.amId)) {
                rootDim = this.facade.getPublishedYearTree(this.amId);
            } else if ("period".equals(dimType) && !StringUtil.isEmpty(this.amId)) {
                rootDim = this.facade.getPublishedPeriodTree(this.amId);
            }
        }
        catch (BIModelRemoteException e) {
            log.error((Object)e);
        }
        return rootDim;
    }

    protected void onOk() {
        if (this.checkBeforeSave()) {
            super.onOk();
        }
    }

    private boolean checkBeforeSave() {
        if (this.pbxSelectKPIModel.getData() == null) {
            WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u9009\u62e9\u4e00\u4e2aKPI\u6a21\u578b\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        IRow row = null;
        for (int i = this.tblSelectMonitor.getRowCount() - 1; i >= 0; --i) {
            row = this.tblSelectMonitor.getRow(i);
            for (int k = this.tblSelectMonitor.getColumnCount() - 1; k >= 0; --k) {
                if (row.getCell(k).getValue() != null) continue;
                StringBuffer info = new StringBuffer();
                info.append("KPI\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u3010");
                switch (k) {
                    case 0: {
                        info.append("KPI");
                        break;
                    }
                    case 1: {
                        info.append("\u663e\u793a\u65b9\u5f0f");
                        break;
                    }
                    case 2: {
                        info.append("\u7ec4\u7ec7\u94bb\u53d6");
                        break;
                    }
                    case 3: {
                        info.append("\u5e74\u94bb\u53d6");
                        break;
                    }
                    case 4: {
                        info.append("\u671f\u95f4\u94bb\u53d6");
                        break;
                    }
                    case 5: {
                        info.append("\u9ed8\u8ba4\u94bb\u53d6");
                    }
                }
                WindowUtil.msgboxInfo((Object)info.append("\u3011\u4e3a\u7a7a\uff01").toString(), (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
        }
        if (this.pbxInitialStateOrg.getData() == null) {
            WindowUtil.msgboxInfo((Object)"\u3010\u7ec4\u7ec7\u3011\u521d\u59cb\u72b6\u6001\u9ed8\u8ba4\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.pbxInitialStateYear.getData() == null) {
            WindowUtil.msgboxInfo((Object)"\u3010\u5e74\u3011\u521d\u59cb\u72b6\u6001\u9ed8\u8ba4\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.pbxInitialStatePeriod.getData() == null) {
            WindowUtil.msgboxInfo((Object)"\u3010\u8d22\u52a1\u671f\u95f4\u3011\u521d\u59cb\u72b6\u6001\u9ed8\u8ba4\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }
}

